(function(RongIM, RongDesktop) {
    'use strict';

    function PCError(message) {
        this.message = message || 'PC 方法错误';
        this.name = 'PCError';
    }
    PCError.prototype = new Error();
    PCError.prototype.constructor = PCError;
    var channel = {
        SEARCH: 'menu.edit.search',
        LOGOUT: 'logout',
        ACCOUNT: 'menu.main.account_settings',
        BALLOON: 'balloon-click',
        DOCKCLICK: 'onDockClick',
        OPENCOVERSATION: 'openConversation'
    };

    function regListener(listenerKey, callback) {
        RongDesktop.ipcRenderer.on(listenerKey, callback);
    }

    function unRegListener(listenerKey) {
        var events = RongDesktop.ipcRenderer._events[listenerKey];
        if (events instanceof Function) {
            RongDesktop.ipcRenderer.removeListener(listenerKey, events);
        } else if (events instanceof Array) {
            events.forEach(function(event) {
                RongDesktop.ipcRenderer.removeListener(listenerKey, event);
            });
        }
    }

    function regSearch(callback) {
        regListener(channel.SEARCH, callback);
    }

    function unregSearch() {
        unRegListener(channel.SEARCH);
    }

    function regLogout(callback) {
        regListener(channel.LOGOUT, callback);
    }

    function unregLogout() {
        unRegListener(channel.LOGOUT);
    }

    function regAccount(callback) {
        regListener(channel.ACCOUNT, callback);
    }

    function unregAccount() {
        unRegListener(channel.ACCOUNT);
    }

    function regBalloon(callback) {
        regListener(channel.BALLOON, callback);
    }

    function unregBalloon() {
        unRegListener(channel.BALLOON);
    }

    function unregOpenCoversation() {
        unRegListener(channel.OPENCOVERSATION);
    }

    function getVersion() {
        return RongDesktop.configInfo.PACKAGE.VERSION;
    }

    function regDockClick(callback) {
        regListener(channel.DOCKCLICK, callback);
    }

    function unregDockClick() {
        unRegListener(channel.DOCKCLICK);
    }

    function playSight(message, messageApi, callback) {
        callback = callback || $.noop;
        var file = RongIM.file;
        var exist = file.checkExist(message.content.localPath);
        if (exist) {
            file.open(message.content.localPath);
        } else {
            callback(0, true);
            var sightUrl = message.content.sightUrl;

            // 兼容 iOS name 没有后缀名问题
            var filename = message.content.name;
            if (!/\.[a-zA-Z0-9]+$/.test(filename)) {
                filename += '.mp4';
            }

            var isPrivate = RongIM.common.isPrivate(RongIM.config);
            var getVideoId = function(url) {
                // 私有云取链接最后一层名称
                if (isPrivate) {
                    var arr = url.split('/');
                    return arr[arr.length - 1];
                }
                // 公有云需从链接中提取
                var urlObj = RongIM.utils.parseUrl(url);
                return urlObj[5];
            };
            var videoId = getVideoId(sightUrl);
            var fileOptions = {
                url: sightUrl,
                name: filename,
                path: RongIM.system.userDataPath + '/video/' + videoId
            };
            var downloader = RongIM.download(fileOptions);
            downloader.onError = function(error) {
                RongIM.utils.console.log('sight download:', error);
            };
            // 下载准备完毕, 此时可知文件大小
            downloader.onReady = function(data) {
                message.content.localPath = data.path;
                messageApi.setContent(message);
            };
            // 下载中,返回下载进度
            downloader.onProgress = function(data) {
                // context.progress = (data.loaded /  data.total) * 100;
                // context.downloading = true;
                var progress = (data.loaded / data.total) * 100;
                var downloading = true;
                callback(progress, downloading);
            };
            // 下载完成
            downloader.onComplete = function(data) {
                var downloading = false;
                callback(0, downloading);
                file.open(data.path);
            };
            downloader.save();
        }
    }

    var client = {
        regSearch: regSearch,
        unregSearch: unregSearch,
        regLogout: regLogout,
        unregLogout: unregLogout,
        regAccount: regAccount,
        unregAccount: unregAccount,
        unregOpenCoversation: unregOpenCoversation,
        regBalloon: regBalloon,
        unregBalloon: unregBalloon,
        getVersion: getVersion,
        userStatusTitle: 'Login_Status_PC',
        regDockClick: regDockClick,
        unregDockClick: unregDockClick,
        getEmojiUrl: RongDesktop.emoji,
        playSight: playSight
    };

    function maxWin() {
        RongDesktop.window.max();
    }

    function minWin() {
        RongDesktop.window.min();
    }

    function restoreWin() {
        RongDesktop.window.restore();
    }

    function closeWin() {
        RongDesktop.window.close();
    }

    function hideWin() {
        if (typeof RongDesktop === 'object' && typeof RongDesktop.window.hide === 'function') {
            RongDesktop.window.hide();
        }
    }

    function showWin() {
        if (typeof RongDesktop === 'object' && typeof RongDesktop.window.show === 'function') {
            RongDesktop.window.show();
        }
    }

    function flashFrame() {
        RongDesktop.window.flashFrame(true);
    }

    function shakeWindow(config) {
        RongDesktop.window.shakeWindow(config);
    }

    function displayBalloon(title, options) {
        RongDesktop.window.displayBalloon(title, options);
    }

    function updateBadgeNumber(count, display) {
        RongDesktop.window.updateBadgeNumber(count, display);
    }

    function focus() {
        RongDesktop.window.focus();
    }

    function isVisible() {
        return RongDesktop.window.isVisible();
    }

    function isFocused() {
        //
        return RongDesktop.window.isFocused();
    }

    var browserWin = RongDesktop.browserWin || {};
    // 远程控制需要增大窗口大小
    var remoteWindowHandler = {
        isExtend: false,
        ExtendWidth: 288,
        // 当宽度大于 1100, 就不再扩大窗口
        WidthLimit: 1090,
        DefaultMinSize: (function() {
            var current = RongDesktop.remote.getCurrentWindow();
            return current.getMinimumSize();
        }()),
        extend: function() {
            var extendWidth = remoteWindowHandler.ExtendWidth;
            remoteWindowHandler.extendWidth(extendWidth);
            remoteWindowHandler.isExtend = true;
        },
        restore: function() {
            if (remoteWindowHandler.isExtend) {
                var extendWidth = -remoteWindowHandler.ExtendWidth;
                remoteWindowHandler.extendWidth(extendWidth);
                remoteWindowHandler.isExtend = false;
            }
        },
        extendWidth: function(extendWidth) {
            var current = RongDesktop.remote.getCurrentWindow();
            var size = current.getSize();
            var width = size[0];
            var height = size[1];
            current.setSize(width + extendWidth, height);
        },
        getWindowSize: function() {
            var current = RongDesktop.remote.getCurrentWindow();
            var size = current.getSize();
            return size;
        },
        setMinWidth: function(minWidth) {
            minWidth = parseInt(minWidth);
            var current = RongDesktop.remote.getCurrentWindow();
            var minSize = current.getMinimumSize();
            current.setMinimumSize(minWidth, minSize[1]);
        },
        setDefaultMinWidth: function() {
            var defaultSize = remoteWindowHandler.DefaultMinSize;
            var current = RongDesktop.remote.getCurrentWindow();
            current.setMinimumSize(defaultSize[0], defaultSize[1]);
        }
    };
    var sound = {
        ringAudio: null,
        playRing: function() {
            if (!sound.ringAudio) {
                sound.ringAudio = document.createElement('audio');
                sound.ringAudio.loop = true;
                sound.ringAudio.src = 'data:audio/mp3;base64,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';
            }
            sound.ringAudio.play();
        },
        stopRing: function() {
            if (sound.ringAudio) {
                sound.ringAudio.pause();
                sound.ringAudio.currentTime = 0;
            }
        }
    };
    RongDesktop.window.on('maximize', function() {
        if (RongIM.instance) {
            RongIM.instance.isMaxWindow = true;
        }
    });
    RongDesktop.window.on('unmaximize', function() {
        if (RongIM.instance) {
            RongIM.instance.isMaxWindow = false;
        }
    });
    var browserWindow = {
        max: maxWin,
        min: minWin,
        restore: restoreWin,
        close: closeWin,
        hide: hideWin,
        show: showWin,
        focus: focus,
        isFocused: isFocused,
        flashFrame: flashFrame,
        shakeWindow: shakeWindow,
        displayBalloon: displayBalloon,
        updateBadgeNumber: updateBadgeNumber,
        quit: RongDesktop.window.quit,
        isVisible: isVisible,
        remoteWindowHandler: remoteWindowHandler,
        toggleDevTools: function() {
            RongDesktop.window.toggleDevTools();
        },
        openPSArticle: function(url) {
            var loginInfo = RongIM.utils.cache.get('loginInfo');
            var querystr = RongIM.utils.getQuerystr({
                zkxToken: loginInfo.zkxToken,
                empId: loginInfo.zkxEmpId || '',
                sessionid: loginInfo.RCESESSIONID || '',
                url: url
            });
            browserWin.create({
                width: 1000,
                minWidth: 600,
                path: '/modules/publicservice-article/index.html?' + querystr,
                isLocal: true,
                id: 'RCEPSArticle'
            });
        },
        openVersions: function() {
            var path = '/modules/appversion/desktop.html';
            browserWin.create({
                path: path,
                isLocal: true,
                width: 800,
                height: 512,
                minWidth: 800,
                minHeight: 512
            });
        },
        closeAll: function() {
            var work = RongDesktop.work;
            if (browserWin.closeAll) {
                browserWin.closeAll();
            } else if (work) {
                work.close();
            }
        },
        // 监听应用公众号信息
        enterPublic: function(router, callback) {
            RongDesktop.ipcRenderer.on('openConversation', function(event, params) {
                RongDesktop.window.focus();
                callback(router, params);
            });
        },
        sendPublicMessage: function(params) {
            browserWin.sendCommand(params);
        },
        openRemoteControl: function(title, targetId, sessionId) {
            var locale = RongIM.instance.config.locale;
            var querystr = RongIM.utils.getQuerystr({
                title: title,
                targetId: targetId,
                sessionId: sessionId,
                locale: locale
            });
            var path = '/modules/remote-control/propmt.html?' + querystr;
            var isMac = RongDesktop.system.platform.indexOf('darwin') !== -1;
            var bottom = isMac ? 250 : 300;
            browserWin.create({
                id: 'remoteControl',
                isLocal: true,
                path: path,
                right: 340,
                bottom: bottom,
                width: 340,
                height: 250,
                minWidth: 340,
                minHeight: 250
            });
            sound.playRing();
        },
        closeRemoteControl: function() {
            // 避免闪
            setTimeout(function() {
                RongDesktop.Ipc.send('remote-control-close');
                sound.stopRing();
            }, 1000);
        },
        changeRemoteControlTitle: function(title) {
            RongDesktop.Ipc.send('change-remote-title', title);
        },
        onRemoteControlAccept: function(callback) {
            RongDesktop.Ipc.register('remote-control-accept', callback);
        },
        onRemoteControlReject: function(callback) {
            RongDesktop.Ipc.register('remote-control-reject', callback);
        },
        sendPublicNotify: function(params) {
            browserWin.sendNotify(params);
        }
    };
    // end region
    function chkFileExist(dir) {
        return RongDesktop.file.checkExist(dir);
    }

    function openFile(localPath) {
        RongDesktop.file.open(localPath);
    }

    function openFileDir(dir) {
        RongDesktop.file.openDir(dir);
    }

    function getBlobs(arrPath) {
        return RongDesktop.file.getBlobs(arrPath);
    }

    function getPaths() {
        return RongDesktop.file.getPaths();
    }

    function getImgByPath() {
        return RongDesktop.file.getImgByPath();
    }

    function getFiles() {
        return RongDesktop.file.getFiles();
    }

    var local_prefix = 'file:///';

    function cacheGePath(url) {
        var tmpConfig = {
            appKey: RongIM.instance.config.appkey,
            id: RongIM.instance.auth.id
        };
        // eslint-disable-next-line new-cap
        RongIM.resCache = RongIM.resCache || new RongDesktop.cache(tmpConfig);
        var _cache = RongIM.resCache;
        if (url) {
            var key = url.replace(/\./g, '\\.');
            var cachObj = _cache.get(key) || {};
            return cachObj.localPath || '';
        }
        return '';
    }
    var getBlob = function(filePath) {
        var file = null;
        var defer = $.Deferred();
        $.ajax({
            xhrFields: {
                responseType: 'blob'
            },
            url: local_prefix + filePath,
            type: 'GET'
        }).then(function(buffer) {
            var fileInfo = RongDesktop.file.getFileInfo(filePath);
            fileInfo.buffer = buffer;
            var blob = new window.Blob([fileInfo.buffer], {
                type: fileInfo.type
            });
            file = new window.File([blob], fileInfo.name, {
                type: fileInfo.type,
                lastModified: fileInfo.lastModified
            });
            file.localPath = filePath;
            defer.resolve(file);
        }, function(err) {
            defer.reject(err);
        });
        return defer.promise();
    };

    var file = {
        checkExist: chkFileExist,
        open: openFile,
        openDir: openFileDir,
        getBlobs: getBlobs,
        getPaths: getPaths,
        getImgByPath: getImgByPath,
        getFiles: getFiles,
        zipFolders: RongDesktop.file.zipFolders,
        unzip: RongDesktop.file.unzip,
        delZip: RongDesktop.file.delZip,
        cacheGePath: cacheGePath,
        getFileStat: RongDesktop.file.getFileStat,
        getBlob: getBlob
    };

    function setLanguage(lang) {
        if (typeof RongDesktop === 'object' && typeof RongDesktop.system === 'object' && typeof RongDesktop.system.setLanguage === 'function') {
            RongDesktop.system.setLanguage(lang);
        }
    }

    function clearCache() {
        RongDesktop.system.clearCache();
    }

    function relaunch() {
        RongDesktop.system.relaunch();
    }

    function exit() {
        RongDesktop.system.exit();
    }

    function logout() {
        RongDesktop.system.logout();
    }

    function login() {
        RongDesktop.system.login();
    }

    function reload() {
        RongDesktop.system.reload();
    }

    function reloadIgnoringCache() {
        RongDesktop.system.reloadIgnoringCache();
    }

    function setShowVersion(value) {
        RongDesktop.system.setShowVersion(value);
    }

    function appLogger(levels, log) {
        RongDesktop.system.appLogger(levels, log);
    }

    function processLogger(levels, log) {
        RongDesktop.system.processLogger(levels, log);
    }

    window.openExternal = function(url, openChrome) {
        if (openChrome) {
            function cpuArch() {
                var ua = navigator.userAgent.toLowerCase();
                if (ua.indexOf('win64') > -1 || ua.indexOf('wow64') > -1 || ua.indexOf('x86_64') > -1) {
                    return '64';
                }
                return '32';
            }
            var cmd = '';
            [
                "%LocalAppData%",
                "%ProgramFiles(x86)%",
                "%ProgramFiles%"
            ].forEach(function(sysPath) {
                if (cmd) cmd += ' ELSE ';
                cmd += 'IF EXIST "' + sysPath + '\\Google\\Chrome\\Application\\chrome.exe" (ECHO 1)';
            });
            [
                "%AppData%",
                "%AllUsersProfile%"
            ].forEach(function(sysPath) {
                cmd += ' ELSE IF EXIST "' + sysPath + '\\Microsoft\\Windows\\Start Menu\\Google Chrome" (ECHO 1)';
            });
            RongDesktop.child_process.exec(cmd, {
                shell: 'CMD'
            }, function(err, stdout, stderr) {
                console.info(cmd + ': ' + stdout);
                if (stdout && stdout.charAt(0) == '1') {
                    var arch = cpuArch();
                    console.info('cpuArch: ' + arch);
                    RongDesktop.child_process.spawn('start', [
                        'chrome.exe', '--no-sandbox',
                        '--register-pepper-plugins="%ProgramFiles' + (arch == '64' ? '(x86)' : '') + '%\\KGChromePlugin\\KGChromePlugin_' + arch + '.dll;application/kg-plugin"',
                        '--new-window', '"' + url + '"'
                    ], {
                        shell: 'CMD'
                    });
                } else {
                    RongDesktop.shell.openExternal(url);
                }
            });
        } else {
            RongDesktop.shell.openExternal(url);
        }
    }

    var system = {
        setShowVersion: setShowVersion,
        setLanguage: setLanguage,
        clearCache: clearCache,
        relaunch: relaunch,
        exit: exit,
        logout: logout,
        locale: RongDesktop.system.locale,
        getDeviceId: function() {
            // PC 初始化时值为 null 改为使用方法获取
            return RongDesktop.system.deviceId;
        },
        messageNotification: RongDesktop.system.messageNotification,
        dbPath: RongDesktop.system.dbPath,
        platform: RongDesktop.system.platform,
        version: RongDesktop.system.version,
        userDataPath: RongDesktop.system.userDataPath,
        setConnectStatus: RongDesktop.system.setConnectStatus,
        login: login,
        setAutoLaunch: RongDesktop.system.setAutoLaunch,
        getAutoLaunch: RongDesktop.system.getAutoLaunch,
        reload: reload,
        reloadIgnoringCache: reloadIgnoringCache,
        openByBrowser: openExternal,
        appLogger: appLogger,
        processLogger: processLogger
    };

    function isAvailableData() {
        // PC 断开连接时也可以操作本地数据
        return true;
    }
    var lib = {
        getDataProvider: function() {
            return RongDesktop.addon;
        },
        clearUnreadCountByTimestamp: function(params, callback) {
            RongIMClient.getInstance()
                .clearUnreadCountByTimestamp(params.conversationType, params.targetId, params.timestamp, {
                    onSuccess: function() {
                        callback();
                    },
                    onError: function(errorCode) {
                        callback(errorCode);
                    }
                });
        }
    };

    var imageViewer = {
        openWin: function(options) {
            RongDesktop.imageViewerOpener.open(options);
        },
        close: function() {
            RongDesktop.imageViewerOpener.close();
        },
        logout: function() {
            RongDesktop.imageViewerOpener.logout();
        },
        recall: function(messageUId) {
            RongDesktop.imageViewerOpener.recall(messageUId);
        }
    };

    // 测试 onDockClick
    RongDesktop.ipcRenderer.on('hide', function() {
        if (RongIM.browserWindow.onHide) {
            RongIM.browserWindow.onHide();
        }
    });

    // 获取导航
    function getNavi(naviConfig, callback) {
        RongDesktop.Navi.get(naviConfig, function(error, result) {
            if (error) {
                callback(error);
                return;
            }
            result.version = naviConfig.version;
            callback(null, result);
        });
    }

    var Database = RongDesktop.Database;
    RongIM.Database = Database;

    var intercepts = [{
            method: 'get',
            path: '/staffs',
            handle: function(params, callback) {
                var duty_name = params.query.duty_name;
                duty_name = decodeURIComponent(duty_name);
                Database.staff.getByDutyname(duty_name, function(error, userList) {
                    callback(error, {
                        data: userList
                    });
                });
            }
        }, {
            method: 'post',
            path: '/staffs/batch',
            handle: function(params, callback) {
                var ids = params.data.ids;
                Database.staff.batch(ids, function(error, userList) {
                    var resultIdList = userList.map(function(user) {
                        return user.id;
                    });
                    var unexists = ids.filter(function(id) {
                        return resultIdList.indexOf(id) === -1;
                    });
                    if (unexists.length === 0) {
                        callback(error, {
                            data: userList
                        });
                        return;
                    }
                    // 外部联系人、第三方应用信息 /staffs/diff 接口不返回重新从 server 获取并存储到 staffs 表
                    RongIM.syncdata.userById(unexists, function(err, result) {
                        if (err) {
                            callback(err, result);
                            return;
                        }
                        var list = userList.concat(result);
                        callback(null, {
                            data: list
                        });
                    });
                    // RongIM.dataModel.User.batchFromServer(unexists, function (err, result) {
                    //     if (err) {
                    //         callback(err, result);
                    //         return;
                    //     }
                    //     var otherUserList = result.data;
                    //     Database.staff.insertOrReplace(otherUserList);
                    //     var list = userList.concat(otherUserList);
                    //     callback(null, {
                    //         data: list
                    //     });
                    // });
                });
            }
        }, {
            method: 'get',
            path: '/staffs/{id}',
            handle: function(params, callback) {
                Database.staff.get(params.params.id, callback);
            }
        },
        {
            method: 'post',
            path: '/staffs/search',
            handle: function(params, callback) {
                var data = params.data;
                var keyword = data.keywords[0];
                // 0: 根据姓名搜索,默认0 1:根据工号搜索 2:根据手机号搜索,暂不支持 3:根据邮箱搜索,暂不支持
                var type = data.type;
                if (type === 1) {
                    Database.staff.searchByStaffNo(keyword, function(error, userList) {
                        callback(error, userList);
                    });
                } else {
                    Database.staff.search(keyword, function(error, userList) {
                        callback(error, userList);
                    });
                }
            }
        },
        {
            method: 'post',
            path: '/staffs/search/mobile',
            handle: function(params, callback) {
                var keyword = params.data.keywords[0];
                var partial_match = params.data.partial_match;
                Database.staff.searchByMobile(keyword, partial_match, function(error, userList) {
                    callback(error, userList);
                });
            }
        },
        {
            method: 'post',
            path: '/staffs/search/email',
            handle: function(params, callback) {
                var keyword = params.data.keywords[0];
                Database.staff.searchByEmail(keyword, function(error, userList) {
                    callback(error, userList);
                });
            }
        },
        {
            method: 'post',
            path: '/misc/duty/search',
            handle: function(params, callback) {
                我看最后一下
                var keyword = params.data.keywords[0];
                Database.staff.dutySearch(keyword, function(error, list) {
                    callback(error, list);
                });
            }
        },
        {
            method: 'get',
            path: '/organization',
            handle: function(params, callback) {
                var type = params.query.type;
                Database.organization.getByType(type, function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        }, {
            method: 'get',
            path: '/organization/root',
            handle: function(params, callback) {
                Database.organization.root(function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        }, {
            method: 'get',
            path: '/organization/{id}/members',
            handle: function(params, callback) {
                Database.organization.getMembers(params.params.id, function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        }, {
            method: 'get',
            path: '/organization/{id}/all_members',
            handle: function(params, callback) {
                var id = params.params.id;
                var type = params.query.type;
                Database.organization.getAllMembers(id, type, function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        }, {
            method: 'get',
            path: '/companies/{id}',
            handle: function(params, callback) {
                var id = params.params.id;
                Database.company.get(id, callback);
            }
        }, {
            method: 'post',
            path: '/companies/batch',
            handle: function(params, callback) {
                var idList = params.data.ids;
                Database.company.batch(idList, function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        }, {
            method: 'get',
            path: '/companies/diff/0',
            handle: function(params, callback) {
                Database.company.getAll(function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        },
        {
            method: 'post',
            path: '/companies/search',
            handle: function(params, callback) {
                var keyword = params.data.keywords[0];
                Database.company.search(keyword, function(error, list) {
                    callback(error, list);
                });
            }
        },
        {
            method: 'get',
            path: '/departments/{id}',
            handle: function(params, callback) {
                var id = params.params.id;
                Database.department.get(id, callback);
            }
        }, {
            method: 'get',
            path: '/departments/{id}/branches',
            handle: function(params, callback) {
                var id = params.params.id;
                Database.department.branches(id, function(error, list) {
                    callback(error, {
                        data: list
                    });
                });
            }
        },
        {
            method: 'post',
            path: '/departments/search',
            handle: function(params, callback) {
                var keyword = params.data.keywords[0];
                Database.department.search(keyword, function(error, list) {
                    callback(error, list);
                });
            }
        }
    ];

    function getGroup(idList, callback) {
        Database.group.batch(idList, function(error, groupList) {
            if (error) {
                callback(error);
                return;
            }
            // 去除未获取到的 group 剩下未获取到的从 server 获取并存储
            groupList.forEach(function(group) {
                var index = idList.indexOf(group.id);
                if (index >= 0) {
                    idList.splice(index, 1);
                }
            });
            if (idList.length === 0) {
                callback(null, groupList);
                return;
            }
            RongIM.syncdata.groupById(idList, function(err, unexistGroupList) {
                if (err) {
                    callback(err);
                    return;
                }
                callback(null, unexistGroupList.concat(groupList));
            });
        });
    }

    var groupIntercept = [{
            method: 'post',
            path: '/groups/batch',
            handle: function(params, callback) {
                var idList = params.data.ids;
                getGroup(idList, callback);
            }
        },
        {
            method: 'get',
            path: '/groups/receivers',
            pass: true
        },
        {
            method: 'get',
            path: '/groups/receiver_unread',
            pass: true
        },
        {
            method: 'get',
            path: '/groups/{id}',
            handle: function(params, callback) {
                var id = params.params.id;
                getGroup([id], function(error, groupList) {
                    var group = groupList ? groupList[0] : null;
                    callback(error, group);
                });
            }
        },
        {
            mehtod: 'get',
            path: '/groups/{id}/members',
            handle: function(params, callback) {
                var id = params.params.id;
                Database.groupMember.getMembers(id, function(error, members) {
                    // 新增成员数据未同步时，获取不到成员信息，根据 id 同步用户信息
                    var notHaveInfo = members.filter(function(item) {
                        var unexists = !item.name;
                        return unexists;
                    });
                    if (notHaveInfo.length === 0) {
                        callback(error, {
                            data: members
                        });
                        return;
                    }
                    var idList = notHaveInfo.map(function(item) {
                        return item.id;
                    });
                    RongIM.syncdata.userById(idList, function(err, userList) {
                        if (err) {
                            callback(err, {
                                data: members
                            });
                            return;
                        }
                        var tmpMap = {};
                        userList.forEach(function(item) {
                            tmpMap[item.id] = item;
                        });
                        notHaveInfo.forEach(function(member) {
                            var item = tmpMap[member.id];
                            member.name = item.name;
                            member.state = item.state;
                            member.user_type = item.user_type;
                        });
                        callback(err, {
                            data: members
                        });
                    });
                });
            }
        },
        {
            method: 'post',
            path: '/groups/batch/members',
            handle: function(params, callback) {
                var idList = params.data.ids;
                Database.groupMember.batch(idList, callback);
            }
        }
        // {
        //     method: 'post',
        //     path: '/groups/search',
        //     handle: function (params, callback) {
        //         var keyword = params.data.keywords[0];
        //         Database.group.search(keyword, callback);
        //     }
        // }
    ];

    intercepts = intercepts.concat(groupIntercept);

    var Intercepter = {
        find: function(method, path) {
            // fake: disable sync data
            // for (var i = 0, length = intercepts.length; i < length; i += 1) {
            for (var i = 0, length = groupIntercept.length; i < length; i += 1) {
                // fake: disable sync data
                // var item = intercepts[i];
                var item = groupIntercept[i];
                var methodSame = (item.method || 'get').toLowerCase() === method.toLowerCase();
                var reg = new RegExp('^' + item.path.replace(/{\w+}/g, '([a-zA-Z0-9\\_\\-]+)') + '(?:[?]|$)');
                var pathSame = reg.test(path);
                if (methodSame && pathSame) {
                    if (item.pass) {
                        break;
                    }
                    return item;
                }
            }
            return null;
        },
        parseUrl: function(rule, url) {
            var reg = new RegExp('^' + rule.replace(/{\w+}/g, '([a-zA-Z0-9\\_\\-]+)') + '(?:[?]|$)');
            var pathSame = reg.test(url);
            if (!pathSame) {
                return null;
            }
            // 获取 url 参数
            var params = {};
            var paramsKey = rule.match(/{\w+}/g);
            if (paramsKey) {
                paramsKey = paramsKey.map(function(str) {
                    return str.substring(1, str.length - 1);
                });
                var paramsValue = reg.exec(url);
                paramsKey.forEach(function(key, index) {
                    params[key] = paramsValue[index + 1];
                });
            }
            var query = {};
            // 获取 query 参数
            var queryStr = url.split('?')[1];
            if (queryStr) {
                var queryList = queryStr.split('&');
                queryList.forEach(function(item) {
                    var queryItem = item.split('=');
                    var key = queryItem[0];
                    query[key] = queryItem[1];
                });
            }
            return {
                query: query,
                params: params
            };
        }
    };

    RongIM.Intercepter = Intercepter;

    var firstSyncdataKey = 'rong-firstsyncdata';
    RongIM.firstSyncdata = {
        remove: function(userId) {
            if (!userId) {
                return;
            }
            var value = window.localStorage.getItem(firstSyncdataKey) || '';
            var uidList = value.split(',');
            var index = uidList.indexOf(userId);
            if (index > -1) {
                uidList.splice(index, 1);
                window.localStorage.setItem(firstSyncdataKey, uidList.join(','));
            }
        },
        get: function(userId) {
            var value = window.localStorage.getItem(firstSyncdataKey) || '';
            var appkey = RongIM.serverConfig.im.app_key;
            var dbFileExists = Database.existsSync(appkey, userId);
            return !dbFileExists || value.indexOf(userId) === -1;
        },
        set: function(userId) {
            var value = window.localStorage.getItem(firstSyncdataKey) || '';
            if (value.indexOf(userId) === -1) {
                value += (',' + userId);
                window.localStorage.setItem(firstSyncdataKey, value);
            }
        }
    };

    var clipboard = {
        writePath: function(path) {
            var url = 'file:///' + path;
            RongDesktop.file.copyToClipboard(url);
        }
    };

    /*
    file: {url: 文件下载链接, name: 保存后的别名}
    config: {timeout: timeout 连接超时, retries: 重试次数}
    */
    RongIM.getNavi = getNavi;
    RongIM.imageViewer = imageViewer;
    RongIM.download = RongDesktop.download;
    // 分片下载
    RongIM.downloader = RongDesktop.downloader;
    RongIM.browserWindow = browserWindow;
    RongIM.file = file;
    RongIM.system = system;
    RongIM.isAvailableData = isAvailableData;
    RongIM.lib = lib;
    RongIM.client = client;
    RongIM.clipboard = clipboard;

    RongDesktop.system.onResume = function() {
        if (RongIM.system.onResume) {
            RongIM.system.onResume();
        }
    };

    RongDesktop.system.onSuspend = function() {
        if (RongIM.system.onSuspend) {
            RongIM.system.onSuspend();
        }
    };
    // RongIM.screenshot = RongDesktop.screenshot;
    RongIM.screenshot = {
        start: RongDesktop.screenshot.start,
        setShortcut: RongDesktop.screenshot.setShortcut,
        setHideWindow: RongDesktop.screenshot.setHideWindow,
        setEnabled: RongDesktop.screenshot.setEnabled,
        setCallback: RongDesktop.screenshot.setCallback,
        setCancelCallback: RongDesktop.screenshot.setCancelCallback,
        // 用于区别 窗口隐藏时截图 还是 截图时选择了隐藏窗口
        winShow: false
    };

    RongDesktop.screenshot.onComplete = function(data) {
        // 调用paste功能弹出截图
        Vue.nextTick(function() {
            document.execCommand('Paste');
        });
        if (RongIM.screenshot.onComplete) {
            RongIM.screenshot.onComplete(data);
        }
    };
    RongDesktop.screenshot.onCancel = function() {
        if (RongIM.screenshot.onCancel) {
            RongIM.screenshot.onCancel();
        }
    };
    if (RongDesktop.system.version) {
        RongIM.appVersion = RongDesktop.system.version;
    } else if (RongDesktop.app && RongDesktop.app.version) {
        RongIM.appVersion = RongDesktop.app.version;
    }

    RongIM.remoteControl = RongDesktop.remoteControl;

    RongIM.cleanStorage = function() {
        Database.close();
        RongDesktop.cleanStorage();
        window.localStorage.clear();
    };

    RongIM.upload = RongDesktop.upload;
}(RongIM, RongDesktop));