(function (RongIM) {
'use strict';

var common = RongIM.common;
var diviceAPI = RongIM.dataModel.Device;

RongIM.dialog.deviceLocking = function () {
    var im = RongIM.instance;
    var messageApi = im.dataModel.Message;
    var options = {
        name: 'device',
        template: 'templates/device-locking.html',
        data: function () {
            return {
                show: true
            };
        },
        mounted: function () {
            var context = this;
            context.messageWatch = function (message) {
                if (message.messageType === 'MultiClientMessage') {
                    if (+message.content.action === 2) {
                        // 解锁
                        context.show = false;
                        im.isLock = false;
                    }
                }
            };
            messageApi.watch(context.messageWatch);
        },
        methods: {
            unlock: function () {
                diviceAPI.unlock(function (errorCode) {
                    if (errorCode) {
                        common.toastError(errorCode);
                    }
                });
            }
        },
        destroyed: function () {
            var context = this;
            messageApi.unwatch(context.messageWatch);
        }
    };
    common.mountDialog(options);
};
}(RongIM));
