(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

RongIM.dialog.getFileHelper = function (helper) {
  console.log(helper)
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var options = {
        name: 'get-file-helper',
        template: 'templates/file-helper/helper.html',
        data: function () {
            return {
                show: true,
                helper: helper
            };
        },
        components: {
            avatar: components.getAvatar
        },
        methods: getMethods(dataModel, im)
    };
    common.mountDialog(options, function (instance) {
        RongIM._groupInstance = instance;
    });
};

function getMethods(dataModel, im) {
    var conversation = dataModel.Conversation;
    return {
        close: function () {
            this.show = false;
        },
        start: function () {
            var helper = this.helper;
            var params = {
                conversationType: utils.conversationType.PRIVATE,
                targetId: helper.id,
                user: helper
            };
            console.log(params)
            im.$router.push({
                name: 'conversation',
                params: params
            });
            conversation.add(params);
            var itemId = ['conversation', params.conversationType, params.targetId].join('-');
            var item = document.getElementById(itemId);
            if (item) {
                var parentHeight = item.parentNode.offsetHeight;
                var offsetTop = item.offsetTop;
                var alginWithTop = offsetTop > parentHeight;
                item.scrollIntoView(alginWithTop);
            }
            this.close();
        }
    };
}
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
