(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

components.getGroupNoticeNotifyMessage = function (resolve, reject) {
    var options = {
        name: 'group-notice-notify-message',
        props: ['message', 'keyword'],
        template: '#rong-template-group-notice-message',
        data: function () {
            return {
                sentStatus: utils.sentStatus
            };
        },
        computed: {
            content: function () {
                var content = this.message.content.content;
                content = common.textMessageFormat(content);
                content = common.groupNoticeFormat(content, this.locale);
                return common.highlight(content, this.keyword);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
