(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var common = RongIM.common;
var CallType = common.CallType;
var RCCall = dependencies.RCCall;

var mediaTypeMap = {
    1: 'audio',
    2: 'video'
};

components.getSummaryMessage = function (resolve, reject) {
    var messageApi = RongIM.dataModel.Message;
    var serverConfig = RongIM.serverConfig || {};
    var voipConf = serverConfig.voip || {};
    var options = {
        name: 'summary-message',
        props: ['message'],
        template: '#rong-template-summary',
        computed: {
            type: function () {
                var mediaType = this.message.content.mediaType;
                return mediaTypeMap[mediaType];
            },
            isActive: function () {
                var status = this.message.content.status;
                return ([3, 13].indexOf(status) !== -1);
            },
            status: function () {
                var status = this.message.content.status;
                return this.locale.voip.summaryCodeMap[status];
            },
            content: function () {
                var duration = this.message.content.duration;
                var str = this.status;
                // 已接通 显示通话时间
                if (this.isActive) {
                    str += utils.secondToMinute(duration / 1000);
                }
                return str;
            },
            isUnread: function () {
                var status = this.message.content.status;
                // 5 未接听 11 对方取消
                var isCancel = [5, 11].indexOf(status) !== -1;
                var receivedStatus = this.message.receivedStatus;
                return receivedStatus !== utils.receivedStatus.LISTENED && isCancel;
            },
            isReceiver: function () {
                var messageDirection = this.message.messageDirection;
                return messageDirection === utils.messageDirection.RECEIVE;
            }
        },
        methods: {
            invite: function () {
                if (!voipConf.audio_enable) {
                    return;
                }
                var conversation = {
                    conversationType: this.message.conversationType,
                    targetId: this.message.targetId
                };
                var userApi = RongIM.dataModel.User;
                var friendApi = RongIM.dataModel.Friend;
                var isPrivate = Number(conversation.conversationType) === 1;
                if (isPrivate) {
                    var canNotChat = !userApi.validateCanChat(conversation.targetId);
                    if (canNotChat) {
                        friendApi.insertRFVMsg(conversation.targetId);
                        return;
                    }
                }
                var mediaType = this.message.content.mediaType;
                var params = {
                    conversation: conversation,
                    type: mediaType,
                    isPrivate: true
                };
                var voipTip = {};
                voipTip[CallType.MEDIA_VEDIO] = this.locale.voip.videoTip;
                voipTip[CallType.MEDIA_AUDIO] = this.locale.voip.audioTip;

                RCCall.start(params, function (errorCode, data) {
                    if (errorCode) {
                        common.messageToast({
                            type: 'error',
                            message: voipTip[data.type]
                        });
                    }
                });

                var messageId = this.message.messageId;
                if (messageId && this.isUnread && this.isReceiver) {
                    var LISTENED = utils.receivedStatus.LISTENED;
                    this.message.receivedStatus = LISTENED;
                    messageApi.setMessageReceivedStatus({
                        messageId: messageId,
                        status: LISTENED
                    });
                }
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, {
    RCCall: RCCall
}, RongIM.components));
