(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

components.getTextMessage = function (resolve, reject) {
    var options = {
        name: 'text-message',
        props: ['message', 'keyword'],
        template: '#rong-template-text',
        data: function () {
            return {
                sentStatus: utils.sentStatus
            };
        },
        computed: {
            content: function () {
                var content = this.message.content.content;
                content = utils.htmlLang.check(content);
                content = common.textMessageFormat(content);
                return common.highlight(content, this.keyword);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

/* function encodeHtml(str){
    var encodedStr = "" ;
    if (str=="") return encodedStr ;
    else {
        for (var i = 0 ; i < str.length ; i ++){
            encodedStr += "&#" + str.substring(i, i + 1).charCodeAt().toString(10) + ";" ;
        }
    }
    return encodedStr ;
} */
}(RongIM, RongIM.components));
