(function (RongIM, dependencies, components) {
'use strict';

var contact = components.contact;

RongIM.routes = {
    linkActiveClass: 'rong-selected',
    maps: [
        {
            path: '/login/:selected?',
            name: 'login',
            component: components.getLogin,
            meta: {
                pulicAccess: true
            }
        },
        {
            path: '/signup',
            name: 'signup',
            component: components.getSignup,
            meta: {
                pulicAccess: true
            }
        },
        {
            path: '/forget-password',
            name: 'forgetPassword',
            component: components.forgetPassword,
            meta: {
                pulicAccess: true
            }
        },
        {
            path: '/conversation/:conversationType([1-8]{1})?/:targetId?',
            name: 'conversation',
            components: {
                list: components.getConversationList,
                main: components.getConversation
            }
        },
        {
            path: '/contact',
            name: 'contact',
            components: {
                list: contact.getList
            }
        },
        {
            path: '/contact/group',
            name: 'group',
            components: {
                list: contact.getList,
                main: contact.getGroup
            }
        },
        {
            path: '/contact/approve',
            name: 'approve',
            components: {
                list: contact.getList,
                main: contact.getApprove
            }
        },
        {
            path: '/contact/org/:coId/:orgId?/:type?',
            name: 'organization',
            components: {
                list: contact.getList,
                main: contact.getOrg
            }
        },
        {
            path: '/contact/mydept/:coId/:orgId?/:type?',
            name: 'mydept',
            components: {
                list: contact.getList,
                main: contact.getOrg
            }
        },
        {
            path: '/workApps/:targetId?',
            name: 'workApps',
            components: {
                workapps: components.publicHome
            }
        },
        {
            path: '/publicHome',
            name: 'publicHome',
            components: {
                workapps: components.publicHome
            }
        },
        {
            path: '/zhkx',
            name: 'zhkx',
            components: {
                workapps: components.publicHome
            }
        },
        {
            path: '*',
            redirect: '/conversation'
        }
    ]
};
}(RongIM, null, RongIM.components));
