(function (RongIM, dependencies, components) {
    'use strict';

    var $ = dependencies.jQuery;
    var Vue = dependencies.Vue;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var utils = RongIM.utils;
    var cache = utils.cache;
    var selectIndex = 0;
    var pageNum = RongIM.config.search.pageNum;
    var server = RongIM.config.dataModel.server;

    // 搜索消息时，高亮消息关键字
    var messageSearch = {
        TextMessage: function (message, keyword) {
            var str = message.content.content;
            return getSubstrHighlight(str, keyword);
        },
        FileMessage: function (message, keyword) {
            var str = message.content.name;
            // 7 - 页面最多可容纳字符长度
            return getSubstrHighlight(str, keyword, 7);
        },
        RichContentMessage: function (message, keyword) {
            var str = message.content.title;
            return getSubstrHighlight(str, keyword, 7);
        },
        GroupNoticeNotifyMessage: function (message, keyword) {
            var str = message.content.content;
            return getSubstrHighlight(str, keyword);
        }
    };

    components.getSearch = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var orgApi = dataModel.Organization;
        var userApi = dataModel.User;
        var friendApi = dataModel.Friend;
        var pubApi = dataModel.Public;
        var starApi = dataModel.Star;
        var groupApi = dataModel.Group;
        // 模块化屏蔽入口
        // 好友
        var enabledFriend = im.serverConfig.friend.enable;
        // pin
        var enabledPIN = im.serverConfig.pin.enable;
        var options = {
            name: 'search',
            template: 'templates/search.html',
            data: function () {
                return {
                    auth: im.auth,
                    enabledFriend: enabledFriend,
                    enabledPIN: enabledPIN,
                    isShowMenu: false,
                    currentView: '',
                    /* 'contacts' or 'groups' or `history` or 'pubs' */
                    keyword: '',
                    contacts: [],
                    dutys: [],
                    dutysDetail: {},
                    orgs: [],
                    orgsDetail: {},
                    groups: [],
                    history: [],
                    pubs: [],
                    // 伯鑫star
                    starScontact: [],
                    starScontactDetail: {},
                    showStarScontactDetail: false,
                    // 伯鑫end
                    showSearchRecord: false,
                    inputIsFocus: false,
                    recordList: [],
                    searchHistoryDetail: {
                        list: [],
                        count: 0
                    },
                    showHistoryDetail: false,
                    showDutysDetail: false,
                    showOrgsDetail: false,
                    curItem: null,
                    busy: {
                        contacts: false,
                        groups: false,
                        dutys: false,
                        orgs: false,
                        history: false,
                        pubs: false,
                        // 伯鑫star
                        starScontact: false,
                        // 伯鑫end
                        pinGroup: false,
                    },
                    searchBeforeReturning: {
                        contacts: false,
                        groups: false,
                        // dutys: false,
                        orgs: false,
                        history: false,
                        pubs: false,
                        // 伯鑫star
                        starScontact: false,
                        // 伯鑫end
                        pinGroup: false,
                        contactsFriends: false
                    },
                    searchPending: null,
                    friends: [],
                    isStaff: im.auth.isStaff,
                    loadBusy: false,
                    currentPage: 1,
                    pageNum: pageNum,
                    pinGroups: [],
                    show: true,
                    showSearchContacts: {
                        contactsFriends: false,
                        contacts: false,
                    }
                };
            },
            computed: {
                isEmpty: function () {
                    var matchCount = this.contacts.length + this.groups.length + this.history.length + this.dutys.length + this.orgs.length + this.pubs.length + this.starScontact.length + this.pinGroups.length;
                    var noMatch = matchCount === 0;
                    var hasInputValue = this.keyword.length > 0;
                    return hasInputValue && noMatch;
                },
                showStarScontact: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.starScontact.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'starscontact';
                },
                showContacts: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        console.log("showContacts两参数", this.contacts.length > 0, !showDeatil);
                        console.log("showContacts整体", this.contacts.length > 0 && !showDeatil);
                        return this.contacts.length > 0 && !showDeatil;
                    }
                    // console.log(" this.currentView应为true",this.currentView === 'contacts');
                    // return this.currentView === 'contacts';
                    return true
                },
                showPubs: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.pubs.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'pubs';
                },
                showDutys: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.dutys.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'dutys' && this.showDutysDetail === false;
                },
                showOrgs: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.orgs.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'orgs' && this.showOrgsDetail === false;
                },
                showGroups: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.groups.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'groups';
                },
                showHistory: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.history.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'history';
                },
                isBusy: function () {
                    var busy = this.busy;
                    // var isLoading = busy.contacts || busy.dutys || busy.orgs || busy.groups || busy.history || busy.pubs || busy.starScontact || busy.pinGroup;
                    var isLoading = busy.contacts || busy.dutys || busy.orgs || busy.groups || busy.pubs || busy.starScontact || busy.pinGroup;
                    return isLoading;
                },
                isSearchBeforeReturning: function () {
                    var searchBeforeReturning = this.searchBeforeReturning;
                    var isLoading = searchBeforeReturning.orgs && searchBeforeReturning.groups && searchBeforeReturning.pubs && searchBeforeReturning.starScontact && searchBeforeReturning.pinGroup;
                    return isLoading;
                },
                isShowSearchContacts: function () {
                    var showSearchContacts = this.showSearchContacts;
                    var show = showSearchContacts.contacts;
                    console.log("isShowSearchContacts应为true", show);
                    return show
                },
                contactsList: function () {
                    console.log("contactsList ==>", this.contacts);
                    if (this.currentView === 'contacts') {
                        var end = this.currentPage * this.pageNum;
                        let num = this.contacts.slice(0, end).length - 50;
                        let endArr = this.contacts.slice(0, end).slice(num);
                        // let starArr = this.contacts.slice(0, end).slice(0,num);
                        endArr.forEach((item, index) => {
                            this.getPath(item)
                        })
                        return this.contacts.slice(0, end);
                    }
                    this.contacts.slice(0, 3).forEach((item, index) => {
                        this.getPath(item)
                    })
                    return this.contacts.slice(0, 3);
                },
                starScontactList: function () {
                    if (this.currentView === 'starscontact' || this.starScontact.length > 0) {
                        var end = this.currentPage * this.pageNum;
                        return this.starScontact.slice(0, end);
                    }
                    console.log(this.starScontact)
                    return this.starScontact.slice(0, 3);
                },
                dutysList: function () {
                    if (this.currentView === 'dutys') {
                        var end = this.currentPage * this.pageNum;
                        return this.dutys.slice(0, end);
                    }
                    return this.dutys.slice(0, 3);
                },
                orgsList: function () {
                    if (this.currentView === 'orgs') {
                        var end = this.currentPage * this.pageNum;
                        return this.orgs.slice(0, end);
                    }
                    return this.orgs.slice(0, 3);
                },
                groupsList: function () {
                    if (this.currentView === 'groups') {
                        var end = this.currentPage * this.pageNum;
                        return this.groups.slice(0, end);
                    }
                    return this.groups.slice(0, 3);
                },
                pubsList: function () {
                    if (this.currentView === 'pubs') {
                        return this.pubs;
                    }
                    return this.pubs.slice(0, 3);
                },
                historyList: function () {
                    if (this.currentView === 'history') {
                        var end = this.currentPage * this.pageNum;
                        return this.history.slice(0, end);
                    }
                    return this.history.slice(0, 3);
                },
                dutyDetailList: function () {
                    var end = this.currentPage * this.pageNum;
                    return this.dutysDetail.list.slice(0, end);
                },
                orgDetailList: function () {
                    var end = this.currentPage * this.pageNum;
                    return this.orgsDetail.list.slice(0, end);
                },
                historyDetailList: function () {
                    var end = this.currentPage * this.pageNum;
                    return this.searchHistoryDetail.list.slice(0, end);
                },
                showGroup: function () {
                    return this.$route.path.indexOf('contact') > -1
                },
                showContactsTWO: function () {
                    let context =this
                    if (context.contactsList.length > 0) {
                        console.log("联系人有数据->",context.contactsList);
                        return true
                    }
                    console.log("联系人没有数据---------->",context.contactsList);
                    return false
                },

            },
            components: {
                avatar: components.getAvatar
            },
            directives: {
                scrollTop: function (el) {
                    Vue.nextTick(function () {
                        $(el).scrollTop(0);
                    });
                }
            },
            created: function () {
                var context = this;
                im.$on('searchBlur', function () {
                    context.showSearchRecord = false;
                    context.searchBoxBlur();
                });
                if (!utils.isEmpty(this.keyword)) {
                    this.searchAll();
                }
            },
            watch: {
                $route: function () {
                    // this.clear();
                },
                starScontact: function (newValue, oldVal) {
                    // console.log(JSON.stringify(newValue), JSON.stringify(oldVal))
                },
                keyword: function (newValue, oldVal) {
                    // 删除空格
                    if (newValue.length < oldVal.length) {
                        console.log("我重置了1");
                        this.showSearch();
                        this.keywordChanged(newValue.replace(/\s+/g, ''));
                    } else {
                        newValue = newValue.replace(/\s+/g, '');
                        oldVal = oldVal.replace(/\s+/g, '');
                        // 如果新的keyword和旧keyword相同，则不搜索
                        if (newValue && newValue === oldVal) {
                            return;
                        }
                        console.log("我重置了");
                        this.showSearch();
                        this.keywordChanged(newValue);

                    }

                },
                currentView: function () {
                    initSearch(this);
                }
            },
            methods: {
                showSearch: function () {
                    // this.searchBeforeReturning.contacts =false;
                    // this.searchBeforeReturning.contactsFriends =false;
                    this.searchBeforeReturning.groups = false;
                    this.searchBeforeReturning.dutys = false;
                    // this.searchBeforeReturning.dutys =falsecers 
                    this.searchBeforeReturning.orgs = false;
                    this.searchBeforeReturning.history = false;
                    this.searchBeforeReturning.pubs = false;
                    this.searchBeforeReturning.starScontact = false;
                    this.searchBeforeReturning.pinGroup = false;
                    this.showSearchContacts.contacts = false;
                    this.showSearchContacts.contactsFriends = false;
                },
                keywordChanged: function (newValue) {
                    console.log("===>正在搜索接口", newValue);
                    var context = this;
                    this.cancelSearch();
                    this.searchPending = setTimeout(function () {
                        context.searchPending = null;
                        console.log('isBusy==>', context.isBusy);
                        // if (context.isBusy) {
                        //     context.keywordChanged(newValue);
                        // } else {
                        // initSearch(context);
                        if (newValue) {
                            context.showSearchRecord = false;
                        } else if (context.inputIsFocus) {
                            context.showSearchRecord = true;
                        }
                        context.doSearch(newValue);
                        // }
                    }, 2000);
                },
                doSearch: function (value) {
                    this.currentView = '';
                    this.showHistoryDetail = false;
                    this.showDutysDetail = false;
                    this.showOrgsDetail = false;
                    this.showStarScontactDetail = false;
                    console.log('is==>', utils.isEmpty(value));
                    if (utils.isEmpty(value)) {
                        this.clear();
                    } else {
                        this.searchAll();
                    }
                },
                searchAll: function () {
                    console.log('isStaff===>', this.isStaff);
                    if (this.isStaff) {
                        this.getContacts();
                        // this.getDutys();
                        this.getOrgs();
                        this.getPubs();
                        this.getPinGroup();
                    }
                    // searchFriend(this, friendApi);
                    this.searchGroup();
                    this.getStarScontact();
                    this.getHistory();
                },
                toastError: function (errorCode) {
                    if (!this.keyword) common.toastError(errorCode);
                },
                isCompany: function (org) {
                    return +org.type === common.OrgType.COMPANY;
                },
                isStaffs: function (org) {
                    return +org.type === common.OrgType.STAFF;
                },
                isDept: function (org) {
                    return +org.type === common.OrgType.DEPT;
                },
                searchBoxBlur: function () {
                    if (this.$refs.searchBox) this.$refs.searchBox.blur();
                },
                getGroupType: common.getGroupType,
                memberCount: function (duty) {
                    var count = duty.count || duty.member_count || 0;
                    return count;
                },
                showGroupType: function (group) {
                    return group && group.type > 0;
                },
                showMenu: function () {
                    this.isShowMenu = true;
                    im.$on('imclick', this.hideMenu);
                },
                hideMenu: function () {
                    this.isShowMenu = false;
                    im.$off('imclick', this.hideMenu);
                },
                focus: function () {
                    if (this.$refs.searchBox) {
                        this.$refs.searchBox.focus();
                    }
                },
                getUsername: common.getUsername,
                getGroupName: common.getGroupName,
                createGroup: function () {
                    var userId = im.auth.id;
                    dataModel.User.getBatch([userId], function (errorCode, list) {
                        // dialog.createGroup(null, list);
                        // dialog.blishGroup(null, list,true,'establish',false);
                        dialog.newDialogBox(null, list, "created");
                    });
                },
                createReport: function () {
                    let that = this;
                    dialog.addContact({}, function (result) {
                        that.$emit('addGroup', result)
                    });
                },
                gotoPinGroup: function (item) {
                    let that = this;
                    if (that.$route.name.indexOf('contact') != '-1' || that.$route.name.indexOf('organization') != '-1') {
                        // this.show = false
                        this.keyword = ''
                        that.$emit("searchPinGroup", item)
                    } else {
                        that.$router.push({
                            name: 'contact',
                            params: {
                                item: item,
                                source: 'search'
                            }
                        });
                    }


                    // this.$emit('gotoPinGroup', item)

                },
                addFriend: function () {
                    dialog.addFriend();
                },
                addPin: function () {
                    // dialog.newAddPin();
                    // dialog.pinDialogBox()
                    dialog.addPin({});
                },
                createApproval: function () {
                    var link = 'https://xh.cast.org.cn/default/oa/taskcenter/taskquery/sendRedirect.jsp?taskCenterRedirect=/freeflow/wap/launch&processdefId=1';
                    let url = ''
                    var loginInfo = utils.cache.get('loginInfo');
                    if (loginInfo && loginInfo.zkxToken) {
                        var token = decodeURIComponent(loginInfo.zkxToken) + ';path=/';
                        if (loginInfo.RCESESSIONID) {
                            // let urlParts = link.split('#');
                            // link += urlParts[0] + (
                            //     urlParts[0].indexOf('?') > 0 ? '&' : '?'
                            // ) + "sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) + "&uid=RY" + loginInfo.zkxEmpId+(
                            //     urlParts[1] ? ('#' + urlParts[1]) : ''
                            // );
                            link += "&sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                                "&uid=RY" + loginInfo.zkxEmpId

                        }

                        // link = 'https://xh.cast.org.cn/default/oa/taskcenter/taskquery/sendRedirect.jsp?taskCenterRedirect=/freeflow/wap/launch&processdefId=1?';
                        url = RongIM.config.loginServer + '/sign-bridge.html' + '?target=' + encodeURIComponent(link) +
                            '&token=' + encodeURIComponent(token);
                        console.log(url)
                    }
                    RongIM.browserWindow.openPSArticle(url)
                    // RongDesktop.browserWin.create({
                    //     width: 1000,
                    //     minWidth: 800,
                    //     path: url,
                    // });
                    // window.open(url);
                },
                cancelSearch: function () {
                    if (this.searchPending) {
                        clearTimeout(this.searchPending);
                        this.searchPending = null;
                    }
                },
                clear: function () {
                    this.cancelSearch();
                    this.keyword = '';
                    this.contacts = [];
                    this.dutys = [];
                    this.orgs = [];
                    this.groups = [];
                    this.history = [];
                    this.pubs = [];
                    this.starScontact = [];
                    this.pinGroups = [];
                    this.currentView = '';
                    this.showSearch()
                },
                getContacts: function () {
                    console.log(111);
                    if (this.isStaff) {
                        var context = this;
                        context.busy.contacts = true;
                        // orgApi.searchInMyOrg({
                        //     type: 'staff',
                        //     keyword: context.keyword,
                        //     scope: 'name,duty,mobile,staff_no'
                        // }, function(staffList) {
                        //     console.log("staffList--->",staffList);
                        //     context.showSearchContacts.contacts=true,
                        //     // console.log("context.showSearchContacts.contacts",context.showSearchContacts.contacts);
                        //     renderStaffList(
                        //         context, orgApi, userApi, friendApi,
                        //         staffList, context.keyword
                        //     );
                        //     context.busy.contacts = false;
                        // });
                        // getContacts(this, orgApi, userApi, friendApi);
                        console.log(context.keyword);
                        var xhr = new XMLHttpRequest();
                        xhr.open("GET", server + "/staffs/search/inOrgsNew?keyword=" + context.keyword, true);
                        xhr.setRequestHeader('Content-Type', 'application/json');
                        xhr.send();
                        xhr.onreadystatechange = function () {
                            if (xhr.readyState == 4 && xhr.status == 200) {
                                var json = xhr.responseText;//获取到json字符串，还需解析
                                let result = JSON.parse(json).result.data;
                                console.log("get", result);
                                if (result.length == 0) {
                                    // var xhr = new XMLHttpRequest();
                                    xhr.open("GET", server + "/staffs/search/inOrgsNew?keyword=" + context.keyword, true);
                                    xhr.setRequestHeader('Content-Type', 'application/json');
                                    xhr.send();
                                    xhr.onreadystatechange = function () {
                                        if (xhr.readyState == 4 && xhr.status == 200) {
                                            var json = xhr.responseText;//获取到json字符串，还需解析
                                            let result = JSON.parse(json).result.data;
                                            console.log("get2", result);
                                                context.contacts = result;
                                                context.busy.contacts = false;
                                                context.showSearchContacts.contacts = true,
                                                    searchFileHelper(context, friendApi);

                                        }
                                    }
                                } else {
                                    console.log("双搜索else=========================");
                                    context.contacts = result;
                                    context.busy.contacts = false;
                                    context.showSearchContacts.contacts = true,
                                        searchFileHelper(context, friendApi);
                                }

                            }
                        }
                    }
                },
                getDutys: function () {
                    getDutys(this, orgApi);
                },
                getOrgs: function () {
                    /*
                                    var context = this;
                                    context.busy.orgs = true;
                                    orgApi.searchInMyOrg({
                                        type: 'depart',
                                        keyword: context.keyword,
                                        scope: 'name'
                                    }, function(departList) {
                                        context.orgs = departList;
                                        context.busy.orgs = false;
                                    });
                    */
                    getOrgs(this, orgApi);
                },
                getGroups: function () {
                    getGroups(this, dataModel.Group, dataModel.Conversation);
                },
                searchGroup: function () {
                    searchGroup(this, dataModel.Group);
                },
                getPubs: function () {
                    getPubs(this, pubApi);
                },
                getPinGroup: function () {
                    getPinGroup(this, orgApi, groupApi);
                },
                getStarScontact: function () {
                    getStarScontact(this, starApi)
                },
                getHighlightUsername: function (user) {
                    var name = common.getUsernameHighlight(user);
                    return common.filterMark(name);
                },
                getHighlight: function (duty) {
                    return common.getHighlight(duty);
                },
                getHighlightGroupName: function (group) {
                    var name = common.highlight(common.getGroupName(group), group.range);
                    return common.filterMark(name);
                },
                getMatchedMembers: function (group) {
                    /*  搜索群组信息，群组内有包含此关键词的用户，当可以匹配到名字时显示匹配结果，匹配不到时，显示服务端返回的 user_list
                        前端匹配名字拿的群组前九个人
                        时间：2019-3-30
                        修改人：刘雨奇
                    */
                    var matchMembers = common.getMatchedMembers(this.keyword, group).length > 0;
                    if (matchMembers) {
                        return common.getMatchedMembers(this.keyword, group);
                    }
                    var members = [];
                    var memberNames = group.user_list;
                    memberNames.forEach(function (item) {
                        members.push(common.highlight(item.name, item.range));
                    });

                    if (members.length > 0) {
                        return members.join('，');
                    }
                    return '';
                },
                highlight: function (name) {
                    return common.highlight(name, this.keyword);
                },
                nextAction: function (conversationType, targetId, target) {
                    if (target.visible == 2) {
                        return common.messageToast({
                            type: 'success',
                            message: "该用户为半公开,无法发起会话!",
                            position: 'bottom'
                        });
                    }
                    if (targetId === im.auth.id) {
                        dialog.user(targetId);
                        return;
                    }
                    this.showConversation(conversationType, targetId, target);
                },
                showConversation: function (conversationType, targetId, target) {
                    var context = this;
                    var conversationApi = dataModel.Conversation;
                    var isPrivate = conversationType === utils.conversationType.PRIVATE;
                    if (isPrivate && userApi.executiveLimit(target)) {
                        dialog.user(target.id);
                        return;
                    }
                    var params = {
                        conversationType: conversationType,
                        targetId: targetId
                    };
                    this.currentView = '';

                    checkConUnread(this, conversationType, targetId, conversationApi, im);
                    this.$router.push({
                        name: 'conversation',
                        params: params
                    });
                    im.$emit('messageinputfocus');
                    conversationApi.add(params);
                    this.setRecord();
                    // this.clear();

                    var scrollToView = function (item) {
                        if (item) {
                            var parentHeight = item.parentNode.offsetHeight;
                            var offsetTop = item.offsetTop;
                            var alginWithTop = offsetTop > parentHeight;
                            item.scrollIntoView(alginWithTop);
                        }
                    };

                    var conversationItems = ['conversation', conversationType, targetId];
                    var itemId = conversationItems.join('-');
                    var conItem = document.getElementById(itemId);
                    var onTimeout = function () {
                        conItem = document.getElementById(itemId);
                        scrollToView(conItem);
                    };

                    scrollToView(conItem);

                    if (!conItem) {
                        conversationApi.getNativeList(function (errorCode, list) {
                            if (errorCode) {
                                context.toastError(errorCode);
                                return;
                            }
                            for (var i = 0, len = list.length; i < len; i += 1) {
                                var hasConversation = +list[i].conversationType === +conversationType && list[i].targetId === targetId;
                                if (hasConversation) {
                                    // 滚动到会话位置
                                    im.$emit('loadSearch', i);
                                    setTimeout(onTimeout, 0);
                                    break;
                                }
                            }
                        });
                    }
                },
                getHistory: function () {
                    getHistory(this, dataModel.Conversation);
                },
                setRecord: function () {
                    setRecord(this);
                },
                searchRecord: function (record) {
                    this.keyword = record;
                    this.showSearchRecord = false;
                },
                viewDutysDetail: function (duty) {
                    if (!duty) {
                        return;
                    }
                    var context = this;
                    initSearch(context);
                    context.showDutysDetail = true;
                    context.dutysDetail = {
                        name: duty.name,
                        list: [],
                        count: duty.count
                    };
                    userApi.searchByDuty(duty.name, function (errorCode, result) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        context.dutysDetail.list = result.data;
                    });
                },
                viewOrgsDetail: function (org) {
                    if (!org) {
                        return;
                    }
                    var context = this;
                    initSearch(context);
                    context.showOrgsDetail = true;
                    context.orgsDetail = {
                        // members: [],
                        name: org.name || org.deptName,
                        list: [],
                        count: org.count || org.member_count
                    };
                    orgApi.getBranch(org.id, null, function (errorCode, dept) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        var _list = [].concat(dept.staffs, dept.depts, dept.companies);
                        context.orgsDetail.list = _list;
                    });
                },
                showDeatil: function (item) {
                    if (!item) {
                        return;
                    }
                    var context = this;
                    if (item.matchCount === 1) {
                        gotoMessage(context, item.latestMessage, im);
                        return;
                    }
                    initSearch(context);
                    context.searchHistoryDetail = {
                        user: item.user,
                        group: item.group,
                        list: [],
                        count: item.matchCount
                    };
                    var params = {
                        conversationType: item.conversationType,
                        targetId: item.targetId,
                        timestamp: 0,
                        keyword: context.keyword,
                        count: 0
                    };
                    dataModel.Message.search(params, function (errorCode, searchList) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        dataModel.Message.addSendUserInfo(searchList, function (error, list) {
                            context.searchHistoryDetail.list = list;
                            context.showHistoryDetail = true;
                        });
                    });
                },
                getUserPath: function (user) {
                    var str = '';
                    var path = user.org_path.concat([]);
                    if (path.length === 1) {
                        str = path[0].name;
                    } else if (path.length === 2) {
                        str = path[0].name + '>' + path[1].name;
                    } else if (path.length > 2) {
                        str = path[0].name + '>...>' + path[path.length - 1].name;
                    }
                    return str;
                },
                gotoMessage: function (message) {
                    gotoMessage(this, message, im);
                },
                matchHighlight: function (message) {
                    var locale = this.locale;
                    var prefix = locale.message.prefix[message.messageType] || '';
                    var template = messageSearch[message.messageType];
                    return prefix + (template ? template(message, this.keyword) : message.content);
                },
                enter: function () {
                    // 对应类型搜索enter键的事件
                    var selectItem = this.curItem || getItem(this, selectIndex);
                    switch (selectItem.type) {
                        case 1:
                        case 5:
                            this.nextAction(1, selectItem.item.id, selectItem.item);
                            break;
                        case 4:
                            this.showConversation(3, selectItem.item.id);
                            break;
                        case 6:
                            this.showDeatil(selectItem.item);
                            break;
                        default:
                            break;
                    }
                    this.showSearchRecord = false;
                },
                inputFocus: function () {
                    getRecord(this);
                    this.showSearchRecord = true;
                    this.inputIsFocus = true;
                    var context = this;
                    var hide = function ($event) {
                        if ($($event.target).is('.rong-search-item') || $($event.target).is('.rong-field-search') || $($event.target).is('.rong-record-icon') || $($event.target).is('.rong-record-name')) {
                            return;
                        }
                        context.showSearchRecord = false;
                        $(document).off('mousedown', hide);
                    };
                    $('body').on('mousedown', hide);
                },
                inputBlur: function () {
                    this.inputIsFocus = false;
                    this.setRecord();
                },
                isEqual: function (item, type) {
                    type = +type;
                    var selectItem = this.curItem || getItem(this, selectIndex);
                    if (!selectItem) {
                        return false;
                    }
                    var selected = selectItem.item;
                    if (selectItem.type !== type) {
                        return false;
                    }
                    var equal = false;
                    switch (selectItem.type) {
                        case 2:
                            equal = selected.name === item.name;
                            break;
                        case 1:
                        case 3:
                        case 4:
                        case 5:
                            equal = selected.id === item.id;
                            break;
                        case 6:
                            equal = common.sameConversaton(item, selected);
                            break;
                        default:
                            break;
                    }
                    return equal;
                },
                checkPath: function (item) {
                    if (item.pathName || item.path || item.org_path || (item.orgs_info && item.orgs_info.length > 0)) {
                        return true;
                    }
                    return false;
                },
                getPathName: function (item) {
                    return common.getPathName(item, orgApi);
                },
                getPathNameEllipsis: function (item) {
                    let pathStr = "";
                    if (item.pathNameEllipsis && item.pathNameEllipsis.length > 0) return item.pathNameEllipsis

                    pathStr = common.getPathNameEllipsis(item, orgApi);

                    // if(item.pathNameEllipsis == "" && pathStr == "") {
                    //     pathStr = this.getPath(item).pathNameEllipsis;
                    // }
                    return pathStr
                },
                getPathNameSuffix: function (item) {
                    let nameStr = "";

                    if (item.getPathNameSuffix && item.getPathNameSuffix.length > 0) return item.getPathNameSuffix

                    nameStr = common.getPathNameSuffix(item, orgApi);

                    // if(item.getPathNameSuffix == "" && nameStr == "") {
                    //     nameStr = this.getPath(item).getPathNameSuffix;
                    // }

                    return nameStr;
                },
                getPath(item) {
                    console.log('item的值', item);
                    let staring = "",
                        name = "",
                        newArr = []
                    orgApi.getOrgPath(item.id, function (req, res) {
                        const { main_duty, main_org, orgs_info } = res;
                        // 改变主路径npm
                        if (main_org.mainDepart == '1') {
                            name = main_duty || main_org.name;
                            main_org.path.forEach(item => item.name != '科学组织云' && newArr.push(item.name))
                        } else {
                            name = main_duty || orgs_info[0].name;
                            orgs_info[0].path.forEach(item => newArr.push(item.name))
                        }
                        staring = newArr.join(' > ');
                        if (res.id == item.id) {
                            item.pathNameEllipsis = staring;
                            item.getPathNameSuffix = name;
                        }
                    })
                    return item
                },
                loadMore: function () {
                    loadMore(this);
                },
                showPinGroups: function () {
                    if (utils.isEmpty(this.currentView)) {
                        var showDeatil = this.showHistoryDetail || this.showDutysDetail || this.showOrgsDetail;
                        return this.pinGroups.length > 0 && !showDeatil;
                    }
                    return this.currentView === 'pinGroups' && this.pinGroups.length > 0;
                },
                getPinGroupName: function (pinGroup) {
                    var title = common.textMessageFormat(pinGroup.name);
                    let text = this.keyword
                    return common.highlight(title, text);
                },
                getMatchedPinGroupMembers: function (itemName) {
                    let that = this
                    if (itemName) {
                        let names = itemName.split('、').filter(obj => obj.indexOf(that.keyword) > -1)
                        let members = []
                        names.forEach(function (item) {
                            members.push(common.highlight(item, that.keyword));
                        });
                        return members.join('、');
                    }
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function loadMore(context) {

        var end = context.currentPage * context.pageNum;
        var list;
        if (context.showHistoryDetail) {
            list = context.searchHistoryDetail.list;
        } else if (context.showDutysDetail) {
            list = context.dutysDetail.list;
        } else if (context.showOrgsDetail) {
            list = context.orgsDetail.list;
        } else if (context.showStarScontactDetail) {
            list = context.starScontactDetail.list;
        } else {
            list = context[context.currentView];
        }
        if (list && list.length > end) {
            context.loadBusy = true;
            setTimeout(function () {
                context.loadBusy = false;
                context.currentPage += 1;
            }, 200);
        }
    }

    function initSearch(context) {
        selectIndex = 0;
        context.curItem = null;
        context.currentPage = 1;
        context.busy.contacts = true;
        if (context.auth && context.auth.isStaff) {
            context.busy.dutys = true;
            context.busy.orgs = true;
        }
        context.busy.groups = true;
        context.busy.history = true;
        context.busy.pubs = true;
        context.busy.pinGroup = true
    }

    function gotoMessage(context, message, im) {
        var conversationApi = im.dataModel.Conversation;
        var conversationType = message.conversationType;
        var targetId = message.targetId;
        var router = context.$router;
        context.currentView = '';
        checkConUnread(context, conversationType, targetId, conversationApi, im);
        router.push({
            name: 'conversation',
            params: {
                conversationType: message.conversationType,
                targetId: message.targetId,
                focus: true
            },
            query: {
                timestamp: (new Date()).getTime(),
                messageUId: message.messageUId
            }
        });
    }

    function getSubstrHighlight(str, keyword, maxLength) {
        maxLength = maxLength || 10;
        str = str.replace(/\r\n/g, '');
        str = str.replace(/\n/g, '');
        var keyLength = utils.getLength(keyword);
        var startStr = str.substring(0, str.indexOf(keyword));
        var startLength = utils.getLength(startStr);
        var result = '';
        if (startLength + keyLength > maxLength) {
            var i = (maxLength - keyLength) / 2;
            var move = i > 0 ? i : 0;
            var start = utils.slice(str, startLength - move).length;
            result = '...' + str.substring(start);
        } else {
            result = str;
        }
        result = utils.encodeHtmlStr(result);
        result = result.replace(keyword, '<em>' + keyword + '</em>');
        return result;
    }

    function getFriends(context, friendApi, callback) {
        callback = callback || $.noop;
        friendApi.getList(function (errorCode, list) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.showSearchContacts.contactsFriends = true
            // console.log("context.showSearchContacts.contactsFriends",context.showSearchContacts.contactsFriends);
            common.sortUsers(list);
            context.friends = list;
            callback();
        });
    }

    function searchFriend(context, friendApi) {
        console.log("搜索好朋友");
        var busy = context.busy;
        busy.contacts = true;
        var keyword = context.keyword;
        if (keyword.length === 0) {
            context.contacts = [];
            busy.contacts = false;
            console.log("空空空空");
        } else {
            getFriends(context, friendApi, function () {
                busy.contacts = false;
                var searchFriendList = [];
                context.friends.forEach(function (item) {
                    var nameRange = utils.searchStrRange(item.name, keyword);
                    if (nameRange) {
                        searchFriendList.push($.extend({
                            range: nameRange
                        }, item));
                        return;
                    }
                    var aliasRange = utils.searchStrRange(item.alias, keyword);
                    if (aliasRange) {
                        searchFriendList.push($.extend({
                            range: aliasRange
                        }, item));
                    }
                });
                context.contacts = searchFriendList;
                console.log("searchFriendList",searchFriendList);
                // console.log("searchFriend方法执行searchFileHelper");
                // searchFileHelper(context, friendApi);
            });
        }
    }

    function getContacts(context, orgApi, userApi, friendApi) {
        var numReg = new RegExp(/^[0-9]*$/);
        var emailReg = new RegExp(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/);
        var busy = context.busy;
        var keyword = context.keyword;
        var promiseList = [];
        var staffList = [];
        busy.contacts = true;
        promiseList.push(orgApi.search(keyword, function (errorCode, result) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            [].unshift.apply(staffList, result);
            // staffList = staffList.concat(result);
        }));
        if (emailReg.test(keyword)) {
            promiseList.push(userApi.searchByEmail(keyword, function (errorCode, result) {
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                staffList = staffList.concat(result);
            }));
        }
        if (keyword.length > 3 && numReg.test(keyword)) {
            promiseList.push(userApi.searchByMobile(keyword, function (errorCode, result) {
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                staffList = staffList.concat(result);
            }));
        }
        $.when.apply(null, promiseList).then(function () {
            renderStaffList(
                context, orgApi, userApi, friendApi, uniq(staffList), keyword
            );
            busy.contacts = false;
        });
    }

    function renderStaffList(context, orgApi, userApi, friendApi, staffList, keyword) {
        console.log("renderStaffList--->", staffList);
        common.searchAlias(staffList, keyword, userApi);
        // var friendList = friendApi.getCacheList();
        // friendList = friendList.filter(function(item) {
        //     return +item.user_type === common.UserType.VISITOR;
        // });
        // var searchFriendList = [];
        // friendList.forEach(function(item) {
        //     console.log("friendList---->",friendList);
        //     var nameRange = utils.searchStrRange(item.name, keyword);
        //     if (nameRange) {
        //         searchFriendList.push($.extend({
        //             range: nameRange
        //         }, item));
        //         return;
        //     }
        //     var aliasRange = utils.searchStrRange(item.alias, keyword);
        //     if (aliasRange) {
        //         searchFriendList.push($.extend({
        //             range: aliasRange
        //         }, item));
        //     }
        // });
        // // context.contacts = friendList.concat(staffList);
        // // 优化：删除无用属性减少 Vue 的属性变更监听
        // var contacts = searchFriendList.concat(staffList);
        // contacts.forEach(function(item) {
        //     item.pathName = common.getPathName(item, orgApi);
        //     item.pathNameEllipsis = common.getPathNameEllipsis(item, orgApi);
        //     item.pathNameSuffix = common.getPathNameSuffix(item, orgApi);
        //     delete item.orgs_info;
        //     delete item.name_keyword_initial;
        //     delete item.state;
        //     delete item.user_type;
        //     delete item.is_executive;
        // });
        // context.contacts = contacts;
        context.contacts = staffList;
        console.log("renderStaffList2---->", context.contacts);
        searchFileHelper(context, friendApi);
    }

    function getPubs(context, pubApi) {
        var busy = context.busy;
        busy.pubs = true;
        pubApi.search(context.keyword, function (errorCode, list) {
            busy.pubs = false;
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.searchBeforeReturning.pubs = true;
            // console.log("context.searchBeforeReturning.pubs",context.searchBeforeReturning.pubs);

            context.pubs = list;
        });
    }

    function getPinGroup(context, orgApi, groupApi) {
        var busy = context.busy;
        busy.pinGroup = true;
        orgApi.getPinGroups(context.keyword, function (list) {
            busy.pinGroup = false;
            context.searchBeforeReturning.pinGroup = true;
            // console.log("context.searchBeforeReturning.pinGroup",context.searchBeforeReturning.pinGroup);
            if (!list.count) {
                return;
            }

            context.pinGroups = list.data.map(o => {
                return {
                    ...o,
                    member: []
                }
            });
            context.pinGroups.forEach(obj => {
                groupApi.getPinGroupsDetailByid(obj.id, (erroeCode, result) => {
                    if (erroeCode) {
                        return false;
                    }
                    obj.member = result.data[0].member
                })
            })
        });
    }

    function getStarScontact(context, starApi) {
        let searchResultArr = [],
            searchKey = context.keyword,
            busy = context.busy;
        busy.starScontact = true;
        starApi.getList(function (errorCode, list) {
            busy.starScontact = false;
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.searchBeforeReturning.starScontact = true;
            // console.log("context.searchBeforeReturning.starScontact",context.searchBeforeReturning.starScontact);

            list.forEach(function (item) {
                console.log("---这是什么数据", item)
                var nameRange = utils.searchStrRange(item.name, searchKey);
                var aliasRange = utils.searchStrRange(item.alias, searchKey);
                item.orgs_info = item.orgsInfo;
                if (nameRange || aliasRange) {
                    var result = $.extend({
                        range: nameRange,
                        aliasRange: aliasRange
                    }, item);
                    searchResultArr.push(result);
                }
            });
            common.sortUsers(searchResultArr);
            // searchResultArr.length > 0 ? context.showStarScontactDetail = true : context.showStarScontactDetail= false;
            context.starScontact = searchResultArr;
        })
    }

    function searchFileHelper(context, friendApi) {
        console.log("进入搜索文件小助手context--->",context);
        var busy = context.busy;
        var locale = context.locale;
        var keyword = context.keyword;
        var fileHelper = {};
        var range = utils.searchStrRange(locale.components.getFileHelper.title, keyword);
        fileHelper.range = range;
        if (range) {
            friendApi.getFileHelper(function (errorCode, helper) {
                busy.contacts = false;
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                helper.name = locale.components.getFileHelper.title;
                $.extend(fileHelper, helper);
                console.log("搜索文件小助手---->",fileHelper);
                context.contacts.push(fileHelper);

            });
        }
        console.log("searchFileHelper", context.contacts);
    }

    function getDutys(context, orgApi) {
        var busy = context.busy;
        busy.dutys = true;
        orgApi.searchDuty(context.keyword, function (errorCode, list) {
            busy.dutys = false;
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.dutys = list;
        });
    }

    function getOrgs(context, orgApi) {
        var busy = context.busy;
        busy.orgs = true;
        orgApi.searchCompanies(context.keyword, function (errorCode, companies) {
            if (errorCode) {
                context.toastError(errorCode);
                busy.orgs = false;
                return;
            }
            context.searchBeforeReturning.orgs = true,
                // console.log("context.searchBeforeReturning.orgs",context.searchBeforeReturning.orgs);
                context.coList = companies.map(function (co) {
                    if (co.level === 1) {
                        co.count = RongIM.dataModel._Cache.rootCompanyMemberCount;
                    }
                    return co;
                });
            orgApi.searchOrgs(context.keyword, function (error, result) {
                busy.orgs = false;
                if (error) {
                    context.toastError(error);
                    return;
                }
                context.orgs = [].concat(companies, result).sort(function (a, b) {
                    var aName = a.name_pinyin_full || a.name;
                    var bName = b.name_pinyin_full || b.name;
                    return aName.localeCompare(bName);
                });
            });
        });
    }

    function searchGroup(context, groupApi) {
        var busy = context.busy;
        busy.groups = true;
        var _groups = [];
        groupApi.search(context.keyword, function (errorCode, groups) {
            busy.groups = false;
            if (errorCode) {
                return;
            }
            context.searchBeforeReturning.groups = true;
            // console.log("context.searchBeforeReturning.groups",context.searchBeforeReturning.groups);

            context.groups = [];
            groups.forEach(function (group) {
                var rangeName = utils.searchStrRange(context.getGroupName(group), context.keyword);
                var isSearched = group.user_list.length > 0;
                if (rangeName || isSearched) {
                    group = $.extend({
                        range: rangeName
                    }, group);
                    _groups.push(group);
                }
            });
            common.sortGroups(_groups);
            context.groups = _groups;
        });
    }

    function getGroups(context, groupApi, conversationApi) {
        var groupDefer = $.Deferred();
        var busy = context.busy;
        busy.groups = true;
        groupApi.getList(function (errorCode, groups) {
            if (errorCode) {
                groupDefer.reject(errorCode);
                return;
            }
            groupDefer.resolve(groups);
        });

        $.when(groupDefer.promise())
            .then(function (favGroups) {
                var conversationList = conversationApi.getLocalList();
                conversationList = conversationList.filter(function (item) {
                    return item.conversationType === utils.conversationType.GROUP;
                });
                var list = [].concat(favGroups);
                var groupIds = list.map(function (item) {
                    return item.id;
                });
                conversationList.forEach(function (conversation) {
                    var existed = groupIds.indexOf(conversation.targetId) >= 0;
                    if (!existed) {
                        var group = utils.toJSON(conversation.group);
                        group.id = conversation.targetId;
                        list.push(group);
                    }
                });
                context.groups = [];
                list.forEach(function (group) {
                    var rangeName = utils.searchStrRange(context.getGroupName(group), context.keyword);
                    var matchMembers = common.getMatchedMembers(context.keyword, group).length > 0;
                    if (rangeName || matchMembers) {
                        group = $.extend({
                            range: rangeName
                        }, group);
                        context.groups.push(group);

                    }
                });
            }).fail(function (errorCode) {
                context.toastError(errorCode);
            }).always(function () {
                busy.groups = false;
            });
    }

    function getHistory(context, conversationApi) {
        if (context.keyword !== '') {
            var busy = context.busy;
            busy.history = true;
            conversationApi.search(context.keyword, function (errorCode, list) {
                busy.history = false;
                context.searchBeforeReturning.history = true
                // console.log("context.searchBeforeReturning.history",context.searchBeforeReturning.history);

                list.sort(function (one, another) {
                    return another.sentTime - one.sentTime;
                });
                context.history = list;
            });
        }
    }

    // 获取搜索历史
    function getRecord(context) {
        var recordList = cache.get('record') ? (cache.get('record')[context.auth.id] || []) : [];
        context.recordList = recordList;
    }

    // 设置搜索历史
    function setRecord(context) {
        var keyword = context.keyword.replace(/\s+/g, '');
        if (!keyword) {
            return;
        }
        var recordList = context.recordList;
        recordList = recordList.filter(function (item) {
            return item !== keyword;
        });
        recordList.unshift(keyword);
        recordList = recordList.slice(0, 5);
        context.recordList = recordList;

        var recordObject = cache.get('record') || {};
        recordObject[context.auth.id] = recordList;
        cache.set('record', recordObject);
    }

    function getVisibleResultLength(context) {
        var length = {
            contacts: Math.min(context.contacts.length, 3),
            dutys: Math.min(context.dutys.length, 3),
            orgs: Math.min(context.orgs.length, 3),
            groups: Math.min(context.groups.length, 3),
            pubs: Math.min(context.pubs.length, 3),
            history: Math.min(context.history.length, 3),
            starScontact: Math.min(context.starScontact.length, 3)
        };

        if (length[context.currentView]) {
            length = {
                contacts: 0,
                dutys: 0,
                orgs: 0,
                groups: 0,
                pubs: 0,
                history: 0,
                starScontact: 0
            };
            length[context.currentView] = context[context.currentView].length;
        }

        length.all = length.contacts + length.dutys + length.orgs + length.groups + length.pubs + length.history + length.starScontact;
        return length;
    }

    // 获取当前选中的是搜索结果中的哪一个
    function getItem(context, index) {
        var lenObj = getVisibleResultLength(context);
        var item = {};
        var thisIndex = index;
        if (index < lenObj.contacts) {
            item = {
                type: 1,
                item: context.contacts[thisIndex]
            };
        } else if (index < lenObj.contacts + lenObj.dutys) {
            thisIndex -= lenObj.contacts;
            item = {
                type: 2,
                item: context.dutys[thisIndex]
            };
        } else if (index < lenObj.contacts + lenObj.dutys + lenObj.orgs) {
            thisIndex = thisIndex - lenObj.contacts - lenObj.dutys;
            item = {
                type: 3,
                item: context.orgs[thisIndex]
            };
        } else if (index < lenObj.contacts + lenObj.dutys + lenObj.orgs + lenObj.groups) {
            thisIndex = thisIndex - lenObj.contacts - lenObj.dutys - lenObj.orgs;
            item = {
                type: 4,
                item: context.groups[thisIndex]
            };
        } else if (index < lenObj.contacts + lenObj.dutys + lenObj.orgs + lenObj.groups + lenObj.pubs) {
            thisIndex = thisIndex - lenObj.contacts - lenObj.dutys - lenObj.orgs - lenObj.groups;
            item = {
                type: 5,
                item: context.pubs[thisIndex]
            };
        } else {
            thisIndex = thisIndex - lenObj.contacts - lenObj.dutys - lenObj.orgs - lenObj.groups - lenObj.pubs;
            item = {
                type: 6,
                item: context.history[thisIndex]
            };
        }
        return item;
    }

    function checkConUnread(context, conversationType, targetId, conversationApi, im) {
        conversationApi.getOne(conversationType, targetId, function (errorCode, conversation) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            if (conversation.unreadMessageCount > 0) {
                conversationApi.clearUnReadCount(conversationType, targetId);
                im.$emit('conversationchange', conversation);
            }
        });
    }

    function uniq(array) {
        var map = {};
        return array.filter(function (item) {
            var id = item.id;
            if (map[id]) {
                return false;
            }
            map[id] = id;
            return true;
        });
    }
}(RongIM, {
    jQuery: jQuery,
    Vue: Vue
}, RongIM.components));