/**
 * 
 */
(function (RongIM) {
  
  'use strict';
  console.log(RongIM)
  // 公共节点数据
  var treeViewDataJson = {
    // 我的组织
    myOrgTree: {
      text: RongIM.locale.zh.blish.orgContact,
      icon: 'my',
      root:true,
      id: "",
      rootType: 'myOrganization',
      isSelectd: true,
      tree: 'left',
      onlyId: createRandomId(),
      state: {
        checked: false,
        disabled: false,
        expanded: true,
        selected: false
      },
    },
    // // 我的关注
    // myFollowTree: {
    //   text: RongIM.locale.zh.blish.friend,
    //   icon: 'follow',
    //   root:true,
    //   id: 'BM1101',
    //   rootType: 'myFollow',
    //   onlyId: createRandomId(),
    //   parent_id: 0,
    //   tree: 'left'
    // },
    // 我的关注
    myFollowTree: {
      text: RongIM.locale.zh.blish.friend,
      icon: 'follow',
      root: true,
      id: 'BM1101',
      onlyId: createRandomId(),
      rootType: 'myFollow',
      tree: 'left'
    },
    // 部门
    followDept: {
      text: RongIM.locale.zh.blish.followDept,
      icon: 'follow-bumen',
      root:false,
      onlyId: createRandomId(),
      id: 'followDept',
      rootType: 'myFollow',
      nodeType: 'followDept',
      tree: 'left'
    },
    // 组织
    followOrganization: {
      text: RongIM.locale.zh.blish.followOrganization,
      icon: 'company-base',
      root:false,
      onlyId: createRandomId(),
      id: 'followOrganization',
      rootType: 'myFollow',
      nodeType: 'followOrganization',
      tree: 'left'
    },
    // 工作组
    followWorkingGroup: {
      text: RongIM.locale.zh.blish.followWorkingGroup,
      icon: 'follow-gongzuozu',
      root:false,
      onlyId: createRandomId(),
      id: 'followWorkingGroup',
      rootType: 'myFollow',
      nodeType: 'followWorkingGroup',
      tree: 'left'
    },
    // 我的通讯录
    myMailListTree: {
      text: RongIM.locale.zh.blish.myMailList,
      icon: 'my-mail-list',
      root: true,
      id: 'BM8965_z',
      onlyId: createRandomId(),
      rootType: 'myMailList',
      tree: 'left'
    },
    // 我的联盟单位
    myAllyTree: {
      text: RongIM.locale.zh.blish.myAlly,
      icon: 'my-ally',
      root: true,
      id: '',
      onlyId: createRandomId(),
      rootType: 'myAlly',
      tree: 'left'
    },
    // 联盟单位
    allyListTree: {
      text: RongIM.locale.zh.blish.allyList,
      icon: 'company',
      root: false,
      onlyId: createRandomId(),
      id: "allyList",
      rootType: 'allyList',
      nodeType: 'allyList',
      tree: 'left'
    },
    // 新的联盟单位申请
    allyApplyTree: {
      text: RongIM.locale.zh.blish.allyApply,
      icon: 'ally-apply-list',
      root: false,
      onlyId: createRandomId(),
      id: "",
      rootType: 'myAlly',
      nodeType: 'allyApply',
      tree: 'left'
    },
    // 科协组织云
    myKxyTree: {
      text: RongIM.locale.zh.blish.myMechanism,
      icon: 'china',
      root:true,
      onlyId: createRandomId(),
      id: "BM1101_o",
      rootType: 'KXY',
      tree: 'left'
    },
     // 通讯组
     distributionGroupTree: {
      text: RongIM.locale.zh.blish.distributionGroup,
      icon: 'tongxunzu',
      root:false,
      onlyId: createRandomId(),
      id: 'pinGroup',
      rootType: 'distributionGroup',
      nodeType: 'distributionGroup',
      tree: 'left'
    },
    // 群聊
    datSayGroupTree: {
      text: RongIM.locale.zh.blish.dayGroup,
      icon: 'day-group',
      root:false,
      onlyId: createRandomId(),
      id: 'BM1987_x',
      rootType: 'myMailList',
      nodeType: 'communicateGroup',
      tree: 'left'
    },
    // 外部联系人
    dayContactTree: { 
      text: RongIM.locale.zh.blish.dayContacts,
      icon: 'day-contact',
      root:false,
      onlyId: createRandomId(),
      id: 'BM2658_z',
      rootType: 'myMailList',
      nodeType: 'dailyContact',
      tree: 'left'
    },
    // 重要联系人
    specialContactTree: {
      text: RongIM.locale.zh.blish.importantContacts,
      icon: 'importan-contact',
      root:false,
      onlyId: createRandomId(),
      id: 'BM3542_c',
      rootType: 'myMailList',
      nodeType: 'KeyContacts',
      tree: 'left'
    },
    // 文件小助手
    FileAssistantTree: {
      text: RongIM.locale.zh.components.getFileHelper.title,
      icon: 'file-assistant',
      root: false,
      onlyId: createRandomId(),
      id: "BM5842_C",
      rootType: 'myMailList',
      nodeType: 'fileAssistant',
      tree: 'left'
    },
    // 入群申请
    groupApplyTree: {
      text: RongIM.locale.zh.blish.groupApply,
      icon: 'group-apply',
      root: false,
      onlyId: createRandomId(),
      id: "BM6548_C",
      rootType: 'myMailList',
      nodeType: 'groupApply',
      tree: 'left'
    },
    // 新好友申请
    newFriendApplyTree: {
      text: RongIM.locale.zh.blish.newFriendApply,
      icon: 'frienda-apply',
      root: false,
      onlyId: createRandomId(),
      id: "BM8516_c",
      rootType: 'myMailList',
      nodeType: 'friendApply',
      tree: 'left'
    },
    // 最近聊天
    newRecentTree: {
      text: RongIM.locale.zh.blish.recent,
      icon: 'frienda-apply',
      root: false,
      onlyId: createRandomId(),
      id: "BM44653_x",
      rootType: 'myMailList',
      nodeType: 'recent',
      tree: 'left'
    },
    // 最近联系人
    recentContacts: {
      text: RongIM.locale.zh.blish.myMailList,
      icon: 'my-mail-list',
      root: true,
      onlyId: createRandomId(),
      id: "BM85699_b",
      rootType: 'myMailList',
      nodeType: 'recentContacts',
      tree: 'left'
    }
  };
  RongIM.treeView = {
    treeViewData: treeViewDataJson,
    setTreeViewJson: function(treeViewArr){
      return configTreeViewJson(treeViewArr)
    },
    addItemNodes: function(item,rootType,treeType){
      return setItemNodes(item,rootType,treeType)
    },
    combine: function(list) {
      return combine(list)
    }
  };
}(RongIM));
/**treeView的默认参数 */
var initTreeKey= {
  text: "",                                  // 树节点名称
  icon: '',                                  // 树节点icon
  root: false,                               // 该树节点是否为根节点
  id: null,                                  // 该节点id
  rootType: '',                              // 该节点的根节点的类型(用于区分是哪个根节点的子节点)
  parent_id: 0,                              // 父节点id (如果该节点为根节点为0，默认为0)
  selectable: false,    
  BackColor: '',
  state: {
    checked: false,
    disabled: false,
    expanded: false,
    selected: false
  },
  isSelectd: false,                          // 是否选中
  type: '',                                  // 额外增加的参数(接口数据)            
  vchar_p3:'',                               // 额外增加的参数(接口数据)
  node_count:'',                             // 额外增加的参数(接口数据)
  tree: ''   ,                               // 实例化treeView组件区分(用于展示多个treeView)
};

/** 生成随机id*/ 
function createRandomId(){
  return (Math.random()*10000000).toString(16).substr(0,4)+'-'+(new Date()).getTime()+'-'+Math.random().toString().substr(2,5);
};

/**
 * 生成treeView JSON 数据 
 * @param {treeViewArr} Array 数组对象[{每个树需要配置的参数},{每个树需要配置的参数}]
 * */
function configTreeViewJson(treeViewArr){
  let generateArr= [];
  if(!Array.isArray(treeViewArr)) { return false}
  treeViewArr.forEach((item,index) => {
    let generateItemObj = {};
    Object.assign(generateItemObj ,initTreeKey);
    for(let key in item){
      if(key == "nodes" && Array.isArray(item[key]) && item[key].length > 0) {
        generateItemObj[key] = configTreeViewJson(item[key])
      }else {
        generateItemObj[key] = item[key];
      }
    }
    generateArr.push(generateItemObj)
  })
  return generateArr;
}

/**
 * 动态获取数据生成tree节点数据
 * @param {item}       Object  当前点击的节点数据
 * @param {rootType}   String  根节点类型
 * @param {treeType}   String  当前treeView类型(用于区分多个属性结构展示区分)
 */
function setItemNodes(item,rootType,treeType) {
  let nodeIcon = '';
  if (rootType == 'distributionGroup') {
    nodeIcon = 'txz-item'
  } else {
    if (typeof item.vchar_p3 !== 'undefined') {
      nodeIcon = item.vchar_p3 == 1 ? 'jianshe' : (item.vchar_p3 == 2  ? 'company' : 'yingyong');
    }
  }
  let itemNodeParams = {
    text: item.alias || item.name,
    id: item.id,
    parent_id: item.parent_id,
    selectable: false,
    BackColor: '',
    state: {
        checked: false,
        disabled: false,
        expanded: false,
        selected: false
    },
    onlyId: createRandomId(),
    isSelectd: false,
    rootType: rootType,
    type: item.type,
    vchar_p3: item.vchar_p3,
    node_count: item.node_count || 0,
    path: item.path,
    tree: treeType,
    icon: nodeIcon,
    // icon: rootType === 'distributionGroup'?'txz-item':(item.vchar_p3 == 1 ? 'jianshe' : item.vchar_p3 == 2  ? 'company' : 'yingyong')
  }
  if(item.mainly == 1){
    itemNodeParams.mainly = true
  }
  if(item.node_count > 0) {
    itemNodeParams.nodes= [];
  }
  return itemNodeParams;
}
//数组合并去重
function combine(arr){
  const res = new Map();
  return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
}