(function (RongIM) {
'use strict';

var components = RongIM.components;
var utils = RongIM.utils;
var common = RongIM.common;

function getFullUrl(path) {
    return '//rce-df.rongcloud.net/erp/approval' + path;
}

var ajax = function (options) {
    var auth = RongIM.instance.auth;
    options.url = getFullUrl(options.url);
    options.headers = $.extend({
        code: auth.code,
        userId: auth.id
    }, options.headers);
    if (typeof options.data === 'object') {
        options.data = 'param=' + JSON.stringify(options.data);
    }
    return $.ajax(options);
};

var serverApi = {
    getDetail: function (id, isLeader) {
        return ajax({
            url: '/request/getinfo.json?id=' + id,
            headers: {
                isLeader: isLeader
            }
        });
    },
    agree: function (parmas) {
        return ajax({
            url: '/add.json',
            method: 'post',
            headers: {
                isLeader: parmas.isLeader
            },
            data: {
                id: parmas.id,
                status: 2
            }
        });
    },
    reject: function (parmas) {
        return ajax({
            url: '/add.json',
            method: 'post',
            headers: {
                isLeader: parmas.isLeader
            },
            data: {
                id: parmas.id,
                status: 3
            }
        });
    }
};

RongIM.dialog.approvalDetail = function (brief) {
    var selfId = RongIM.instance.auth.id;
    var options = {
        template: 'modules/approval/detail.html',
        // props:['brief'],
        data: function () {
            return {
                show: true,
                brief: brief,
                approval: {
                    proposer: {},
                    approver: {}
                }
            };
        },
        components: {
            avatar: components.getAvatar
        },
        computed: {
            isLeader: function () {
                // 是否自己发起的 1 是 0 否
                return this.brief.userId === selfId ? 1 : 0;
            },
            showControl: function () {
                var isApprover = this.approval.approverId === selfId;
                var isWaitapprove = this.approval.status === 1;
                return isApprover && isWaitapprove;
            }
        },
        mounted: function () {
            getDetail(this);
            $(document).on('click', this.close);
        },
        methods: {
            close: function () {
                this.show = false;
                $(document).off('click', this.close);
            },
            getTimeString: function getTimeString(time) {
                return moment(time).format('YYYY/M/D H:m');
            },
            getShowName: function (user) {
                if (utils.isEmpty(user)) {
                    return '';
                }
                return user.id === selfId ? '我' : user.name;
            },
            agree: function () {
                var context = this;
                var id = this.approval.id;
                var params = {
                    id: id,
                    isLeader: this.isLeader
                };
                serverApi.agree(params).done(function (rep) {
                    if (rep.code !== 200) {
                        return;
                    }
                    context.approval.status = 2;
                });
            },
            reject: function () {
                var context = this;
                var id = this.approval.id;
                var params = {
                    id: id,
                    isLeader: this.isLeader
                };
                serverApi.reject(params).done(function (rep) {
                    if (rep.code !== 200) {
                        return;
                    }
                    context.approval.status = 3;
                });
            }
        }
    };
    common.mountDialog(options);
};

function getDetail(context) {
    var isLeader = context.isLeader;
    var id = context.brief.id;
    serverApi.getDetail(id, isLeader).done(function (rep) {
        if (rep.code !== 200) {
            return;
        }
        context.approval = rep;
        context.approval.proposer = {
            avatar: rep.portrait_rl,
            name: rep.user_name,
            id: rep.user_id
        };
        context.approval.approver = {
            avatar: rep.supervisor_portrait_url,
            name: rep.supervisor_name,
            id: rep.approver_id
        };
    });
}
}(RongIM));
