/*
说明：收藏详情
*/
(function (RongIM, components) {
    'use strict';

    var common = RongIM.common;
    // var dialog = RongIM.dialog;
    var utils = RongIM.utils;

    RongIM.dialog.collectDetail = function (items) {
        // var im = RongIM.instance;
        var userApi = RongIM.dataModel.User;
        var options = {
            name: 'ack',
            template: 'modules/collect/templates/collect-detail.html',
            data: function () {
                return {
                    show: true,
                    style: '',
                    item: items,
                    self: ''
                };
            },
            filters: {
                dateFormat: function (timestamp) {
                    return utils.dateFormat(timestamp, {
                        alwaysShowTime: true,
                        showAll: true
                    });
                }
            },
            mounted: function () {
                var context = this;
                if (context.item.sourceType !== 1) {
                    return;
                }
                var senderId = context.item.senderId;
                userApi.get(senderId, function (errorCode, result) {
                    if (errorCode) {
                        common.toastError(errorCode);
                        return;
                    }
                    context.self = result.name;
                });
            },
            methods: {
                close: function () {
                    this.show = false;
                },
                getMessageType: function (item) {
                    // var supported;// = childComponents[item.messageType];
                    var map = {
                        LocalImageMessage: 'ImageMessage',
                        LocalFileMessage: 'FileMessage'
                    };
                    var messageType = item.messageType;
                    messageType = map[item.messageType] || messageType;
                    return messageType;
                }
            },
            components: {
                customSelect: components.customSelect,
                TextMessage: components.getTextMessage,
                ImageMessage: components.getImageCollect,
                LocalImageMessage: components.getImageMessage,
                FileMessage: components.getFileMessage,
                LocalFileMessage: components.getFileMessage,
                VoiceMessage: components.getVoiceMessage,
                LocationMessage: components.getLocationMessage,
                CardMessage: components.getCardMessage,
                SightMessage: components.getSightMessage,
                RichContentMessage: components.getRichContentMessage,
                ApprovalMessage: components.getApprovalMessage,
                UnknownMessage: components.getUnknownMessage,
                GroupNoticeNotifyMessage: components.getGroupNoticeNotifyMessage,
                BQMMEmojiMessage: components.getBQMMEmojiMessage,
                BQMMGifMessage: components.getBQMMGifMessage,
                JrmfRedPacketMessage: components.getJrmfRedPacketMessage,
                PublicServiceRichContentMessage: components.getPSImageTextMessage,
                PublicServiceMultiRichContentMessage: components.getPSMultiImageTextMessage,
                VideoSummaryMessage: components.getSummaryMessage,
                RemoteControlSummaryMessage: components.getRemoteSummaryMessage,
                ReferenceMessage: components.getQuoteMessage
            }
        };
        common.mountDialog(options, function () {
            // 调试使用
        });
    };
}(RongIM, RongIM.components));
