(function (RongIM, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var messageApi = RongIM.dataModel.Message;
    var timer = null;
    /*
    说明： 选择用户信息发送已选收藏消息
    */
    RongIM.dialog.collect = function (context2) {
        var im = RongIM.instance;
        var collectApi = RongIM.dataModel.Collect;

        var options = {
            name: 'collect-dialog',
            template: 'modules/collect/templates/collect-dialog.html',
            data: function () {
                return {
                    show: true,
                    selected: [],
                    currentView: 'all',
                    list: [],
                    collectList: [],
                    index: -1,
                    oldkeyword: '',
                    keyword: '',
                    message: '',
                    busy: false,
                    filtedMessageList: [],
                    checkList: []
                };
            },
            props: {
                valueKey: {
                    type: String,
                    default: 'value'
                },
                nameKey: {
                    type: String,
                    default: 'name'
                }
            },
            computed: {
                isBusy: function () {
                    /* var hasInputValue = this.keyword.length > 0;
                    var matchCount=this.collectList.length = 0;
                    return hasInputValue && matchCount && this.busy; */
                    return this.busy;
                },
                isEmpty: function () {
                    var hasInputValue = this.keyword.length > 0;
                    var matchCount = this.collectList.length = 0;
                    return hasInputValue && matchCount;
                }
            },
            components: {
                search: components.getCollectSearch,
                customSelect: components.customSelect,
                TextMessage: components.getTextMessage,
                ImageMessage: components.getImageMessage,
                LocalImageMessage: components.getImageMessage,
                FileMessage: components.getFileMessage,
                LocalFileMessage: components.getFileMessage,
                VoiceMessage: components.getVoiceMessage,
                LocationMessage: components.getLocationMessage,
                CardMessage: components.getCardMessage,
                SightMessage: components.getSightMessage,
                RichContentMessage: components.getRichContentMessage,
                ApprovalMessage: components.getApprovalMessage,
                UnknownMessage: components.getUnknownMessage,
                GroupNoticeNotifyMessage: components.getGroupNoticeNotifyMessage,
                BQMMEmojiMessage: components.getBQMMEmojiMessage,
                BQMMGifMessage: components.getBQMMGifMessage,
                JrmfRedPacketMessage: components.getJrmfRedPacketMessage,
                PublicServiceRichContentMessage: components.getPSImageTextMessage,
                PublicServiceMultiRichContentMessage: components.getPSMultiImageTextMessage,
                VideoSummaryMessage: components.getSummaryMessage,
                RemoteControlSummaryMessage: components.getRemoteSummaryMessage,
                ReferenceMessage: components.getQuoteMessage
            },
            watch: {
                currentView: function (data) {
                    this.keyword = '';
                    this.oldkeyword = '';
                    this.index = -1;
                    if (data === 'all') {
                        this.collectList = this.list; return;
                    }
                    this.collectList = this.list.filter(function (item) {
                        return reName(data).indexOf(item.objectName) !== -1;
                    });
                }
                /* keyword:function(newValue,oldValue){
                     newValue = newValue.replace(/\s+/g,'');
                     oldValue = oldValue.replace(/\s+/g,'');
                     if(newValue&&newValue===oldValue){
                         return ;
                     }
                     this.collectList=this.list.filter(function(item){
                         return item.content.content.indexOf(newValue)!=-1;
                     })
                 } */
            },
            filters: {
                dateFormat: function (timestamp) {
                    return utils.dateFormat(timestamp, {
                        alwaysShowTime: true
                    });
                }
            },
            created: function () {
                this.checkList.push({
                    name: im.locale.components.collect.all,
                    value: 'all'
                });
            },
            destroyed: function () {
                collectApi.unwatch(this.userChanged);
            },
            mounted: function () {
                var context = this;
                getList(context, collectApi);
                context.userChanged = function () {
                    getList(context, collectApi);
                };
                collectApi.watch(context.userChanged);
            },
            methods: getMethods(collectApi, im, context2)
        };
        common.mountDialog(options);
    };
    function getList(context, collectApi) {
        context.busy = true;
        var params = {
            version: -1,
            scope: 'message'
        };
        collectApi.getList(params, function (errorCode, list) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            context.list = list;
            context.collectList = list;
            context.filtedMessageList = list;
            context.busy = false;
            var arr = list.map(function (item) {
                return item.objectName;
            });
            context.checkList = context.checkList.slice(0, 1);
            if (arr.indexOf('RC:TxtMsg') !== -1) {
                context.checkList.push({
                    name: context.locale.components.collect.text,
                    value: 'text'
                });
            }
            if (arr.indexOf('RC:VcMsg') !== -1) {
                context.checkList.push({
                    name: context.locale.components.collect.voice,
                    value: 'voice'
                });
            }
            if (arr.indexOf('RC:LBSMsg') !== -1) {
                context.checkList.push({
                    name: context.locale.components.collect.position,
                    value: 'position'
                });
            }
            if (arr.indexOf('RC:ImgMsg') !== -1 || arr.indexOf('RC:SightMsg') !== -1) {
                context.checkList.push({
                    name: context.locale.components.collect.video,
                    value: 'video'
                });
            }
            if (arr.indexOf('RC:FileMsg') !== -1 || arr.indexOf('LRC:fileMsg') !== -1) {
                context.checkList.push({
                    name: context.locale.components.collect.file,
                    value: 'file'
                });
            }
            if (arr.indexOf('RC:ImgTextMsg') !== -1) {
                context.checkList.push({
                    name: context.locale.components.collect.link,
                    value: 'link'
                });
            }
        });
    }
    function getMethods(collectApi, im) {
        return {
            close: function () {
                this.show = false;
            },
            getItemValue: function (item) {
                return item[this.valueKey];
            },
            getItemName: function (item) {
                return item[this.nameKey];
            },
            getSelected: function (value) {
                var context = this;
                var item = {};
                this.list.forEach(function (i) {
                    if (context.getItemValue(i) === value) {
                        item = i;
                    }
                });
                return this.getItemName(item);
            },
            localeFormat: utils.templateFormat,
            submit: function () {
                var routeParams = im.$route.params;
                var conversationType = parseInt(routeParams.conversationType);
                var targetId = routeParams.targetId;
                var msg = {
                    messageType: this.message.messageType,
                    content: this.message.content
                };
                if (this.message.objectName === 'RC:SightMsg') {
                    msg.messageType = 'SightMessage';
                }
                if (this.message.objectName === 'RC:CardMsg') {
                    msg.messageType = 'CardMessage';
                }
                var message;
                if (this.message.messageType === 'RichContentMessage' && +this.message.sourceType === 3) {
                    var item = this.message.content;
                    message = common.buildMessage.RichContentMessage(item);
                } else {
                    message = messageApi.create(msg);
                }
                var paramList = {
                    conversationType: conversationType,
                    targetId: targetId,
                    content: message
                };
                messageApi.send(paramList, function (errorCode) {
                    if (errorCode) {
                        console.error(errorCode);
                    }
                });
                this.close();
            },
            isEqual: function (_item, index) {
                if (index === this.index) {
                    return true;
                }
                return false;
            },
            clear: function () {
                this.keyword = '';
                this.search();
            },
            down: function () {
                this.busy = true;
            },
            select: function (item, index) {
                if (item.messageType === 'VoiceMessage') {
                    var param = {
                        message: this.locale.tips.voiceForward,
                        callback: function () { },
                        el: this.$el.firstChild,
                        type: 'error'
                    };
                    common.messageToast(param);
                    return;
                }
                this.index = index;
                this.message = item;
            },
            getMessageType: function (item) {
                var messageType;
                switch (item.messageType) {
                    case 'RC:SightMsg':
                        messageType = 'SightMessage';
                        break;
                    case 'LRC:fileMsg':
                        messageType = 'FileMessage';
                        break;
                    case 'RC:CardMsg':
                        messageType = 'CardMessage';
                        break;
                    default:
                        messageType = item.messageType;
                }
                return messageType;
            },
            search: function () {
                var context = this;
                if (context.oldkeyword === context.keyword) {
                    context.busy = false;
                    return;
                }
                context.oldkeyword = context.keyword;
                clearTimeout(timer);
                context.busy = true;
                timer = setTimeout(function () {
                    search(context, collectApi);
                }, 500);
            }
        };
    }
    function search(context, collectApi) {
        var params = {
            scope: 'message',
            keyword: context.keyword
        };
        var type = context.currentView;
        if (type === 'text') {
            params.type = 'RC:TxtMsg';
        } else if (type === 'voice') {
            params.type = 'RC:VcMsg';
        } else if (type === 'position') {
            params.type = 'RC:LBSMsg';
        } else if (type === 'video') {
            params.type = ['RC:ImgMsg', 'RC:SightMsg'];
        } else if (type === 'file') {
            params.type = 'RC:FileMsg';
        } else if (type === 'link') {
            params.type = 'RC:ImgTextMsg';
        }
        collectApi.search(params, function (errorCode, ids) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            context.collectList = [];
            for (var i = 0; i < ids.length; i += 1) {
                for (var j = 0; j < context.list.length; j += 1) {
                    if (ids[i] === context.list[j].uid) {
                        context.collectList.push(context.list[j]);
                    }
                }
            }
            context.busy = false;
        });
    }
    function reName(obj) {
        switch (obj) {
            case 'all':
                obj = ''; break;
            case 'text':
                obj = 'RC:TxtMsg'; break;
            case 'voice':
                obj = 'RC:VcMsg'; break;
            case 'position':
                obj = 'RC:LBSMsg'; break;
            case 'video':
                obj = 'RC:ImgMsgRC:SightMsg'; break;
            case 'file':
                obj = 'RC:FileMsgFileMessageLRC:fileMsg'; break;
            case 'link':
                obj = 'RC:ImgTextMsg'; break;
            default: return undefined;
        }
        return obj;
    }
}(RongIM, RongIM.components));
