(function (RongIM, dependencies, components) {
    'use strict';
    var utils = RongIM.utils;
    var debounceResume = utils.debounce(resumeUpload, 200);
    components.addAttachment = function (resolve, reject) {
        var im = RongIM.instance;
        var options = {
            name: 'add-attachment',
            template: 'modules/pin/templates/add-attachment.html',
            props: {
                attachs: {
                    type: Array,
                    default: []
                },
                isAttachFull: false
            },
            data: function () {
                return {
                    attachments: [...this.attachs] || [],
                };
            },
            computed: {
                getAttachCount: function () {
                    var count = this.attachments.length;
                    var attachFormat = im.locale.components.newPin.attaCount;
                    return this.localeFormat(attachFormat, count);
                },
                /*
                是否显示重新下载按钮
                断网状态不显示
                */
                isShowRenew: function () {
                    return im.status === utils.status.CONNECTED;
                },
                isWeb: function () {
                    var platform = utils.getPlatform();
                    var isWeb = platform.indexOf('web') !== -1;
                    return isWeb;
                },

            },
            watch: {

            },
            mounted() {
                console.log(this.attachments)
                if (this.attachments.length > 0) {
                    this.getAttachs()
                }

            },
            methods: {
                getAttachs: function () {
                    let list = this.attachments
                    this.attachments = list.map(e => {
                        return {
                            data: e,
                            progress: 100,
                            url: e.url,
                            rawSize: e.size,
                            uploadStatus: utils.uploadStatus.SUCCESS
                        };
                    });
                },
                clickButton: function () {
                    $('#rongAddAttachment').trigger("change");
                },
                addAttachment: function (event) {
                    var context = this;
                    var fileSize = RongIM.serverConfig.media.max_file_size * 1024 * 1024;
                    var fileMaxSize = fileSize ? utils.formatFileSize(fileSize) : '';
                    var message = fileMaxSize ? utils.templateFormat(context.locale.tips.overSize, fileMaxSize) : '';
                    var fileList = event.target.files;
                    if (!checkAttachInBound(context, fileList)) {
                        context.toast({
                            type: 'error',
                            message: context.locale.components.newPin.mostAtta
                        });
                        return;
                    }
                    var sizeState = checkAttachSize(fileList, fileSize);
                    if (sizeState === 1 || sizeState === 2) {
                        var showMsg = sizeState === 1 ? context.locale.tips.zeroSize : message;
                        this.toast({
                            type: 'error',
                            message: showMsg
                        });
                    }
                    var uploadCount = 0;
                    for (var i = 0; i < fileList.length; i += 1) {
                        var file = fileList[i];
                        if (file.size > 0 && file.size <= fileSize) {
                            upload(file, context);
                            uploadCount += 1;
                        }
                        context.$emit('updateAttachs', context.attachments)
                    }
                    if (uploadCount === 0) {
                        return;
                    }
                    this.showAttach = true;
                    components.addAttachment(context);
                    resetInputFileValue('rongAddAttachmentInDetail');
                    
                },
                formatFileSize: utils.formatFileSize,
                isShowProgress: function (attach) {
                    var isCanceled = attach.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isUploading = attach.uploadStatus === utils.uploadStatus.UPLOADING;
                    return isCanceled || isUploading;
                },
                getProgress: function (attach) {
                    return parseInt(attach.progress) + '%';
                },
                getFileIconClass: function (data) {
                    let name = data.name || data.data.name
                    var prefix = 'rong-pin-file-';
                    var getPointTotal = name.split('.').length - 1;
                    var splitArr = name.split('.');
                    var isExpired = false;
                    var suffix = '';
                    if (isExpired) {
                        suffix = '-expired';
                    }
                    return prefix + splitArr[getPointTotal] + suffix;
                },
                getProgressWidth: function (attach) {
                    attach.progress = attach.progress || 0;
                    return attach.progress + '%';
                },
                removeAttachment: function (attachment, index) {

                    this.attachments.splice(index, 1)

                    this.$emit("removeAttachment", this.attachments)
                    // console.log('todo: 如果有上传的分片记录,删除');
                },
                getAttachName: function (data) {
                    let name = data.name || data.data.name;
                    // var length = getNameLength(name);
                    // if (length > 27) {
                    //     var splitLength = name.length * 27 / length / 2;
                    //     var head = name.substring(0, splitLength);
                    //     var foot = name.substring(name.length - splitLength, name.length);
                    //     return head + '...' + foot;
                    // }
                    return name;
                },
                cancelUpload: function (item) {
                    item.cancel();
                    if (this.isWeb) {
                        this.removeAttachment(item);
                    }
                },
                isCancelUpload: function (item) {
                    var isCanceled = item.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isFailed = item.uploadStatus === utils.uploadStatus.FAIL;
                    return isCanceled || isFailed;
                },
                resumeUpload: function (item) {
                    if (item.uploadStatus === utils.uploadStatus.UPLOADING) {
                        return;
                    }
                    if (!checkExist(item, this)) {
                        return;
                    }
                    debounceResume(item);
                },
                isShowCancel: function (item) {
                    return item.uploadStatus === utils.uploadStatus.UPLOADING;
                },
                isShowRemove: function (item) {

                    var isCanceled = item.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isComplete = item.uploadStatus === utils.uploadStatus.SUCCESS;
                    return isCanceled || isComplete;
                },
                fileState: function (item) {
                    var state = '';
                    switch (item.uploadStatus) {
                        case utils.uploadStatus.READY:
                            break;
                        case utils.uploadStatus.UPLOADING:
                            state = this.locale.uploading;
                            break;
                        case utils.uploadStatus.SUCCESS:
                            state = this.locale.uploaded;
                            break;
                        case utils.uploadStatus.FAIL:
                            state = this.locale.cancelled;
                            break;
                        case utils.uploadStatus.CANCELLED:
                            state = this.locale.stoped;
                            break;
                            // 失效  24小时内不操作继续发送，则该文件发送状态置为已失效
                        case utils.uploadStatus.EXPIRED:
                            state = this.locale.expired;
                            break;
                        default:
                            state = this.locale.uploaded;
                            break;
                    }
                    return state;
                },
                isAssetTypeAnImage: function (name) {
                    if(name==undefined){
                        return false;
                    }
                    let index = name.lastIndexOf(".");
                    return utils.isAssetTypeAnImage(name.substr(index + 1))
                },
                getUrl(item){
                   return item.url || item.data.path
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };
    // var debounceResume = utils.debounce(resumeUpload, 200);
    function resumeUpload(attach) {
        var dataModel = RongIM.instance.dataModel;
        var getFileType = utils.getFileType;
        var fileType = getFileType(attach.data.name);
        var pinApi = dataModel.Pin;
        pinApi.uploadAttach(fileType, attach.data, attach, function (err) {
            if (err) {
                utils.console.warn('上传失败');
            }
        });
    }

    function watchAttach(addPin) {
        var fileTimer = addPin.fileTimer;
        if (fileTimer) clearInterval(fileTimer);
        fileTimer = setInterval(function () {
            var attachments = addPin.attachments.filter(function (attachment) {
                return attachment.uploadStatus === utils.uploadStatus.UPLOADING;
            });
            for (var i = 0; i < attachments.length; i += 1) {
                var item = attachments[i];
                checkExist(item, addPin);
            }
        }, 6000);
    }

    function checkExist(item, addPin) {
        var file = RongIM.file;
        var localPath = item.data.path;
        var fileExist = file.checkExist(localPath);
        if (!fileExist) {
            // item.uploadStatus = utils.uploadStatus.EXPIRED;
            addPin.cancelUpload(item);
            addPin.toastError('file-404');
            return false;
        }
        return true;
    }

    function resetInputFileValue(inputId) {
        var $inputFile = $('#' + inputId);
        $inputFile.val('');
    }

    function checkAttachInBound(context, fileList) {
        // PIN 携带的附件最大数
        var serverConfig = RongIM.serverConfig;
        var maxAttachCount = serverConfig.pin.max_attachment_count;
        // 附件个数设置
        var attachCount = context.attachments.length + fileList.length;
        var isBeyond = attachCount > maxAttachCount;

        return !isBeyond;
    }

    function checkAttachSize(fileList, fileSize) {
        var hasZero = 0;
        /* eslint-disable no-restricted-syntax */
        // eslint-disable-next-line guard-for-in
        for (var key in fileList) {
            if (fileList[key].size === 0) {
                hasZero = 1;
                break;
            }
            if (fileList[key].size > fileSize) {
                hasZero = 2;
                break;
            }
        }
        /* eslint-enable no-restricted-syntax */
        return hasZero;
    }

    function upload(file, context) {
        var models = RongIM.instance.dataModel;
        var pin = models.Pin;
        var getFileType = utils.getFileType;
        var fileType = getFileType(file.name);
        var attach = {
            data: file,
            progress: 0,
            url: null,
            uploadId: Date.now(),
            uploadStatus: utils.uploadStatus.READY,
            rawSize: file.size
        };
        context.attachments.push(attach);
        pin.uploadAttach(fileType, file, attach, function (err) {
            if (err) {
                utils.console.warn('上传失败');
                return;
            }
            saveLocalAttach(attach.data, attach.data.path);
        });
    }

    function getNameLength(name) {
        var mark = 0;
        for (var i = 0; i < name.length; i += 1) {
            var cName = name[i];
            mark += utils.isChinese(cName) ? 2 : 1;
        }
        return mark;
    }

    function saveLocalAttach(attach, localPath) {
        var im = RongIM.instance;
        im.dataModel.Pin.addPinLocalAttach(attach.name, localPath);
    }
}(RongIM, null, RongIM.components));