(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var fileApi = RongIM.dataModel.File;
    var orgazApi = RongIM.dataModel.Organization;
    var debounceDownload = utils.debounce(initDownload, 300);
    components.getPinDetail = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        var system = RongIM.system;
        var options = {
            name: 'pinDetail',
            template: 'modules/pin/templates/pin-detail.html',
            props: ['isSender', 'isReply', 'pinDetail', 'isForward', 'showDetail', 'addPinForward'],
            data: function () {
                return {
                    confirmExpand: true,
                    receivedExpand: true,
                    resendExpand: true,
                    receiverList: [],
                    commentList: [],
                    entryComment: '',
                    attachmentList: [],
                    isShowEnd: false,
                    downloaders: {},
                    commentBusy: false,
                    ifConfirm: false,
                    showCommentExpend: true,
                    showForwardExpend: true,
                    showPin: this.showDetail,
                    selectedForwardPin: {}, //显示详情的转发记录对象
                    ifShowForwardDetail: false, //是否显示转发记录详情
                    formForward: this.addPinForward || false,
                    isSend: this.isSender || false,
                    isOutDelayed: false,
                    timer: null,
                    unConfirmCount: 0,
                    confirmCount: 0,
                    currentPage: 1,
                    pageNum: 100,
                    allReceriver: [],
                    isShowForward: true, //是否显示转发记录
                    showGroup: false, //是都显示通讯组编辑页面
                    pinGroupList: [],
                    allGroups: [], //所有通讯组
                    selectGroup: {
                        id: ''
                    },
                    groupName: '', //新增组名称
                    showSetting:false,
                    currentNum:0,
                };
            },
            components: {
                avatar: components.getAvatar,
                pinAlarmClock: components.getAlarmClock
            },
            directives: {
                focus: {
                    inserted: function (el, value) {
                        if (value) {
                            el.focus();
                        }
                    }
                }
            },
            computed: {
                isMac: function () {
                    let os = system.platform
                    return os === 'win32' || os === 'linux';
                },
                pinUid: function () {
                    return this.pinDetail ? this.pinDetail.uid : null;
                },
                user: function () {
                    return this.pinDetail ? this.pinDetail.user : null;
                },
                getConfirmReceivers: function () {
                    return getConfirmReceivers(this, true);
                },
                getUnConfirmReceivers: function () {
                    return getConfirmReceivers(this, false);
                },
                isShowConfirmBtn: function () {
                    if (!this.pinDetail) {
                        return false;
                    }
                    if (this.pinDetail.creator_uid == im.loginUser.id) {
                        return false;
                    } else {
                        return !this.isSend && !this.pinDetail.confirmed && !this.formForward
                    }
                },
                isShowCommentTopLine: function () {
                    var hasComment = this.commentList.length;
                    var isExpand = (this.isSend && this.receivedExpand) || this.confirmExpand;
                    if (this.isSend && this.confirmExpand) {
                        isExpand = isExpand && this.receivedExpand;
                    }
                    return hasComment && isExpand;
                },
                showComment: function () {
                    //是否有评论
                    let hasComment = this.pinDetail && this.commentList.length > 0
                    //是否为发送人//是否为发送人
                    let isCreator = this.pinDetail.creator_uid == im.loginUser.id
                    if (hasComment) {
                        if(this.pinDetail.send_see == 0){
                            return true;
                        }
                        return isCreator ? true : this.commentList.filter(obj => obj.publisher_uid === im.loginUser.id || obj.publisher_uid === this.pinDetail.creator_uid).length > 0
                    } else {
                        return false;
                    }
                    // return this.pinDetail && this.pinDetail.comment_count > 0 
                },
                showForward: function () {
                    return this.pinDetail && this.pinDetail.type != 2 && this.pinDetail.forwardPins && this.pinDetail.forwardPins.length > 0 && !this.isForward
                },
                isShowInput: function () {
                    var pinDetail = this.pinDetail;
                    
                    if (!pinDetail) {
                        return;
                    }
                    this.isOutDelayed = pinDetail.delayed &&
                        pinDetail.delayed_send_dt < new Date().getTime();
                    var isConfirmed = pinDetail.type == 1 ? pinDetail.confirmed : true;
                    var isValidTime = !pinDetail.delayed || this.isOutDelayed;
                    // var isForword = pinDetail.pin_type == 1
                    return isConfirmed && isValidTime && !this.formForward;
                },
                getReceiverList: function () {
                    // if (this.isShowEnd) {
                    return this.receiverList || [];
                    // }
                },
                getCommentList: function () {
                    var commentList = []
                    // (this.pinDetail.send_see == 1 && this.pinDetail.creator_uid == im.loginUser.id)
                    if (this.pinDetail.send_see == 1) { //仅发送人可见
                        if (this.pinDetail.creator_uid == im.loginUser.id) { //当前用户是发送人
                            commentList = this.commentList
                        } else { //只能看自己的
                            commentList = this.commentList.filter(obj => obj.publisher_uid === im.loginUser.id || obj.publisher_uid === this.pinDetail.creator_uid)
                        }
                    } else {
                        commentList = this.commentList
                    }

                    var split = document.body.clientHeight || 120;
                    split = parseInt((split - 120) / 70);
                    if (this.isShowEnd) {
                        return commentList;
                    }
                    return commentList.length > 20 ? commentList.slice(0, split) : commentList;
                },
                disableSend: function () {
                    return this.entryComment.trim() === '';
                },
                inSentPin: function () {
                    return this.pinDetail.type == 0;
                },
                inForward: function () {
                    return this.pinDetail && this.pinDetail.pin_type == 1
                },
                getPlaceHolder: function () {
                    if (this.pinDetail.send_see == 0) {
                        //没有设置为仅发送人可见
                        return this.locale.components.pinDetail.input;
                    } else {
                        if (this.pinDetail.type == 0) {
                            //我发出的pin，send_see 1 设置为仅发送人可见

                            return this.locale.components.pinDetail.inputAll
                        } else {
                            //我收到的
                            return this.locale.components.pinDetail.inputSendSee
                        }
                    }
                },
                 //是否显示超长提示
                 showErrorText: function () {
                    return this.groupName.length > 15
                },
                isWeb: function () {
                    var platform = utils.getPlatform();
                    var isWeb = platform.indexOf('web') !== -1;
                    return isWeb;
                }
            },
            methods: getMethods(dataModel, im),
            created: function () {
                this.clearCookie()
                created(this, dataModel, im);
            },
            destroyed: function () {
                setTimeout(() => {
                    unwatch(this, pinApi)
                }, 1000)
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function setupPinDetail(context, pinApi, pin, callback) {

        pinApi.getPinDetail(pin.uid, function (errorCode, detail) {
            if (errorCode) {
                return;
            }
            // $.extend(pin, detail);
            if (callback) callback(detail);
        });
    }

    function created(context, dataModel, im) {
        var pinApi = dataModel.Pin;
        var userApi = dataModel.User;
        // hidePanel(context, im);
        commentWatch(context, im, pinApi, userApi);
        confirmWatch(context, pinApi);
        newReciverWatch(context, pinApi, userApi);
        //获取详情
        setDetail(context, im, context.pinUid);

    }

    function getMethods(dataModel, im) {
        var pinApi = dataModel.Pin;
        return {
            userProfile: dialog.user,
            getUsername: common.getUsername,
            formatFileSize: utils.formatFileSize,
            clipboard: function (text, event) {
                const clipboard = new ClipboardJS(event.target, {
                    text: () => text
                })
                let that = this;
                clipboard.on('success', (e) => {
                    clipboard.destroy()
                    common.messageToast({
                        type: 'success',
                        message: that.locale.copyFileUrl.success
                    });
                })
                clipboard.on('error', (e) => {
                    clipboard.destroy()
                    common.messageToast({
                        type: 'error',
                        message: that.locale.copyFileUrl.error
                    });
                })
                clipboard.onClick(event)
            },

            // click copy content
            copy: function (attach, event) {
                let arr1 = attach.url.split('?') //arr1[0]=?前的路径
                let arr2 = arr1[0].split('/') //arr2[arr2.length-1] = 要取的字符串
                arr2[arr2.length-1] = attach.name //替换文件名
                let str1 = arr2.join('/') //拼接字符串 str1= arr1[0] 也就是 ?前的路径
                arr1[0]=str1;
                let url = arr1.join('?') //拼接arr1就是完整url
                let code = utils.encryptCode(url);
                // url = "https://work.cast.org.cn/modules/redirect.html?down=" + encodeURIComponent(code)
                this.clipboard(url, event);
            },

            inputFocus: function () {
                Vue.nextTick(function () {
                    var replyInput = $('#replyInput')[0];
                    if (replyInput) replyInput.focus();
                });
            },
            isShowConfirmStatus: function () {
                var isSend = this.isSend;
                var isConfirmed = !isSend && this.pinDetail.confirmed;
                return isSend || isConfirmed;
            },
            getUserName: function (user) {
                return user ? user.alias || user.name : ' ';
            },
            clickShowConfirmDetail: function () {
                this.confirmExpand = !this.confirmExpand;
            },
            clickShowReceiveDetail: function () {
                this.receivedExpand = !this.receivedExpand;
            },
            clickShowResendDetail: function () {
                this.resendExpand = !this.resendExpand;
            },
            clickShowComment: function () {
                this.showCommentExpend = !this.showCommentExpend
            },
            clickShowForWard: function () {
                this.showForwardExpend = !this.showForwardExpend
            },
            getConfirmDetail: function () {
                if (this.isSend) {
                    var isLoadedReceivers = this.receiverList && this.isShowEnd;
                    var unConfirmCount = isLoadedReceivers ?
                        this.getUnConfirmReceivers.length :
                        this.pinDetail.un_confirm_count;
                    var confirmFormat = this.locale.components.pinDetail;
                    return unConfirmCount === 0 ?
                        confirmFormat.allConfirmed :
                        this.localeFormat(confirmFormat.unConfirmedCount, unConfirmCount);
                }
                var confirmedFormat = this.locale.components.receivedPin.confirmed;
                return this.pinDetail.confirmed ? confirmedFormat : '';
            },
            dateFormat: function (timestamp) {
                var dateFormatUtil = utils.dateFormat;
                var options = {
                    alwaysShowTime: true
                };
                return dateFormatUtil(timestamp, options);
            },
            pinDate: function () {
                var pinDetail = this.pinDetail;
                if (!pinDetail) {
                    return;
                }
                var createDt = pinDetail.send_dt || pinDetail.create_dt;
                var timestamp = pinDetail.delayed ? pinDetail.delayed_send_dt : createDt;
                var dateFormatUtil = utils.dateFormat;
                var options = {
                    alwaysShowTime: true
                };
                return dateFormatUtil(timestamp, options);
            },
            enterComment: function (event) {
                var that = this;
                if (event.shiftKey) {
                    return;
                }
                if (event.target.value === '\n') {
                    that.entryComment = '';
                }
                if (this.entryComment === '') {
                    return;
                }
                event.target.value = '';
                this.sendComment();
            },
            sendComment: function () {
                var that = this;
                if (that.commentBusy) {
                    return;
                }
                that.commentBusy = true;
                that.entryComment = that.entryComment.replace(/^ /, '');
                if (!that.entryComment) {
                    common.messageToast({
                        type: 'error',
                        message: that.locale.components.pinDetail.inputCanNotEmpty
                    });
                    that.commentBusy = false;
                    return;
                }
                var comment = {
                    pin_uid: that.pinUid,
                    publisher_uid: im.auth.id,
                    content: that.entryComment,
                    create_dt: Date.now(),
                    user: im.loginUser
                };
                // that.commentList.push(comment);
                that.pinDetail.comment_count = that.commentList.length

                pinApi.comment(that.pinUid, that.entryComment, null, function (errorCode, result) {
                    that.commentBusy = false;
                    if (errorCode) {
                        common.toastError(errorCode);
                        return;
                    }
                    im.$nextTick(() => {
                        // const scrollTop = that.$refs.scrollY.scrollTop;
                        // const scrollHeight = that.$refs.scrollY.scrollHeight;
                        // if ((that.$refs.scrollY.clientHeight + scrollTop) - scrollHeight != 0) { //如果置底
                        //     // 需要执行的代码
                        //     that.$refs.scrollY.scrollTop = that.$refs.scrollY.scrollHeight;
                        // }
                    });
                    that.entryComment = '';
                    that.$emit('addCommentCount', that.pinDetail)

                });
            },

            pinConfirm: function () {
                var that = this;
                pinApi.confirm(that.pinUid, function () {
                    that.pinDetail.confirmed = true;
                    setupReceiverConfirm(that, im.loginUser.id);
                    that.$emit('confirmPin', that.pinDetail);
                    //修改确认未确认
                    that.unConfirmCount -= 1
                    that.confirmCount += 1
                    that.inputFocus();
                });
            },
            resend: function (type) {
                if (!this.commentBusy) {
                    var localeInfo = this.locale.components.pinDetail;
                    var context = this;
                    let tips = ''
                    if (type) {
                        if (context.getUnConfirmReceivers.length > 0) {
                            tips = context.localeFormat(localeInfo.resendToUnconfirmedTips, context.getUnConfirmReceivers.length)
                        } else {
                            tips = localeInfo.noUnConfirm
                        }

                    } else {
                        tips = context.localeFormat(localeInfo.resendToAllTips, context.receiverList.length)
                    }
                    common.messagebox({
                        type: 'confirm',
                        title: localeInfo.resend,
                        message: tips,
                        hashchangeClose: false,
                        callback: function () {
                            context.commentBusy = true;
                            if (type && context.getUnConfirmReceivers.length == 0) {
                                return;
                            }
                            pinApi.resend(context.pinUid, type ? 1 : 0, function () {
                                context.commentBusy = false;
                                common.messagebox({
                                    message: context.locale.components.newPin.success,
                                    hashchangeClose: false
                                });
                            });
                        }
                    });
                }
            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
            },
            addReceivers: function () {
                let _that = this
                if (!this.receiverList) {
                    return;
                }
                dialog.pinDialogBox({
                    groupMembers: this.receiverList.map(obj => {
                        return { ...obj,
                            id: obj.receiver_uid
                        }
                    }),
                    isAddReceiver: true
                }, (tips, content) => {
                    let list = content.filter(obj => !obj.user)
                    pinApi.addReceivers(this.pinDetail.uid, list.map(obj => obj.id), function (errorCode, result) {
                        if (errorCode) {
                            common.toastError(errorCode);
                            return;
                        }
                        content.forEach(obj => {
                            if (!obj.user) {
                                let user = {
                                    id: obj.id,
                                    name: obj.name,
                                    avatar: obj.avatar
                                }
                                Object.assign(obj, {
                                    user
                                })
                            }

                        })
                        _that.receiverList = _that.unique(content);
                    })

                });
                // dialog.addReceivers(defaultSelected, this);
                // dialog.addReceiversDialog(defaultSelected, this);
            },
            download: function (attach, list, pinUid, num, isResume) {
                let count = attach.name.lastIndexOf(".");
                if (this.isAssetTypeAnImage(attach.name)) {
                    attach.rename = '科协一家图片_' + moment(attach.create_dt).format('YYYYMMDDHHmmss') + attach.name.substring(count)
                } else {
                    attach.rename = this.insertStr(attach.name, count, '_' + moment(attach.create_dt).format('YYYYMMDDHHmmss'));
                }
                if (isResume) {
                    if (this.downloader) {
                        this.attachments[num].isDownloading = true;
                        this.attachments[num].isCanceled = false;
                        this.downloader.resume();
                    }
                    return;
                }
                let locaPath = RongIM.downloader.getSaveFolder();
                if (!locaPath) {
                    debounceDownload(attach, attach.url, num, this, isResume);
                    return
                };

                RongIM.downloader.doesItExistLocaPath(locaPath).then((res) => {
                    let isFile = RongIM.downloader.getFileList(locaPath).some((item) => {
                        return attach.name == item;
                    })
                    if (isFile) {
                        this.repeatFile(locaPath, attach, num);
                    } else {
                        debounceDownload(attach, attach.url, num, this, isResume);
                    }
                }).catch(err => {
                    RongIM.downloader.removeSaveFolder();
                    debounceDownload(attach, attach.url, num, this, isResume);
                })
            },
            // 重复文件处理
            repeatFile(locaPath, attach, num, isResume) {
                let count = attach.name.lastIndexOf(".");
                for (let i = 1; i < RongIM.downloader.getFileList(locaPath).length; i++) {
                    if (RongIM.downloader.getFileList(locaPath).indexOf(this.insertStr(attach.name, count, "(" + i + ")")) == -1) {
                        let name = this.insertStr(attach.name, count, "(" + i + ")");
                        i = RongIM.downloader.getFileList(locaPath).length;
                        attach.name = name;
                    }
                }

                debounceDownload(attach, attach.url, num, this);
                common.messageToast({
                    message: "文件保存为" + attach.name,
                    type: 'success'
                });
            },
            cancelDownload: function (url, attach) {
                var currentDownload = this.downloaders[url];
                if (currentDownload) {
                    attach.isCanceled = true;
                    attach.isDownloading = false;
                    currentDownload.abort();
                }
            },
            getFileIconClass: function (name) {
                var prefix = 'rong-pin-file-';
                var getPointTotal = name.split('.').length - 1;
                var splitArr = name.split('.');
                return prefix + splitArr[getPointTotal];
            },
            getFileIconStyle: function (attach) {
                var name = attach.name || '';
                var imageMark = ['png', 'jpeg', 'gif', 'jpg'];
                var getPointTotal = name.split('.').length - 1;
                var type = name.split('.')[getPointTotal];
                var isImage = imageMark.indexOf(type) !== -1;
                if (isImage) {
                    return {
                        'background-image': 'url(' + attach.url + ')',
                        'background-size': 'cover',
                        'background-position': '0 0'
                    };
                }
                return undefined;
            },
            getPinContent: function (content) {
                if (!content) {
                    return undefined;
                }
                content = common.textMessageFormat(content);
                return common.highlight(content);
            },
            isShowDelayedIcon: function () {
                var pin = this.pinDetail;
                if (!pin.delayed) {
                    return false;
                }
                var sendTime = pin.delayed_send_dt;
                var thisTime = new Date().getTime();
                return sendTime > thisTime;
            },
            openFolder: openFolder,
            forwardPin: function (pin) {
                let _that = this
                let msg = {
                    forWard: true,
                    pin: _that.pinDetail
                }
                // this.showPin = false
                this.$emit('closeDetail')
                // dialog.addPin(msg);

            },
            //创建寻呼
            addPin: function () {
                dialog.addPin({
                    memberList: this.receiverList
                });
            },
            // 暂停
            pauseDownload: function (url, attach, num) {
                var currentDownload = this.downloaders[url];
                let pinObj = this.attachmentList[num]
                pinObj.isCanceled = true;
                pinObj.isDownloading = false;
                this.attachmentList.splice(num, 1, pinObj);
                if (currentDownload) {
                    currentDownload.pause();
                    // currentDownload.abort();
                }
            },
            // 继续
            resumeDownload: function (url, attach) {
                if (this.downloaders[url]) {
                    attach.isDownloading = false;
                    this.downloaders[url].resume();
                } else {
                    this.download(url, true);
                }
            },
            afterEnter: function () {
                this.isClicking = 0;
                im.$emit('pinDetailLoadDone');
            },
            enterCancelled: function () {
                this.isClicking = 0;
            },
            isAssetTypeAnImage: function (name) {
                let index = name.lastIndexOf(".");
                return utils.isAssetTypeAnImage(name.substr(index + 1))
            },
            /**
             * 字符串指定位置插入
             * @param {String} soure  原字符串
             * @param {Number} start  将要插入得位置
             * @param {String} newStr 要插入的字符
             */
            insertStr(soure, start, newStr) {
                return soure.slice(0, start) + newStr + soure.slice(start);
            },
            showForwordDetail: function (pin) {
                if (!pin) return false;
                let _that = this
                if (pin.title !== '已撤回') {
                    setupPinDetail(_that, pinApi, pin, function (selectPin) {
                        _that.selectedForwardPin = selectPin;
                        _that.ifShowForwardDetail = true
                        _that.isShowForward = false;
                        // _that.selectedForwardPin.isReply = isReply;
                        selectPin.un_read_comment_count = 0;
                        if (selectPin.type == 0) {
                            _that.isSend = true
                        } else {
                            _that.isSend = false
                        }
                    });

                } else {
                    common.messageToast({
                        type: 'success',
                        message: im.locale.pin.revokePin
                    });
                }

            },
            pinPushed: function () {
                this.isOutDelayed = true
            },

            loadMore: function () {
                let context = this
                if (!isScrollToBottom() || (context.allReceriver.length === context.receiverList.length)) {
                    return false;
                }
                var end = context.receiverList.length;
                if (context.allReceriver && context.allReceriver.length > end) {
                    context.receiverList = context.receiverList.concat(context.allReceriver.slice(end, end + context.pageNum))
                }
            },
            //判断打开文件还是下载
            downloadOrOpen: function (attach, attachments, uid, index) {
                let that = this;
                if (attach.isClick) {
                    return false
                }
                if (!attach.isDownloading && attach.downloadProgress === 0) {
                    attach.isClick = true;
                    that.download(attach, attachments, uid, index)
                } else if (!attach.isDownloading && attach.downloadProgress === 100) {
                    this.openFolder(attach, true)
                } else {
                    return false
                }

            },
            isExis: function (item) {
                let arr = this.pinGroupList.filter(obj => obj.name == item.name)
                if (arr.length > 0) {
                    return true
                } else {
                    return false
                }
            },
            //删除元素
            delItem: function (index) {
                this.pinGroupList.splice(index, 1);
            },
            //点击空格键添加到所属通讯组
            saveGrou() {
                if(this.groupName.length > 15){
                    this.$refs.groupName.focus()
                    return ;
                }
                let obj = {
                    name: this.groupName
                }
                //输入的通讯组名称已存在
                if (this.groupName == '') {
                    return;
                }
                if (this.checkOnly()) {
                    this.allGroups.forEach((item, index) => {
                        if (item.name == this.groupName) {
                            this.pinGroupList.push(item)
                        }
                    })

                } else {
                    this.pinGroupList.push(obj)
                }

                this.groupName = ''
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            //检验输入的通讯组名是否存在
            checkOnly() {
                let arr = this.allGroups.filter(obj => obj.name == this.groupName)
                return arr.length > 0
            },
            //保存通讯组
            savePinGroup() {
                let that = this
                let receiver_ids = that.receiverList.map(obj => obj.user.id)
                let receiver_names = that.pinGroupList.map(obj => obj.name)
                im.dataModel.Group.changePersonalGroup({
                    receiver_ids: receiver_ids,
                    receiver_names: receiver_names
                }, function (errorcode, res) {
                    if (errorcode) {
                        return;
                    }
                    common.messageToast({
                        type: 'success',
                        message: '添加成功'
                    });
                    that.showGroup = false
                    let str = ''
                    that.pinGroupList = []
                    that.pinGroup = str.substring(0, str.length - 1)
                })
            },
            openPinGroup:function(){
                let that = this
                if(that.pinGroupList.length == 0){
                    that.showGroup=false;
                    return false;
                }
                common.messagebox({
                    type: 'confirm',
                    message: that.locale.btns.saveThis,
                    callback: function () {
                        that.savePinGroup()
                    },
                    closeCallback: function () {
                        that.showGroup=false;
                        that.pinGroupList = []
                    },
                    hashchangeClose: false
                });
            },
            selectObj: function (obj) {
                let flag = this.pinGroupList.filter(res =>res.id ==obj.id )
                if(flag.length >0){
                    this.pinGroupList.splice(this.pinGroupList.findIndex(item => item.id === obj.id), 1)
                    return;
                }
                this.selectGroup = obj
                let list = this.pinGroupList;
                list.push(obj)
                const res = new Map();
                this.pinGroupList = list.filter((arr) => !res.has(arr.name) && res.set(arr.name, 1));
                // this.pinGroupList = this.unique(list)

            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
            },
            setShowGroup: function () {
                this.showGroup = true
                getPinGroups(this)
            },
            enter(num) {
                this.showSetting = true;
                this.currentNum = num;
            },
            leave() {
                this.showSetting = false;
                this.currentNum = null;
            },
            saveAs(event, attach) {
                console.log(attach);
                let arr1 = attach.url.split('?') //arr1[0]=?前的路径
                let arr2 = arr1[0].split('/') //arr2[arr2.length-1] = 要取的字符串
                arr2[arr2.length-1] = attach.name //替换文件名
                let str1 = arr2.join('/') //拼接字符串 str1= arr1[0] 也就是 ?前的路径
                arr1[0]=str1;
                let url = arr1.join('?') //拼接arr1就是完整url
                console.log(url);
                event.target.href = url;
            },
            delPin(pin){
                this.$parent.delPin(pin)
            },
            clearCookie() {
                // debugger
                var keys = document.cookie.match(/[^ =;]+(?=\=)/g);
                if (keys) {
                    for (var i = keys.length; i--;)
                        document.cookie = keys[i] + '=0;expires=' + new Date(0).toUTCString()
                }
            }
            
        };
    }
  //获取所有的通讯组
  function getPinGroups(context) {
    orgazApi.getPinGroups('', res => {
        if (!res.count) return;
        context.allGroups = res.data

    })
}
    function isScrollToBottom() {
        var $el = $('.rong-pin-detail-bd');
        if (!$el) return false;
        //滚动高度
        var scrollTop = $el[0].scrollTop;
        //div高度
        var height = $el.height();
        return scrollTop - height >= 0;
    }
    var setupCommentList = utils.throttle(function (context, im, pinApi, uid, isWatch) {
        pinApi.getCommentList(uid, function (errorCode, comments) {
            if (errorCode) {
                return;
            }
            Vue.nextTick(function () {
                context.commentList = comments;
                context.$nextTick(() => {
                    if (isWatch && comments[0].publisher_uid == im.loginUser.id) {
                        context.$refs.scrollY.scrollTop = context.$refs.pinComment.offsetTop;
                    }
                })
            });
        });
    }, 2000);
    // 表情面板隐藏展示切换
    function toggleEmoji(context) {
        var hideEmoji = function () {
            context.showEmojiPanel = false;
            $(document).off('click', hideEmoji);
        };
        context.showEmojiPanel = !context.showEmojiPanel;
        if (context.showEmojiPanel) {
            $(document).on('click', hideEmoji);
        }
    }

    function commentWatch(context, im, pinApi) {
        context.commentWatch = function (message) {
            var isMessageType = message.messageType === pinApi.MessageType.PinCommentMessage;
            if (isMessageType) {
                var comment = message.content;
                // comment.pinUid === context.pinUid && addPinComment(context, pinApi, userApi, comment);
                // 多设备同时登陆时，收到多条相同的 pin 消息，导致 pin 详情页评论重复，暂时修改为和移动端相同的逻辑：收到消息后，同步获取 pin 评论列表
                if (comment.pinUid === context.pinUid) {
                    setupCommentList(context, im, pinApi, comment.pinUid, true);
                }
            }
        };
        pinApi.watch(context.commentWatch);
    }

    function confirmWatch(context, pinApi) {
        context.confirmWatch = function (message) {
            var isMessageType = message.messageType === pinApi.MessageType.PinConfirmMessage;
            var isThisPinMessage = isMessageType && message.content.pinUid === context.pinUid;
            if (isThisPinMessage) {
                setupReceivers(context, pinApi, context.pinUid);
            }
        };
        pinApi.watch(context.confirmWatch);
    }

    function newReciverWatch(context, pinApi) {
        context.newReciverWatch = function (message) {
            var isMessageType = message.messageType === pinApi.MessageType.PinNewReciverMessage;
            var isThisPinMessage = isMessageType && message.content.pinUid === context.pinUid;
            if (isThisPinMessage) {
                setupReceivers(context, pinApi, context.pinUid);
            }
        };
        pinApi.watch(context.newReciverWatch);
    }

    function unwatch(context, pinApi) {
        pinApi.unwatch(context.commentWatch);
        pinApi.unwatch(context.confirmWatch);
        pinApi.unwatch(context.newReciverWatch);
    }

    function setupReceiverConfirm(context, uid) {
        if (!context.receiverList) {
            return;
        }
        context.receiverList.forEach(function (receiver) {
            if (receiver.receiver_uid === uid) {
                receiver.is_confirmed = true;
            }
        });
    }

    function hidePanel(context, im) {
        im.$on('imclick', function (event) {
            var $target = $(event.target);
            var wrap = '.rong-pin-detail, .rong-pin-item, .rong-dialog, .dialog-content';
            var inBody = $target.closest('body').length > 0;
            var inWrap = $target.closest(wrap).length < 1;
            var isOuter = inBody && inWrap;
            if (isOuter) context.$emit('hidepanel');
        });
    }


    function setDetail(context, im, pinUid) {
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        if (context.pinDetail && context.pinDetail.attachment_count > 0) {
            setupPinAttachmentList(context, pinApi, pinUid);
        }
        if (context.pinDetail && context.pinDetail.comment_count > 0) {
            setupCommentList(context, im, pinApi, pinUid);
        }

        setupReceivers(context, pinApi, pinUid);
        setupShowEnd(context, im);
        getForwardPin(context, pinApi, pinUid)
    }
    // 获取转发记录
    function getForwardPin(context, pinApi, uid) {
        pinApi.getPinDetail(uid, function (errorCode, result) {
            if (errorCode) {
                return;
            }
           
            context.pinDetail.forwardPins = result.forwardPins
        })
    }

    function setupShowEnd(context, im) {
        im.$on('pinDetailLoadDone', function () {
            context.isShowEnd = true;
            // if (context.isReply) {
            context.inputFocus();
            // }
            im.$off('pinDetailLoadDone');
        });
    }

    function setupReceivers(context, pinApi, uid) {
        pinApi.getReceiverList(uid, function (errorCode, receivers) {
            if (errorCode) {
                return;
            }
            // let count = receivers.length;
            context.unConfirmCount = receivers.filter(obj => !obj.is_confirmed).length
            context.confirmCount = receivers.filter(obj => obj.is_confirmed).length
            context.allReceriver = receivers
            context.$nextTick(() => {
                let end = context.currentPage * context.pageNum
                context.receiverList = receivers.slice(0, end)
                context.currentPage += 1
            })

        });

    }

    function loadDownloadStat(uId) {
        var fileState = RongIM.downloader.getProgress(uId);
        if (fileState.offset) {
            return fileState.offset;
        }
        return 0;
    }

    function setupPinAttachmentList(context, pinApi, uid) {

        // pinApi.getAttachments(uid, function (errorCode, result) {
        let result = context.pinDetail.attachments
        var progress = {
            isDownloading: false,
            downloadProgress: 0,
            isCanceled: false
        };
        result = result.map(function (attach) {
            return $.extend(attach, progress);
        });
        result = result.map(function (atta) {
            var imageUrl = '//rongcloud-image.';
            var fileUrl = '//rongcloud-file.';
            if (atta.url.indexOf(imageUrl) === -1 && atta.url.indexOf(fileUrl) === -1) {
                atta.url = atta.url + '?attname=' + encodeURI(atta.name);
            }
            var downloadSize = loadDownloadStat(atta.uid);
            if (downloadSize) {
                atta.isCanceled = true;
                atta.downloadProgress = (downloadSize / atta.size) * 100;
            }
            //判断本地是否存在,
            let count = atta.name.lastIndexOf(".");
            //如果是图片
            let name = ''
            if (context.isAssetTypeAnImage(atta.name)) {
                name = '科协一家图片_' + moment(atta.create_dt).format('YYYYMMDDHHmmss') + atta.name.substring(count)
            } else {
                name = context.insertStr(atta.name, count, '_' + moment(atta.create_dt).format('YYYYMMDDHHmmss'));
            }
            var localPath = pinApi.getPinLocalAttach(name);
            var fileExist = RongIM.file.checkExist(localPath);
            if (fileExist) {
                atta.name = name;
            }
            return atta;
        });
        context.attachmentList = result;
        setupAttachDownload(context);
        setupAttachExists(context.attachmentList);
        // });
    }

    function setupAttachDownload(context) {
        context.attachmentList.forEach(function (attach, index) {
            attach.downloaders = context.downloaders;
            // initDownload(attach, attach.url, index, context);
        });
    }

    function getConfirmReceivers(context, isConfirmed) {
        if (!context.getReceiverList) {
            return [];
        }
        return context.getReceiverList.filter(function (receiver) {
            return receiver.is_confirmed === isConfirmed;
        });
    }

    function openFolder(attach, isClickName) {
        var file = RongIM.file;
        var localPath = attach.localPath;
        var fileExist = file.checkExist(localPath);
        if (attach.isDownloading && fileExist) {
            return;
        }
        if (localPath && fileExist) {
            if (isClickName) {
                file.open(localPath);
            } else {
                file.openDir(localPath);
            }
        } else {
            common.toastError('file-404');
            attach.downloadProgress = 0;
            removeLocalAttach(attach);
        }
    }

    function initDownload(context, fileUrl, index, _that, isResume) {
        /* var file = {url: fileUrl};
        var downloader = RongIM.download(file); */
        fileApi.getFileDownloadToken(function (error, token) {
            if (error) {
                common.toastError('download-error');
                return;
            }
            var url = fileUrl;
            if (url.indexOf('?') !== -1) {
                url += '&token=' + token;
            } else {
                url += '?token=' + token;
            }
            var file = {
                url: url,
                name: context.rename,
                size: context.size,
                uId: context.uid
            };
            var downloader = RongIM.downloader.load(file);
            downloader.onError = function () {
                // stateCode = ('download-' + params.state);
                context.isDownloading = false;
                context.isCanceled = true;
                context.downloadProgress = 0;
                // common.handleError(stateCode);
            };

            // 下载准备完毕, 此时可知文件大小
            downloader.onReady = function (data) {
                // console.debug('full size:' + data.total);
                // context.isDownloading = true;
                // context.isCanceled = false;
                Vue.nextTick(function () {
                    let pinObj = _that.attachmentList[index]
                    pinObj.isDownloading = true
                    pinObj.isCanceled = false
                    _that.attachmentList.splice(index, 1, pinObj);
                })
            };

            // 下载中,返回下载进度
            downloader.onProgress = function (data) {
                Vue.nextTick(function () {
                    let pinObj = _that.attachmentList[index]
                    pinObj.isDownloading = true
                    pinObj.isCanceled = false
                    pinObj.loaded = data.loaded
                    context.downloadProgress = (data.loaded / data.total) * 100 > 100 ? 100 : (data.loaded / data.total) * 100;
                    _that.attachmentList.splice(index, 1, pinObj);
                })


            };

            // 下载完成
            downloader.onComplete = function (data) {

                Vue.nextTick(function () {
                    let pinObj = _that.attachmentList[index]
                    pinObj.isDownloading = false
                    pinObj.isClick = false
                    _that.attachmentList.splice(index, 1, pinObj);
                })
                if (!data.path) {
                    return;
                }
                context.downloadProgress = 100;
                context.localPath = data.path;
                context.name = context.rename
                _that.$emit('changeAttachStatus', {
                    uid: _that.pinDetail.uid,
                    index: index
                })
                saveLocalAttach(context, data.path);
            };

            // 下载取消
            downloader.onCancel = function () {
                context.isDownloading = false;
                context.isCanceled = false;
                context.isClick = false;
                // context.downloadProgress = 0;
            };
            // context.downloaders[fileUrl] = downloader;
            //继续
            if (isResume) {
                downloader.continue();
                return;
            }
            downloader.saveAs();
        });
    }

    function saveLocalAttach(attach, localPath) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        pinApi.addPinLocalAttach(attach.name, localPath);
    }

    function removeLocalAttach(attach) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        pinApi.removeLocalAttach(attach.name);
    }

    function setupAttachExists(attachmentList) {
        var im = RongIM.instance;
        var pinApi = im.dataModel.Pin;
        attachmentList.forEach(function (attach) {
            setAttach(attach);
        });

        function setAttach(attach) {
            var localPath = pinApi.getPinLocalAttach(attach.name);
            var fileExist = RongIM.file.checkExist(localPath);
            if (fileExist) {
                attach.localPath = localPath;
                attach.downloadProgress = 100;
            }
        }
    }
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));