(function (RongIM, dependencies, components) {
'use strict';

var pin = components.pin;

var routers = [
    {
        path: '/pin',
        name: 'pin-nav',
        redirect: '/pin/allPins'
    },
    {
        path: '/pin/allPins/:filter?',
        name: 'pin-allPins',
        components: {
            list: pin.getNav,
            main: pin.getAllPins
        }
    },
    {
        path: '/pin/received/:filter?',
        name: 'pin-received',
        components: {
            list: pin.getNav,
            main: pin.getReceived
        }
    },
    {
        path: '/pin/replyOrConfirm/:filter?',
        name: 'pin-replyOrConfirm',
        components: {
            list: pin.getNav,
            main: pin.getReplyOrConfirm
        }
    },
    {
        path: '/pin/sent/:filter?',
        name: 'pin-sent',
        components: {
            list: pin.getNav,
            main: pin.getSent
        }
    },
    {
        path: '/pin/newReply/:filter?',
        name: 'pin-newReply',
        components: {
            list: pin.getNav,
            main: pin.getNewReply
        }
    }
];

routers.forEach(function (item) {
    RongIM.routes.maps.unshift(item);
});
}(RongIM, null, RongIM.components));
