(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var dataModel = RongIM.dataModel;
var remoteApi = dataModel.RemoteControl;
var im;
var remoteOverTime = RongIM.config.modules.remoteControl.overtime;

components.getRemoteSummaryMessage = function (resolve, reject) {
    im = RongIM.instance;
    var options = {
        name: 'remotecontrol-message',
        props: ['message'],
        template: 'modules/remote-control/templates/summary-message.html',
        methods: {
            getHangupReason: common.getRemoteControlSummary,
            startRemoteControl: startRemoteControl
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function startRemoteControl() {
    if (remoteApi.isBusyline()) {
        var locale = im.locale.components.remoteControl;
        var busyLocale = locale.busy;
        common.messageToast({
            type: 'error',
            message: busyLocale
        });
        return;
    }
    var message = this.message;
    var isControl = message.content.isControl;
    var params = im.$route.params;
    var method = isControl ? remoteApi.request : remoteApi.invite;
    method(params, function (err, msg) {
        if (!err) {
            im.$emit('setRemoteControl', msg);
            setRemoteTimeout(msg);
        }
    });
}

function setRemoteTimeout(message) {
    var RemoteControlHangupReason = common.RemoteControlHangupReason;
    var targetId = message.targetId;
    var messageType = message.messageType;
    var sessionId = message.content.sessionId;
    setTimeout(function () {
        var remote = remoteApi.get(targetId);
        var currentMsg = remote.message;
        var isSameType = currentMsg.messageType === messageType;
        var isSameSession = currentMsg.content.sessionId === sessionId;
        if (currentMsg && isSameType && isSameSession) {
            var reason = RemoteControlHangupReason.RemoteNoResponse;
            hangupRemoteControl(message, sessionId, reason);
        }
    }, remoteOverTime);
}

function hangupRemoteControl(params, sessionId, reason) {
    var remote = RongIM.dataModel.RemoteControl;
    var instance = RongIM.instance;
    remote.hangup(params, sessionId, reason, function (err, message) {
        if (!err) {
            instance.$emit('setRemoteControl', message);
        }
    });
    remote.summary(params, {
        reason: reason,
        direction: RongIMLib.MessageDirection.SEND
    });
}
}(RongIM, RongIM.components));
