(function (RongWork) {
    'use strict';

    function getFullUrl(url) {
        return RongWork.config.server + url;
    }

    function getFullUrlOA(url) {
        return RongWork.config.serverOA + url;
    }
    var ajax = function (options, callback) {
        var data = options.data;
        if (!$.isEmptyObject(data) && options.method &&
            options.method.toUpperCase() != 'GET') {
            data = JSON.stringify(options.data);
        }
        var arg = {
            url: options.src ? options.src : getFullUrl(options.url),
            method: options.method,
            xhrFields: {
                withCredentials: true
            },
            headers: options.headers ? options.headers : {
                'Content-Type': 'application/json;charset=UTF-8'
            },
            data: data,
            dataType: 'json'
        };
        return $.ajax(arg).then(function (rep) {
            var defer = $.Deferred();
            if (rep.code !== 10000) {
                callback(rep.code);
                defer.reject(rep.code);
            } else {
                callback(null, rep.result);
                callback.done = true;
                defer.resolve(rep.result);
            }
            return defer.promise();
        }).fail(function (xhr, err) {
            if (!callback.done) callback(err);
        });
    };
    var ajaxOa = function (options, callback) {
        var data = options.data;
        if (!$.isEmptyObject(data) && options.method &&
            options.method.toUpperCase() != 'GET') {
            data = JSON.stringify(options.data);
        }
        var arg = {
            url: options.src ? options.src : getFullUrlOA(options.url),
            method: options.method,
            xhrFields: {
                withCredentials: true
            },
            headers: options.headers ? options.headers : {
                'Content-Type': 'application/json;charset=UTF-8'
            },
            data: data,
            dataType: 'json'
        };
        return $.ajax(arg).then(function (rep) {
            var defer = $.Deferred();
            if (rep) {
                callback(rep);
                callback.done = true;
                defer.resolve(rep);
            }

            return defer.promise();
        }).fail(function (xhr, err) {
            if (!callback.done) callback(err);
        });
    };

    var server = {
        getAllApps: function (callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/subscriptions/apps'
            }, callback);
        },
        getUnfavApps: function (userId, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps?userId=' + userId + '&subscribe=0'
            }, callback);
        },
        getFavApps: function (userId, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/subscriptions/apps?favorite=1'
                // url: '/apps?userId=' + userId + '&subscribe=1'
            }, callback);
        },
        getLikeApps: function (callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/favorites'
            }, callback);
        },
        getPublicInfo: function (appId, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/' + appId
            }, callback);
        },
        addFavApp: function (appIdList, callback) {
            callback = callback || $.noop;
            // var userId = RongWork.instance.query.userId;
            return ajax({
                // url: '/apps/' + userId + '/subscribe',
                url: '/apps/favorites/batch',
                method: 'POST',
                data: {
                    apps: appIdList
                }
            }, callback);
        },
        removeFavApp: function (appIdList, callback) {
            callback = callback || $.noop;
            // var userId = RongWork.instance.query.userId;
            return ajax({
                // url: '/apps/' + userId + '/subscribe',
                url: '/apps/favorites/batch',
                method: 'DELETE',
                data: {
                    apps: appIdList
                }
            }, callback);
        },
        request: function (options, callback) {
            return ajax(options, callback);
        },
        // 更新工作台应用最近使用时间
        updateApplication: function (id, callback) {
            callback = callback || $.noop;
            // var userId = RongWork.instance.query.userId;
            return ajax({
                // url: '/apps/' + userId + '/subscribe',
                url: '/apps/updateApplication/' + id,
                method: 'POST',
            }, callback);
        },
        // 重新定义我的应用
        updateMyApplication: function (param, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/updateMyApplication/',
                method: 'POST',
                data: param
            }, callback);
        },
        //批量移除我的应用
        batchRemoveMyApplication: function (appIdList, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/batchRemoveMyApplication/',
                method: 'DELETE',
                data: {
                    apps: appIdList
                }
            }, callback);
        },
        //批量添加我的应用
        batchAddMyApplication: function (appIdList, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/batchAddMyApplication/',
                method: 'POSt',
                data: {
                    apps: appIdList
                }
            }, callback);
        },
        //获取当前用户的自定义应用分类
        getApplicationType: function (callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/getApplicationType/',
                method: 'GET',
            }, callback);
        },
        LoginOACookie: function (param, callback) {
            callback = callback || $.noop;
            return ajaxOa({
                // url: '/default/com.geostar.gtgh.oa.taskcenter.taskcenter.queryNums.biz.ext',
                url: '/default/LoginCookie',
                method: 'POST',
                data: param
            }, callback);
        },
        getTabList: function (callback) {
            document.cookie = 'JSESSIONID=' + RongWork.utils.cache.get("JSESSIONID") + ";path=/;domain=" + document.domain + ";";

            callback = callback || $.noop;
            return ajaxOa({
                // url: '/default/com.geostar.gtgh.oa.taskcenter.taskcenter.queryNums.biz.ext',
                url: '/default/com.geostar.gtgh.oa.taskcenter.taskcenter.queryNums.biz.ext',
                method: 'GET',
            }, callback);
        },
        queryAudit: function (empId, callback) {

            callback = callback || $.noop;
            return ajaxOa({
                // url: '/default/com.geostar.gtgh.oa.taskcenter.taskcenter.queryNums.biz.ext',
                url: '/default/taskcenter/queryAuditByEmpId.tc',
                method: 'POST',
                data: { empId: empId }
            }, callback);
        },
        queryCopy: function (empId, callback) {

            callback = callback || $.noop;
            return ajaxOa({
                // url: '/default/com.geostar.gtgh.oa.taskcenter.taskcenter.queryNums.biz.ext',
                url: '/default/taskcenter/taskCopyByEmpId.tc',
                method: 'POST',
                data: { empId: empId, readFlag: '0' }
            }, callback);
        },
        readAlready: function (empId, processinstId, callback) {

            callback = callback || $.noop;
            return ajaxOa({
                // url: '/default/com.geostar.gtgh.oa.taskcenter.taskcenter.queryNums.biz.ext',
                url: '/default/taskcenter/readAlready.tc',
                method: 'POST',
                data: { empId: empId, processinstId: processinstId }
            }, callback);
        },
        // 获取应用一级分类
        getAppAllOneType: function (data, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/getAppAllOneType',
                method: 'GET',
                data
            }, callback);
        },
        // 获取应用二级分类
        getAppOneAndTwoType: function (id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/getAppOneAndTwoType',
                method: 'GET',
                data: { id: id }
            }, callback);
        },
        // 获取二级分类
        getAppDataByTwoType: function (id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: '/apps/getAppDataByTwoType',
                method: 'GET',
                data: { id: id }
            }, callback);
        },
        // 获取部门树
        getAppStoreDepartTree: function (id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/departments/getAppStoreDepartTree?parentUid=${id}`,
                method: 'GET',
            }, callback);
        },
        //根据id获取部门信息
        getAppDataByDepartId: function (id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/getAppDataByDepartId`,
                method: 'GET',
                data: { id: id },
            }, callback);
        },
        // 根据分类id查找对应的id下的应用
        getAppsByTypeId: function (id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/appStore/getAppsByTypeId`,
                method: 'GET',
                data: { id: id },
            }, callback);
        },
        // 我的应用详细信息
        getDetails: function (app_id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/${app_id}`,
                method: 'GET'
            }, callback);
        },
        // 获取评论
        getAllComment: function (app_id, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/appStore/getAllComment/?appUid=${app_id}`,
                method: 'GET'
            }, callback);
        },
        // 点赞
        addCommentGreat: function (data, callback) {
            console.log(data.comment_uid);
            callback = callback || $.noop;
            return ajax({
                url: `/apps/appStore/addCommentGreat`,
                method: 'POST',
                data,
            }, callback);
        },
         // 踩
         stepOnComment: function (data, callback) {
            console.log(data.comment_uid);
            callback = callback || $.noop;
            return ajax({
                url: `/apps/appStore/stepOnComment`,
                method: 'POST',
                data,
            }, callback);
        },
        // 新增评论
        addComment: function (data, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/appStore/addComment`,
                method: 'POST',
                data,
            }, callback);
        },
        // 根据关键字搜索应用
        searchStore: function (keyword, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/appStore/search?keyword=${keyword}`,
                method: 'GET',
            }, callback);
        },
        // 添加我的应用
        batchAddMyApplication: function (data, callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/batchAddMyApplication`,
                method: 'POST',
                data,
            }, callback);
        },
        getCas:function (url,userId,callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/user/getCasTicket?appService=${url}&userId=${userId}`,
                method: 'GET',
            }, callback);
        },
        // 获取全部应用常用的20个应用
        getConstantAppList:function (callback) {
            callback = callback || $.noop;
            return ajax({
                url: `/apps/subscriptions/apps/getConstantAppList`,
                method: 'GET',
            }, callback);
        }
    };

RongWork.serverApi = server;
}(window.RongWork));