(function (RongWork) {
    'use strict';

    let components = RongWork.components;
    let utils = RongWork.utils;
    let serverApi = RongWork.serverApi;
    let confirmeQuit = false;
    let BaseApp = utils.appType.base;

    function getCurrentWebview(context) {
        let webview = context.$refs[context.currentTab.id];
        if ($.isArray(webview)) {
            return webview[0];
        }
        return webview;
    }

    function init(config) {
        config.product.productName = config.product.name[config.locale];
        let browserWindow = RongWork.browserWindow;
        let time;
        let work = new Vue({
            el: config.el,
            data: {
                // 是否为工作台
                workbench: true,
                busy: false,
                config: config,
                isMaxWindow: false,
                allApps: [],
                baseApps: [],
                otherApps: [],
                scienceApps: [],
                workApps: [],
                academicApps: [],
                partyApps: [],
                thinkApps: [],
                currentTab: null,
                tabList: [],
                location: window.location.href,
                canGoForward: false,
                canGoBack: false,
                canReload: false,
                keyword: '',
                showApps: {
                    baseApps: true,
                    scienceApps: false,
                    workApps: false,
                    academicApps: false,
                    partyApps: false,
                    thinkApps: false
                },
                showTodo: true,
                taskList: [],
                copyMeList: [],
                todoList: [],
                copyList: [],
                activeAppTab: '1',
                workList: [],
                showMyApp: true, //是否显示我的应用
                isShowAppsNum: true,//是否显示全部应用数量
                isShowConstantAppList: true,//是否显示全部应用前20个应用
                contextMenuStyle: '',
                delItem: {},
                showContextMenuDiv: false,
                latelyApps: [], //最近使用app
                showAllApp: false,
                isSearch: false, //是否处于搜索状态
                myApps: [],
                ConstantAppList: [],//全部应用常用应用
                tabNum: {},
                appTypeList: [],
                a: {},
                loginInfo: {},
                todoCount: 0,
                copyCount: 0,
                isActiveTab: true,
                allAppsNum: 0,
                // 是否为应用商店
                AppStore: false,
                appStoreType: [],
                showAppStoreValue: 16,
                AppOneAndTwoType: [],
                AppTwoAndTwoType: [],
                AppDataByTwoType: [],
                // 是否进入应用详情页
                isopenAppList: false,
                // 应用详情
                AppList: '',
                // 星星评分
                starList: [
                    {
                        isShowStar: false
                    },
                    {
                        isShowStar: false
                    },
                    {
                        isShowStar: false
                    },
                    {
                        isShowStar: false
                    },
                    {
                        isShowStar: false
                    }
                ],
                colorList: [
                    "#6D9088",
                    "#D6A3CB",
                    "#A3D6A7",
                    "#E37C7B",
                    "#49B8E6",
                    "#A48780",
                    "#E49D84",
                    "#223F59",
                    "#8C8C8C",
                    "#1E1E1E"
                ],
                inputComment: '',
                inputSearch: '',
                AppsearchAppList: [],
                isSearchApp: false,
                app_picture_url_list: [],
                listIndex: 0, //默认显示第几张图片
                TwoIndex: 1, //默认显示第几张图片
                timer: null, //定时器
                comments: '',
                CommentDetailes: '',
                YWBackground: '34',
                BMBackground: 'BM2000000190',

            },
            components: {
                // editOtherapp: components.getEditOtherapp,
                pinSearch: components.getPinSearch
            },
            created: function () {
                let context = this;

                initOAData(context, true)
                browserWindow.onPublicNotify(function (notify) {
                    getAppList(context);
                    context.removeTab(notify);
                });
            },
            computed: {
                //上一张
                prevIndex() {
                    if (this.listIndex == 0) {
                        return this.AppList.app_files.length - 1;
                    } else {
                        return this.listIndex - 1;
                    }
                },
                //下一张
                nextIndex() {
                    if (this.listIndex == this.AppList.app_files.length - 1) {
                        return 0;
                    } else {
                        return this.listIndex + 1;
                    }
                },

                tabWidth: function () {
                    let context = this;
                    let width = 0;
                    if (context.tabList.length > 0) {
                        width = 99 / context.tabList.length;
                        width = width > 50 ? 50 : width;
                    }
                    return width + '%';
                },
                locale: function () {
                    let language = this.query.language || 'zh';
                    RongWork.locale[language].product = this.config.product;
                    return RongWork.locale[language];
                },
                os: function () {
                    return this.query.os || browserWindow.getPlatform();
                },
                usingShell: function () {
                    return (this.os.indexOf('win') > -1);
                },
                query: function () {
                    return getQuery();
                },
                workListStyle: function () {
                    return this.query.hideWorkList ? {
                        'display': 'none'
                    } : {};
                },
                workMainStyle: function () {
                    return this.query.hideWorkList ? {
                        'margin-left': '0'
                    } : {};
                },
                workCtrlStyle: function () {
                    return this.query.hideWorkList ? {
                        'display': 'none'
                    } : {};
                },
                workBodyStyle: function () {
                    return this.query.hideWorkList ? {
                        'padding-top': '0'
                    } : {};
                },
            },
            watch: {
                inputSearch: function () {
                    let context = this
                    if (context.inputSearch == '') {
                        context.isSearchApp = false
                    }
                },
                // AppOneAndTwoType: function () {
                //     let context = this
                // },
                showAppStoreValue: function (newVal) {
                    let context = this
                    if (context.showAppStoreValue == 16) {
                        context.YWBackground = 34
                        serverApi.getAppOneAndTwoType(context.showAppStoreValue, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.AppOneAndTwoType = result.data;
                            let app = context.AppOneAndTwoType[0]
                            serverApi.getAppDataByTwoType(app.id, function (errorCode, result) {
                                if (errorCode) {
                                    return;
                                }
                                context.AppDataByTwoType = result.data
                            })
                        })
                    }
                    if (context.showAppStoreValue == 59) {
                        context.BMBackground = 'BM2000000190'
                        let id = 'Ghe8QFCYO0qWhrbqpBFkwqr'
                        serverApi.getAppStoreDepartTree(id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.AppTwoAndTwoType = result.data;
                            let app = context.AppTwoAndTwoType[0]
                            for (let index = 0; index < context.AppTwoAndTwoType.length; index++) {
                                // 地方科協
                                if (context.AppTwoAndTwoType[index].id == "BM2000000004") {
                                    context.AppTwoAndTwoType[index].childData = []
                                }
                                // 高校科協
                                if (context.AppTwoAndTwoType[index].id == "BM1000001263") {
                                    context.AppTwoAndTwoType[index].childData = []
                                }
                                // 企業科協
                                if (context.AppTwoAndTwoType[index].id == "BM1000001091") {
                                    context.AppTwoAndTwoType[index].childData = []
                                }
                            }
                            serverApi.getAppDataByTwoType(app.id, function (errorCode, result) {
                                if (errorCode) {
                                    return;
                                }
                                serverApi.getAppDataByDepartId(app.childData[0].id || app.id, function (errorCode, result) {
                                    if (errorCode) {
                                        return;
                                    }
                                    context.AppDataByTwoType = result.data
                                })
                            })
                        })
                    }
                },
                currentTab: function (newVal) {
                    if (newVal) {
                        let webview = getCurrentWebview(this);
                        let canGoBack = false;
                        let canGoForward = false;
                        if (webview) {
                            canGoBack = webview.canGoBack && webview.canGoBack();
                            canGoForward = webview.canGoForward && webview.canGoForward();
                        }
                        this.canGoBack = canGoBack;
                        this.canGoForward = canGoForward;
                        this.canReload = validUrl(this.pageUrl(newVal));
                    }
                },
                activeAppTab(v) {
                    let allAppsList = this.allApps.filter(obj => obj.description == v)
                    let regex = this.keyword ? new RegExp(this.keyword, 'i') : null;
                    let that = this;
                    that.isActiveTab = true
                    that.workList = []
                    allAppsList.forEach(function (item) {
                        if (!regex || regex.test(item.name)) that.workList.push(item);
                    })

                },
                showTodo(v) {
                    let context = this;
                    if (v) {
                        this.taskList = this.todoList
                    } else {
                        queryCopy(context)
                        // this.taskList = this.copyList.map(obj => {
                        //     return {
                        //         ...obj,
                        //         taskName: obj.processdefName,
                        //         beforePerson: obj.fromPartEmpname
                        //     }
                        // })
                    }
                },
                keyword(v) {
                    this.isActiveTab = false
                }
            },
            mounted: function () {
                let context = this;
                // getApplicationType(this)
                getAppList(this);
                this.getConstantAppList();
                browserWindow.reloadWork(function (path) {
                    let newQuery = getQuery(path);
                    if (newQuery.targetId) {
                        newQuery.id = newQuery.targetId;
                    }
                    context.openApp(newQuery);
                });
                for (let i = 0; i < this.starNum; i++) {
                    this.starList[i].isShowStar = true
                }
            },
            methods: {
                getConstantAppList() {
                    let context = this;
                    serverApi.getConstantAppList(function (errorCode, result) {
                        if (errorCode) {
                            console.log(errorCode);
                            return;
                        }
                        context.ConstantAppList = result.apps
                    })
                },
                //深拷贝数组
                deepCopy(obj) {
                    // 判断是否是对象
                    if (typeof obj !== 'object') return
                    // 判断obj类型，根据类型新建一个对象或者数组
                    let newObj = obj instanceof Array ? [] : {}
                    // 遍历对象，进行赋值
                    for (let key in obj) {
                        if (obj.hasOwnProperty(key)) {
                            let val = obj[key]
                            // 判断属性值的类型，如果是对象，递归调用deepCopy
                            newObj[key] = typeof val === 'object' ? this.deepCopy(val) : val
                        }
                    }
                    return newObj
                },
                showTwoimg(index) {
                    if (this.AppList.app_files.length == 1) {
                        this.TwoIndex = 0
                    }
                    if (index + 1 > this.AppList.app_files.length - 1) {
                        return 0;
                    } else {
                        return 1;
                    }
                },
                changePage(index) {
                    this.listIndex = index;

                    if (index == this.app_picture_url_list.length - 1) {
                        this.TwoIndex = 0;
                    } else {
                        this.TwoIndex = index + 1;
                    }
                },

                //移除
                out() {
                    // this.setTimer();
                },
                //移入
                over() {
                    // clearInterval(this.timer);
                },
                // //3秒切图
                // setTimer() {
                //     this.timer = setInterval(() => {
                //         this.listIndex++;
                //         this.TwoIndex++;
                //         if (this.listIndex == this.app_picture_url_list.length) {
                //             this.listIndex = 0;
                //         }
                //         if (this.TwoIndex == this.app_picture_url_list.length) {
                //             this.TwoIndex = 0;
                //         }
                //     }, 3000);
                // },
                async addApp(val) {
                    let context = this;
                    context.app_picture_url_list = [];
                    if (val.app_is_my_scope == '1') {
                        alert('您没有添加权限，请联系管理员')
                        return false
                    }
                    if (val.app_is_free == '1') {
                        alert('付费应用请与管理员联系。')
                        return false
                    }
                    if (!val.pc_home_page_url) {
                        alert('该应用只在科协一家移动端端展示')
                    }

                    serverApi.batchAddMyApplication({ apps: [val.id] }, function (res) {
                        serverApi.getDetails(val.id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.AppList = result
                            result.app_files.forEach(item => {
                                context.app_picture_url_list.push(item.app_picture_url)
                                if (context.app_picture_url_list.length == 1) {
                                    context.TwoIndex = 0
                                } else if (context.app_picture_url_list.length > 1) {
                                    context.TwoIndex = 1
                                }
                            });

                            context.AppList.create_time = new Date(parseInt(context.AppList.create_dt)).toLocaleDateString()
                        })
                    })
                },
                clearSearchStore() {
                    let context = this;
                    context.inputSearch = '';
                },
                searchStore() {
                    let context = this;
                    if (context.inputSearch == '') {
                        return
                    }
                    serverApi.searchStore(context.inputSearch.trim(), function (errorCode, result) {
                        if (errorCode) {
                            return;
                        }
                        context.APPsearchAppList = result;
                        context.isSearchApp = true;

                    })
                },
                getaddComment(app) {
                    let context = this;
                    if (context.inputComment == '') {
                        alert('请输入评论！')
                        return
                    }
                    let stars = 0;
                    for (let i = 0; i < context.starList.length; i++) {
                        if (context.starList[i].isShowStar == true) {
                            stars += 1
                        }

                    }
                    let data = {
                        app_uid: app.id,
                        content: context.inputComment,
                        stars: stars,
                    }
                    serverApi.addComment(data, function (errorCode, res) {
                        if (errorCode) {
                            alert('评论失败，请稍后重试！')
                            return
                        }
                        context.inputComment = '';
                        context.starList[0].isShowStar = false;
                        context.starList[1].isShowStar = false;
                        context.starList[2].isShowStar = false;
                        context.starList[3].isShowStar = false;
                        context.starList[4].isShowStar = false;

                        serverApi.getAllComment(context.comments.id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.comments = result;

                        })
                    })

                },
                // 回复评论
                getHfaddComment(Comment) {

                    let context = this;
                    if (context.CommentDetailes == '') {
                        alert('请输入评论！')
                        return
                    }
                    let data = {
                        app_uid: context.AppList.id,
                        content: context.CommentDetailes,
                        parent_uid: Comment.uid,
                        stars: null,
                    }
                    serverApi.addComment(data, function (errorCode, res) {
                        if (errorCode) {
                            alert('评论失败，请稍后重试！')
                            return
                        }
                        context.CommentDetailes = '';
                        let HF = document.getElementById(Comment.uid)
                        HF.style.display = 'none'
                        serverApi.getAllComment(context.comments.id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.comments = result;

                        })
                    })
                },
                goCommentDetailes(Comment) {
                    let context = this
                    let HF = document.getElementById(Comment.uid)
                    console.log(HF.style.display === 'block');
                    if (HF.style.display === 'block') {
                        HF.style.display = 'none'
                    } else {
                        HF.style.display = 'block'
                    }

                },
                // 点赞
                getaddCommentGreat(Comment) {
                    let context = this
                    serverApi.addCommentGreat({ comment_uid: Comment.uid }, function (errorCode, result) {
                        if (errorCode) {
                            alert('点赞失败，请稍后重试！')
                            return;
                        }
                        serverApi.getAllComment(context.comments.id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.comments = result
                        })
                    })

                },
                // 踩
                getstepOnComment(Comment) {
                    let context = this
                    serverApi.stepOnComment({ comment_uid: Comment.uid }, function (errorCode, result) {
                        if (errorCode) {
                            alert('踩失败，请稍后重试！')
                            return;
                        }
                        serverApi.getAllComment(context.comments.id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.comments = result
                        })
                    })

                },
                gettime(time) {
                    let newtime = ''
                    newtime = new Date(parseInt(time)).toLocaleDateString()
                    return newtime
                },
                Start(e, index) {
                    let context = this;
                    for (let i = 0; i <= context.starList.length - 1; i++) {
                        if (i <= index) {
                            context.starList[i].isShowStar = true
                        } else {
                            context.starList[i].isShowStar = false
                        }

                    }

                },
                gobackAppType() {
                    let context = this;
                    context.isopenAppList = false;
                    context.AppStore = true;
                    context.workbench = false;
                    context.starList[0].isShowStar = false;
                    context.starList[1].isShowStar = false;
                    context.starList[2].isShowStar = false;
                    context.starList[3].isShowStar = false;
                    context.starList[4].isShowStar = false;
                    clearInterval(this.timer);
                    context.listIndex = 0;
                    context.TwoIndex = 1;
                    context.inputComment = '';
                    context.CommentDetailes = '';
                },
                async openAppList(app) {
                    let context = this;
                    context.app_picture_url_list = [];
                    // context.AppList='';
                    // context.comments='';
                    await serverApi.getDetails(app.id, function (errorCode, result) {
                        if (errorCode) {
                            return;
                        }
                        context.AppList = result
                        result.app_files.forEach(item => {
                            context.app_picture_url_list.push(item.app_picture_url)
                            if (context.app_picture_url_list.length == 1) {
                                context.TwoIndex = 0
                            } else if (context.app_picture_url_list.length > 1) {
                                context.TwoIndex = 1
                            }
                        });
                        //定时器
                        // context.setTimer();
                        context.AppList.create_time = new Date(parseInt(context.AppList.create_dt)).toLocaleDateString()
                    })
                    await serverApi.getAllComment(app.id, function (errorCode, result) {
                        if (errorCode) {
                            return;
                        }
                        context.comments = result
                    })
                    context.isopenAppList = true;
                    context.AppStore = false;
                    context.workbench = false;
                },
                openTwoAppType: function (appStore) {
                    let context = this;
                    let ids = appStore.id
                    if (appStore.childData && appStore.childData.length) {
                        // document.getElementById(ids).style.display = (document.getElementById(ids).style.display == 'none') ? '' : 'none'
                    } else if (ids == 'BM2000000004' || ids == 'BM1000001263' || ids == 'BM1000001091') {
                        context.BMBackground = appStore.id
                        serverApi.getAppDataByDepartId(ids, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.AppDataByTwoType = result.data
                        })
                    }
                },
                openAppType: function (appStore) {
                    let context = this;
                    let ids = appStore.id
                    context.YWBackground = appStore.id
                    serverApi.getAppDataByTwoType(ids, function (errorCode, result) {
                        if (errorCode) {
                            return;
                        }
                        context.AppDataByTwoType = result.data
                    })


                },
                openAppTwoType: function (appStore) {
                    let context = this;
                    let ids = appStore.id
                    context.BMBackground = appStore.id
                    serverApi.getAppDataByDepartId(ids, function (errorCode, result) {
                        if (errorCode) {
                            return;
                        }
                        context.AppDataByTwoType = result.data
                    })
                },
                appGroupTitle: function (tag, listTag) {
                    if (!listTag) listTag = tag;
                    return this.locale[tag] + ' (' + this[listTag].length + ')';
                },
                min: function () {
                    browserWindow.min();
                },
                max: function () {
                    browserWindow.max();
                    this.isMaxWindow = true;
                },
                restore: function () {
                    browserWindow.restore();
                    this.isMaxWindow = false;
                },
                close: function () {
                    browserWindow.close();
                },
                goBack: function () {
                    let webview = getCurrentWebview(this);
                    if (webview) {
                        webview.goBack();
                    }
                },
                goForward: function () {
                    let webview = getCurrentWebview(this);
                    if (webview) {
                        webview.goForward();
                    }
                },
                reload: function () {
                    let webview = getCurrentWebview(this);
                    if (webview) {
                        if (webview.reload) {
                            webview.reload();
                        } else {
                            webview.src = webview.src;
                        }
                    }
                },
                removeTab: function (notify) {
                    // 后台关闭后消息通知，移除当前已经打开的应用
                    let context = this;
                    let notifyApp = context.tabList.filter(function (item) {
                        return item.id === notify.targetId;
                    });
                    if (context.isSelected(notifyApp[0])) {
                        utils.messagebox({
                            message: context.locale.theAppCloseTip,
                            callback: function () {
                                context.closeTab(notifyApp[0]);
                            }
                        });
                    } else if (notifyApp[0]) {
                        context.closeTab(notifyApp[0]);
                    }
                },
                closeTab: function (item) {
                    let index = this.tabList.indexOf(item);
                    this.tabList.splice(index, 1);
                    this.currentTab = this.tabList[0];
                },
                showPublicDetail: function (item) {
                    return (
                        item.type !== -1 && !validUrl(this.pageUrl(item))
                    );
                },
                isSelected: function (item) {
                    return item === this.currentTab && item !== undefined;
                },
                workViewStyle: function (item) {
                    return Object.assign({
                        display: this.isSelected(item) ? 'flex' : 'none'
                    },
                        this.workBodyStyle
                    );
                },
                isTrueFlag: function (str) {
                    return str == '1' || str == 'true' || str == 'yes' || str == 'on';
                },
                openApp: function (app) {
                    let context = this;
                    let appIndex = -1;
                    context.tabList.forEach(function (value, index) {
                        if (value.id === app.id) {
                            appIndex = index;
                        }
                    });
                    if (appIndex > -1) {
                        context.currentTab = context.tabList[appIndex];
                    } else if (app.type !== -1) {
                        serverApi.getPublicInfo(app.id, function (errorCode, result) {
                            if (errorCode || !result) {
                                return;
                            }
                            let pageUrl = context.pageUrl(result);
                            let searchArgs = {};
                            let searchStart = pageUrl.indexOf('?');
                            if (searchStart > -1) {
                                pageUrl.substr(searchStart + 1).split('&').forEach(function (arg) {
                                    let pair = arg.split('=');
                                    searchArgs[pair[0].toLowerCase()] = pair[1];
                                });
                            }
                            if (context.isTrueFlag(searchArgs['opentab'])) {
                                if (pageUrl.indexOf("?") == -1) {
                                    // 没有问号
                                    pageUrl = pageUrl + `?LoginPlatform=${context.query.userId}`
                                    // pageUrl = pageUrl + "?ticket=" + getCasTicket_ticket
                                } else {
                                    // 有问号
                                    // 处理地址，将LoginPlatform=RY2000002969拼到?后面
                                    const PAGEURLARRAY = pageUrl.split('?')
                                    PAGEURLARRAY[1] = `LoginPlatform=${context.query.userId}&` + PAGEURLARRAY[1]
                                    pageUrl = PAGEURLARRAY.join('?')
                                    // pageUrl = pageUrl + "&ticket=" + getCasTicket_ticket
                                }
                                RongWork.browserWindow.openPSArticle(context.bridgeUrl(pageUrl))
                                // if (context.tabList.indexOf(result) === -1) {
                                //     context.tabList.push(result);
                                //     Vue.nextTick(function () {
                                //         initWebview(result, context); 
                                //     });
                                // }
                                // context.currentTab = result;
                            } else {
                                let getCasTicket_ticket = context.query.getCasTicket_ticket
                                // 获取cas（废弃    ）
                                // serverApi.getCas(encodeURIComponent(app.pc_home_page_url), context.query.staffId, function (errorCode, result) {
                                //     if (errorCode) {
                                //         return;
                                //     }
                                //      console.log(pageUrl);
                                //     console.log(result.ticket);
                                //     let ticket = result.ticket
                                if (pageUrl.indexOf("?") == -1) {
                                    // 没有问号
                                    console.log(1);
                                    pageUrl = pageUrl + `?LoginPlatform=${context.query.userId}`
                                    // pageUrl = pageUrl + "?ticket=" + getCasTicket_ticket
                                } else {
                                    // 有问号
                                    console.log(2);
                                    // 处理地址，将LoginPlatform=RY2000002969拼到?后面
                                    const PAGEURLARRAY = pageUrl.split('?')
                                    PAGEURLARRAY[1] = `LoginPlatform=${context.query.userId}&` + PAGEURLARRAY[1]
                                    pageUrl = PAGEURLARRAY.join('?')
                                    // pageUrl = pageUrl + "&ticket=" + getCasTicket_ticket
                                    console.log(pageUrl);
                                }
                                //     // openExternal(
                                //     //     context.bridgeUrl(pageUrl),
                                //     //     context.usingShell && context.isTrueFlag(searchArgs['openchrome'])
                                //     // );
                                // })
                                openExternal(
                                    context.bridgeUrl(pageUrl),
                                    context.usingShell && context.isTrueFlag(searchArgs['openchrome'])
                                );

                            }
                        });
                        serverApi.updateApplication(app.id, function (res) {
                            //将点击的app,加到最近使用
                            if (context.latelyApps.filter(obj => obj.id == app.id).length > 0) {
                                context.latelyApps.splice(context.latelyApps.findIndex(item => app.id === item.id), 1)
                            }
                            context.latelyApps.unshift(app)

                        })
                    } else {
                        // context.tabList.push(app);
                        // context.currentTab = app;
                        // Vue.nextTick(function () {
                        //     initWebview(app, context);
                        // });
                        let list = context.appTypeList.map(obj => {
                            return {
                                id: obj.uid,
                                name: obj.customName + "(" + context.getAppNum(obj) + ")"
                            }
                        })
                        RongWork.dialog.editOtherApps(list, (res) => {
                            context.myApps = res
                            //新增
                            // if (res.flag == 1) {
                            //     context.myApps.push(res.app)
                            // } else if (res.flag == 0) {
                            //     context.myApps.splice(context.myApps.findIndex(item => res.app.id === item.id), 1)
                            // } else {
                            //     context.myApps = context.myApps.filter(a => !res.some(b => b == a.id))
                            // }

                        })
                    }
                },
                openTask: function (task) {
                    let context = this;
                    let processinstId = task.processinstId.substring(task.processinstId.indexOf("_") + 1)
                    let result = ''
                    let zkxEmpId = utils.getQueryString("empId")
                    if (!context.showTodo) {
                        serverApi.readAlready(zkxEmpId, task.processinstId, (res) => {
                            context.taskList.filter(obj => obj != task)
                            result = task.viewUrlPc + "&processinstId=" + processinstId + "&&time=" + new Date().getTime()
                            RongWork.browserWindow.openPSArticle(context.bridgeUrl(result))
                        })
                    } else {
                        let taskId = task.taskId.substring(task.taskId.indexOf("_") + 1)
                        result = task.taskUrlPc + "&taskId=" + taskId + "&processinstId=" + processinstId
                        RongWork.browserWindow.openPSArticle(context.bridgeUrl(result))
                    }
                },
                openMore: function () {
                    //待办
                    let url = ''
                    if (this.showTodo) {
                        url = RongWork.config.serverOA + '/default/taskcenter/index.html#/taskcenter/wap?type=1'
                    } else {
                        url = RongWork.config.serverOA + '/default/taskcenter/index.html#/taskcenter/wap?type=2'
                    }
                    RongWork.browserWindow.openPSArticle(this.bridgeUrl(url))
                },
                enterPublic: function (app) {
                    let context = this;
                    if (!context.busy) {
                        context.busy = true;
                        browserWindow.enterPublic(app, function () {
                            context.busy = false;
                        });
                    }
                },
                isAppStore: function () {
                    let context = this;
                    context.AppStore = !context.AppStore;
                    context.workbench = !context.workbench;
                    context.inputSearch = '';
                    let param = 0
                    serverApi.getAppAllOneType(param, function (errorCode, result) {
                        if (errorCode) {
                            return;
                        }
                        context.appStoreType = result.data
                        serverApi.getAppOneAndTwoType(context.appStoreType[0].id, function (errorCode, result) {
                            if (errorCode) {
                                return;
                            }
                            context.AppOneAndTwoType = result.data
                            let app = context.AppOneAndTwoType[0]
                            serverApi.getAppDataByTwoType(app.id, function (errorCode, result) {
                                if (errorCode) {
                                    return;
                                }
                                context.AppDataByTwoType = result.data
                            })

                        })
                    })
                },
                edit: function () {
                    this.openApp({
                        name: this.locale.setCommonApp,
                        type: -1
                    });
                },
                reloadFavApp: function () {
                    this.closeTab(this.currentTab);
                    getAppList(this);
                },
                searchAppList: function (val) {
                    this.keyword = val.keyword;
                    if (val) {
                        if (val.keyword != '') {
                            this.isShowAppsNum = false
                            this.isShowConstantAppList = false
                            this.isSearch = true
                            this.showAllApp = true
                            this.filterApps();
                        } else {
                            this.isShowAppsNum = true
                            this.isShowConstantAppList = true
                            // this.allAppsNum = this.allApps.filter(item => (item.pc_home_page_url && item.pc_home_page_url != '')).length;
                            this.isSearch = false
                            this.showAllApp = false
                            this.workList = this.allApps.filter(item => item.description == this.appTypeList[0].uid)
                        }
                    } else {
                        this.isShowAppsNum = true
                        this.isShowConstantAppList = true
                        // this.allAppsNum = this.allApps.filter(item => (item.pc_home_page_url && item.pc_home_page_url != '')).length;
                        this.isSearch = false
                        this.showAllApp = false

                    }
                },
                filterApps: function () {
                    let context = this;
                    let regex = this.keyword ? new RegExp(this.keyword, 'i') : null;
                    // this.allAppsNum = '',
                    this.baseApps = [];
                    this.otherApps = [];
                    this.scienceApps = [];
                    this.workApps = [];
                    this.academicApps = [];
                    this.partyApps = [];
                    this.thinkApps = [];
                    let sortDate = (a, b) => {
                        return a.lately_dt < b.lately_dt ? 1 : -1
                    }
                    this.latelyApps = this.allApps.filter(obj => obj.lately_dt && obj.pc_home_page_url).sort(sortDate)
                    this.myApps = this.allApps.filter(obj => {
                        let favorite_pc = getQueryString('favorite', obj.pc_home_page_url) == 'pc';
                        if (favorite_pc) obj.my_application = 1;
                        return favorite_pc || obj.my_application == 1;
                    })

                    context.workList = []
                    let list = this.allApps.filter(item => (item.pc_home_page_url && item.pc_home_page_url != ''))
                    list.forEach(function (item) {
                        let pageUrl = context.pageUrl(item);
                        if (!pageUrl) return;

                        // let isOther = item.type != BaseApp
                        // let pushTarget = [];
                        let pushTarget = context.baseApps;
                        // let favorite = pageUrl.indexOf('favorite');
                        // if (favorite > -1) {
                        //     favorite = pageUrl.substr(favorite).split('&')[0];
                        // } else {
                        //     favorite = null;
                        // }
                        let isOther = item.type != BaseApp;
                        //判断是否在我的应用里面
                        if (pushTarget.filter(ibj => ibj.id == item.id).length > 0) {
                            item.inMyApp = true;
                        }
                        if (isOther) {
                            context.otherApps.push(item);
                            if (item.description == 1) {
                                pushTarget = context.scienceApps;
                                if (context.keyword == '') {
                                    context.workList = context.scienceApps;
                                }

                            } else if (item.description == 2) {
                                pushTarget = context.workApps;
                            } else if (item.description == 3) {
                                pushTarget = context.academicApps;
                            } else if (item.description == 4) {
                                pushTarget = context.partyApps;
                            } else if (item.description == 5) {
                                pushTarget = context.thinkApps;
                            }
                        }
                        if (!regex || regex.test(item.name)) {
                            pushTarget.push(item);
                            context.workList.push(item)
                        }

                    })
                    this.onLoadApps();
                },
                pageUrl: function (app) {
                    return app.pc_home_page_url || '';
                },
                appUrl: function (app) {
                    let pageUrl = this.pageUrl(app);
                    /*return (this.os.indexOf('web') > -1) ? this.bridgeUrl(pageUrl) : pageUrl;*/
                    let url = this.bridgeUrl(pageUrl);
                    if (pageUrl.indexOf("useValidation") > -1);
                    return url;
                },
                bridgeUrl: function (pageUrl) {
                    if (pageUrl.match(/\/taskcenter\//i) != null && this.query.sessionid) {
                        let urlParts = pageUrl.split('#');
                        pageUrl = urlParts[0] + (
                            urlParts[0].indexOf('?') > 0 ? '&' : '?'
                        ) + "sessionid=" + encodeURIComponent(this.query.sessionid) +
                            "&uid=" + this.query.staffId + (
                                urlParts[1] ? ('#' + urlParts[1]) : ''
                            );
                    }
                    let token = decodeURIComponent(this.query.zkxToken) + ';path=/';
                    return RongWork.loginServer + '/sign-bridge.html' +
                        '?target=' + encodeURIComponent(pageUrl) +
                        '&empId=' + (this.query.empId || '') +
                        '&token=' + encodeURIComponent(token);
                },
                onLoadApps: function () {
                    let context = this;
                    let params = {
                        id: this.query.targetId
                    };
                    let targetUrl = this.query.targetUrl;
                    if (targetUrl) {
                        targetUrl = decodeURIComponent(targetUrl);
                        allApps.some(function (app) {
                            if (context.pageUrl(app) === targetUrl) {
                                params.id = app.id;
                                return true;
                            }
                        });
                    }
                    if (params.id) {
                        this.openApp(params);
                    }
                },
                isWebPlatform: function () {
                    let platform = browserWindow.getPlatform();
                    return platform.indexOf('web') !== -1;
                },
                //显示右键
                showContextmenu: function (event, item, fixOffset) {
                    this.showContextMenuDiv = true
                    this.delItem = item;
                    fixOffset = $.extend({
                        left: 0,
                        top: 0
                    }, fixOffset);
                    let offset = $(this.$el).offset();
                    let top = event.pageY - offset.top + fixOffset.top;
                    let bottom = document.documentElement.offsetHeight - event.clientY;
                    let throttle = 80;
                    if (bottom < throttle) {
                        top = 'auto';
                    } else {
                        bottom = 'auto';
                    }
                    let left = event.pageX - offset.left + fixOffset.left;


                    this.contextMenuStyle = {
                        left: getStyleValue(left),
                        top: getStyleValue(top),
                        bottom: getStyleValue(bottom)
                    };
                },
                imclick: function (event) {
                    let $target = $(event.target);
                    let wrap = '.menu-context';
                    let inBody = $target.closest('body').length > 0;
                    let inWrap = $target.closest(wrap).length < 1;
                    let isOuter = inBody && inWrap;
                    if (isOuter) this.showContextMenuDiv = false
                },
                deleteItem: function () {
                    let that = this;
                    that.showContextMenuDiv = false;
                    let favorite_pc = getQueryString('favorite', that.delItem.pc_home_page_url) == 'pc';
                    if (favorite_pc) {
                        utils.messagebox({
                            message: '该应用为默认应用，不支持移除'
                        });
                        return;
                    }
                    utils.messagebox({
                        message: '确定从“我的应用”中移除？',
                        type: 'confirm',
                        callback: function () {
                            let param = {
                                "app_uid": that.delItem.id,
                                "state": 0
                            }
                            serverApi.updateMyApplication(param, function (res) {
                                that.myApps.splice(that.myApps.findIndex(item => that.delItem.id === item.id), 1)
                                that.showContextMenuDiv = false
                            })
                        },
                    });

                },
                getAppNum: function (item) {
                    let list = this.allApps.filter(obj => obj.description == item.uid).filter(item => (item.pc_home_page_url && item.pc_home_page_url != ''))
                    let regex = this.keyword ? new RegExp(this.keyword, 'i') : null;
                    let num = 0
                    list.forEach(function (item) {
                        if (!regex || regex.test(item.name)) num += 1;
                    })
                    return num
                },
                isActive: function (item) {
                    if (this.keyword && this.keyword != '' && !this.isActiveTab) {
                        return this.getAppNum(item) > 0
                    }
                    return this.activeAppTab == item.uid
                },
                getEmpty() {
                    return "没有搜索到" + '<em>&quot;' + this.keyword + '&quot;</em>' + '相关的结果'
                },
                initOAData() {
                    initOAData(this)
                }

            }
        });
        //watchClose(work);
        RongWork.instance = work;
    }

    function initOAData(context, flag) {
        // debugger
        if (flag) {
            getTudoList(context)
            queryCopy(context)
            return;
        }
        if (context.showTodo) {
            getTudoList(context)
        } else {
            queryCopy(context)
        }

    }
    // 获取自定义用用类型
    function getApplicationType(context) {
        serverApi.getApplicationType((errorCode, res) => {
            context.appTypeList = res.sort((x, y) => x.oid - y.oid)
            // let last = list.slice(-5)
            // let prev = list.splice(list.length - 5, 5)
            // context.appTypeList = last.concat(list)
        })
    }

    function getStyleValue(prop) {
        return isNaN(prop) ? prop : prop + 'px';
    }

    function validUrl(str) {
        let reg = /^(http|https):\/\/\S+$/;
        return reg.test(str);
    }
    //获取tab列表
    function getTabList(context) {
        serverApi.getTabList((res) => {
            context.tabNum = res
        })
    }
    //获取待办列表
    function getTudoList(context) {
        let zkxEmpId = utils.getQueryString("empId")
        serverApi.queryAudit(zkxEmpId, (res) => {
            // console.log(res);
            context.a = res
            context.todoCount = res.page.count
            context.todoList = res.datas.filter((obj, index) => index < 3)
            context.taskList = context.todoList
            if (context.showTodo) {
                setTimeout(() => getTudoList(context), 5 * 1000);
            }

        })
    }

    function queryCopy(context) {
        let zkxEmpId = utils.getQueryString("empId")
        serverApi.queryCopy(zkxEmpId, (res) => {
            context.copyCount = res.page.count
            context.copyList = res.datas.filter((obj, index) => index < 3)
            if (!context.showTodo) {
                // context.taskList = context.copyList
                context.copyMeList = context.copyList
            }

        })
    }

    function getQuery(str) {
        let query = {};
        if (str) {
            let ss = str.indexOf('?');
            if (ss === -1) {
                str = '';
            } else if (ss !== 0) {
                str = str.substring(ss);
            }
        } else {
            str = window.location.search;
        }
        if (str) {
            str.substring(1).split('&').forEach(function (item) {
                let arr = item.split('=');
                query[arr[0]] = arr[1];
            });
        }
        return query;
    }

    function getNameByUrl(field, url) {
        // eslint-disable-next-line no-undef
        const href = url || window.location.href;
        const reg = new RegExp(`[?&]${field}=([^&#]*)`, 'i');
        const string = reg.exec(href);
        return string ? decodeURIComponent(decodeURIComponent(string[1])) : null;
    };

    function getAppList(context) {
        serverApi.getAllApps(function (errorCode, result) {
            let allAppType = result.appsType;
            // let appTypeGu = result.appsType.filter(obj => obj.oid).sort((x, y) => x.oid - y.oid)
            let appTypeGu = result.appsType
            let arrC = allAppType.filter(a => !appTypeGu.some(b => b.id == a.id))
            context.activeAppTab = result.appsType.filter(obj => obj.oid == 1)[0].uid
            context.appTypeList = appTypeGu.concat(arrC)

            if (result && result.apps && result.apps.length > 0) {
                // console.log("result.apps--->",result.apps);
                context.allApps = result.apps.map(function (item) {
                    // 判断web端https方式登录程序
                    if (location.protocol == 'https:' && context.isWebPlatform() && item.logo_url.indexOf('8086') != -1) {
                        item.logo_url = 'https://work.cast.org.cn:1446' + item.logo_url.split('8086')[1]
                    }
                    return item;
                });
                context.allAppsNum = context.allApps.filter(item => (item.pc_home_page_url && item.pc_home_page_url != '')).length;

                context.filterApps();
            }
        });
    }

    function initWebview(item, context) {
        if (!item) {
            return;
        }
        let id = item.id;
        let webview = context.$refs[id];
        if ($.isArray(webview)) {
            webview = webview[0];
        }
        context.canGoBack = false;
        context.canGoForward = false;
        context.canReload = validUrl(context.pageUrl(item));
        if (webview) {
            if (webview.getWebContents) {
                let ses = webview.getWebContents().session;
                let token = decodeURIComponent(context.query.zkxToken).split('=');
                ses.cookies.remove(context.pageUrl(item), 'JSESSIONID', function () { });
                ses.cookies.set({
                    url: RongWork.loginServer,
                    name: token[0],
                    value: token[1],
                    path: '/'
                }, function (err) { });
                ses.cookies.flushStore(function () { });
            }
            webview.addEventListener('new-window', function (event) {
                let url = event.url;
                if (url.startsWith('http:') || url.startsWith('https:')) {
                    openExternal(context.bridgeUrl(url));
                }
            });
            webview.addEventListener('did-navigate', function (event) {
                if (context.currentTab.id === id) {
                    context.canGoBack = webview.canGoBack && webview.canGoBack();
                    context.canGoForward = webview.canGoForward && webview.canGoForward();
                }
            });
            webview.addEventListener('console-message', function (event) {
                if (/#关闭.*页面#/.test(event.message)) context.closeTab(item);
            });
        }
    }
    /*function watchClose(context) {
        window.onbeforeunload = function () {
            if (!confirmeQuit) {
                RongWork.browserWindow.focus();
                // context.closeBefore = true;
                utils.messagebox({
                    type: 'confirm',
                    message: context.locale.closeWorkTip,
                    callback: function () {
                        confirmeQuit = true;
                        RongWork.browserWindow.close();
                    }
                });
                return true;
            }
            return undefined;
        };
    }*/

    function getQueryString(name, url) {
        url = url || window.location.href;
        let index = url.lastIndexOf('?');
        if (index === -1) return;
        let query = url.slice(index + 1);
        let vars = query.split("&");
        for (let i = 0; i < vars.length; i++) {
            let pair = vars[i].split("=");
            if (pair[0] == name) { return pair[1]; }
        }
        return;
    }
    function alert(e) {
        $("body").append("<div id='msg'><span>" + e + "</span></div>");
        clearmsg();
    }
    function clearmsg() {
        let t = setTimeout(function () {
            $("#msg").remove();
        }, 2000)
    };

    RongWork.init = init;
}(window.RongWork));