### 桌面版解决方案

#### 环境说明

1、支持的平台

`Mac`: 支持 MacOS 10.9+

`Windows`: Windows 7 及以上版本（ARM 版本的 Windows 暂不支持）

2、开发环境

Node 8.12.0 (Windows必须 32 位) 如果已安装其他版本 Node 可使用工具切换，[Windows](https://www.npmjs.com/package/wnvm)、[Mac](https://www.npmjs.com/package/n)

#### 快速启动

1、安装依赖包 (项目根目录下)

```
npm install
```

`备注`：

首次安装若遇到 `electron` 无法下载，可切换到淘宝镜像，具体如下：

使用淘宝镜像：`npm config set registry https://registry.npm.taobao.org`

使用默认：`npm config set registry https://registry.npmjs.org/`

```
npm install -g node-gyp
```

'备注':

Mac 制作安装包环境需要 node-gyp，还需要

python (推荐 v2.7, v3.x.x 不支持)

Xcode，需要通过 Xcode 安装 Command Line Tools，可以在以下菜单找到它 Xcode -> Preferences -> Locations (或 xcode-select --install 在终端运行)

这一步将安装 gcc 和相关的工具链包括 make

2、运行

```
npm start [dev]
```

3、配置文件

按需修改配置文件 `src/local_config.conf`

#### 修改图标

图标位置: `res` 目录，详细说明如下：

`app.icns`:  Mac 打包图标

`app.ico`: Windows 打包图标，安装包图标

`Windows_icon.png`: Windows 托盘图标

`app.png`: App 启动页面背景图标

`Mac_Template.png`:   Mac 右上角图标

`Mac_Template@2x.png`: 高分辨率图片

`Mac_TemplateWhite.png`: Mac 右上角点击反白图标

`Mac_TemplateWhite@2x.png`: 高分辨率图片

`注意`：Mac 图标图标用法请参考 [NativeImage](https://electronjs.org/docs/api/native-image)

#### 打包

`注意`: 

* Mac 和 Windows 的打包操作、制作安装包操作必须在对应平台进行
* 如果 local_config.json 中 build 为调试状态, 打包后的名字后将自带 TEST. 建议改成发布状态再打包

Windows​: 

```
npm run package:win
```

Mac:

```
npm run package:mac
```

#### Windows 下签名

1、本地安装开发者证书

2、使用 signtool 进行签名

`参考文档`:

[SignTool](https://docs.microsoft.com/zh-cn/windows/desktop/SecCrypto/signtool)

`环境`:

`Visual Studio`: vs 目录下执行签名命令

`示例`:

```
signtool sign /debug /v /f [SignCertFile] /p [Password] /t http://timestamp.verisign.com/scripts/timstamp.dll [FileName.exe]
```

#### Mac 下签名

`说明`: 如果不签名, 运行时会因为来自不明身份的开发者而无法打开

1、确保 Mac 本地已经安装开发者证书

`参考文档`:

[Electron - Signing a Mac Application](https://pracucci.com/atom-electron-signing-mac-app.html)

[Requesting certificates](https://github.com/nwjs/nw.js/wiki/MAS%3A-Requesting-certificates)

2、在 `build-tools/pack/codesign.bash` 中正确配置签名

3、开始签名

```
npm run codesign <appName>
```

4、检查签名是否成功

```
spctl --verbose=4 --assess --type execute build/App目录/App名称.app
```

`成功输出`: build/App目录/App名称.app: accepted   source=Developer ID

`失败输出`: build/App目录/App名称.app: a sealed resource is missing or invalid

#### Windows​ 制作安装包

`说明`: Windows 使用 inno setup 制作安装包

1、安装 inno setup

`下载地址`: 

[inno setup](http://www.jrsoftware.org/isinfo.php)

2、下载 [ChineseSimplified.isl](https://raw.github.com/jrsoftware/issrc/master/Files/Languages/Unofficial/ChineseSimplified.isl) 到 innosetup 安装目录 `/Languages/Unofficial` (若 Unofficial 目录不存在需手工创建)

3、使用 inno setup 修改目录下的 LICENSE 文件, 该文件为安装时的许可协议

4、`制作`: 使用 inno setup 打开项目文件 `desktop_setup.iss`, 修改顶部配置项, 选择菜单 Build —> Complie

`配置项说明`:

`MyAppName`: 应用程序名

`MyCompanyName`: 公司名称

`MyAppVersion`: App 版本号

`MyAppPublisher`: 控制面板选中 App 时显示的发布者

`MyAppURL`: 控制面板选中 App 时显示的链接

`MyAppExeName`: App 运行文件名

`UninstallName`: App 卸载文件名

`BaseDir`: 桌面版根目录

`Protocal`: 注册表名称

`注意`:

制作前, 必须更新 desktop_setup.iss 中的 AppId. AppId 生成方式: Tool -> Generate GUID

inno setup 文档: [http://www.jrsoftware.org/ishelp/](http://www.jrsoftware.org/ishelp/)

#### Mac 制作安装包

执行命令:

```
npm run installer:mac
```

#### 辅助文档

>打包程序依赖工具

[electron-builder](https://github.com/electron-userland/electron-builder/tree/v2.9.3)

[electron-packager](https://github.com/electron-userland/electron-packager)

[electron-winstaller](https://www.npmjs.com/package/electron-winstaller)

[gulp](https://www.npmjs.com/package/gulp)
