import os
import platform
import subprocess
import sys
import re
from datetime import datetime
import ConfigParser

YELLOW = '\033[33m'
GREEN = '\033[32m'
RED = '\033[31;1m'
MAGENTA = '\033[35;1m'
ENDC = '\033[0m'

def tran_value(org, des):
    if not org:
        org = des
    return org.replace('/', '\/')

def chdir(root, path=''):
    print('%scd %s%s' % (YELLOW, root, ENDC))
    os.chdir(root)


def run_cmd(cmd, stop=True):
    if cmd.startswith('sed ') and 'Linux' in platform.system():
        cmd = cmd.replace('"" ', '', 1)
    print('%s%s%s' % (GREEN, cmd, ENDC))
    ps = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
    ps.communicate()
    if ps.returncode != 0:
        if stop:
            print('%sError: Build failed. Return code = %d%s' % (RED, ps.returncode, ENDC))
            sys.exit(ps.returncode)
        else:
            print('%sWarning: Command run failed. Return code = %d%s' % (MAGENTA, ps.returncode, ENDC))
    return ps.returncode

def strip_str(str):
    if not str:
        return str
    return str.strip()


def trans_null(value):
    if value == None:
        value = ''
    return value

def sed_command(olcStr, newStr,file):
    print('%s%s%s' % (olcStr,"  ", newStr))
    tmp_file ="tmpfile"
    f = open(file,"r")
    f2 = open(tmp_file,"w")
    for line in f:
        if olcStr in line:
            line= str.replace(line,olcStr,newStr)
            print('%s' % (line))
            f2.write(line)
            continue
        f2.write(line)
        f2.flush()
    f.close()
    f2.close()
    os.remove(file)
    os.rename(tmp_file,file)

def trans2utf8(str, encoding):
    return str.decode(encoding).decoding('utf-8')