const builder = require('electron-builder');
const path = require('path');
const rimraf = require('rimraf');
const Config = require('../../src/config.js');

const buildJson = {
    osx: {
        title: Config.PACKAGE.APPNAME,
        background: path.join(__dirname, '../..', 'res', Config.PACKAGE.MAC.BACKGROUND),
        icon: path.join(__dirname, '../..', 'res', Config.PACKAGE.MAC.APPICON),
        'icon-size': 80,
        contents: [
            {
                x: 438, y: 160, type: 'link', path: '/Applications',
            },
            { x: 192, y: 160, type: 'file' },
        ],
    },
};
const options = {
    platform: 'osx',
    out: 'dist/osx',
    config: buildJson,
    appPath: `build/${Config.PACKAGE.APPNAME}-darwin-x64/${Config.PACKAGE.APPNAME}.app`,
    basePath: '..',
    overwrite: true,
};

const electronBuilder = builder.init();

function deleteOutputFolder() {
    return new Promise((resolve, reject) => {
        rimraf(path.join(__dirname, '..', 'dist', 'osx'), error => (error ? reject(error) : resolve()));
    });
}

function createMacInstaller() {
    return new Promise((resolve, reject) => {
        electronBuilder.build(options, error => (error ? reject(error) : resolve()));
    });
}


deleteOutputFolder()
    .then(createMacInstaller)
    .catch((error) => {
        // eslint-disable-next-line no-console
        console.error(error.message || error);
        process.exit(1);
    });
