#!/usr/bin/env python
# coding=utf-8

import os
import re
import sys
from datetime import datetime
import ConfigParser

from common import strip_str, trans_null
from common import RED

class Config:
    def __init__(self, commitId):
        self.root_path = sys.path[0][:-len('/build-tool')]
        print('%s%s%s' % (RED, '\nroot_path => ', self.root_path))
        self.encoding = strip_str(os.environ.get('Jenkins_Encoding', 'utf-8'))
        print('%s%s%s%s' % (RED, 'encoding => ', self.encoding, '\n'))
        self.now_time = datetime.now().strftime("%Y%m%d%H")
        self.version = self.trans2utf8(os.environ.get('RCE_Version'))
        self.build = self.trans2utf8(os.environ.get('RCE_Build'))
        self.reportUrl = self.trans2utf8(os.environ.get('RCE_ReportUrl'))
        self.appId = self.trans2utf8(os.environ.get('RCE_AppId'))
        self.protocal = self.trans2utf8(os.environ.get('RCE_Protocal')) 
        self.productName = self.trans2utf8(os.environ.get('RCE_ProductName'))
        self.description = self.trans2utf8(os.environ.get('RCE_Description'))
        self.appName = self.trans2utf8(os.environ.get('RCE_AppName'))
        self.author = self.trans2utf8(os.environ.get('RCE_Author'))
        self.gitCommitId = self.trans2utf8(commitId)
        self.home = self.trans2utf8(os.environ.get('RCE_Home'))
        self.companyName = self.trans2utf8(os.environ.get('RCE_CompanyName'))
        self.appUrl = self.trans2utf8(os.environ.get('RCE_AppUrl'))
        self.myAppPublisher = self.trans2utf8(os.environ.get('RCE_MyAppPublisher'))
        self.uninstallName = self.trans2utf8(os.environ.get('RCE_UninstallName'))
        self.appIssId = self.trans2utf8(os.environ.get('RCE_AppIssId'))
        self.ignoreCertificateErrors = self.trans2utf8(os.environ.get('RCE_IgnoreCertificateErrors'))
        self.appServer = self.trans2utf8(os.environ.get('RCE_AppServer'))
        self.productNameEn = self.trans2utf8(os.environ.get('RCE_ProductNameEn'))
        self.productNameZh = self.trans2utf8(os.environ.get('RCE_ProductNameZh'))
        self.noProxy = self.trans2utf8(os.environ.get('RCE_NoProxy'))
        self.versionCode = self.trans2utf8(os.environ.get('RCE_VersionCode', os.environ.get('BUILD_ID')))
        self.copyright = self.trans2utf8(os.environ.get('RCE_Copyright'))
        self.baseDir = self.trans2utf8(os.environ.get('RCE_BaseDir', self.root_path))
    
    def trans2utf8(self, content):
        return strip_str(trans_null(content)).decode(self.encoding).encode('utf-8')

    def export_file(self):
        cp = ConfigParser.SafeConfigParser()
        cp.read('src/local_config.conf')
        cp.set('base', 'Version', trans_null(self.version))
        cp.set('base', 'Build', trans_null(self.build))
        cp.set('base', 'ReportUrl', trans_null(self.reportUrl))
        cp.set('base', 'AppId', trans_null(self.appId))
        cp.set('base', 'Protocal', trans_null(self.protocal))
        cp.set('base', 'ProductName', trans_null(self.productName))
        cp.set('base', 'Description', trans_null(self.description))
        cp.set('base', 'AppName', trans_null(self.appName))
        cp.set('base', 'Author', trans_null(self.author))
        cp.set('base', 'GitCommitId', trans_null(self.gitCommitId))
        cp.set('base', 'Home', trans_null(self.home))
        cp.set('base', 'CompanyName', trans_null(self.companyName))
        cp.set('base', 'AppUrl', trans_null(self.appUrl))
        cp.set('base', 'MyAppPublisher', trans_null(self.myAppPublisher))
        cp.set('base', 'UninstallName', trans_null(self.uninstallName))
        cp.set('base', 'BaseDir', trans_null(self.baseDir))
        cp.set('base', 'AppIssId', trans_null(self.appIssId))
        cp.set('base', 'ignorecertificateerrors', trans_null(self.ignoreCertificateErrors))
        cp.set('base', 'appserver', trans_null(self.appServer))
        cp.set('base', 'productnameen', trans_null(self.productNameEn))
        cp.set('base', 'productnamezh', trans_null(self.productNameZh))
        cp.set('base', 'noproxy', trans_null(self.noProxy))
        cp.set('base', 'versioncode', trans_null(self.versionCode))
        cp.set('base', 'copyright', trans_null(self.copyright))
        
        cp.write(open('src/local_config.conf', 'w'))
