#!/usr/bin/env python
# coding=utf-8

import os
import sys
from pc_rce_config import Config
from common import chdir, run_cmd, tran_value

def trans(content):
    return content.decode('utf-8').encode('gb18030')

def modifyIssFile(conf):
    chdir(conf.root_path)
    run_cmd('sed -i "s/A2CCF795-7A51-404B-AFAB-87AA245733D1/%s/g" ./desktop_setup.iss' % conf.appIssId)
    f = open('desktop_setup.iss','r')
    w = open('temp.iss','w')

    for line in f.readlines():  
        if '#define MyAppName' in line:
            temp = '#define MyAppName ' + '"' + trans(conf.appName) + '"\r\n'
            w.write(temp)
            continue
        if '#define MyCompanyName' in line:
            temp = '#define MyCompanyName ' + '"' + trans(conf.companyName) + '"\r\n'
            w.write(temp)
            continue
        if '#define MyAppVersionCode' in line:
            temp = '#define MyAppVersionCode ' + '"' + trans(conf.versionCode) + '"\r\n'
            w.write(temp)
            continue
        if '#define MyAppVersion' in line:
            temp = '#define MyAppVersion ' + '"' + trans(conf.version) + '"\r\n'
            w.write(temp)
            continue
        if '#define MyAppCopyright' in line:
            temp = '#define MyAppCopyright ' + '"' + trans(conf.copyright) + '"\r\n'
            w.write(temp)
            continue
        if '#define Protocal' in line:
            temp = '#define Protocal ' + '"' + trans(conf.protocal) + '"\r\n'
            w.write(temp)
            continue
        if '#define MyAppPublisher' in line:
            temp = '#define MyAppPublisher ' + '"' + trans(conf.myAppPublisher) + '"\r\n'
            w.write(temp)
            continue
        if '#define MyAppExeName' in line:
            temp = '#define MyAppExeName ' + '"' + trans(conf.appName) + '.exe"\r\n'
            w.write(temp)
            continue
        if '#define MyAppURL' in line:
            temp = '#define MyAppURL ' + '"' + trans(conf.appUrl) + '"\r\n'
            w.write(temp)
            continue
        if '#define BaseDir' in line:
            temp = '#define BaseDir ' + '"' + trans(conf.baseDir) + '"\r\n'
            w.write(temp)
            continue
        if '#define UninstallName' in line:
            temp = '#define UninstallName ' + '"' + trans(conf.uninstallName) + '"\r\n'
            w.write(temp)
            continue
        w.write(line)
    f.close()
    w.close()
    run_cmd('rm -rf ./desktop_setup.iss')
    run_cmd('mv ./temp.iss ./desktop_setup.iss')

if __name__ == '__main__':
    if len(sys.argv) == 1:
        print("### Usage: python ./win_pc_rce_build <GitCommitId> ###")
        sys.exit(0)
    conf = Config(sys.argv[1])
    conf.export_file()
    modifyIssFile(conf)