
const fs = require('fs');
const path = require('path');
const { ConfigIniParser } = require('config-ini-parser');

const delimiter = '\n'; // or "\n" for *nux
// If don't assign the parameter delimiter then the default value \n will be used
const parser = new ConfigIniParser(delimiter);
const localConfig = path.join(__dirname, 'local_config.conf');
const iniContent = fs.readFileSync(localConfig, 'utf-8');
parser.parse(iniContent);
const reportUrl = parser.get('base', 'reporturl');
const home = parser.get('base', 'home');
const appId = parser.get('base', 'appid');
const protocal = parser.get('base', 'protocal');
const productName = parser.get('base', 'productname');
const appName = parser.get('base', 'appname');
const description = parser.get('base', 'description');
const author = parser.get('base', 'author');
const runTimeVersion = parser.get('base', 'runtimeversion');
const version = parser.get('base', 'version');
const versionCode = parser.get('base', 'versioncode');
const ignoreCertificateErrors = parser.get('base', 'ignorecertificateerrors');
const appServer = parser.get('base', 'appserver');
const productNameEn = parser.get('base', 'productnameen');
const productNameZh = parser.get('base', 'productnamezh');
const noProxy = parser.get('base', 'noproxy');
const copyright = parser.get('base', 'copyright');
const build = parser.get('base', 'build');

const imConfig = {
    modules: {
        screencapture: {
            url: './modules/screenshot/{platform}',
            oriname: 'screencapture.node',
            newname: 'screencapture_process.node',
        },
        rongimlib: {
            url: './modules/ronglib/{platform}',
            oriname: 'RongIMLib.node',
            newname: 'RongIMLib_process.node',
        },
        // win32 only
        remotecontrol_public: {
            url: './modules/remote_control/{platform}',
            oriname: 'remotecontrol_public.node',
            newname: 'remotecontrol_process-public.node',
        },
        remotecontrol_private: {
            url: './modules/remote_control/{platform}',
            oriname: 'remotecontrol_private.node',
            newname: 'remotecontrol_process-private.node',
        },
    },
    REPORT_URL: reportUrl,
    DEFAULT_PORT: 33003,
    APP_ID: appId,
    HOME: home,
    PROTOCAL: protocal,
    WINICON: 'app.ico',
    ALWAYS_SHOW_IN_PRIMARY: false,
    // 忽略CA证书验证错误
    IGNORE_CERTIFICATE_ERRORS: ignoreCertificateErrors === 'true',
    APP_SERVER: appServer,
    APP_VERSION: version,
    APP_VERSION_CODE: versionCode,
    PRODUCT_NAME_EN: productNameEn,
    PRODUCT_NAME_ZH: productNameZh,
    // 忽略代理
    NO_PROXY: noProxy,
    SUPPORT: { // new add
        CSDK: true,
        SCREENSHOT: true,
        RemoteControl: false,
    },
    WIN: {
        //  WINDOWS ONLY,TRAY BLINK ON
        //  new Tray,tray.setImage
        TRAY: 'Windows_icon.png',
        //  WINDOWS ONLY,TRAY BLINK OFF
        //  tray.setImage
        TRAY_OFF: 'Windows_Remind_icon.png',
        TRAY_DROP: 'Windows_offline_icon.png',
        //  tray.displayBalloon
        BALLOON_ICON: 'app.png',
        INIT_WIDTH: 1000, // new add
        INIT_HEIGHT: 640, // new add
    },
    MAC: {
        // HELPER_BUNDLE_ID: 'SealTalk_Ent_Test',
        //  new Tray
        TRAY: 'Mac_Template.png',
        //  tray.setPressedImage
        PRESSEDIMAGE: 'Mac_TemplateWhite.png',
    },
    PACKAGE: {
        // 以下参数设置需对照 配置说明 中 4 项列出的工具参数理解
        PRODUCTNAME: productName,
        APPNAME: appName,
        VERSION: version,
        VERSION_CODE: versionCode,
        DESCRIPTION: description,
        AUTHOR: author,
        RUNTIMEVERSION: runTimeVersion,
        COPYRIGHT: copyright,
        WIN: {
            APPICON: 'app.ico',
            ICON_URL: '',
            LOADING_GIF: '../res/loading.gif',
        },
        MAC: {
            APPICON: 'app.icns',
            BACKGROUND: 'bg.png',
            // CF_BUNDLE_VERSION: '1.0.3'
        },
        LINUX: {
            APPICON: 'app.png',
        },
    },
    VOIP: {
        INDEX: '/modules/voip/voip.html', // 暂时未用
        MINWIDTH: 100,
        MINHEIGHT: 100,
        BOUNDS: {
            X: 0,
            Y: 0,
            WIDTH: 338,
            HEIGHT: 260,
        },
    },
    IMAGE_VIEWER: {
        TITLE: '图片查看',
        INDEX: '/modules/image-viewer/desktop.html',
        MINWIDTH: 400,
        MINHEIGHT: 400,
        BOUNDS: {
            X: 0,
            Y: 0,
            WIDTH: 350,
            HEIGHT: 300,
        },
    },
    ABOUT: {
        INDEX: '/views/about.html',
        SIZE: {
            WIDTH: 440,
            HEIGHT: 290,
        },
        TITLE: `${appName} for Mac`,
        VERSION: `v${version} (Build:${versionCode})`,
        URL_HOMEPAGE: 'http://www.rongcloud.cn/product/rce?browser=1',
        URL_INTRODUCTION: '/modules/appversion/desktop.html?browser=0',
    },
    DEBUG: build.toLowerCase() !== 'release',
};

imConfig.getAppHost = () => `http://127.0.0.1:${imConfig.DEFAULT_PORT}`;

module.exports = imConfig;