(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var $ = dependencies.jQuery;

function getGroup(resolve, reject) {
    var im = RongIM.instance;
    var options = {
        name: 'contact-group',
        template: 'templates/contact/group.html',
        data: function () {
            return {
                isLoadDone: false,
                groups: []
            };
        },
        computed: {
            showEmptyGroup: function () {
                return this.groups.length === 0;
            }
        },
        mounted: function () {
            initGroup(this, im.dataModel.Group);
        },
        methods: {
            getGroupType: common.getGroupType,
            getGroupName: common.getGroupName,
            startConversation: function (id) {
                startConversation(this, id, im.dataModel.Conversation);
            },
            createGroup: function () {
                var userId = im.auth.id;
                im.dataModel.User.getBatch([userId], function (errorCode, list) {
                    // RongIM.dialog.createGroup(null, list);
                    // RongIM.dialog.blishGroup(null, list,true);
                    dialog.newDialogBox(null, list,"created");
                });
            },
            memberCount: function (group) {
                var format = this.locale.contact.person;
                if (group.member_count === 1) {
                    format = this.locale.contact.personSingle;
                }
                return this.localeFormat(format, group.member_count);
            }
        },
        components: {
            avatar: components.getAvatar
        }
    };
    utils.asyncComponent(options, resolve, reject);
}

function initGroup(context, groupApi) {
    groupApi.getList(function (errorCode, groups) {
        if (errorCode) {
            context.groups = [];
            context.isLoadDone = true;
            common.toastError(errorCode);
            return;
        }
        groups.forEach(function (item, index) {
            item.wType = groups.length - index + item.type * groups.length;
        });

        groups.sort(function (a, b) {
            return b.wType - a.wType;
        });

        context.groups = groups;
        context.isLoadDone = true;

    });
}

function startConversation(context, id, conversationApi) {
    var params = {
        targetId: id,
        conversationType: utils.conversationType.GROUP
    };
    var path = {
        name: 'conversation',
        params: params
    };
    context.$router.push(path);
    conversationApi.add(params);
    // 页面跳转完成后获取页面节点滚动会话列表
    setTimeout(function () {
        var itemId = ['conversation', params.conversationType, params.targetId].join('-');
        var item = document.getElementById(itemId);
        if (item) {
            var parentHeight = item.parentNode.offsetHeight;
            var offsetTop = item.offsetTop;
            var alginWithTop = offsetTop > parentHeight;
            item.scrollIntoView(alginWithTop);
        }
    }, 50);
}

$.extend(true, components, {
    contact: {
        getGroup: getGroup
    }
});
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
