/*
说明：'@' 时成员列表显示
功能：
    1. render 根据传入参数在页面渲染 '@' 列表
    2. prev 选择前一个（键盘方向键上下选择）
    3. next 选择后一个
    4. getValue 获取当前选中的
备注：
    @所有人 id 为 0
*/
(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;

components.getAtPanel = function (resolve, reject) {
    var options = {
        name: 'at-panel',
        template: '#rong-template-at-panel',
        components: {
            avatar: components.getAvatar
        },
        data: function () {
            return {
                positionStyle: {},
                list: [],
                isShow: false,
                value: null
            };
        },
        mounted: function () {
            var context = this;
            var im = RongIM.instance;
            im.$on('imclick', function () {
                context.isShow = false;
            });
        },
        methods: getMethods()
    };
    utils.asyncComponent(options, resolve, reject);
};

function getMethods() {
    return {
        getValue: function () {
            return this.value;
        },
        render: render,
        prev: function () {
            var result = getNextOrPrev(this.list, this.value, -1);
            this.value = result.item;
            this._scroll(result.index);
        },
        next: function () {
            var result = getNextOrPrev(this.list, this.value, +1);
            this.value = result.item;
            this._scroll(result.index);
        },
        clickSelect: function (member) {
            this.$emit('atPanelClickSelect', member);
            this.isShow = false;
            this.value = null;
        },
        _scroll: function (index) {
            scroll(this.$el, index);
        },
        isAtAll: function (user) {
            return user.id === 0;
        }
    };
}

/*
说明：根据传入参数在指定位置渲染生成 '@' 列表
参数：
    @param {array<object>}  memberList    '@' 需要展示的成员
    @param {object}         position      css 样式 {left:'',bottom:''}
    @param {boolean}        showAtall     是否显示 @所有人
*/
function render(memberList, position, showAtall) {
    var context = this;
    if (memberList.length === 0) {
        context.isShow = false;
        return;
    }
    var list = memberList.map(function (item) {
        item.selected = false;
        return item;
    });
    if (showAtall) {
        list.unshift({
            id: 0,
            name: context.locale.everyone,
            avatar: ''
        });
    }

    var selectedMember = list[0];
    selectedMember.selected = true;

    context.value = selectedMember;
    context.positionStyle = position;
    context.list = list;
    context.isShow = true;
}

/*
说明： '@' 列表移动选择 "光标" ("-" 向前移动 "+" 向后移动)
参数：
    @param {Array}      list   页面绑定展示的列表
    @param {objece}     item   "光标" 当前选中 list 中的对象
    @param {number}     opt    "-" 向前(上)移动 "+" 向后(下)移动
*/
function getNextOrPrev(list, item, opt) {
    if (isNaN(opt)) {
        return undefined;
    }
    item.selected = false;
    var index = list.indexOf(item);
    var length = list.length;
    index += opt;
    if (index < 0) {
        index = length - 1;
    }
    if (index > length - 1) {
        index = 0;
    }
    var resultItem = list[index];
    resultItem.selected = true;
    Vue.set(list, index, resultItem);
    return {
        item: resultItem,
        index: index
    };
}

/*
说明： 滚动到当前选中的对象，使在可见区域
参数：
    @param {HTMLElement} container  "@" 列表 html 对象
    @param {number}      index      当前选中的下标
*/
function scroll(container, index) {
    var curEle = container.children[index];
    var top = curEle.offsetTop;
    var containerHeight = container.offsetHeight + container.scrollTop;
    if (top + curEle.offsetHeight > containerHeight) {
        var scrollTop = top - container.offsetHeight + curEle.offsetHeight;
        container.scrollTop = scrollTop;
    } else if (top < container.scrollTop) {
        container.scrollTop = top;
    }
}
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
