(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var dialog = RongIM.dialog;

/*
说明： 会话设置
*/
components.getConversationSetting = function (resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var conversationApi = dataModel.Conversation;
    var options = {
        name: 'conversation-setting',
        template: '#rong-template-conversation-setting',
        props: ['user'],
        data: function () {
            var params = im.$route.params;
            return {
                conversation: {
                    conversationType: params.conversationType,
                    targetId: params.targetId
                }
            };
        },
        components: {
            avatar: components.getAvatar
        },
        mounted: function () {
            var context = this;
            var conversation = context.conversation;
            im.$on('imclick', context.close);
            conversationApi.getOne(conversation.conversationType, conversation.targetId, function (errorCode, newConversation) {
                context.conversation = newConversation;
            });
        },
        computed: {
            // 置顶按钮值绑定
            isTop: {
                get: function () {
                    return this.conversation.isTop;
                },
                set: function (checked) {
                    this.conversation.isTop = checked;

                    var action = checked ? 'top' : 'untop';
                    var conversation = this.conversation;
                    conversationApi[action](conversation.conversationType, conversation.targetId);
                }
            },
            // 禁言按钮值绑定
            isMute: {
                get: function () {
                    return this.conversation.notificationStatus;
                },
                set: function (checked) {
                    this.conversation.notificationStatus = checked;

                    var action = checked ? 'mute' : 'unmute';
                    var conversation = this.conversation;
                    conversationApi[action](conversation.conversationType, conversation.targetId);
                }
            },
            // 是否文件助手
            isFileHelper: function () {
                var user = this.user;
                return user.type === 3 || user.isRobot;
            },
            fileHelperLocale: function () {
                var locale = this.locale;
                var getFileHelper = (locale.components || {}).getFileHelper;
                return getFileHelper;
            }
        },
        filters: {
            slice: function (name) {
            // 如果没有头像，中文下显示最后一个汉字，英文下显示第一个英文字母
                if (!name) {
                    return name;
                }
                var isChinese = /^[^\x20-\xff]+$/.test(name);
                return isChinese ? name.slice(-1) : name[0].toUpperCase();
            }
        },
        methods: {
            getUsername: common.getUsername,
            // 对方高管则不可邀请加入群组
            executiveLimit: function (item) {
                if (item.isFriend || im.auth.isExecutive) {
                    return false;
                }
                var isExecutive = !!item.isExecutive;
                return isExecutive;
            },
            addMembers: function () {
                var members = [im.loginUser, this.user];
                // dialog.createGroup(null, members);
                // dialog.blishGroup(null, members,true,'personnelAdd');
                //个人右上角小人，聊天设置
                dialog.newDialogBox(null, members,"created");
            },
            close: function () {
                this.$emit('hidepanel');
                im.$off('imclick', this.close);
            },
            getThemeIndex: function (id) {
            // 根据id返回固定数字，用于显示头像背景色，共6种颜色
                var LENGTH = 6;
                return id ? (id.slice(-1).charCodeAt(0) % LENGTH) : 0;
            },
            userProfile: dialog.user
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
