(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

/*
说明： 获取公众号信息组件
*/
components.getPublicInfo = function (resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var conversationApi = dataModel.Conversation;
    var publicApi = dataModel.Public;
    var pcWin = RongIM.browserWindow;
    var options = {
        name: 'public-detail',
        template: '#rong-template-public-detail',
        props: ['user'],
        data: function () {
            var params = im.$route.params;
            return {
                conversation: {
                    conversationType: params.conversationType,
                    targetId: params.targetId
                },
                publicName: '',
                publicDescription: '',
                hasHomePage: false,
                isShow: false
            };
        },
        components: {
            avatar: components.getAvatar
        },
        mounted: function () {
            var context = this;
            var conversation = context.conversation;
            im.$on('imclick', context.close);
            conversationApi.getOne(conversation.conversationType, conversation.targetId, function (errorCode, newConversation) {
                context.conversation = newConversation;

                // 获取公众号相关信息（名称、描述）
                publicApi.getPublicInfo(conversation.targetId, function (result) {
                    context.publicName = result.name;
                    context.publicDescription = result.description;
                    context.hasHomePage = !!(result.pc_home_page_url || result.home_page_url);
                    context.isShow = true;
                });
            });
        },
        computed: {
            // 置顶按钮值绑定
            isTop: {
                get: function () {
                    return this.conversation.isTop;
                },
                set: function (checked) {
                    this.conversation.isTop = checked;

                    var action = checked ? 'top' : 'untop';
                    var conversation = this.conversation;
                    conversationApi[action](conversation.conversationType, conversation.targetId);
                }
            },
            // // 禁言按钮值绑定
            isMute: {
                get: function () {
                    return this.conversation.notificationStatus;
                },
                set: function (checked) {
                    this.conversation.notificationStatus = checked;

                    var action = checked ? 'mute' : 'unmute';
                    var conversation = this.conversation;
                    conversationApi[action](conversation.conversationType, conversation.targetId);
                }
            }
        },
        methods: {
            getUsername: common.getUsername,
            close: function () {
                this.$emit('hidepanel');
                im.$off('imclick', this.close);
            },
            enterPublic: function () {
                this.$emit('hidepanel');
                im.$off('imclick', this.close);
                im.$router.push({
                    path: '/workApps/' + this.conversation.targetId
                });
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
