(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var dialog = RongIM.dialog;
var $ = dependencies.jQuery;
var im;
var pageNum = RongIM.config.profile.pageNum;

/*
说明：  keywordChanged 搜索框值改变时执行搜索命令并将搜索结果赋值 context
步骤：  keyword 值为空重置为初始状态
        keyword 不为空正则匹配判断
            keyword 为手机号按手机搜索成员
            keyword 为邮箱按预想搜索成员
            否则按成员名称搜索
            只要 keyword 有值则搜索 职位（getDutyList）部门（getDeptList）
*/
var keywordChanged = utils.debounce(function (context, keyword, api) {
    if (utils.isEmpty(keyword)) {
        getRoot(context, api.org);
        context.dutyList = [];
        context.searchOrg = {
            list: [],
            lastIndex: 0
        };
        return;
    }
    var numReg = new RegExp(/^[0-9]*$/);
    var emailReg = new RegExp(/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/);
    var promiseList = [];
    var _members = [];
    var _errorCallbak = function (errorCode) {
        context.searchResult = {
            members: [],
            depts: [],
            companies: []
        };
        context.toastError(errorCode);
    };
    promiseList.push(api.org.search(keyword, function (errorCode, members) {
        if (errorCode) {
            _errorCallbak(errorCode);
            return;
        }
        [].unshift.apply(_members, members);
        _members = _members.concat(members);
    }));
    if (keyword.length > 3 && numReg.test(keyword)) {
        promiseList.push(api.user.searchByMobile(keyword, function (errorCode, members) {
            if (errorCode) {
                _errorCallbak(errorCode);
                return;
            }
            _members = _members.concat(members);
        }));
    }
    if (emailReg.test(keyword)) {
        promiseList.push(api.user.searchByEmail(keyword, function (errorCode, members) {
            if (errorCode) {
                _errorCallbak(errorCode);
                return;
            }
            _members = _members.concat(members);
        }));
    }
    $.when.apply(null, promiseList).then(function () {
        _members = uniq(_members);
        common.searchAlias(_members, keyword, api.user);
        // common.sortUsers(_members);
        _members.forEach(function (item) {
            item.pathName = common.getPathName(item, api.org);
            item.pathNameEllipsis = common.getPathNameEllipsis(item, api.org);
            item.pathNameSuffix = common.getPathNameSuffix(item, api.org);
            delete item.orgs_info;
            delete item.name_keyword_initial;
            delete item.state;
            delete item.user_type;
            delete item.is_executive;
        });
        if (keyword === context.keyword) {
            context.searchResult = {
                members: _members,
                depts: [],
                companies: []
            };
            context.allList = _members;
            context.lastIndex = _members.length > pageNum ? pageNum : _members.length;
        }
        context.busy.contacts = false;
    });
    getDutyList(context);
    getDeptList(context);
}, 800);

function getOrg(resolve, reject) {
    im = RongIM.instance;
    var orgApi = im.dataModel.Organization;
    var userApi = im.dataModel.User;
    var options = {
        name: 'org',
        template: 'templates/group/org.html',
        data: function () {
            return {
                busy: {
                    contacts: false,
                    duty: false,
                    dept: false
                },
                currentView: 'contacts',
                showDutyDetail: false,
                showDeptDetail: false,
                keyword: '',
                breadcrumb: {},
                searchResult: {
                    id: '',
                    deptName: '',
                    members: [],
                    depts: [],
                    companies: []
                },
                dutyList: [],
                searchOrg: {
                    list: [],
                    lastIndex: 0
                },
                searchDutyDetail: {
                    duty: {},
                    list: [],
                    lastIndex: 0
                },
                loadingNextPage: false,
                lastIndex: 0,
                allList: [],
                crumbCacheList: {},
                executiveAndNotfriend: {
                    list: [],
                    deptCount: {},
                    dutyCount: {}
                }
            };
        },
        /* selected 已选择的成员， defaultSelected 默认选中的成员， canNotSelected 不可选不可见的成员（暂时 pin 屏蔽自己用到）， disableExecutive 禁用高管 */
        props: ['selected', 'defaultSelected', 'canNotSelected', 'disableExecutive', 'fixHeight', 'onlyStaff', 'maxCount', 'isPin'],
        directives: {
            autoUserlistHeight: function (el) {
                Vue.nextTick(function () {
                    var allHeight = el.dataset.height;
                    var onlyStaff = el.dataset.staff;
                    if (onlyStaff) {
                        allHeight = +allHeight + 36;
                    }
                    var curmbHeight = 0;
                    var crumbEl = $(el.dataset.crumbSelector)[0];
                    if (crumbEl) {
                        curmbHeight = crumbEl.clientHeight;
                    }
                    $(el).css({ height: allHeight - curmbHeight });
                });
            },
            autoScrollright: function (el) {
                Vue.nextTick(function () {
                    el.scrollLeft = el.scrollWidth;
                });
            }
        },
        computed: {
            searchHeight: function () {
                if (this.isPin) {
                    return 229;
                }
                if (this.onlyStaff) {
                    return 316;
                }
                return 280;
            },
            searching: function () {
                // 当数据列表为空且仍有至少一个接口在等待返回时，值为 true
                return this.allList.length === 0 && (this.busy.contacts || this.busy.duty || this.busy.dept);
            },
            // 根据职位名称判断是否选中
            checkedDuty: {
                set: function (newVal) {
                    var context = this;
                    var oldVal = this.checkedDuty;
                    var addedNameList = newVal.filter(function (item) {
                        return oldVal.indexOf(item) === -1;
                    });
                    var removedNameList = oldVal.filter(function (item) {
                        return newVal.indexOf(item) === -1;
                    });
                    var deferList = [];
                    addedNameList.forEach(function (item) {
                        deferList.push(userApi.searchByDuty(item));
                    });
                    if (deferList.length !== 0) {
                        $.when.apply(null, deferList).done(function () {
                            var addedUserList = [];
                            $.each(arguments, function (key, result) {
                                addedUserList = addedUserList.concat(result.data || []);
                            });
                            recordExecutiveAndNotfriend(addedUserList, context);
                            addOrRemoveMember('added', addedUserList, context);
                        });
                    }
                    var removedUserList = context.selected.filter(function (item) {
                        var dutyName = item.dutyName || item.duty_name;
                        return removedNameList.indexOf(dutyName) !== -1;
                    });
                    addOrRemoveMember('removed', removedUserList, context);
                },
                get: function () {
                    var context = this;
                    var count = {};
                    context.selected.forEach(function (user) {
                        var dutyName = user.duty_name || user.dutyName;
                        count[dutyName] = count[dutyName] || 0;
                        count[dutyName] += 1;
                    });
                    var dutyCount = context.executiveAndNotfriend.dutyCount;
                    var selectedDuty = context.dutyList.filter(function (duty) {
                        return count[duty.name] >= duty.count - (dutyCount[duty.name] || 0);
                    });
                    return selectedDuty.map(function (item) {
                        return item.name;
                    });
                }
            },
            /* 无效的部门成员数（需要排除 canNotSelected ），多公司。改为多公司后一个成员可在多个部门。要计算成员所在所有部门 */
            invalidDeptMemberCount: function () {
                var count = {};
                (this.canNotSelected || []).forEach(function (item) {
                    var idList = item._pathIdList;
                    if (!idList) {
                        idList = getPathList(item.orgsInfo);
                        item._pathIdList = idList;
                    }
                    idList.forEach(function (deptId) {
                        count[deptId] = count[deptId] || 0;
                        count[deptId] += 1;
                    });
                });
                return count;
            },
            selectedIdList: function () {
                return this.selected.map(function (item) {
                    return item.id;
                });
            },
            defaultIdList: function () {
                return (this.defaultSelected || []).map(function (item) {
                    return item.id;
                });
            },
            // TODO: 未使用到暂注释
            // defaultDeptIdList: function () {
            //     var deptIdList = [];
            //     (this.defaultSelected || []).forEach(function (dept) {
            //         if(!utils.isEmpty(dept.path)) {
            //             deptIdList = dept.path.split(',').concat(deptIdList);
            //         }
            //     });
            //     return deptIdList;
            // },
            canNotSelectedIdList: function () {
                return (this.canNotSelected || []).map(function (item) {
                    return item.id;
                });
            },
            hasKeyword: function () {
                return this.keyword.length > 0;
            },
            /* 搜索结果是否有内容，依次判断 searchResult 的属性 members depts companies 的数组长度 */
            hasResult: function () {
                var searchResult = this.searchResult;
                var memberLen = searchResult.members.length;
                var deptLen = searchResult.depts.length;
                var companyLen = searchResult.companies.length;
                return memberLen > 0 || deptLen > 0 || companyLen > 0;
            },
            /* "全选" 按钮 绑定计算属性 */
            checkedAll: {
                get: function () {
                    return getCheckedAll(this);
                },
                set: function (checked) {
                    setCheckedAll(this, orgApi, checked);
                }
            },
            /* "职位全选" 按钮 绑定计算属性 */
            checkedAllDuty: {
                get: function () {
                    var context = this;
                    var selectedIdList = this.selected.map(function (item) {
                        return item.id;
                    });
                    var selectedAll = true;
                    this.searchDutyDetail.list.filter(function (item) {
                        return !context.limitCondition(item);
                    }).forEach(function (item) {
                        if (selectedIdList.indexOf(item.id) === -1) {
                            selectedAll = false;
                        }
                    });
                    return selectedAll;
                },
                set: function (checked) {
                    var context = this;
                    var todoMembers = this.searchDutyDetail.list;
                    var eventType = checked ? 'added' : 'removed';
                    addOrRemoveMember(eventType, todoMembers, context);
                }
            },
            /* "全选" 按钮 半选状态绑定计算属性 */
            indeterminate: function () {
                if (this.isCardSelect) {
                    return false;
                }
                return getIndeterminate(this);
            },
            indeterminateDuty: function () {
                var selectedIdList = this.selected.map(function (item) {
                    return item.id;
                });
                var indeterminate = false;
                var selectAll = true;
                var context = this;
                this.searchDutyDetail.list.filter(function (item) {
                    return !context.limitCondition(item);
                }).forEach(function (item) {
                    if (selectedIdList.indexOf(item.id) > -1) {
                        indeterminate = true;
                    } else {
                        selectAll = false;
                    }
                });
                if (selectAll) {
                    indeterminate = false;
                }
                return indeterminate;
            },
            /* 成员选中状态计算属性绑定 */
            checkedMembers: {
                get: function () {
                    return this.selected.map(function (item) {
                        return item.id;
                    });
                },
                set: function (newMemberIds) {
                    // 只有企业通讯录的选择器变化会触发
                    var context = this;
                    var oldMembers = context.checkedMembers.slice();
                    var addedList = [];
                    newMemberIds.forEach(function (id) {
                        var index = oldMembers.indexOf(id);
                        if (index === -1) {
                            // 标记新加入的 id
                            addedList.push(id);
                        } else {
                            // 移除还存在的 id，剩余的即是被删除的 id
                            oldMembers.splice(index, 1);
                        }
                    });
                    if (oldMembers.length) {
                        this.onMemberChange('removed', oldMembers);
                    }
                    if (addedList.length) {
                        this.onMemberChange('added', addedList);
                    }
                }
            },
            isCardSelect: function () {
                return this.$parent.$options.name === 'card';
            },
            pageList: function () {
                return this.allList.slice(0, this.lastIndex);
            },
            dutyDetailList: function () {
                return this.searchDutyDetail.list.slice(0, this.searchDutyDetail.lastIndex);
            },
            orgList: function () {
                return this.searchOrg.list.slice(0, this.searchOrg.lastIndex);
            }
        },
        components: {
            imageLoader: components.getImageLoader,
            avatar: components.getAvatar,
            customSelect: components.customSelect
        },
        watch: {
            keyword: function (keyword) {
                this.showDutyDetail = false;
                this.showDeptDetail = false;
                if (keyword === '') {
                    this.searchResult = {
                        id: '',
                        deptName: '',
                        members: [],
                        depts: [],
                        companies: []
                    };
                }
                this.resetSearch();
                var api = {
                    org: orgApi,
                    user: userApi
                };
                this.busy = {
                    contacts: true,
                    duty: true,
                    dept: true
                };
                keywordChanged(this, keyword, api);
            },
            currentView: function () {
                this.showDutyDetail = false;
                this.showDeptDetail = false;
            },
            selected: function () {
                calcDeptCheckState(this, this.searchResult.depts);
                calcDeptCheckState(this, this.searchResult.companies);
                calcDeptCheckState(this, this.searchOrg.list);
            },
            'searchResult.companies': function () {
                calcDeptCheckState(this, this.searchResult.companies);
            },
            'searchResult.depts': function () {
                calcDeptCheckState(this, this.searchResult.depts);
            },
            'searchOrg.list': function () {
                calcDeptCheckState(this, this.searchOrg.list);
            }
        },
        created: function () {
            created(this, orgApi);
        },
        methods: {
            departIconClass: function(item) {
                return (item.vchar_p3 == 1) ? 'rong-dept-blue-icon' : 'rong-dept-icon';
            },
            resetSearch: function () {
                this.allList = [];
                this.searchOrg = {
                    list: [],
                    lastIndex: 0
                };
                this.searchDutyDetail = {
                    duty: {},
                    list: [],
                    lastIndex: 0
                };
                this.dutyList = [];
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$parent) {
                    el = this.$parent.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            toast: function (params) {
                params.el = this.$parent.$el.firstChild;
                common.messageToast(params);
            },
            computeHeight: function (height) {
                var fixHeight = Number(this.fixHeight) || 0;
                return height + fixHeight;
            },
            userProfile: function (userId) {
                dialog.user(userId, null, true);
            },
            clear: function () {
                this.keyword = '';
            },
            /* 页面绑定使用排除 searchResult.members 中 canNotSelected 用户不做显示 */
            unifyMembers: function (_members) {
                var context = this;
                var members = _members.filter(function (item) {
                    return context.canNotSelectedIdList.indexOf(item.id) === -1;
                });
                // common.sortUsers(members);
                return members;
            },
            getUsername: function (item) {
                var name = common.getUsernameHighlight(item);
                return common.filterMark(name);
            },
            highlight: function (item) {
                if (!item) {
                    return '';
                }
                return common.highlight(item.name, item.range);
            },
            highlightDeptName: function (dept) {
                if (!dept) {
                    return '';
                }
                return common.highlight(dept.name, dept.range);
            },
            isShowWhenHasAlias: function (item) {
                return item.alias;
            },
            /* 成员的禁用状态，是否可选择、取消。 1.默认选中成员 2.高管成员3.不可选中成员 */
            isDisabled: function (item) {
                var canNotSelected = this.canNotSelectedIdList.indexOf(item.id) > -1;
                return this.isDefault(item) || this.executiveLimit(item) || canNotSelected;
            },
            /* 判断是否有高管限制，如果对方是好友，或自己是高管，或高管已禁用（disableExecutive） 则返回 false 否则 返回对方 isExecutive 属性 */
            executiveLimit: function (item) {
                if (item.isFriend || im.auth.isExecutive || this.disableExecutive) {
                    return false;
                }
                var isExecutive = !!item.isExecutive;
                return isExecutive;
            },
            limitCondition: function (item) {
                var canNotSelected = this.canNotSelectedIdList.indexOf(item.id) > -1;
                if (canNotSelected) {
                    return true;
                }
                return this.executiveLimit(item);
            },
            isDefault: function (item) {
                return this.defaultIdList.indexOf(item.id) >= 0;
            },
            hasMembers: function (dept) {
                var count = dept.member_count;
                return count > 0;
            },
            changeDept: function (org) {
                if (org) changeDept(this, orgApi, org);
            },
            scrollTop: function () {
                var $list = $(this.$refs.list);
                $list.scrollTop(0);
            },
            memberCount: function (dept) {
                var count = dept.member_count || dept.count || 0;
                return count;
            },
            getDutyDetail: function (duty) {
                var context = this;
                context.searchDutyDetail = {
                    duty: duty,
                    list: [],
                    lastIndex: pageNum
                };
                userApi.searchByDuty(duty.name, function (errorCode, result) {
                    if (errorCode) {
                        context.toastError(errorCode);
                        return;
                    }
                    context.showDutyDetail = true;
                    context.searchDutyDetail = {
                        duty: duty,
                        list: result.data,
                        lastIndex: result.data.length > pageNum ? pageNum : result.data.length
                    };
                    recordExecutiveAndNotfriend(result.data, context);
                });
            },
            getDeptDetail: function (dept) {
                if (!dept) {
                    return;
                }
                this.showDeptDetail = true;
                changeDept(this, orgApi, { id: dept.id, type: common.OrgType.DEPT });
            },
            getCoDetail: function (co) {
                if (!co) {
                    return;
                }
                this.showDeptDetail = true;
                changeDept(this, orgApi, { id: co.id, type: common.OrgType.COMPANY });
            },
            getPathName: function (item) {
                return common.getPathName(item, orgApi);
            },
            getPathNameEllipsis: function (item) {
                return common.getPathNameEllipsis(item, orgApi);
            },
            getPathNameSuffix: function (item) {
                return common.getPathNameSuffix(item, orgApi);
            },
            checkChange: function (event, item) {
                var checked = event.target.checked;
                Vue.set(item, 'checked', checked);
                if (checked) {
                    Vue.set(item, 'indeterminate', false);
                }
                setCheckedDepts(this, orgApi, item, checked);
            },
            loadMore: function () {
                loadMore(this);
            },
            loadMoreDutyDetail: function () {
                loadMore(this, 'dutyDetail');
            },
            loadMoreOrg: function () {
                loadMore(this, 'org');
            },
            loadMoreDept: function () {
                loadMore(this, 'dept');
            },
            onMemberChange: function (type, members) {
                var context = this;
                userApi.get(members, function (err, list) {
                    if (err) {
                        context.toastError(err);
                        return;
                    }
                    context.$emit(type, list);
                });
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
}

/**
 * 筛选记录高管非好友，用于计算全选状态
 * @param {Array<staff>} members 员工
 * @param {Object} context
 */
function recordExecutiveAndNotfriend(members, context) {
    var self = RongIM.instance.auth || {};
    if (self.isExecutive) {
        return;
    }
    var addList = members.filter(function (item) {
        return item.isExecutive && !item.isFriend;
    });
    var list = context.executiveAndNotfriend.list;
    addList = common.without(addList, list);
    [].push.apply(list, addList);
    var deptCount = context.executiveAndNotfriend.deptCount;
    var dutyCount = context.executiveAndNotfriend.dutyCount;
    addList.forEach(function (item) {
        var dutyName = item.duty_name || item.dutyName;
        if (dutyName) {
            dutyCount[dutyName] = dutyCount[dutyName] || 0;
            dutyCount[dutyName] += 1;
        }
        var orgsInfo = item.orgsInfo || item.orgs_info;
        var idList = getPathList(orgsInfo);
        idList.forEach(function (deptId) {
            deptCount[deptId] = deptCount[deptId] || 0;
            deptCount[deptId] += 1;
        });
    });
}

/**
 * 添加或删除人员
 * 排除已选中 和 高管非好友
 * @param {Array<staff>} members
 * @param {Object} context
 */
function addOrRemoveMember(type, members, context) {
    var list = members.filter(function (item) {
        return !context.limitCondition(item);
    });
    common.without(list, context.selected);
    if (list.length > 0) {
        context.$emit(type, list);
    }
}

/*
说明：获取全选状态
步骤：1.获取当前成员如果 checkedMembers 选中的列表中没有返回 false
      2.获取当前部门和公司如果 checkedDepts 选中的列表中没有返回 false
      3.否则返回 true
*/
function getCheckedAll(context) {
    var searchResult = context.searchResult;
    var memberList = searchResult.members;
    memberList = memberList.filter(function (item) {
        var canselected = context.canNotSelectedIdList.indexOf(item.id) === -1;
        return canselected && !context.executiveLimit(item);
    });
    for (var i = 0, memberLen = memberList.length; i < memberLen; i += 1) {
        var member = memberList[i];
        if (context.checkedMembers.indexOf(member.id) === -1) {
            return false;
        }
    }
    var deptList = searchResult.depts.concat(searchResult.companies);
    deptList = deptList.filter(function (item) {
        return item.member_count > 0;
    });
    for (var j = 0, deptLen = deptList.length; j < deptLen; j += 1) {
        var dept = deptList[j];
        if (!dept.checked) {
            return false;
        }
    }
    return true;
}

function getCurrentSelectedCount(context) {
    var searchResult = context.searchResult;
    var currentDeptId = searchResult.id;
    var memberCount = 0;
    var isCompany = searchResult.id === '';
    var keyword = context.keyword;
    if (!utils.isEmpty(keyword)) {
        // 场景：搜索关键词
        var selectedIdList = context.selected.map(function (item) {
            return item.id;
        });
        var currentIdList = searchResult.members.map(function (item) {
            return item.id;
        });
        return utils.intersection(selectedIdList, currentIdList).length;
    }
    if (isCompany) {
        memberCount = context.selected.length;
    } else {
        // 场景：浏览某个部门
        memberCount = context.selected.filter(function (item) {
            var idList = item._pathIdList;
            if (!idList) {
                var orgsInfo = item.orgsInfo || item.orgs_info;
                idList = getPathList(orgsInfo);
                item._pathIdList = idList;
            }
            return idList.indexOf(currentDeptId) >= 0;
            // return (item.path || '').indexOf(currentDeptId) >= 0;
        }).length;
    }
    return memberCount;
}

/*
说明：获取当前所有成员数 部门，公司使用累加属性 memberCount
*/
function getMemberCount(context) {
    var memberCount = 0;
    var executiveDeptCount = context.executiveAndNotfriend.deptCount;
    var searchResult = context.searchResult;
    memberCount += searchResult.members.length;
    memberCount += searchResult.depts.concat(searchResult.companies).map(function (dept) {
        return dept.member_count - (executiveDeptCount[dept.id] || 0);
    }).reduce(function (one, two) {
        return one + two;
    }, 0);
    var canNotSelCount = context.canNotSelected ? context.canNotSelected.length : 0;
    return memberCount - canNotSelCount;
}

/*
说明：获取 "全选" 按钮的半选状态
*/
function getIndeterminate(context) {
    var selectedLength = getCurrentSelectedCount(context);
    var memberCount = getMemberCount(context);
    var result;
    if (selectedLength > 0 && !context.checkedAll) {
        result = selectedLength < memberCount;
    } else {
        result = false;
    }
    return result;
}

/*
说明：设置全选获取
步骤：1.获取所有部门 id
      2.获取部门下所有成员
      3.拼接 unifyMembers 当前可选成员
      4.多部门需要排除重复人员
*/
function setCheckedAll(context, orgApi, checked) {
    var searchResult = context.searchResult;
    var validList = searchResult.depts.concat(searchResult.companies).filter(function (item) {
        return item.member_count > 0;
    });
    var deptIdList = validList.map(function (dept) {
        return dept.id;
    });
    var _members = context.unifyMembers(searchResult.members);
    var totalCount = context.unifyMembers(_members).length;
    searchResult.depts.forEach(function (dept) {
        totalCount += context.memberCount(dept);
    });
    searchResult.companies.forEach(function (company) {
        totalCount += context.memberCount(company);
    });
    if (context.maxCount && totalCount > context.maxCount) {
        context.$emit('maxCountLimit');
        return;
    }
    if (!context.hasKeyword && searchResult.id) {
        getMembers(orgApi, [searchResult.id], function (errorCode, members) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            var todoMembers = [].concat(members);
            todoMembers = common.removeDuplicatesById(todoMembers);
            recordExecutiveAndNotfriend(todoMembers, context);
            var eventType = checked ? 'added' : 'removed';
            addOrRemoveMember(eventType, todoMembers, context);
        });
    } else {
        getMembers(orgApi, deptIdList, function (errorCode, members) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            var todoMembers = members.concat(_members);
            todoMembers = common.removeDuplicatesById(todoMembers);
            recordExecutiveAndNotfriend(todoMembers, context);
            var eventType = checked ? 'added' : 'removed';
            addOrRemoveMember(eventType, todoMembers, context);
        });
    }
}

function getPathList(orgInfoList) {
    var orgApi = RongIM.dataModel.Organization;

    orgInfoList = orgInfoList || [];
    var pathList = [];
    orgInfoList.forEach(function (orgInfo) {
        // 判断如果是独立子公司则从独立子公司开始计算 path
        var path = [].concat(orgInfo.path || []);
        var org = path[1];
        var isAutocephaly = org && org.type === 2 && orgApi.isAutonomyCompany(org.id);
        if (isAutocephaly) {
            path.shift();
        }
        pathList = pathList.concat(path);
    });

    // 排除重复一个人不能在同一部门计算多次
    var pathIdList = [];
    pathList.forEach(function (item) {
        var unexist = pathIdList.indexOf(item.id) === -1;
        if (unexist && item.id !== '') {
            pathIdList.push(item.id);
        }
    });
    return pathIdList;
}

var checkdeptDeferemit = {};
var uid = 0;
var getDeferemitUid = function () {
    var temp = uid;
    uid += 1;
    return temp;
};
function mapToArr(map) {
    var arr = [];
    Object.keys(map).forEach(function (key) {
        arr.push(map[key]);
    });
    return arr;
}
// 延时通知修改等待所有请求结果返回一次性通知
function deferEmit(context) {
    var notLoading = Object.keys(checkdeptDeferemit).every(function (key) {
        return checkdeptDeferemit[key].result !== null;
    });
    if (notLoading) {
        var addedMap = {};
        var removedMap = {};
        Object.keys(checkdeptDeferemit).forEach(function (key) {
            var item = checkdeptDeferemit[key];
            var mergeMap = addedMap;
            var pushMap = removedMap;
            if (item.type === 'added') {
                mergeMap = removedMap;
                pushMap = addedMap;
            }
            var result = item.result;
            result.forEach(function (member) {
                var memberId = member.id;
                if (mergeMap[memberId]) {
                    delete mergeMap[memberId];
                } else {
                    pushMap[memberId] = member;
                }
            });
        });
        var addedArr = mapToArr(addedMap);
        var removedArr = mapToArr(removedMap);
        addOrRemoveMember('added', addedArr, context);
        addOrRemoveMember('removed', removedArr, context);
        checkdeptDeferemit = {};
    }
}
function setCheckedDepts(context, orgApi, dept, checked) {
    var deferUid = getDeferemitUid();
    if (checked) {
        var _func = function () {
            checkdeptDeferemit[deferUid] = {
                type: 'added',
                result: null
            };
            getMembers(orgApi, [dept.id], function (errorCode, members) {
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                members = common.removeDuplicatesById(members);
                recordExecutiveAndNotfriend(members, context);
                checkdeptDeferemit[deferUid].result = members;
                deferEmit(context);
            });
        };
        if (context.maxCount) {
            var count = dept.member_count || dept.count;
            count += context.selected.length;
            if (count > context.maxCount) {
                context.$emit('maxCountLimit');
                return;
            }
            _func();
        } else {
            _func();
        }
        return;
    }
    checkdeptDeferemit[deferUid] = {
        type: 'removed',
        result: null
    };
    getMembers(orgApi, [dept.id], function (errorCode, members) {
        if (errorCode) {
            context.toastError(errorCode);
            return;
        }
        recordExecutiveAndNotfriend(members, context);
        checkdeptDeferemit[deferUid].result = members;
        deferEmit(context);
    });
}

function getMembers(orgApi, deptIdList, callback) {
    if (deptIdList.length < 1) {
        callback(null, []);
        return;
    }

    var promiseList = [];
    if (deptIdList.length > 0) {
        deptIdList.forEach(function (deptId) {
            var defer = $.Deferred();
            promiseList.push(defer.promise());
            orgApi.getMembers(deptId, function (errorCode, members) {
                if (errorCode) {
                    defer.reject(errorCode);
                    return;
                }
                /*
                选择总公司时排除下面独立子公司
                涉及多部门有一个不在独立子公司下则返回
                */
                if (members.length === 0) {
                    defer.resolve(members);
                    return;
                }

                var list = [];
                var isSelectMainCompany = deptId === members[0].orgsInfo[0].path[0].id;
                if (isSelectMainCompany) {
                    members.forEach(function (member) {
                        var directly = false;
                        var orgsInfo = member.orgsInfo || member.orgs_info || [];
                        for (var i = 0; i < orgsInfo.length; i += 1) {
                            var orgInfo = orgsInfo[i];
                            var subcompany = orgInfo.path[1];
                            if (!subcompany || (subcompany && !orgApi.isAutonomyCompany(subcompany.id))) {
                                directly = true;
                            }
                        }
                        if (directly) {
                            list.push(member);
                        }
                    });
                } else {
                    list = members;
                }
                defer.resolve(list);
            });
        });
        $.when.apply(null, promiseList).then(function () {
            var args = [].slice.call(arguments);
            var members = args.reduce(function (one, two) {
                return one.concat(two);
            });
            callback(null, members);
        }).fail(callback);
    }
}

function created(context, orgApi) {
    getRoot(context, orgApi);
}

function getRoot(context, orgApi) {
    /*
    多公司数据结构改变：需要取总公司下独立子公司
    独立子公司只存在第二级
    */
    if (context.crumbCacheList.root) {
        context.searchResult = {
            id: '',
            members: [],
            depts: [],
            companies: [].concat(context.crumbCacheList.root.companies)
        };
        context.allList = context.searchResult.companies;
        context.lastIndex = context.allList.length > pageNum ? pageNum : context.allList.length;
        return;
    }
    orgApi.getAutocephalyCompanyWithMydept(function (error, companyList) {
        var allCompany = JSON.parse(JSON.stringify(companyList));
        allCompany.forEach(function (item) {
            item.type = common.OrgType.COMPANY;
        });
        common.sortByMydeptAndMajorCompany(allCompany, RongIM.instance.auth.companyId);
        context.crumbCacheList.root = {
            id: '',
            members: [],
            depts: [],
            companies: [].concat(allCompany)
        };
        context.searchResult = {
            id: '',
            members: [],
            depts: [],
            companies: allCompany
        };
        context.allList = allCompany;
        context.lastIndex = context.allList.length > pageNum ? pageNum : context.allList.length;
    });
}

/*
说明：根据 org 获取直属部门下成员，部门，公司 org => {id: '组织机构 id', type: '组织结构 type'}
    设置 searchResult 属性  {
            id: '',
            deptName: '',
            members: [],
            depts: [],
            companies: []
        }
    org 的 id 为空字符时返回跟节点
*/
function changeDept(context, orgApi, org) {
    if (org.id === '') {
        getRoot(context, orgApi);
        return;
    }
    var _callback = function () {
        var obj = context.crumbCacheList[org.id];
        recordExecutiveAndNotfriend(obj.members, context);
        context.searchResult = {
            id: org.id,
            deptName: obj.deptName,
            members: [].concat(obj.members),
            depts: [].concat(obj.depts),
            companies: [].concat(obj.companies)
        };
        // 获取所有list的总和
        var members = context.unifyMembers(context.searchResult.members);
        /*
        获取部门 path 和公司信息 如果有 独立子部门直接显示独立子部门
        */
        context.allList = members.concat(context.searchResult.depts).concat(context.searchResult.companies);
        context.lastIndex = context.allList.length > pageNum ? pageNum : context.allList.length;
        var orgTree = orgApi.getLocalDept(org.id);
        var pathList = orgTree.pathList || [];
        var autonomy = pathList[1];
        var selfIsAutonomyCompany = orgApi.isAutonomyCompany(org.id);
        var isAutonomyBranch = autonomy && orgApi.isAutonomyCompany(autonomy.id);
        if (isAutonomyBranch || selfIsAutonomyCompany) {
            pathList.shift();
        }
        context.breadcrumb = pathList;
        context.scrollTop();
    };
    if (context.crumbCacheList[org.id]) {
        _callback();
        return;
    }
    orgApi.getBranch(org.id, function (errorCode, result) {
        if (errorCode) {
            context.toastError(errorCode);
            return;
        }
        // 排除独立子公司
        var companies = result.companies.filter(function (co) {
            return !orgApi.isAutonomyCompany(co.id);
        });
        context.crumbCacheList[org.id] = {
            id: org.id,
            deptName: '',
            members: result.staffs,
            depts: result.depts,
            companies: companies
        };
        if (org.type === common.OrgType.COMPANY) {
            orgApi.getCompanyById(org.id, function (error, company) {
                context.crumbCacheList[org.id].deptName = company.name;
                _callback();
            });
        } else if (org.type === common.OrgType.DEPT) {
            orgApi.getDept(org.id, function (error, data) {
                context.crumbCacheList[org.id].deptName = data.deptName;
                _callback();
            }, true);
        }
    });
}

function getDutyList(context) {
    var orgApi = RongIM.dataModel.Organization;
    var keyword = context.keyword;
    context.busy.duty = true;
    context.dutyList = [];
    orgApi.searchDuty(keyword, function (errorCode, result) {
        if (errorCode) {
            context.toastError(errorCode);
            return;
        }
        context.dutyList = result;
        context.busy.duty = false;
    });
}

function getDeptList(context) {
    var orgApi = RongIM.dataModel.Organization;
    var keyword = context.keyword;
    context.busy.dept = true;
    orgApi.searchCompanies(keyword, function (errorCode, companies) {
        if (errorCode) {
            context.toastError(errorCode);
            return;
        }
        var coList = companies.map(function (co) {
            if (co.level === 1) {
                co.count = RongIM.dataModel._Cache.rootCompanyMemberCount;
            }
            return co;
        }).filter(function (co) {
            return co.count > 0;
        });
        orgApi.searchOrgs(keyword, function (error, result) {
            if (error) {
                context.toastError(error);
                return;
            }
            var deptList = result.filter(function (dept) {
                dept.type = 1;
                return dept.count > 0;
            });
            var _list = deptList.concat(coList);
            context.searchOrg = {
                list: _list,
                lastIndex: _list.length > pageNum ? pageNum : _list.length
            };
            context.busy.dept = false;
        });
    });
}
// 计算部门选中状态：全选，半选
function calcDeptCheckState(context, depts) {
    var count = {};
    context.selected.forEach(function (item) {
        var idList = item._pathIdList;
        if (!idList) {
            var orgsInfo = item.orgsInfo || item.orgs_info;
            idList = getPathList(orgsInfo);
            item._pathIdList = idList;
        }
        idList.forEach(function (deptId) {
            count[deptId] = count[deptId] || 0;
            count[deptId] += 1;
        });
    });
    depts.forEach(function (dept) {
        var invalidDeptMemberCount = (context.invalidDeptMemberCount[dept.id] || 0);
        var executiveCount = context.executiveAndNotfriend.deptCount[dept.id] || 0;
        dept.member_count = dept.member_count || dept.count;
        var memberCount = dept.member_count - invalidDeptMemberCount - executiveCount;
        var selectedCount = count[dept.id];
        var checked;
        var indeterminate;
        if (selectedCount >= memberCount) {
            checked = true;
            indeterminate = false;
        } else if (selectedCount > 0) {
            checked = false;
            indeterminate = true;
        } else {
            checked = false;
            indeterminate = false;
        }
        Vue.set(dept, 'checked', checked);
        Vue.set(dept, 'indeterminate', indeterminate);
    });
}

function loadMore(context, type) {
    if (context.loadingNextPage === true) {
        return;
    }
    context.loadingNextPage = true;
    var totalNum = context.allList.length;
    var end = context.lastIndex + pageNum;
    var lastIndex = context.lastIndex;
    if (type === 'dutyDetail') {
        totalNum = context.searchDutyDetail.list.length;
        end = (context.searchDutyDetail.lastIndex || 0) + pageNum;
        lastIndex = context.searchDutyDetail.lastIndex;
    } else if (type === 'org') {
        totalNum = context.searchOrg.list.length;
        end = (context.searchOrg.lastIndex || 0) + pageNum;
        lastIndex = context.searchOrg.lastIndex;
    }
    var adjust = function (index) {
        return index > totalNum ? totalNum : index;
    };
    end = adjust(end);
    if (end === lastIndex) {
        context.loadingNextPage = false;
        return;
    }
    setTimeout(function () {
        if (type === 'dutyDetail') {
            context.searchDutyDetail.lastIndex = end;
        } else if (type === 'org') {
            context.searchOrg.lastIndex = end;
        } else {
            context.lastIndex = end;
        }
        context.loadingNextPage = false;
    }, 500);
}

function uniq(array) {
    var map = {};
    return array.filter(function (item) {
        var id = item.id;
        if (map[id]) {
            return false;
        }
        map[id] = id;
        return true;
    });
}

$.extend(true, components, {
    group: {
        getOrg: getOrg
    }
});
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
