(function (RongIM, dependencies, components) {
    'use strict';

    var Vue = dependencies.Vue;
    var VueRouter = dependencies.VueRouter;
    var $ = dependencies.jQuery;
    var routes = RongIM.routes;
    var common = RongIM.common;
    var utils = RongIM.utils;
    var cache = utils.cache;
    var dialog = RongIM.dialog;
    var win = dependencies.win;
    var updateFav = RongIM.updateFav;
    var layout = RongIM.config.layout;
    var rongMain = layout.main.margin;
    window.eventBus = new Vue(); //注册全局事件对象
    function init(config) {
        if (!config.appkey || !config.dataModel.server) {
            common.handleError('invalid-config');
            return;
        }

        var pcVersion = RongIM.system.version;
        pcVersion = pcVersion ? '(' + pcVersion + ')' : '';

        config.product.pcVersion = pcVersion;
        // 设置缓存模块
        UploadClient.setCache(RongIM.upload);

        var dataModel = RongIM.dataModel;
        var pcWin = RongIM.browserWindow;
        var client = RongIM.client;
        var system = RongIM.system;

        // 模块化屏蔽入口
        var serverConfig = RongIM.serverConfig;
        var im = new Vue({
            el: config.el,
            router: getRouter(dataModel),
            data: {
                isMaxWindow: false,
                config: config,
                serverConfig: serverConfig,
                auth: null,
                cacheAuth: null,
                status: utils.status.CONNECTING,
                unReadCount: 0,
                hidden: false,
                isLock: false,
                loginUser: null,
                requestUnReadCount: 0,
                approveUnReadCount: 0,
                isShowCollect: RongIM.config.modules.collect,
                pinUnReadCount: {
                    unComment: 0,
                    unConfirm: 0
                },
                workUnReadCount: 0,
                homeUnReadCount: 0,
                resizeNode: {
                    rongList: {
                        width: 0
                    },
                    main: {
                        marginLeft: rongMain.left
                    },
                    messageInput: {
                        height: 0
                    }
                },
                resizeDirection: {
                    temp: '',
                    use: ''
                },
                connectedTime: 0,
                isFirstSyncdata: true,
                syncdataLoad: {
                    show: false,
                    progress: 0,
                    state: 'none'
                },
                paramsData: {},
                followParams: {},
                showType: '',
                showFollow: '',
                addFollowItem: null,
                cancelFollowItemData: null,
                eventTarget: null,
                refsCount: null,
                myMailListNoneParams: false,
                deletePinGroupItem: null
            },
            computed: {
                enabledWork: function () {
                    return serverConfig.work.enable;
                },
                enabledPIN: function () {
                    return serverConfig.pin.enable;
                },
                isSupportRemoteControl: function () {
                    var platform = RongIM.system.platform;
                    var isWeb = platform.indexOf('web') !== -1;
                    var isLinux = platform.indexOf('linux') !== -1;
                    var config = RongIM.serverConfig.remote_control || {};
                    var isEnabled = config.enable || config.enabled;
                    return !isLinux && !isWeb && isEnabled;
                },
                locale: function () {
                    RongIM.locale[this.config.locale].product = this.config.product;
                    return RongIM.locale[this.config.locale];
                },
                os: function () {
                    return system.platform;
                },
                isMac: function () {
                    return this.os !== 'win32' && this.os !== 'linux';
                },
                showWelcomePage: function () {
                    var list = ['/conversation', '/contact', '/pin', '/collect'];
                    return list.indexOf(this.$route.path) >= 0;
                },
                pinNavCount: function () {
                    var unConfirm = this.pinUnReadCount.unConfirm;
                    return unConfirm || '';
                },
                isStaff: function () {
                    return this.auth.isStaff;
                },
                mainViewStyle: function () {
                    return {
                        'margin-left': this.resizeNode.main.marginLeft + 'px'
                    };
                },
                workAppStyle: function () {
                    return {
                        'margin-left': 0
                    };
                },
                key() {
                    return this.$route.name !== undefined ? this.$route.name + +new Date() : this.$route + +new Date()
                },
                offsetX() {
                    return this.resizeNode.main.marginLeft
                }
            },
            watch: {
                auth: function (newValue, oldValue) {
                    var api = {
                        user: dataModel.User,
                        status: dataModel.Status
                    };
                    var same = $.isEmptyObject(newValue) && $.isEmptyObject(oldValue);

                    if (!same) authChanged(this, api, newValue);
                },
                unReadCount: function () {
                    updateFav();
                },
                pinUnReadCount: function () {
                    if (this.enabledPIN) updateFav();
                },
                $route: function () {
                    updatePassword(im.auth);
                    if (!this.$route.path.startsWith('/pin')) {
                        localStorage.removeItem("ifHigtSearch")
                    }
                    if (this.$route.name != 'organization') {
                        this.showType = ''
                    }

                    // if(config.support.screenshot) {
                    //     toggleScreenShortcut(route);
                    // }
                },
                isLock: function (newValue) {
                    var notSupport = !this.config.support.voip;
                    if (utils.isEmpty(newValue) || notSupport) {
                        return;
                    }
                    RCCall.disable(newValue);
                }
            },
            created: function () {
                var api = {
                    conversation: dataModel.Conversation,
                    message: RongIM.dataModel.Message,
                    user: RongIM.dataModel.User
                };
                created(this, client, api);
            },
            components: {
                'syncdata-loading': components.getSyncdataLoading,
                'online-status': components.getOnlineStatus,
                avatar: components.getAvatar,
                publicHome: components.publicHome,
                treeItem: components.item,
                leftList: components.leftList,
                kxyRight: components.kxyRight,
                friend: components.newGetFriends,
                'new-request-friend': components.newGetRequestFriend,
                'new-request-ally': components.newGetRequestAlly,
                'new-approve': components.getNewApprove
            },
            methods: {
                itemNodesActive(val, target) {
                    console.log(val)
                    let that = this;
                    that.myMailListNoneParams = false;
                    that.showType = '';
                    this.paramsData = val;
                    this.eventTarget = target;
                    this.showType = val.root && val.rootType != "KXY" ? '' : val.rootType;
                    console.log(this.showType)
                    switch (this.showType) {
                        case "myOrganization":
                            that.$refs.myorg.init(val, this.showType);
                            break;
                        case "KXY":
                            that.$refs.kxRight.init(val, this.showType);
                            break;
                        case "myFollow":
                            that.$refs.follow.init(val, this.showType);
                            break;
                        case "myMailList":
                            if (val.root) {
                                that.myMailListNoneParams = true;
                            } else {
                                that.myMailListNoneParams = false;
                                this.showType = val.nodeType;
                                that.rootMyMailListItem(val.nodeType, val)
                            }
                            break;
                        case "distributionGroup":
                            that.$refs.distributionGroup.init(val, that.showType);
                            break;
                        case "myAlly":
                            if (val.root) {
                              this.showType = '';
                            } else {
                              this.showType = val.nodeType;
                            }
                            break;
                        case "allyList":
                            if (val.id == 'allyList') {
                              this.showType = '';
                            } else {
                              that.$refs.allyList.init(val, this.showType);
                            }
                            break;
                        default:
                    }
                },
                rootMyMailListItem(nodeType, val) {
                    let that = this;
                    switch (nodeType) {
                        case "communicateGroup":
                            that.$refs.dayGroup.init(val, that.showType);
                            break;
                            // case "distributionGroup":
                            //     that.$refs.distributionGroup.init(val, that.showType);
                            //     break;
                        case "dailyContact":
                            that.$refs.dayContact.init(val, that.showType);
                            break;
                        case "KeyContacts":
                            that.$refs.importanContact.init(val, that.showType);
                            break;
                        case "fileAssistant":
                            that.$refs.fileAssistant.start();
                            break;
                        default:
                            that.$refs.dayGroup.init(val, that.showType);
                    }
                },
                addFollow(item) {
                    this.addFollowItem = item
                },
                refreshFollow(type) {
                    this.$refs.treeList.getMyFollow()
                    // if(type) 
                },
                cancelFollowItem(item) {
                    this.cancelFollowItemData = item
                },
                routePathStartWith: function (path) {
                    return this.$route.path.indexOf(path) === 0;
                },
                showSetting: dialog.setting,
                userProfile: function () {
                    dialog.user(im.auth.id);
                },
                updateTotalUnreadCount: function (list) {
                    updateTotalUnreadCount(dataModel.Conversation, im, list);
                },
                min: function () {
                    pcWin.min();
                },
                max: function () {
                    pcWin.max();
                    this.isMaxWindow = true;
                },
                restore: function () {
                    pcWin.restore();
                    this.isMaxWindow = false;
                },
                close: function () {
                    pcWin.close();
                },
                login: function (params) {
                    var api = {
                        user: dataModel.User,
                        status: dataModel.Status,
                        conversation: dataModel.Conversation
                    };
                    return login(this, api, params);
                },
                connect: function () {
                    // var im = this;
                    var naviConfig = naviRequestParams(im.config, im.auth);
                    connect({
                        user: dataModel.User,
                        status: dataModel.Status
                    }, naviConfig, function (errorCode, token) {
                        if (errorCode) {
                            return;
                        }
                        im.auth.token = token;
                        cache.set('auth', im.auth, true);
                        getNativeConversationList(im);
                    });
                },
                loginedGetBasedata: function () {
                    loginedGetBasedata(this);
                },
                checkLock: function () {
                    // var system = this;
                    dataModel.getUserSetting(function (result) {
                        if (result.value === 'true') {
                            dialog.deviceLocking();
                            im.isLock = true;
                        }
                    });
                },
                logout: function () {
                    im.$emit('imLogouted');
                    logout(this, dataModel.Status, dataModel.User);
                    pcWin.closeAll();
                    RongIM.imageViewer.logout();
                },
                mousedown: function (event) {
                    if (event.which === 3) {
                        event.preventDefault();
                        this.$emit('imRightClick', event);
                    }
                },
                formateUnreadCount: common.formateUnreadCount,
                syncdataLoadFinished: function () {
                    this.syncdataLoad.show = false;
                    this.syncdataLoad.state = 'none';
                    this.syncdataLoad.progress = 0;
                },
                onNetworkAvailable: function onNetworkAvailable() {
                    // 网络由不可用变可用时触发（已登录时才会触发）
                    var random = 30 + Math.round(Math.random() * 60);
                    clearTimeout(onNetworkAvailable.timeout);
                    onNetworkAvailable.timeout = setTimeout(function () {
                        var auth = im.auth || im.cacheAuth;
                        if (auth) {
                            RongIM.syncdata.all(auth.isStaff);
                        }
                    }, random * 1000);
                },
                // 刷新
                retrySyncdata: function () {
                    // var im = this;
                    im.syncdataLoad.state = 'loading';
                    im.syncdataLoad.progress = 0;
                    var auth = im.auth || im.cacheAuth;
                    RongIM.syncdata.all(auth.isStaff, im.syncdataCallback, function (p) {
                        im.syncdataLoad.progress = Number(p.toFixed(2));
                    });
                },
                //删除通讯组
                deletePinGroup(item,detail,flag) {
                    this.deletePinGroupItem = item
                    // if(flag != 'delUser'){
                    //     this.showType = ''
                    // }

                    this.$refs.treeList.getPinGroupChange(item)
                },
                addGroup(item){
                    this.$refs.treeList.addGroup(item)
                }
            },
            destroyed: function () {
                var models = [
                    dataModel.Status,
                    dataModel.Message,
                    dataModel.Friend,
                    dataModel.Account,
                    dataModel.Conversation,
                    dataModel.User,
                    dataModel.Group,
                    dataModel.Pin
                ];
                cleanup(models);
                unRegListeners(this, pcWin);
            }
        });
        dataModel.init(config);
        im.dataModel = dataModel;
        initWatch(im);
        turnOffCapsLockWarning();
        im.client = client;
        im.system = system;
        im.auth = cache.get('auth');
        RongIM.instance = im;
        if (im.auth) {
            // 已登录
            RongIM.Database.init(RongIM.serverConfig.im.app_key, im.auth.id, function () {
                loginedGetBasedata(im);
                var naviConfig = naviRequestParams(im.config, im.auth);
                connect({
                    user: dataModel.User,
                    status: dataModel.Status
                }, naviConfig, function (errorCode, token) {
                    if (errorCode) {
                        return;
                    }
                    im.auth.token = token;
                    cache.set('auth', im.auth, true);
                    getNativeConversationList(im);
                });
                im.checkLock();
                setStatus(getStatus());
            });
        }
        im.client = client;
        im.system = system;
        RongIM.instance = im;
        setStatus(getStatus());

        // 版本检查
        versionCheck();
    }

    function initWatch(im) {
        var dataModel = im.dataModel;
        var enabledFriend = im.serverConfig.friend.enable;
        var enabledPIN = im.serverConfig.pin.enable;
        watchConnectionStatus(dataModel.Status, im);
        watchMessage(dataModel.Message, dataModel.Conversation, dataModel.User, dataModel.Group, im);
        watchConversation(dataModel.Conversation, im);
        watchLoginUser(dataModel.User, im);
        watchFriendRequest(dataModel.Friend, im);
        watchAccount(dataModel.Account, im);
        if (enabledPIN) {
            watchPinUnreadCount(dataModel.Pin, im);
        }
        if (enabledFriend) {
            watchApproveRequest(dataModel.Group, im);
        }
    }

    function watchAccount(accountApi, im) {

        accountApi.watch(function (errorCode) {
            im.$router.push({
                name: 'login'
            });
            im.logout();
            common.messagebox({
                hashchangeClose: false,
                message: im.locale.errorCode[errorCode],
                callback: function () {
                    im.logout();
                },
                closeCallback: function () {
                    im.logout();
                }
            });
        });
    }

    function getRequestList(friendApi, im) {
        friendApi.getRequestList(function (errorCode, list) {
            if ($.isEmptyObject(list)) {
                return;
            }
            im.requestUnReadCount = getRequestUnreadCount(list);
        });
    }

    function getRouter(dataModel) {
        var loginRedirect = {
            path: '',
            clear: function () {
                this.path = '';
            }
        };

        var router = new VueRouter({
            linkActiveClass: routes.linkActiveClass,
            routes: routes.maps
        });

        router.beforeEach(function (to, from, next) {
            var im = router.app;
            var publicAccess = to.matched.some(function (record) {

                return record.meta.pulicAccess;
            });
            Vue.nextTick(function () {
                console.log('to ====', to)
                console.log('from ====', from)
                //判断是否为寻呼的路径，是清空localStorage里面的搜索调试
                if (to.path.substr(1, 3) != 'pin') {
                    localStorage.removeItem('searchText')
                    localStorage.removeItem('searchObj')
                    localStorage.removeItem('ifHight')

                }
                if (to.name !== 'login' && (publicAccess || im.auth)) {
                    if (document.body.style.backgroundColor !== 'rgb(255, 255, 255)') {
                        document.body.style.backgroundColor = '#FFF';
                    }
                    if (im.isFirst) {
                        im.isFirst = false;
                    }
                }
                if (publicAccess || im.auth) {
                    var path = loginRedirect.path;
                    if (to.name === 'conversation' && path) {
                        loginRedirect.clear();
                        next(path);
                    } else if (to.name === 'login') {
                        im.auth = null;
                        im.cacheAuth = null;
                        next();
                    } else {
                        //新增init参数 修复点击左侧工作台直接跳转sign-bridge
                        if (to.params.init && to.name == 'workApps') {
                            next()
                        } else {
                            // 添加source参数，修复搜索组织云后，通讯组搜索跳转失败问题
                            if(to.name == 'contact' && to.params.source == "search"){
                                next()
                            }else{
                                next(recordPrimarypath(to, from));
                            }
                          
                        }

                    }
                    return;
                }

                var params = cache.get('login-params');
                if (utils.isEmpty(params) || !params.password) {
                    next({
                        name: 'login'
                    });
                    return;
                }

                // 自动登录
                dataModel.User.autoLogin(params, function (errorCode, result) {
                    if (errorCode) {
                        loginRedirect.path = to.fullPath;
                        cache.remove('login-params');
                        next({
                            name: 'login'
                        });
                        return;
                    }
                    document.body.style.backgroundColor = '#FFF';
                    var user = result.staff;
                    var isModifyPwd = result.password_security === 0;
                    var auth = {
                        id: result.staff.id,
                        token: result.token,
                        code: user.code,
                        companyId: user.company_id,
                        deptId: user.dept_id,
                        isModifyPwd: isModifyPwd,
                        isStaff: user.user_type === common.UserType.STAFF,
                        orgsInfo: user.orgs_info,
                        display_mobile: user.display_mobile,
                        xhManager: result.xhManager
                    };
                    im.auth = auth;
                    im.isFirstSyncdata = RongIM.firstSyncdata.get(user.id);
                    if (im.isFirstSyncdata) {
                        im.syncdataLoad.show = true;
                    }
                    im.syncdataLoad.state = 'loading';
                    im.syncdataLoad.progress = 0;
                    var syncdataCallback = function (error) {
                        if (error) {
                            im.syncdataLoad.state = 'failed';
                            next({
                                name: 'login'
                            });
                            return;
                        }
                        RongIM.firstSyncdata.set(user.id);
                        im.syncdataLoad.state = 'success';
                        loginedGetBasedata(im);
                        var naviConfig = naviRequestParams(im.config, auth);
                        var connectSuccess = function (err, token) {
                            if (err) {
                                return;
                            }
                            im.auth.token = token;
                            cache.set('auth', im.auth, true);
                            getNativeConversationList(im);
                        };
                        connect({
                            user: dataModel.User,
                            status: dataModel.Status
                        }, naviConfig, connectSuccess);
                        if ($('.rong-dialog').length) return;
                        next();
                    };
                    RongIM.Database.init(RongIM.serverConfig.im.app_key, im.auth.id, function () {
                        RongIM.syncdata.all(auth.isStaff, syncdataCallback, function (p) {
                            im.syncdataLoad.progress = Number(p.toFixed(2));
                        });
                    });
                });
            });
        });

        return router;
    }

    // 进入一级路径跳转到对应记录路径
    var cachePrimarypath = {};

    function recordPrimarypath(to, from) {
        var toPath = to.path.split('/');
        var fromPath = from.path.split('/');
        if (fromPath.length > 2) {
            cachePrimarypath[fromPath[1]] = from.path;
        } else {
            cachePrimarypath[fromPath[1]] = undefined;
        }
        var query = to.query;
        var useCache = (!query.force && toPath.length === 2);
        if (useCache) {
            return cachePrimarypath[toPath[1]];
        }
        return undefined;
    }

    // 新版里只向sessionStorage里保存auth，
    // 旧版本里向localStorage里保存auth，会影响到新版本里的cache.get('auth')取值，
    // 需要清理下
    function fixCache(keyNS) {
        cache.remove(keyNS + 'auth');
        // localStorage.removeItem(keyNS + 'auth');
    }

    function created(context, client, api) {
        var conversationApi = api.conversation;

        client.regLogout(function () {
            context.logout();
        });

        client.regAccount(function () {
            context.showSetting();
        });

        if (context.config.support.balloonClick) {
            client.regBalloon(function (event, opt) {
                context.$router.push({
                    name: 'conversation',
                    params: {
                        targetId: opt.data.targetId,
                        conversationType: opt.data.targetType
                    }
                });
            });
        }

        $(win).on('focus', function () {
            context.hidden = false;
            var targetId = context.$route.params.targetId;
            var conversationType = context.$route.params.conversationType;
            if (!utils.isEmpty(conversationType) && !utils.isEmpty(targetId)) {
                conversationApi.clearUnReadCount(conversationType, targetId);
            }
        });
        $(win).on('blur', function () {
            context.hidden = true;
        });
        if (context.config.support.voip) {
            RCCall.init();
        }
    }

    function unRegListeners(context, client) {
        client.unregLogout();
        client.unregAccount();
        if (context.config.support.balloonClick) {
            client.unregBalloon();
        }
    }

    function authChanged(im, api, auth) {
        // auth changed 导致 connect 重复调用
        if (!auth) {
            var $fav = $('#rong-favicon');
            updateFav($fav.data('default-value'));

            if (im.status === utils.status.CONNECTED) {
                api.status.disconnect();
            }

            api.user.logout();
            clearCache();
            try {
                im.system.logout();
            } catch (e) {
                throw new Error('im.client.logout error!', e);
            }

            if (im.$route.name !== 'login') {
                im.$router.push({
                    name: 'login'
                });
            }
        }
    }

    var getPinUnConfirmCount = utils.throttle(function (pinApi, im) {
        pinApi.getUnConfirmCount(function (errorCode, unconfirm) {
            if (!errorCode) {
                im.pinUnReadCount.unConfirm = unconfirm.cnt;
                updateUnreadCount();
                updateFav();
            }
        });
    }, 2000);
    var getPinCommentUnreadCount = utils.throttle(function (pinApi, im) {
        pinApi.getUnReadCount(function (errorCode, unread) {
            if (!errorCode) {
                im.pinUnReadCount.unComment = unread.cnt;
            }
        });
    }, 2000);
    var getUndoCount = utils.throttle(function (pinApi, im) {
        pinApi.getUndoCount(function (errorCode, res) {
            if (!errorCode) {
                im.workUnReadCount = res.cnt;
            }
        });
    }, 2000);

    function loginedGetBasedata(im) {
        var userApi = im.dataModel.User;
        var auth = im.auth;
        if (auth.isStaff) {
            userApi.getDetail(auth.id, function (errorCode, user) {
                if (errorCode) {
                    common.toastError(errorCode);
                    return;
                }
                im.loginUser = user;
            });
        } else {
            userApi.getVisitors(auth.id, function (errorCode, user) {
                if (errorCode) {
                    common.toastError(errorCode);
                    return;
                }
                im.loginUser = user;
            });
        }
        // 重置 fav 未读数
        // updateFav();
        setApproveUnReadCount(im.dataModel.Group, im);
        getRequestList(im.dataModel.Friend, im);
        getPinUnConfirmCount(im.dataModel.Pin, im);
        getPinCommentUnreadCount(im.dataModel.Pin, im);
        getUndoCount(im.dataModel.Pin, im);

        // TODO: connected 执行
        // getNativeConversationList(im);
        // if(im.$route.name === 'login') {
        //     im.$router.push({name: 'conversation'});
        // }
        im.system.login();
    }

    /* function toggleScreenShortcut(route) {
        var params = route.params;
        var isConversaiton = route.name === 'conversation';
        var validConversation = !!(isConversaiton && params.conversationType && params.targetId);
        // addon.toggleScreenShortcut(validConversation);
        RongIM.screenshot.setEnabled(validConversation);
    } */

    function firstMultideviceLogin(conversationApi) {
        // 首次多端同时登陆显示文件助手
        var otherDeviceLogin = false;
        var loginStatus = cache.get('login_status');
        if (loginStatus && loginStatus.length > 0) {
            loginStatus.forEach(function (item) {
                if (item.title === 'Login_Status_Mobile') {
                    otherDeviceLogin = true;
                }
            });
        }
        if (otherDeviceLogin) {
            cache.set('login_status', '');
            conversationApi.addFileHelper();
        }
    }

    function login(context, api, params) {
        var im = context;
        var loginType = im.config.modules.zkxLoginType;
        var defer = $.Deferred();
        var loginParams = {
            isRememberMe: params.isRememberMe,
            phone: params.phone,
            zip: params.zip,
            zkxToken: params.zkxToken,
            agent: {
                platform: utils.getPlatform(),
                device_id: common.getDeviceId()
            },
            status: getStatus(),
            extra: {
                validataCode: params.captcha,
                loginType: loginType
            },
            verificationCode: params.verificationCode,
            verifyId: params.verifyId
        };

        var requriedPassword = utils.isEmpty(cache.get('login-params'));
        if (requriedPassword) {
            loginParams.password = params.password;
        }
        // 2019-06-12 密码加密传输 uapi.user.login 改为 api.user.securityLogin
        api.user.securityLogin(loginParams, function (errorCode, result) {
            if (errorCode) {
                im.auth = null;
                defer.reject(errorCode, result);
            } else {
                var user = result.staff;
                // password_security 密码安全状态，0表示初始密码需要修改，大于0表示密码正常(1为弱密码，2为强密码)
                var isModifyPwd = result.password_security === 0;
                var auth = {
                    isExecutive: result.staff.is_executive,
                    id: result.staff.id,
                    token: result.token,
                    code: user.code,
                    companyId: user.company_id,
                    deptId: user.depart_id,
                    isStaff: user.user_type === 0,
                    isModifyPwd: isModifyPwd,
                    // 多公司多部门 部门 path
                    orgsInfo: user.orgs_info,
                    display_mobile: user.display_mobile,
                    xhManager: result.xhManager,
                };
                im.cacheAuth = auth;
                // 首次多端同时登陆显示文件助手 其他端登录状态 login_status
                cache.set('login_status', result.login_status);

                if (isModifyPwd) {
                    cache.set('auth-password', loginParams.password, true);
                }

                if (params.isRememberMe) {
                    var backup = $.extend(true, {}, loginParams);
                    cache.set('login-params', backup);
                }
                im.isFirstSyncdata = RongIM.firstSyncdata.get(user.id);
                if (im.isFirstSyncdata) {
                    im.syncdataLoad.show = true;
                }
                im.syncdataLoad.state = 'loading';
                im.syncdataLoad.progress = 0;
                im.syncdataCallback = function (error) {
                    if (error) {
                        im.syncdataLoad.state = 'failed';
                        defer.reject(error);
                        return;
                    }
                    RongIM.firstSyncdata.set(user.id);
                    im.syncdataLoad.state = 'success';
                    var naviConfig = naviRequestParams(im.config, auth);
                    connect(api, naviConfig, function (err, token) {
                        if (err) {
                            defer.reject(err);
                            return;
                        }
                        firstMultideviceLogin(api.conversation);

                        auth.token = token;
                        var isTemp = true;
                        cache.set('auth', auth, isTemp);
                        getNativeConversationList(im);
                        im.auth = auth;
                        loginedGetBasedata(im);
                        console.log(loginParams)
                        if (loginParams.agent.platform == 'web') {
                            im.$router.push({
                                name: 'workApps'
                            });
                        } else {
                            im.$router.push({
                                name: 'conversation'
                            });
                        }

                        defer.resolve(auth);
                        im.checkLock();
                    });
                };
                RongIM.Database.init(RongIM.serverConfig.im.app_key, user.id, function () {
                    RongIM.syncdata.all(auth.isStaff, im.syncdataCallback, function (p) {
                        im.syncdataLoad.progress = Number(p.toFixed(2));
                    });
                });
            }
            im.busy = false;
        });
        return defer.promise();
    }

    function getStatus() {
        return cache.get('online-status') || 'online';
    }

    function connect(api, naviConfig, callback) {
        callback = callback || $.noop;
        callback.done = false;
        var deviceId = common.getDeviceId();
        var im = RongIM.instance;
        var sys = RongIM.system;
        var status = im.status;
        var connected = status === utils.status.CONNECTED;
        if (connected) {
            callback(null, naviConfig.token);
            return;
        }
        RongIM.getNavi(naviConfig, function (error, result) {
            if (error) {
                sys.appLogger('error', '获取导航配置失败! Error: ' + JSON.stringify(error));
                callback(error);
                return;
            }
            sys.appLogger('info', '获取导航配置成功! Result:\n' + JSON.stringify(result));
            api.status.connect(result, naviConfig.token, deviceId, function (errorCode) {
                if (callback.done) {
                    return;
                }
                callback.done = true;
                if (errorCode) {
                    if (connect.retry === 'done') {
                        sys.appLogger('error', '链接 RCX 服务失败! Error: ' + JSON.stringify(error));
                        callback(errorCode);
                        return;
                    }

                    api.user.refreshToken(function (err, info) {
                        if (err) {
                            sys.appLogger('error', 'Refresh RCX Token Failed!!!');
                            callback(err);
                            return;
                        }
                        connect.retry = 'done';
                        var token = info.token;
                        sys.appLogger('error', 'Refresh RCX Token Succeed!!! token = ' + token);
                        im.auth.token = token;
                        cache.set('auth', im.auth, true);
                        naviConfig.token = token;
                        connect(api, naviConfig, callback);
                    });
                } else {
                    // 连接成功的时间
                    im.connectedTime = RongIM.dataModel.getServerTime();
                    sys.appLogger('info', '链接 RCX 服务成功!');
                    // 同步远程会话列表
                    syncRemoteConversations(function () {
                        callback(null, naviConfig.token);
                    });
                }
            });
        });
    }

    // 同步远程会话列表，
    function syncRemoteConversations(callback) {
        callback();
        // TODO: 1.6.9 不上此功能，且同步列表未成功，需跟 王平、宏博 联调
        // if (syncRemoteConversations.running) {
        //     callback();
        //     return;
        // }

        // var userId = RongIM.dataModel._Cache.auth.id;
        // var cacheKey = userId + '-sync-remote-conversation';
        // var latestTime = parseInt(cache.get(cacheKey) || 0);
        // var now = Date.now();

        // // 每 12 个小时可同步一次，避免频繁拉取，IM 服务压力过大
        // if (now - latestTime < 12 * 1000 * 3600) {
        //     callback();
        //     return;
        // }

        // syncRemoteConversations.running = true;

        // RongIM.system.appLogger('info', 'sync remote conversations => ');
        // RongIMClient.getInstance().getRemoteConversations(1000, 0, 0, {
        //     onSuccess: function () {
        //         syncRemoteConversations.running = false;
        //         RongIM.system.appLogger('info', 'sync remote conversations => success!');
        //         // 记录同步时间
        //         cache.set(cacheKey, now.toString());
        //         callback();
        //     },
        //     onError: function () {
        //         syncRemoteConversations.running = false;
        //         RongIM.system.appLogger('info', 'sync remote conversations => error!');
        //         callback();
        //     }
        // });
    }

    function logout(context) {
        var loginType = '1';
        var im = context;
        RongIM.client.unregOpenCoversation();
        im.auth = null;
        im.cacheAuth = null;
        im.loginUser = null;
        cachePrimarypath = {};
        if (im.config.support.voip) {
            RCCall.close();
        }
        RongIM.browserWindow.closeRemoteControl();
        if (im.$route.name !== 'login') {
            im.$router.push({
                name: 'login'
            });
            if (RongIM.config.modules.zkxLoginType === 3) {
                loginType = '1'
            }
            RongIM.config.modules.zkxLoginType = loginType;
        }
        // common.downloaders.clear();
        RongIM.resCache = null;
    }

    function clearCache() {
        cache.remove('auth');
        cache.remove('online-status');
        // cache.remove('sysMessage');
        cache.remove('login-params');
    }

    function promptForcedLogout(im, errorCode) {
        im.logout();
        // status 6 其他端登录会连续触发两次关闭上次弹窗
        if (promptForcedLogout.precursor && promptForcedLogout.precursor.close) {
            promptForcedLogout.precursor.close();
        }
        promptForcedLogout.precursor = common.messagebox({
            hashchangeClose: false,
            message: im.locale.errorCode[errorCode]
        });
    }

    function versionCheck() {
        // web 版无需检查
        var sys = RongIM.system;
        if (sys.platform.indexOf('web') > -1) {
            return;
        }
        var im = RongIM.instance;
        var versionChecker = RongIM.dataModel.versionChecker;
        var now = Date.now();
        versionChecker.lastTimestamp = versionChecker.lastTimestamp || 0;
        // 10 分钟内不做二次检查
        if (now - versionChecker.lastTimestamp < 10 * 60 * 1000) {
            return;
        }
        versionChecker.lastTimestamp = now;
        // 平台标识
        var platform;
        if (sys.platform.startsWith('darwin')) {
            platform = versionChecker.PLATFORM.MAC_OS;
        } else if (sys.platform === 'linux') {
            platform = versionChecker.PLATFORM.LINUX;
        } else {
            platform = versionChecker.PLATFORM.WINDOWS;
        }
        // 版本号
        var versionCode = RongIM.config.product.versionCode;
        RongIM.dataModel.versionChecker.check(platform, versionCode, function (versionInfo) {
            if (!versionInfo) {
                return;
            }
            var download_url = versionInfo.download_url;

            function openBrowser() {
                // 使用默认浏览器打开地址
                sys.openByBrowser(download_url);
                // 退出应用
                sys.exit();
            }

            function closeCallback() {
                im.$router.push({
                    name: 'conversation'
                });
            }
            // 需强制更新
            if (versionInfo.force_upgrade) {
                common.messagebox({
                    message: im.locale.components.upgrade.forceUpgrade,
                    callback: openBrowser,
                    closeCallback: openBrowser
                });
                return;
            }
            // 提醒更新，
            common.messagebox({
                type: 'confirm',
                message: im.locale.components.upgrade.confirmUpgrade,
                submitText: im.locale.btns.confirmAndUpgrade,
                callback: openBrowser,
                closeCallback: closeCallback
            });
        });
    }

    function watchConnectionStatus(statusApi, im) {
        var dataModel = RongIM.dataModel;
        var sys = RongIM.system;
        var api = {
            user: dataModel.User,
            status: dataModel.Status,
            conversation: dataModel.Conversation
        };
        var kickedStatus = utils.status.KICKED_OFFLINE_BY_OTHER_CLIENT;
        var blockedStatus = utils.status.USER_BLOCKED;
        var errMap = {
            'logout-by-otherclient': 'logout-by-otherclient'
        };
        errMap[kickedStatus] = 'kicked-offline-by-otherclient';
        errMap[blockedStatus] = 'user-be-blocked';

        function reconnectNavi() {
            var user = im.cacheAuth || im.auth;
            if (utils.isEmpty(user)) {
                // 用户已退出登录不再做重连
                return;
            }
            var naviConfig = naviRequestParams(im.config, user);
            connect(api, naviConfig, function (errorCode, token) {
                if (errorCode) {
                    // console.warn(errorCode);
                    // 3秒后重试
                    api.status.disconnect();
                    setTimeout(reconnectNavi, 3000);
                    return;
                }
                firstMultideviceLogin(api.conversation);
                var auth = $.extend({}, im.cacheAuth || im.auth);
                auth.token = token;
                var isTemp = true;
                cache.set('auth', auth, isTemp);
                cache.set('local-auth', auth);
                im.auth = auth;
                im.$router.push({
                    name: 'conversation'
                });
                im.checkLock();
            });
        }
        statusApi.watch(function (status) {
            if (errMap[status]) {
                im.$emit('userBlocked');
                promptForcedLogout(im, errMap[status]);
                return;
            }

            im.status = status;

            var connected = status === utils.status.CONNECTED;
            var connecting = status === utils.status.CONNECTING;

            // 版本检查
            if (connected) {
                versionCheck();
            }

            if (status === utils.status.DISCONNECTED) {
                // 网络断开设置图标为掉线灰色
                sys.setConnectStatus(false);
            } else if (connected) {
                sys.setConnectStatus(true);
                syncRemoteConversations($.noop);
            } else if (status === 8 || status === 30010) {
                // 8 为导航重定向，临时解决方案
                api.status.disconnect();
                networkAvailable(function afterNetworkAvailable(result) {
                    if (!result) {
                        setTimeout(networkAvailable, 3000, afterNetworkAvailable);
                        return;
                    }
                    im.onNetworkAvailable();
                    reconnectNavi();
                });
            } else if (status === 31004) {
                // token 失效
                api.status.disconnect();
                networkAvailable(function afterNetworkAvailable2(result) {
                    if (!result) {
                        setTimeout(networkAvailable, 3000, afterNetworkAvailable2);
                        return;
                    }
                    api.user.refreshToken(function (err, info) {
                        if (err) {
                            sys.appLogger('error', 'Refresh RCX Token Failed!!!');
                            setTimeout(networkAvailable, 3000, afterNetworkAvailable2);
                            return;
                        }
                        var token = info.token;
                        sys.appLogger('error', 'Refresh RCX Token Succeed!!! token = ' + token);
                        im.auth.token = token;
                        cache.set('auth', im.auth, true);
                        im.onNetworkAvailable();
                        reconnectNavi();
                    });
                });
            }

            // // c++ SDK 有自动重连机制 不需要处理重连
            if (utils.isEmpty(im.auth) || connected || connecting || im.config.support.autoReconnect) {
                return;
            }
            checkToConnect(statusApi, im);
        });

        sys.onResume = function () {
            sys.appLogger('info', 'RCE renderer resumed !!!');
            // 帐号未登录
            if (utils.isEmpty(im.auth)) {
                return;
            }
            // 同步数据: 离线时收不到部门变更状态消息
            im.onNetworkAvailable();
            // 系统恢复时若当前未连接，则主动断开并重新连接
            if (im.status === utils.status.DISCONNECTED) {
                reconnectNavi();
            }
        };
    }

    // web 平台需手动检测网络状态并重新连接
    function checkToConnect(statusApi, im) {
        if (utils.isEmpty(im.auth)) {
            return;
        }
        networkAvailable(function (result) {
            if (result) {
                statusApi.reconnect(function (errorCode) {
                    if (!errorCode) {
                        // 重连成功之后设置图标为在线颜色
                        RongIM.system.setConnectStatus(true);
                    }
                });
                return;
            }
            setTimeout(checkToConnect, 3000, statusApi, im);
        });
    }

    function networkAvailable(callback) {
        callback(true);
        // var params = {
        //     version: (new Date()).getTime()
        // };
        // var url = RongIM.config.dataModel.server + '/configuration/all';
        // $.ajax({
        //     method: 'head',
        //     url: url,
        //     data: params
        // }).then(function () {
        //     callback(true);
        // }, function () {
        //     callback(false);
        // });
    }

    var notificationMessageList = [
        'TextMessage',
        'ImageMessage',
        'FileMessage',
        'VoiceMessage',
        'LocationMessage',
        'LocalFileMessage',
        'LocalImageMessage',
        'CardMessage',
        'SightMessage',
        'RichContentMessage',
        'ApprovalMessage',
        'JrmfRedPacketMessage',
        'PublicServiceRichContentMessage',
        'PublicServiceMultiRichContentMessage',
        'ReferenceMessage'
    ];

    var notificationMessageConvert = {
        TextMessage: function (msg) {
            var textMessage = msg.content;
            var content = textMessage.content;
            content = utils.htmlLang.check(content);
            return content;
        },
        FileMessage: function (msg) {
            return msg.content.name;
        },
        LocalFileMessage: function (msg) {
            return msg.content.name;
        },
        CardMessage: function (msg) {
            return utils.templateFormat(
                RongIM.instance.locale.message.cardOther,
                msg.content.name
            );
        },
        ApprovalMessage: function (msg) {
            return msg.content.content;
        },
        JrmfRedPacketMessage: function (msg) {
            return common.getJrmfRedPacket(msg);
        },
        PublicServiceRichContentMessage: function (msg) {
            var articles = [];
            var content = msg.content;
            // Web SDK 与 C++ SDK 定义消息结构不一致导致
            if (content.richContentMessage) {
                articles = content.richContentMessage.articles;
            } else {
                articles = content.articles;
            }
            return articles[0].title;
        },
        PublicServiceMultiRichContentMessage: function (msg) {
            var articles = [];
            var content = msg.content;
            // Web SDK 与 C++ SDK 定义消息结构不一致导致
            if (content.richContentMessages) {
                articles = content.richContentMessages.articles || [];
            } else {
                articles = content.articles || [];
            }
            return articles[0].title;
        },
        ReferenceMessage: function (msg) {
            var content = msg.content.text;
            content = utils.htmlLang.check(content);
            return common.convertMessage(content);
        }
    };

    var getPrefix = function (msg) {
        var _prefix = RongIM.instance.locale.message.prefix[msg.messageType] || '';
        return _prefix;
    };

    var getShowText = function (msg, isAt, groupApi, userApi, callback) {
        var convert = notificationMessageConvert[msg.messageType] || $.noop;
        var content = convert(msg) || '';
        var notifyMsg = getPrefix(msg) + ' ' + content;
        var settingSystemLocale = RongIM.instance.locale.components.settingSystem;
        var options = {
            title: '',
            // 默认显示“你收到一条新消息”
            body: settingSystemLocale.notifyText
        };
        var isShowPreview = cache.get('showPreview');
        var userId = msg.senderUserId;
        if (msg.conversationType === utils.conversationType.GROUP) {
            groupApi.getOne(msg.targetId, function (errorCode, group) {
                if (errorCode) {
                    utils.console.warn('获取群组信息失败, groupId=' + msg.targetId + '（错误码：' + errorCode + '）');
                    options.title = 'group<' + msg.targetId + '>';
                } else {
                    options.title = group.name;
                }
                if (isShowPreview) {
                    userApi.get(userId, function (_errorCode, user) {
                        var userName = ('user<' + userId + '>');
                        if (_errorCode) {
                            utils.console.warn('获取用户信息失败, userId=' + userId + '（错误码：' + _errorCode + '）');
                        } else {
                            userName = common.getGroupUsername(user, msg.targetId);
                        }
                        if (isAt) {
                            options.body = utils.templateFormat(settingSystemLocale.atText, userName);
                        } else {
                            options.body = userName + ': ' + notifyMsg;
                        }
                        callback(options);
                    });
                } else {
                    callback(options);
                }
            });
        } else {
            userApi.get(userId, function (errorCode, user) {
                var userName = ('user<' + userId + '>');
                if (errorCode) {
                    utils.console.warn('获取用户信息失败, userId=' + userId + '（错误码：' + errorCode + '）');
                } else {
                    userName = common.getUsername(user);
                }
                options.title = userName;
                if (isShowPreview) {
                    options.body = notifyMsg;
                }
                callback(options);
            });
        }
    };

    function getIsAt(message, im) {
        var hasUnRead = true;
        var mentionMsg = message.content.mentionedInfo;
        if (!mentionMsg) {
            return false;
        }
        if (mentionMsg.type === utils.mentionedType.ALL) {
            return hasUnRead;
        }
        var userIdList = mentionMsg.userIdList;
        return userIdList.indexOf(im.auth.id) !== -1 && hasUnRead;
    }

    function watchMessage(messageApi, conversationApi, userApi, groupApi, im) {
        messageApi.watch(function (message) {
            var sys = RongIM.system;
            var win = RongIM.browserWindow;
            var auth = im.auth;
            if (utils.isEmpty(auth)) {
                return;
            }
            var params = {
                conversationType: message.conversationType,
                targetId: message.targetId
            };
            var content = message.content;
            var isCurrentChat = common.sameConversaton(params, im.$route.params);

            // 正在会话的群被解散给出提示并退出会话
            if (message.messageType === 'GroupNotifyMessage') {
                var isDismiss = (message.content.action + '') === '2';
                if (isDismiss && isCurrentChat) {
                    im.$router.push({
                        name: 'conversation',
                        query: {
                            force: 1
                        }
                    });
                }
                return;
            }

            // 收到设备锁屏消息，显示弹层
            if (message.messageType === 'MultiClientMessage') {
                if (+message.content.action === 1) {
                    // 锁定
                    dialog.deviceLocking();
                    im.isLock = true;
                }
                return;
            }

            // 收到设备锁定消息，退出登录
            if (message.messageType === 'DeviMonitorMessage') {
                // 设备锁定消息需判断是否是针对当前设备做操作
                if (common.getDeviceId() === message.content.device_id) {
                    if (+message.content.action === 1) {
                        common.messagebox({
                            message: im.locale.components.device.locked,
                            callback: im.logout,
                            closeCallback: im.logout
                        });
                    } else if (+message.content.action === 2) {
                        var handle = function () {
                            RongIM.Database.clean(im.config.appkey, im.auth.id);
                            im.logout();
                            // 同时删除本地存储的消息
                            messageApi.ClearData();
                        };
                        common.messagebox({
                            message: im.locale.components.device.erase,
                            callback: handle,
                            closeCallback: handle
                        });
                    }
                }
                return;
            }

            // 外部联系人转内部员工通知消息
            if (message.messageType === 'UserTypeChangedMessage') {
                RongIM.firstSyncdata.remove(im.auth.id);
                var companyName = message.content.company_name;
                var logoutHandle = function () {
                    im.logout();
                };
                common.messagebox({
                    hashchangeClose: false,
                    callback: logoutHandle,
                    closeCallback: logoutHandle,
                    message: utils.templateFormat(im.locale.errorCode['user-status-updated'], companyName)
                });
                return;
            }

            if (message.messageType === 'AppNotifyMessage') {
                var publicEnable = content.content.enable;
                var publicAction = content.content.action;
                // 收到公众号关闭通知或者该用户不可见,都提示公众号已关闭.删除会话列表中对应公众号会话，正在会话的公众号退出当前会话
                if ((content.cmd_type === 1 && !publicEnable) || (content.cmd_type === 3 && publicAction === 'del')) {
                    conversationApi.remove(message.conversationType, message.targetId);
                    if (isCurrentChat) {
                        common.messagebox({
                            message: im.locale.components.public.tips,
                            callback: function () {
                                im.$router.push({
                                    name: 'conversation',
                                    query: {
                                        force: 1
                                    }
                                });
                            }
                        });
                    }
                }
                win.sendPublicNotify(message);
                return;
            }

            // RCE Server 订阅状态通知
            if (message.messageType === 'PresenceNotificationMessage') {
                var isPhoneLogin = content.title === 'Login_Status_Mobile';
                if (params.targetId === auth.id && isPhoneLogin) {
                    conversationApi.addFileHelper();
                }
                var conParams = {
                    conversationType: message.conversationType,
                    targetId: message.content.targetId
                };
                var isSameConversaton = common.sameConversaton(conParams, im.$route.params);
                if (isSameConversaton) {
                    userApi.getDetail(content.targetId, function (errorCode, user) {
                        if (errorCode) {
                            return;
                        }
                        user.onlineStatus = user.onlineStatus || {};
                        user.onlineStatus[content.title] = content;

                        if (im.loginUser && im.loginUser.id === user.id) {
                            user.mobile = im.loginUser.mobile;
                        }
                        userApi.observerList.notify(user);
                    });
                }
                return;
            }

            // 系统消息通知提示音
            var isNewMessage = message.sentStatus === utils.sentStatus.SENT ||
                message.sentStatus === utils.sentStatus.RECEIVED ||
                message.receivedStatus === 0;
            var isSelf = message.senderUserId === auth.id;
            var notOfflineMessage = !message.offLineMessage;
            var isSystemMessage = +message.conversationType === utils.conversationType.SYSTEM;
            var key = 'sysMessage';
            var ring = cache.get(key);
            var isNotify = notificationMessageList.indexOf(message.messageType) > -1;
            if (isNewMessage && !isSelf && notOfflineMessage && !isSystemMessage && isNotify) {
                conversationApi.getExpandInfo(params, function (errorCode, info) {
                    info = info || {};
                    var notify = !info.not_disturb;
                    var isAt = getIsAt(message, im);
                    var isFocused = win.isFocused();
                    var isVisible = win.isVisible();
                    var isMac = sys.platform.startsWith('darwin');
                    if ((notify || isAt) && isMac && (!isVisible || !isFocused)) {
                        getShowText(message, isAt, groupApi, userApi, function (showOptions) {
                            sys.messageNotification(showOptions, function () {
                                im.$router.push({
                                    name: 'conversation',
                                    params: {
                                        targetId: message.targetId,
                                        conversationType: message.conversationType
                                    }
                                });
                            });
                        });
                    } else if (notify && ring) {
                        common.playSound();
                    }
                    var isDarwin = (sys.platform === 'darwin');
                    if (!isDarwin && notify) {
                        win.flashFrame();
                    }
                });
            }
        });
    }

    function getNativeConversationList(im) {
        var conversationApi = im.dataModel.Conversation;
        var isWeb = RongIM.system.platform.indexOf('web') > -1;
        if (!isWeb) {
            im.updateTotalUnreadCount([]);
            return;
        }
        conversationApi.getNativeList(function (errorCode, list) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            im.updateTotalUnreadCount(list);
        });
    }

    function watchConversation(conversationApi, im) {
        conversationApi.watch(function () {
            getNativeConversationList(im);
        });
    }

    function watchLoginUser(userApi, im) {
        userApi.watch(function (user) {
            if (im.loginUser && user.id === im.loginUser.id) {
                $.extend(im.loginUser, user);
            }
        });
    }

    function updateTotalUnreadCount(conversationApi, im, list) {
        utils.throttle(function () {
            conversationApi.getTotalUnreadCount(list, function (errorCode, total) {
                im.unReadCount = total;
                updateUnreadCount();
            });
        }, 600)();
    }

    function updateUnreadCount() {
        var im = RongIM.instance;
        var normalUnRead = im.unReadCount;
        var pinUnRead = im.enabledPIN ? im.pinUnReadCount.unConfirm : 0;
        var totalUnRead = normalUnRead + pinUnRead;
        totalUnRead = im.formateUnreadCount(totalUnRead);
        RongIM.browserWindow.updateBadgeNumber(normalUnRead + pinUnRead, totalUnRead);
    }

    function getRequestUnreadCount(list) {
        var total = 0;
        if (list && list.length > 0) {
            list.forEach(function (item) {
                if (item.read_state === 0 && item.state === common.FriendState.INVITEE) {
                    total += 1;
                }
            });
        }
        return total;
    }

    function watchFriendRequest(friendApi, im) {
        friendApi.watch(function (result) {
            var auth = im.auth;
            if (utils.isEmpty(auth)) {
                return;
            }
            if (result.type === 'Friend') {
                return;
            }
            im.requestUnReadCount = getRequestUnreadCount(result.list);
        });
    }

    function watchApproveRequest(groupApi, im) {
        if (im.auth) {
            setApproveUnReadCount(groupApi, im);
        }
        groupApi.watch(function (message) {
            var auth = im.auth;
            if (utils.isEmpty(auth)) {
                return;
            }
            var messageType = message.messageType;
            var isGroupVerifyNotify = messageType === 'GroupVerifyNotifyMessage';
            var isApprove = im.routePathStartWith('/contact/approve');

            if (isGroupVerifyNotify) {
                setApproveUnReadCount(groupApi, im, function (count) {
                    if (isApprove && count > 0) {
                        groupApi.clearApproveUnRead(function () {
                            im.approveUnReadCount = 0;
                        });
                    }
                });
            }
        });
    }

    function setApproveUnReadCount(groupApi, im, callback) {
        callback = callback || $.noop;
        groupApi.getApproveUnread(function (err, count) {
            if (!err) {
                im.approveUnReadCount = count;
                callback(count);
            }
        });
    }

    function watchPinUnreadCount(pinApi, im) {
        if (im.auth) {
            getPinUnConfirmCount(pinApi, im);
            getPinCommentUnreadCount(pinApi, im);
            getUndoCount(pinApi, im);
        }
        pinApi.watch(function (message) {
            var auth = im.auth;
            if (utils.isEmpty(auth)) {
                return;
            }
            var loginId = im.auth ? im.auth.id : null;
            var isPinComment = pinApi.MessageType.PinCommentMessage === message.messageType;
            var isPinCommentRead = pinApi.MessageType.PinCommentReadMessage === message.messageType;
            var isSelf = message.content.publisherUid === loginId;
            var isUnDoProcess = pinApi.MessageType.UnDoProcess === message.messageType;
            var isPinRevoke = pinApi.MessageType.PinRevokeMessage === message.messageType;
            var isPinDeleted = pinApi.MessageType.PinDeletedMessage === message.messageType;
            if (!isPinComment) {
                getPinUnConfirmCount(pinApi, im);
            }
            if ((isPinComment && !isSelf) || isPinCommentRead || isPinRevoke || isPinDeleted) {
                getPinCommentUnreadCount(pinApi, im);
            }
            if (isUnDoProcess) {
                getUndoCount(pinApi, im);
            }
        });
    }

    function turnOffCapsLockWarning() {
        document.msCapsLockWarningOff = true;
    }

    function cleanup(models) {
        if (models && models.length > 0) {
            models.forEach(function (model) {
                model.unwatch();
            });
        }
    }

    RongIM.init = function (config, callback) {
        const _this = this
        callback = callback || $.noop;
        RongIM.dataModel.getServerConfig(function (error /* ,  features */ ) {
            var sys = RongIM.system;
            var imConf = RongIM.config;
            if (error) {
                sys.appLogger('error', 'Get /configuration/all failed!\nResson: ' + JSON.stringify(error));
                callback(error);
                return;
            }
            callback(null);

            var serverConfig = RongIM.serverConfig;
            console.log(_this.locale)
            if (serverConfig.zhkx){
                // _this.locale.zh.components.welcome.zhkx = serverConfig.zhkx.pc_zhkx_menu
                _this.locale.zh.components.login.bm_tips = serverConfig.zhkx.bm_tips
                // _this.locale.zh.components.login.message_bm_tips = serverConfig.zhkx.message_bm_tips
                _this.locale.zh.components.login.pin_bm_tips = serverConfig.zhkx.pin_bm_tips
                _this.locale.zh.tips.inputText = serverConfig.zhkx.message_bm_tips
            }
            // localStorage.setItem('publicKey', serverConfig.security.password_public_key_rsa)
            sys.appLogger('info', 'Get /configuration/all succeed! Result:\n' + JSON.stringify(serverConfig));

            // server 端下发 appeky
            config.appkey = serverConfig.im.app_key;
            imConf.appkey = config.appkey;

            // server 端下发 navi 地址
            var navi_urls = serverConfig.im.navi_urls;
            var naviUrl;
            // 优先匹配同协议导航
            navi_urls.some(function (item) {
                if (item.startsWith(location.protocol)) {
                    naviUrl = item;
                    return true;
                }
                return false;
            });
            // 若无同协议导航时，随意取一个
            naviUrl = naviUrl || navi_urls[0];
            if (!naviUrl) {
                console.error('导航获取失败！');
                return;
            }
            config.sdk.navi = naviUrl;
            imConf.sdk.navi = naviUrl;

            // server 端下发二维码登录配置
            imConf.modules.qrcodeLogin = serverConfig.qrcode.login_enable;
            // server 端下发好友配置
            imConf.modules.friend = serverConfig.friend.enable;

            // server 端下发文件上传地址
            var upload_urls = serverConfig.media.upload_urls;
            var fileDomain;
            upload_urls.some(function (item) {
                if (item.startsWith(location.protocol)) {
                    fileDomain = item;
                    return true;
                }
                return false;
            });
            fileDomain = fileDomain || upload_urls[0];
            if (!fileDomain) {
                console.error('文件服务器获取失败！');
                return;
            }
            var uploadType = serverConfig.media.type;
            imConf.upload.file.domain = fileDomain;
            imConf.upload.type = RongIM.dataModel.File.getFileType(uploadType);
            if (uploadType === 0) {
                // 七牛
                imConf.upload.base64.domain = fileDomain + '/putb64/-1';
            } else {
                imConf.upload.base64.domain = fileDomain + '/upload/base64';
            }
            // server 端下发文件大小设置
            imConf.upload.file.fileSize = serverConfig.media.max_file_size * 1024 * 1024;

            var remoteControlConfig = imConf.modules.remoteControl;
            remoteControlConfig = $.extend(remoteControlConfig, serverConfig.remote_control);
            imConf.modules.remoteControl = remoteControlConfig;

            if (remoteControlConfig.enable && RongIM.remoteControl && RongIM.remoteControl.init) {
                try {
                    RongIM.remoteControl.init(remoteControlConfig);
                } catch (err) {
                    console.warn('remote module load error!', err);
                }
            }

            cache.setKeyNS(config.appkey);
            fixCache(config.appkey);

            var userSetting = cache.get('locale');
            var locale = userSetting || config.locale;
            if (!locale) {
                // zh-CN --> zh;
                var systemLocale = sys.locale.split('-')[0];
                systemLocale = systemLocale.toLowerCase();
                locale = systemLocale;

                var supportList = [];
                $.each(RongIM.locale, function (key) {
                    supportList.push(key);
                });
                var notSupport = supportList.indexOf(locale) === -1;
                if (notSupport) {
                    locale = supportList[0];
                    console.info('不支持语言：', locale);
                }
            }
            // 仅支持 zh, en 其他语言会导致程序错误
            if (locale !== 'zh') {
                locale = 'en';
            }
            config.locale = locale;
            sys.setLanguage(config.locale);
            RongIMLib.RongIMEmoji.setConfig({
                lang: locale
            });
            document.title = config.product.name[locale];
            config.product.productName = config.product.name[config.locale];

            init(config);
        });
    };

    function setStatus(status) {
        var im = RongIM.instance;
        if (!im || utils.isEmpty(im.auth)) {
            return;
        }
        var userApi = RongIM.dataModel.User;
        userApi.setStatus(status);
    }

    function updatePassword(user) {
        var serverConfig = RongIM.serverConfig;
        var isForcedChangePassword = serverConfig.password.default_password_security_level === 0;
        if (utils.isEmpty(user)) {
            return;
        }
        if (user.isModifyPwd && isForcedChangePassword) {
            dialog.setPassword();
        }
    }

    window.onbeforeunload = function () {
        setStatus('offline');
    };

    function naviRequestParams(config, auth) {
        return {
            appkey: config.appkey,
            userId: auth.id,
            token: auth.token,
            url: config.sdk.navi + '/navi.json',
            version: config.sdkVersion
        };
    }
}(RongIM, {
    jQuery: jQuery,
    Vue: Vue,
    VueRouter: VueRouter,
    RCCall: RCCall,
    win: window
}, RongIM.components));
