/* eslint-disable quotes */
/*
desktop locales: https://electron.atom.io/docs/api/locales/

从三位维度进行配置
1. user, conversation, contact, message 等业务数据对象
2. btns, tips 等全局通用的组件
3. components 下逐个 vue 组件进行配置

加载 RongIM.locale.xx 交给 vue 处理
components 下严格对应 vue 组件名称 options.name (组件加载器 asyncComponent 会将组件名称转为驼峰命名 a-b => aB)
组件经加载器处理增加计算属性 locale 和方法 localeFormat
各组件可通过 locale 直接访问对应组件下 key 值(例: signup 组件下可以这样写 locale.title, locale.btns )

使用方法：
根据需要加载语言包 js/locale 下文件
配置支持语言包
value 语言包文件名称（语言缩写）
name 对应说明（语言全称）
RongIM.config.supportLocales = [{
    value: 'zh',
    name: '中文'
}]

// 示例模板 templates/onle-status.html
<ul v-if="showMenu" class="rong-nav-status-menu" :class="['rong-nav-status-' + status]">
    <li class="rong-nav-online"><a href="#" @click.prevent="setStatus('online') ">{{locale.online}}</a></li>
    <li class="rong-nav-leave"><a href="" @click.prevent="setStatus('leave') ">{{locale.leave}}</a></li>
    <li class="rong-nav-busy"><a href="" @click.prevent="setStatus('busy') ">{{locale.busy}}</a></li>
</ul>

如新增加语言包 Afrikaans
1.在 js/locale 新增文件 af.js
(function (RongIM) {
RongIM.locale.af = {};
})(RongIM);
2.在 config.js 中增加对应配置
var supportLocales = [
    ...
    {
        // 对应文件名称
        value: 'af',
        name: 'Afrikaans'
    }
]
*/
(function (RongIM) {
    'use strict';

    RongIM.locale.zh = {
        name: "中文",
        emoji: {
            key: "zh"
        },
        punctuation: {
            separator: "、"
        },
        email: {
            title: "邮箱设置",
            name: "邮箱",
            holder: "请输入您得邮箱",
            btnText: "绑定邮箱"
        },
        phone: {
            title: "手机号码",
            name: "更换",
            vildata: "验证码",
            updataName: "新手机号"
        },
        time: {
            seconds: "秒",
            minutes: "分钟",
            yesterday: "昨天",
            morning: "凌晨",
            forenoon: "上午",
            noon: "中午",
            afternoon: "下午",
            evening: "晚上",
            week: ["周日", "周一", "周二", "周三", "周四", "周五", "周六"],
            format: "YYYY年M月D日"
        },
        tips: {
            loading: "正在加载...",
            inputText: "严禁处理内部及涉密消息，不得扫描翻拍文件",
            searching: "正在搜索...",
            searchEmpty: "没有搜索到{{0}}相关结果",
            msgboxTitle: "提示",
            msgboxSubmitText: "确定",
            departmentGroup: "部门",
            companyGroup: "公司",
            allMemberGroup: "全员",
            contain: "包含: ",
            fileUnexist: "文件不存在",
            uploadAvatar: "头像正在上传中",
            groupDismissed: "该群组被解散",
            pwdTip: "6-16 位数字和字母组合",
            publish: "发布",
            clearApprove: "确定清空入群申请列表？",
            zeroSize: "不能发送大小为 0 KB 的文件",
            overSize: "发送的文件不能大于{{0}}",
            recalled: "消息已被撤回",
            mostMembers: "最多可选择{{0}}人",
            voiceForward: '收藏的语音消息不能转发',
            collected: '已收藏'
        },

        copyFileUrl: {
            success: "复制成功，请在浏览器打开",
            error: "复制失败，不支持"
        },

        btns: {
            complete: '完成',
            sendCaptcha: "发送验证码",
            refresh: "刷新",
            transfer: "转让",
            edit: "编辑",
            send: "发送",
            startConversation: "发起会话",
            save: "保存",
            submit: '提交',
            saveAs: "另存为",
            full: "全屏",
            normal: "退出全屏",
            prev: "上一张",
            next: "下一张",
            prevPage: "上一页",
            nextPage: "下一页",
            reg: "注册",
            login: "登录",
            logining: "登录中...",
            logout: "退出登录",
            rememberMe: "自动登录",
            forget: "忘记密码",
            remove: "删除",
            removeConversation: "删除会话",
            cancel: "取消",
            close: "关闭",
            confirm: "确定",
            back: "返回",
            collapse: "收起",
            more: "查看全部",
            checkedAll: "全选",
            clear: "清空",
            search: "搜索",
            backToSearch: '返回到搜索结果',
            higtSearch: '高级搜索',
            exitSearch: '退出高级搜索',
            searchPerson: "搜索名称、手机号、邮箱",
            searchDuty: "搜索职位名称",
            searchOrg: "搜索组织架构名称",
            expand: "展开",
            recall: "撤回",
            copy: "复制",
            remind: "设置提醒",
            collect: "收藏",
            forward: "转发",
            forwards: "多选转发",
            untop: "取消置顶",
            top: "置顶",
            mute: "消息免打扰",
            unmute: "允许消息通知",
            draft: "草稿",
            saveContact: "保存到通讯录",
            add: "添加",
            inferior: "查看",
            zoomOut: "缩小",
            zoomIn: "放大",
            selectFile: "本地上传",
            addReport: "新建通讯组",
            groupChat: "发起群聊",
            createChat: "发消息",
            addFriend: "外部联系人",
            createGroup: "创建群组",
            maximize: "最大化",
            minimize: "最小化",
            restore: "还原",
            download: "下载",
            view: "查看",
            removeQuit: "删除并退出",
            confirmReply: "确认并回复",
            replyOrConfirm: "待确认",
            newReply: "新回复",
            newPin: "创建寻呼",
            createPin: '新建寻呼',
            publish: "发布",
            ignore: "忽略此次更新",
            remindLater: "以后提醒我",
            upgrade: "立即更新",
            confirmAndUpgrade: "下载并退出",
            saveToLocal: "保存到本地",
            quote: "引用",
            resumeUpload: "继续上传",
            resumDownload: "继续下载",
            pin: "寻呼",
            oneClickSMS: "一键短信",
            oneSubmit: '一键标为确认',
            onePin: '一键寻呼',
            toPin: '转寻呼',
            stop: '暂停',
            toapproval: '转审批',
            createApproval: '发起审批',
            addToGroup: '添加到通讯组',
            saveThis: '保存本次编辑?'
        },
        contact: {
            department: "部门",
            subcompany: "子公司",
            contact: "联系人",
            group: "群组",
            app: "应用",
            orgContact: "组织机构",
            addressList: "组织机构",
            star: "常用联系人",
            friend: "个人通讯录",
            recent: "最近聊天",
            selectedMember: "已选（{{0}}人）",
            emptyMember: "请选择需要添加的联系人",
            expandDept: "展开",
            person: "{{0}}人",
            personSingle: "{{0}}人",
            myGroup: "我的群组",
            addReportSuccess: "新建通讯组成功",
            nameHasText: '组名称已存在，请重新填写',
            record: '结果',
            oneMoreMembers: '通讯组成员不能少于1人'

        },
        blish: {
            createdGroup: "创建沟通群",
            createdChat: "创建群聊",
            createPins: '发寻呼',
            editGroup: "编辑当前组",
            delGroup: "删除当前组",
            department: "部门",
            subcompany: "子公司",
            contact: "联系人",
            group: "群组",
            app: "应用",
            orgContact: "我的组织",
            mechanism: "科协组织云",
            star: "我的群组",
            friend: "我的关注",
            myMailList: "我的通讯录",
            myAlly: "我的联盟单位",
            allyList: "联盟单位",
            allyApply: "新的联盟单位申请",
            recent: "最近聊天",
            recentContacts: "最近联系人",
            selectContacts: '选择联系人',
            goonSelectContacts: '修改联系人',
            addGroupUser: '添加组成员',
            updateGroupUser: '修改组成员',
            selectedMemberList: "已选择联系人",
            emptyMember: "请选择需要添加的联系人",
            expandDept: "展开",
            person: "{{0}}人",
            personSingle: "{{0}}人",
            myGroup: "我的群组",
            myMechanism: "科协组织云",
            distributionGroup: '通讯组',
            followDept: '部门',
            followOrganization: '组织',
            followWorkingGroup: '工作组',
            dayGroup: '群聊',
            dayContacts: "外部联系人",
            importantContacts: "重要联系人",
            addFollowMessage: '添加关注成功',
            addFollowTips: "请输入别名",
            cancelFollow: "取消关注",
            followReason: "请输入关注原因",
            followAlias: "别名：",
            AllSelected: "全选",
            dropDownAll: "全部",
            dropDownDepart: "部门",
            dropDownCompany: "单位",
            dropDownWorkingGroup: "工作组",
            groupApply: "入群申请",
            newFriendApply: "新好友申请",
            setDayGroup: "保存为群聊",
            toast: {
                serverRrrTips: "服务器内部错误",
                repeatTipe: "重复请求",
                noFollowTips: "该组织不可关注",
                repeatFollowTips: "无需再次关注",
                toExamineTips: "等待审核",
                followErrTips: "操作失败",
                invalidOrgId: "⽆效的组织唯⼀id",
                invalidUserId: "⽆效的用户id",
                prohibitTips: "该部门禁止关注"
            },
            cleanFollowMessage: "取消关注成功！",
            submit: "确定",
            clean: "取消"
        },
        conversation: {
            draft: "草稿",
            mute: "消息免打扰",
            atme: "有人@我",
            messageSentFail: "消息发送失败",
            empty: "暂无会话"
        },
        message: {
            confirmLargeGroup: "该群的用户已超过100人，请确认！",
            requestFriendVerification: "你还不是他（她）好友。请先发送好友验证请求，对方验证通过后，才能聊天。",
            requestFriendVerificationButton: "发送好友验证",
            readAll: "阅读全文",
            unknown: "当前版本暂不支持查看此消息",
            read: "已读",
            unread: "未读",
            checkUnread: "查看未读",
            allRead: "全部已读",
            unreadMember: "{{0}}人未读",
            unreadMessageCount: "{{0}}条未读消息",
            // 以下为群信息提示
            self: "你",
            create: "{{0}}创建了群组",
            created: "{{0}}创建了群组",
            join: "{{0}}加入群组",
            joinByQRCode: "{{0}}通过扫描{{1}}分享的二维码加入该群",
            invite: "{{0}}邀请{{1}}加入群组",
            invited: "{{0}}邀请{{1}}加入群组",
            inviteMe: "{{0}}邀请{{1}}加入群组",
            kick: "{{0}}将{{1}}移出群组",
            kicked: "{{1}}被{{0}}移出群组",
            rename: '{{0}}修改群名称为"{{2}}"',
            renamed: '{{0}}修改群名称为"{{2}}"',
            quit: "{{0}}退出了群组",
            dismiss: "该群组已被解散",
            notice: "{{0}}清空了群公告",
            noticeTitle: "群公告",
            OpenMute: "群主已开启“全员禁言”",
            CloseMute: "群主已关闭“全员禁言”",
            addMute: "{{1}}已被群主禁言",
            removeMute: "{{1}}已被群主解除禁言",
            updateManager: "{{1}}成为新群主",
            updateManagerSelf: "{{1}}成为新群主",
            unSupport: "不支持操作类型",
            // 以下为部门群信息提示
            createDepartment: "欢迎加入{{2}}",
            joinDepartment: "欢迎{{1}}加入{{2}}",
            joinDepartmentSelf: "欢迎加入{{2}}",
            departmentInvite: "欢迎{{1}}加入{{2}}",
            departmentInviteSelf: "欢迎加入{{2}}",
            KickDepartment: "{{1}}被移出群组",
            KickedDepartment: "你被移出了群组",
            dismissDepartment: "{{3}}群组已被解散",
            renameDepartment: "群名称被修改为{{2}}",
            updateDepartmentManager: "{{1}}已成为新群主",
            updateDepartmentManagerSelf: "{{1}}已成为新群主",
            // 以下位好友验证通过后,聊天页面的提示信息
            passed: "{{0}}通过了你的好友验证请求，现在可以开始聊天了",
            pass: "你通过了{{0}}的验证请求，现在可以开始聊天了",
            recallSelf: "你撤回了一条消息",
            recallOther: "{{0}}撤回了一条消息",
            recallAdmin: "消息被管理员撤回",
            cardSelf: "你推荐了{{0}}",
            cardOther: "向你推荐了{{0}}",
            redPacketSent: "[云红包]发出红包，请在手机上查看",
            redPacketReceived: "[云红包]收到红包，请在手机上查看",
            redPacketOpened: "{{0}}领取了你的红包",
            youOpenedRedpack: "你领取了{{0}}的红包",
            youOpenedRedpackOfYouSent: "你领取了自己的红包",
            prefix: {
                ImageMessage: "[图片]",
                LocalImageMessage: "[图片]",
                VoiceMessage: "[语音]",
                LocationMessage: "[位置]",
                FileMessage: "[文件]",
                LocalFileMessage: "[文件]",
                SightMessage: "[小视频]",
                RichContentMessage: "[图文]",
                AudioMessage: "[语音通话]",
                VideoMessage: "[视频通话]",
                ShareScreenMessage: "[屏幕共享]",
                ApprovalMessage: "[审批]",
                JieLongMessage: "[接龙]"
            },
            recallEdit: "重新编辑"
        },
        user: {
            mobile: "手机",
            staffNo: "工号",
            signTel: "手机号",
            tel: "电话",
            email: "邮箱",
            deptName: "部门",
            dutyName: "职位",
            supervisorName: "上级",
            password: "密码",
            nickName: "昵称",
            account: "登录名"
        },
        pin: {
            all: "全部",
            today: "最近1天",
            recentWeek: "最近1周",
            recentMonth: "最近1月",
            recentSeason: "最近3月",
            recentHalfYear: "最近半年",
            recentYear: "最近1年",
            willSend: '该消息发送的用户已超过100人，请确认！',
            send: "我发出的",
            receive: "我收到的",
            allPin: '全部寻呼',
            revokePin: '该寻呼已撤回！',
            firstStart: '请先选择开始时间',
            containKey: '内容包含“{{0}}”关键字',
            imgPrefix: '科协一家图片_'
        },
        updater: {
            status: {
                prepared: "新版本更新",
                finished: "已更新到最新版",
                failed: "更新出错",
                failedResult: "升级失败，请点击“立即更新”重试！"
            },
            updateProcess: {
                downloading: "正在下载更新包，请耐心等待（{{0}}% ）",
                updating: "安装更新中（{{0}}% ）",
                finished: "安装完成"
            }
        },
        emptyMessage: {
            pin: "暂无寻呼消息",
            star: "暂无常用联系人",
            newFriend: "暂无好友请求",
            newAlly: "暂无联盟单位申请",
            friend: "暂无好友",
            group: "暂无群组",
            conversation: "暂无会话",
            approve: "暂无入群申请",
            searchPin: "没有搜索到“{{0}}”相关的结果",
            searchHigt: '没有搜索到相关的结果'
        },
        voip: {
            shareScreen: "屏幕共享",
            audio: "语音通话",
            video: "视频通话",
            unAccept: "未接听",
            end: "已结束",
            audioTip: "正在语音通话中！",
            videoTip: "正在视频通话中！",
            shareScreenTip: "正在屏幕共享中！",
            summaryCodeMap: {
                1: '已取消',
                2: '已拒绝',
                3: '通话时长 ',
                4: '己方忙碌',
                5: '未接听',
                6: '己方不支持当前引擎',
                7: '己方网络出错',
                8: '其他设备已处理',
                11: '对方已取消',
                12: '对方已拒绝',
                13: '通话时长 ',
                14: '对方忙碌中',
                15: '对方无应答',
                16: '对方不支持当前引擎',
                17: '对方网络错误',
                18: 'voip 不可用'
            }
        },
        components: {
            upgrade: {
                forceUpgrade: "当前版本已不可用，请下载新版本！",
                confirmUpgrade: "检测到新的客户端版本，是否下载？",
                title: "升级版本"
            },
            appversion: {
                title: "功能介绍",
                show: "查看"
            },
            getFileHelper: {
                title: "文件小助手",
                desc: "可以在手机与电脑间互传文件与消息",
                prompt: "可以在手机与电脑间互传文件与消息",
                start: "发起会话"
            },
            groupTransfer: {
                title: "选择新群主",
                message: "确定选择{{0}}为新群主，你将自动放弃群主身份？"
            },
            groupBanned: {
                title: "选择联系人",
                bannedAll: "全员禁言",
                silenterMembers: "被禁言成员",
                speakerMembers: "可发言成员",
                banned: "你已经被群主禁言"
            },
            signup: {
                title: "注册",
                nickNameTip: "请输入昵称",
                mobileEmptyTip: "请输入手机号",
                mobileErrTip: "请检查手机号格式",
                captchaTip: "请输入验证码",
                captcha: "短信验证码",
                pwdTip: "请输入密码",
                pwdLenTip: "密码包含数字、字母，长度6-16位，区分大小写",
                pwdHasSpace: "密码不能包含空格",
                sendCaptcha: "发送验证码",
                // 界面布局原因这里使用英文括号比较合适
                sentCaptcha: "已发送 ({{0}})"
            },
            login: {
                scanLogin: "扫码登录",
                pwdLogin: "密码登录",
                QRCodeExpired: "您的二维码已经失效，",
                refreshTip: "请点击下方的刷新按钮",
                scanTip: "请扫描二维码登录",
                refresh: "刷新",
                mobileEmptyTip: "请输入手机号",
                mobileErrTip: "请检查手机号格式",
                account: "请输入帐号",
                verificationCode: '请输入验证码',
                inputPwd: "请输入密码",
                accountEmptyTip: "请输入手机号/帐号",
                noPwdTip: "请输入密码",
                autoLogin: "记住密码",
                forgetPwd: "忘记密码",
                newRegisty: "新用户注册",
                clearStorageWarn: "帐号或密码错误，还有 1 次登录机会，如再次错误将清空本地数据",
                textLogin: "短信登录",
                captchaTip: "请输入验证码",
                captcha: "短信验证码",
                sendCaptcha: "发送验证码",
                sentCaptcha: "已发送 ({{0}})"
            },
            search: {
                chatHistory: "聊天记录",
                resultHistory: "{{0}}条相关聊天记录",
                resultHistoryDetail: "{{0}}条与{{1}}相关聊天记录"
            },
            addFriend: {
                title: "外部联系人",
                searchTip: "输入联系人手机",
                contactName: "输入联系人姓名",
                contactRemark: "输入联系人备注（可选）",
                nameEmptyTip: "请输入联系人姓名",
                mobileEmptyTip: "请输入手机号",
                mobileErrorTip: "手机号格式有误",
                mobileErrTip: "请检查手机号格式",
                searchEmpty: "无法找到该用户，请检查输入帐号"
            },
            friends: {
                title: "个人通讯录"
            },
            contactGroup: {
                title: "我的群组"
            },
            contactApprove: {
                title: "入群申请"
            },
            contactList: {
                contactOrg: "组织架构",
                myDept: "我的组织",
                contactStar: "常用联系人",
                newFriend: "好友申请",
                contactFriend: "个人通讯录",
                contactGroup: "我的群组",
                contactApprove: "入群申请"
            },
            requestFriend: {
                title: "新的好友",
                accept: "接受",
                sent: "已发送",
                expired: "已过期",
                added: "已添加"
            },
            requestAlly: {
                title: "新的联盟单位申请",
                add: "添加",
                added: "已添加"
            },
            contactStar: {
                title: "常用联系人"
            },
            user: {
                editAvatar: "修改头像",
                removeFriend: "删除好友",
                addFriend: "添加好友",
                unsetStar: "取消重要联系",
                setStar: "设为重要联系人",
                setStarMessage: "添加重要联系人成功",
                unsetStarMessage: "取消重要联系人成功",
                aliasEmpty: "添加备注名",
                removeFriendBefore: "将该好友删除，将同时删除与该好友的聊天记录。"
            },
            userRequest: {
                editAvatar: "修改头像",
                removeFriend: "删除好友",
                addFriend: "添加好友",
                unsetStar: "取消常用联系人",
                setStar: "设为常用联系人2",
                aliasEmpty: "添加备注名",
                accept: "通过验证",
                removeFriendBefore: "将该好友删除，将同时删除与该好友的聊天记录！",
                requestInfo: "，请求加你为好友！"
            },
            verifyFriend: {
                title: "验证申请",
                tip: "你需要发送验证请求，对方通过后才能添加其好友。",
                iam: "我是"
            },
            ack: {
                title: "消息接收人详情",
                unreadMember: "{{0}}人未读",
                readMember: "{{0}}人已读"
            },
            atPanel: {
                everyone: "所有人"
            },
            card: {
                selected: "",
                empty: ""
            },
            conversationSetting: {
                title: "聊天设置",
                mute: "消息免打扰",
                top: "置顶聊天"
            },
            publicDetail: {
                title: "聊天设置",
                mute: "消息免打扰",
                top: "置顶聊天",
                enter: "进入应用"
            },
            conversation: {
                setting: "聊天设置",
                groupSetting: "群设置",
                groupNotice: "群公告",
                history: "历史消息"
            },
            forward: {
                forwarded: "已转发",
                forwardedFailed: "此消息已被撤回",
                success: "群主转让成功"
            },
            groupSetting: {
                title: "群设置",
                groupName: "群名称",
                admin: "群主",
                mute: "消息免打扰",
                top: "置顶聊天",
                saveContact: "保存到通讯录",
                saveGroup: "保存为群聊",
                member: "群成员",
                joinPermit: "入群验证",
                joinPermitMemo: "新成员需要群主验证同意，才能加入该群",
                banned: "群内禁言",
                bannedMemo: "可以设置全员禁言，也可以添加指定群成员不允许发言",
                setting: "设置",
                dismiss: "解散群组",
                groupAlias: "我在本群的昵称",
                unSetting: "未设置",
                groupAliasSetting: "设置你在此群的昵称，该昵称仅在此群内显示",
                quitMemo: "确认退出群组？",
                dismissMemo: "解散群组后, 所有群成员将失去群友联系，同时该群所有聊天图片、文件也将被永久删除",
                qrcode: "群二维码",
                onlyOwnerManage: "仅群主管理",
                onlyOwnerManageMemo: "启用后，其他成员不能添加群成员和编辑群公告",

            },
            groupNotice: {
                title: "群公告",
                sentTime: "发布时间",
                empty: "该群暂时没有群公告",
                inputText: "输入群公告内容",
                clear: "确定清空群公告？",
                edit: "编辑公告",
                new: "新建",
                cancel: "是否取消发布该条公告？",
                confirm: "该群公告将以 @所有人 的方式发送群消息，通知全部成员，是否发布？",
                onlyOwnerManage: "此群已开启仅群主可管理权限，当前仅群主可操作群公告”并跳转回“群公告"
            },
            groupQrcode: {
                tips: "扫一扫群二维码，立刻加入该群"
            },
            history: {
                title: "消息记录",
                all: "全部",
                file: "文件",
                image: "图片",
                empty: "暂无聊天记录"
            },
            messageInput: {
                emoji: "表情",
                screenshot: "截图(Ctrl+Alt+S)",
                screenshotmac: "截图(Ctrl+Cmd+S)",
                screenshotMaxSize: "发送的截图不能大于{{0}}",
                sendFile: "发送文件",
                sendCard: "发送名片",
                hideWindow: "截屏时隐藏聊天窗口",
                zeroSize: "不能发送大小为 0 KB 的文件",
                banned: "禁言中",
                overSize: "发送的文件不能大于{{0}}",
                voiceCall: '语音通话',
                videoCall: '视频通话',
                chatRecord: '聊天记录',
                buildChain: '接龙',
                chainPlaceholder: '请输入接龙内容'
            },
            previewImage: {
                title: "发送图片"
            },
            forgetPassword: {
                title: "重置密码"
            },
            stepPhone: {
                phone: "手机号",
                phoneEmpty: "请输入手机号",
                phoneInvalid: "请检查手机号格式",
                captchaEmpty: "请输入验证码",
                captcha: "验证码",
                sendCaptcha: "发送验证码",
                sentCaptcha: "已发送 ({{0}})",
                next: "下一步"
            },
            stepPassword: {
                passwordEmpty: "请输入密码",
                confirm: "完成",
                passwordInvalid: "密码长度为6-16位",
                newPassword: "新密码",
                tipPwd: "密码包含数字、字母，长度6-16位，区分大小写",
                enterNewPwd: "确认新密码",
                newPwdEmpty: "请再次输入密码",
                newPwdInvalid: "两次密码输入不一致"
            },
            stepSuccess: {
                title: "密码重置成功"
            },
            onlineStatus: {
                online: "在线",
                leave: "离开",
                busy: "忙碌",
                offline: "离线",
                mobile: "手机在线"
            },
            logout: {},
            welcome: {
                title: "| 科协一家",
                motto: "新的一天 新的开始",
                contact: "组织",
                conversation: "消息",
                setup: "设置",
                pin: "寻呼",
                work: "工作台",
                home: "公共信息",
                // zhkx: '智慧科协2.1',
                collect: "收藏"
            },
            groupCreate: {
                groupName: "群名称",
                tip: "（非必填项）",
                createNotice: "群主已启用“入群验证”，群主同意邀请后才会进入群聊",
                createSuccess: "创建群成功",
                addMemberSuccess: "添加群成员成功",
                addMemberPermit: "成员邀请已发送",
                groupNameErr: "群名称不少于2个字",
                onlyOwnerManageTips: "此群已开启仅群主可管理权限，当前仅群主可添加群成员"
            },
            groupRemovemembers: {
                selectDelTip: "请选择需要删除的联系人",
                delMemberSuccess: "删除群成员成功",
                selectNone: "至少要选择1个成员"
            },
            fileMessage: {
                openFile: "打开文件",
                openFolder: "打开文件夹",
                downloadFile: "下载文件",
                cancelled: "已取消",
                cancel: "取消",
                cancelState: "已取消",
                downloadState: "正在下载",
                receiveState: "已接收",
                sendingState: "正在发送",
                sentState: "已发送",
                expiredState: "已失效",
            },
            cardMessage: {
                businessCard: "个人名片"
            },
            approvalMessage: {
                content: "{{0}}向你提出了审批",
                pending: "审批中",
                passed: "审批通过",
                refused: "审批拒绝",
                remind: "请及时审批",
                startTime: "开始时间",
                endTime: "结束时间",
                title: "审批"
            },
            quoteMessage: {
                file: "文件",
                link: "链接"
            },
            unknownMessage: {
                notSupport: "当前版本暂不支持查看此消息"
            },
            setting: {
                title: "设置",
                account: "帐号设置",
                password: "密码设置",
                system: "系统设置",
                about: "关于",
                help: "帮助",
                contacts: "反馈",
                postInfo: '岗位信息'
            },
            settingAccount: {
                phoneNull: "请输入手机号",
                inputCode: "输入短信验证码",
                codeSent: "验证码已发送至您的手机",
                code: "验证码：",
                inputLabelCode: "请输入验证码",
                regain: "后可重新获取",
                mobile: "手机号：",
                settingUp: "设置",
                change: "更换",
                againSendCode: "单击重新获取",
                cancel: "取消",
                setPhoneText: "请输入新的手机号",
                setPhoneRepetition: "该手机号已被其他账号绑定，如仍需绑定请联系管理员，电话010-68587825 内线 38681",
                errorPhoneMessage: '手机号格式不正确',
                errorCodeMessage: '验证码错误',
                errorNullCodeMessage: '请输入验证码',
                successPhoneMessage: '修改手机成功',
                newPhone: "新手机号：",
                quitTitle: "退出登录",
                quitMessage: "是否确定退出当前帐号",
                errorMessage: '16个字符以内',
                transfiniteMessage: '姓名仅支持中英文和数字'
            },
            settingSystem: {
                sysMsgNotify: "系统消息通知提示音",
                checkUpdate: "检查更新",
                language: "语言设置",
                downloadPath: "文件下载路径",
                downloadPathTips: "说明：点击“修改”按钮后，请在对话框中选择目录下的任意文件，作为文件下载路径",
                change: "修改",
                majorCompany: "主企业",
                autoStart: "开机时自动启动{{0}}",
                previewText: "通知显示消息详情",
                notifyText: "你收到一条新消息",
                atText: "{{0}}在群聊中@了你",
                shortcuts: "快捷键",
                searchShortcut: "搜索快捷键",
                screenshotShortcut: "截图快捷键",
                sendMessageShortcut: "发送消息快捷键",
                sendShortcutWin: "Enter 发送，Shift + Enter 换行",
                sendShortcutMac: "Return 发送，Shift + Return 换行"
            },
            settingAbout: {
                versionInfo: "版本信息"
            },
            settingPassword: {
                oldPwd: "原密码：",
                newPwd: "新密码：",
                confirmPwd: "确认密码：",
                tipOldPwd: "请输入原密码",
                tipNewPwd: "请输入新密码",
                tipPwdLen: "密码长度为6-16位",
                tipPwd: "密码包含数字、字母，长度6-16位，区分大小写",
                tipConfirmPwd: "请再次输入密码",
                tipMatchPwd: "两次密码输入不一致",
                errorCode: {
                    10101: "原密码错误"
                }
            },
            setPassword: {
                safe: "为了您的帐户安全请您",
                modify: "修改登录密码",
                newPwd: "新密码：",
                confirmPwd: "确认密码：",
                tipNewPwd: "请输入新密码",
                tipPwdLen: "6-16位字母和数字组合",
                tipPwd: "密码包含数字、字母，长度6-16位，区分大小写",
                tipConfirmPwd: "请再次输入密码",
                tipMatchPwd: "两次密码输入不一致",
                confirm: "确认"
            },
            editAvatar: {
                selectPic: "请选择图片",
                getAvatarTokenErr: "获取上传 token 失败"
            },
            status: {
                netErr: "当前网络不可用，请检查你的网络设置"
            },
            newPin: {
                contact: "常用联系人",
                addressList: "组织机构",
                friend: "个人通讯录",
                group: "我的群组",
                selectedContact: "已选择联系人 ({{0}})",
                content: "内容",
                attaCount: "{{0}}个附件",
                addAtta: "添加附件",
                addTips: "严禁存储、处理、传输涉密文件、信息",
                sendTime: "发送时间",
                immediatelySend: "立即发送",
                specificSend: "定时发送",
                sendType: "发送短信",
                sendMail: "邮件通知",
                sms: "是",
                app: "否",
                uploading: "文件正在上传中",
                pastTime: "不能选择过去的时间",
                mostReceive: "最多可选择{{0}}人，请删减人员后重试",
                mostAtta: "最多只能添加十个附件",
                success: "发送成功",
                mostContent: "最多只能输入5000字的内容",
                year: "年",
                month: "月",
                day: "日",
                hour: "时",
                minute: "分",
                failSend: "附件中有未上传完成文件不能发送",
                pinTitle: '请输入寻呼主题，可缺省',
                pinContent: '请填写寻呼内容，支持通过回车换行',
                delay: '定时',
                delayed: '已发送',
                successToPinPreview: '发送成功,请在‘寻呼’中查看'
            },
            addAttachment: {
                title: "添加附件",
                add: "添加附件",
                sendFaild: '发送失败',
                uploadFaild: "上传失败",
                renewDownload: "重新上传",
                resumeUpload: "继续上传",
                uploaded: "已上传",
                uploading: "正在上传",
                cancelled: "已取消",
                expired: "已失效",
                copyUrl: '复制附件地址',
                download: '下载',
                openfile: '查看',
                stoped: '已暂停'
            },
            addReceiver: {
                selectedContact: "已选择联系人 ({{0}})",
                selectedPrompt: "请选择需要添加的联系人",
                addSuccess: "加入成功"
            },
            receivedPin: {
                title: "我收到的寻呼",
                confirmed: "已确认",
                unConfirmed: "确认收到",
                reply: "回复({{0}})",
                replyNone: "回复",
                confirmReceived: "确认收到",
                emptyPin: "暂无寻呼消息",
                titleSearch: "主题",
                attachNameSearch: "附件名",
                contactsSearch: "联系人",
                contentSearch: "内容"
            },
            sendPin: {
                title: "我发出的寻呼",
                unConfirmed: "{{0}}人未确认"
            },
            pinDetail: {
                title: "寻呼详情",
                confirmed: "已确认 ({{0}})",
                unConfirmed: "未确认 ({{0}})",
                confirmDetail: "确认详情",
                receiver: "接收人",
                resend: "重发短信",
                input: "请输入回复内容",
                inputSendSee: "请输入回复内容(仅自己和发送人可见)",
                inputAll: '请输入回复内容(全部可见)',
                unConfirmedCount: "{{0}}人未确认",
                inputCanNotEmpty: "回复内容不能为空",
                resendToAll: "通知所有人",
                resendToUnconfirmed: "通知未确认用户",
                resendToAllTips: "通知所有人（{{0}}人）",
                resendToUnconfirmedTips: "通知未确认用户（{{0}}人）",
                allConfirmed: "已全部确认",
                noUnConfirm: '无未确认用户'
            },
            pinSearch: {
                content: "搜内容",
                sender: "搜发送者",
                receiver: "搜接收者",
                attachment: "搜附件"
            },
            approve: {
                wait: "通过",
                already: "已通过",
                overdue: "已过期",
                invalid: "已失效",
                applyto: "申请加入",
                inviter: "邀请人"
            },
            upgradeSuccess: {
                tips: "升级完成！"
            },
            upgradeFailed: {
                tips: "升级失败，请点击“升级更新”重试！"
            },
            upgradeUpgrading: {
                tips: "升级完成{{0}}%"
            },
            upgradeDetail: {
                version: "{{0}}版本",
                feature: "新版本特性"
            },
            device: {
                tips: "电脑端已被锁定",
                note: "你可以在手机端会话列表顶部状态栏解锁",
                button: "在手机上解锁",
                locked: "设备已被锁定",
                erase: "请重新登录"
            },
            remoteControl: {
                title: "远程桌面",
                controlTitle: "远程控制",
                controledTitle: "远程协助",
                controledPanel: "远程协作",
                receiveRequest: "{{0}}请求控制您的电脑",
                receiveInvite: "{{0}}邀请您进行远程协助",
                accept: "接受",
                reject: "拒绝",
                cancel: "取消",
                disconnect: "断开",
                choose: "请选择接受或拒绝该邀请",
                request: "请求控制{{0}}电脑",
                invite: "邀请{{0}}远程协助中",
                building: "正在建立连接...",
                controlling: "您正在控制{{0}}的电脑",
                controled: "{{0}}正在控制您的电脑",
                wait: "正在等待对方接受邀请...",
                busy: "正在进行远程控制!",
                sendRequest: "请求控制对方电脑",
                sendInvite: "邀请对方远程协助",
                pushHangup: "远程协助结束",
                pushInvite: "{{0}}邀请您进行远程协助"
            },
            remoteHangup: {
                100: "已取消",
                101: "已拒绝",
                102: "远程控制连接已断开",
                103: "忙碌中",
                104: "未接听",
                105: "当前引擎暂不支持远程控制",
                106: "网络错误",
                107: "其他设备已处理",
                200: "对方已取消",
                201: "对方已拒绝",
                202: "远程控制连接已断开",
                203: "对方忙",
                204: "对方未接听",
                205: "当前引擎暂不支持远程控制",
                206: "网络错误",
                300: "远程控制连接失败"
            },
            collect: {
                all: '全部收藏',
                text: '文本',
                voice: '语音',
                position: '位置',
                video: '图片及视频',
                file: '文件',
                link: '链接',
                collected: '收藏于',
                second: '秒',
                null: '当前没有收藏',
                allCollect: '全部'
            },
            public: {
                tips: "此应用已关闭，暂时无法使用"
            },
            syncdataLoading: {
                failed: "数据更新异常，请重试",
                completed: "数据更新完毕",
                process: "数据正在更新，请耐心等待…"
            },
            voipInvitemember: {
                selectedMember: "已选成员（{{0}}）",
                audioMaxError: "音频通话最多支持{{0}}人",
                videoMaxError: "视频通话最多支持{{0}}人",
                audioMaxWarn: "音频通话最多支持{{0}}人，后续加入者以观察者身份加入",
                videoMaxWarn: "视频通话最多支持{{0}}人，后续加入者以观察者身份加入"
            },
            work: {
                todo: '待办({{0}})'
            }
        },
        errorCode: {
            'logout-by-otherclient': '您的PC端已退出登录',
            'kicked-offline-by-otherclient': '您的帐号已经在其他设备登录',
            'user-be-blocked': '用户被封禁',
            'user-status-updated': '欢迎加入{{0}}，请重新登录',
            'unknown-error': '未知错误',

            'old-password-error': '原密码错误',
            'new-password-same-old-password': '新密码不能与旧密码一致，请重试',
            'password-changed': '密码已修改，请重新登录！',
            'account-changed': '登录帐号已修改，请重新登录',
            'password-overtime': '密码已过期',

            'message-recall-timeout': '撤回失败，该消息的发送时间超过 3 分钟！',

            'network-error': '网络错误',
            'request-data-failed': '网络错误，获取数据失败',
            'request-failed': '网络请求失败',

            'invalid-config': '未能从config.js里取得appkey或server',
            'invalid-token': '无效的token',
            'require-captcha': '请先获取验证码',

            'card-limit': '单次只能发送一张名片',

            'forward-limit': '转发消息数量不能超过10个聊天',

            'download-interrupted': '下载中断',
            'download-cancelled': '已取消下载',
            'download-error': '下载失败',
            'download-overdue': '文件过期无法下载',
            'download-ebusy': '文件被其他程序占用',
            'download-eperm': '无文件写入权限',

            'upload-error': '上传失败',
            'upload-timeout': '上传超时',

            'file-404': '本地文件不存在或已被删除',
            'file-error': '本地文件获取失败',

            'status-1': '连接中',
            'status-2': '连接已断开',
            'status-3': '网络不可用',
            'status-4': '连接已关闭',
            'status-6': '帐号在其他设备已登录',
            'status-12': '域名不正确',
            'status-13': '用户被封禁',

            'contact-1': '至少要选择1个成员',
            'contact-2': '创建群成功',
            'contact-3': '删除成员成功',
            'contact-4': '添加成员成功',
            'contact-5': '退出群成功',
            'contact-6': '解散群成功',

            'lib--1': '请求超时',
            'lib--2': '未知错误',
            'lib-7': '网络不可用',
            'lib-20604': '发送频率过快',
            'lib-22406': '您当前不在此群组',
            'lib-21501': '消息被敏感词拦截',
            'lib-21502': '消息被敏感词替换',

            10001: '权限不足',
            10002: '不支持',
            // '10003': '一般错误',
            10004: '功能未实现',
            10005: '服务端异常',
            10006: '无效的请求参数',
            10009: '超过发送次数，请稍后重试!',
            15001: '超过发送次数，请稍后重试!',

            "10101-4": "帐号或密码错误，请重新输入",
            "10101-3": "帐号或密码错误，还有 3 次登录机会",
            "10101-2": "帐号或密码错误，还有 2 次登录机会",
            "10101-1": "帐号或密码错误，还有 1 次登录机会",

            10100: '帐号不存在，请重新输入',
            10101: '帐号或密码错误，请重新输入',
            10163: '验证码输入错误，请重新输入',
            10102: '用户未登录或登录信息过期',
            10103: '密码格式不对',
            10104: '昵称不能为空',
            10105: '昵称超过最大长度',
            10106: '头像URL不能为空',
            10107: '头像URL超过最大长度',
            10108: '用户未登录或登录信息过期',
            10109: '用户名为空',
            10110: '用户密码为空',
            10111: '帐号被禁用',
            10112: '获取token失败',
            10113: '用户id不能为空',
            10114: '密码不能为空',
            10115: '无效的手机号码',
            10116: '发送验证码频率过快',
            10117: '验证码已过期',
            10118: '请先发送验证码',
            10119: '请先校验验证码',
            10120: '验证码错误',
            10121: '用户已存在',
            10122: '登录token超时',
            10123: '登录token无效',
            10126: '原密码错误',
            10128: '帐号或密码多次错误，请{{0}}后再试或点击忘记密码',
            10130: '手机号已存在',

            10200: '所请求部门不存在',
            10201: '部门名不能为空',
            10202: '无效的部门ID',
            10203: '上级部门未找到',
            10204: '非法的创建者ID',
            10205: '创建者ID未找到',
            10206: '无效的ManagerID',
            10207: 'Manager未找到',
            10208: '无效的部门成员ID',
            10209: '部门成员为空',
            102010: '已经存在的部门ID',

            // '10400': '不支持的排序类型',
            // can not add yourself
            10400: '不能加自己为好友',
            // request not exist
            10401: '目标联系人不存在',
            // friend not found
            10402: '朋友不存在',
            // request is timeout
            10403: '请求已过期',
            // friendship is created
            10404: '已是朋友关系',

            10500: '未知员工',
            10501: '员工姓名不能为空',
            10502: '员工名已经存在',
            10503: '员工邮箱不能为空',
            10504: '员工邮箱已经存在',
            10505: '无效的员工ID',
            10506: '员工ID已经存在',
            10507: '管理员不存在',
            10508: '请填写手机号码',
            10509: '手机号码已存在',

            10600: '所请求群组不存在',
            10601: '群名称不能为空',
            10602: '群名称长度超过限制',
            10603: '群成员总数超过限制',
            10604: '当前操作用户所能建立的群组个数超过限制',
            10605: '所请求群成员不存在',
            10606: '群成员已经存在',
            10607: '无效的群组ID',
            10608: '无效的群组成员ID',
            10609: '对应的部门未找到',
            10610: '无效的对应部门ID',
            10611: '缺少群组类型',
            10612: '群组ID已经存在',
            10613: '官方群已存在',
            10614: '公司不存在',
            10615: '无效的公司ID',
            10626: '此群已开启仅群主可管理权限，当前仅群主可添加群成员',
            10645: '群成员最多{{0}}人',

            10700: '公司未找到',
            10701: '无效的公司ID',
            10702: '公司ID已经存在',
            10703: '空的公司名',
            10704: '空的公司全名',
            10705: '空的群组名',
            10706: '官方群已存在',
            10707: '无官方群',

            10800: '无效的收藏群组ID',
            10801: '对应的群组未找到',
            10802: '收藏群组不存在',

            10900: '对应联系人未找到',
            10901: '收藏的联系人不存在',

            11000: '未找到scope',
            11001: '未找到名称',

            12000: '无效的话题',

            13000: '未找到职位信息',

            11400: "不在收件人列表",
            11401: "不是pin的创建者",
            11402: "未确认",
            11403: "pin已经被删除",
            11404: "pin已经发送",
            11405: 'pin还未发送',
            12302: '设备已被锁定'
        }
    };
}(RongIM));