(function (RongIM, components) {
'use strict';

var utils = RongIM.utils;
var common = RongIM.common;
var browserWindow = RongIM.browserWindow;

components.getPSImageTextMessage = function (resolve, reject) {
    var options = {
        name: 'ps-image-text-message',
        props: ['message'],
        template: '#rong-template-ps-image-text',
        mixins: [getContextMenu()],
        computed: {
            content: function () {
                var content = this.message.content;
                var articles = content.articles;
                return articles[0] || {};
            }
        },
        created: function () {
            window.addEventListener('resize', this.handleResize);
        },
        beforeDestroy: function () {
            window.removeEventListener('resize', this.handleResize);
        },
        methods: {
            preview: function () {
                var url = this.content.url;
                var loginInfo = utils.cache.get('loginInfo');
                var zkxToken = decodeURIComponent(loginInfo.zkxToken);
                if (url.match(/\/taskcenter\//i) != null && loginInfo.RCESESSIONID) {
                    let urlParts = url.split('#');
                    url = urlParts[0] + (
                        urlParts[0].indexOf('?') > 0 ? '&' : '?'
                    ) + "sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                    "&uid=RY" + loginInfo.zkxEmpId + (
                        urlParts[1] ? ('#' + urlParts[1]) : ''
                    );
                }
                var bridgeUrl = RongIM.config.loginServer + '/sign-bridge.html' +
                                '?target=' + encodeURIComponent(url) +
                                '&token=' + encodeURIComponent(zkxToken + ';path=/') +
                                '&empId=' + (loginInfo.zkxEmpId || '');

                // 公共信息单独处理
                if (url.indexOf('/portlet/content/') > -1) {
                    this.$router.replace({name: 'publicHome', params: {
                        bridgeUrl: bridgeUrl
                    }});
                    return ;
                }
                
                browserWindow.openPSArticle(bridgeUrl);
            },
            forward: function (item) {
                var msgContent = common.buildMessage.RichContentMessage({
                    title: item.title,
                    imageUri: item.picurl,
                    content: item.digest,
                    url: item.url
                });
                this.$emit('forward', { content: msgContent });
            },
            remove: function () {
                this.$emit('remove', this.message);
            },
            collect: function () {
                var message = this.message;
                var item = message.content.articles[0];
                var sourceType;
                if (+message.conversationType === 7) {
                    sourceType = 3;
                }
                var params = {
                    scope: 'message',
                    type: 'RC:ImgTextMsg',
                    search_content: item.title,
                    fav_content: {
                        sender_id: message.senderUserId,
                        source_type: sourceType,
                        target_id: message.targetId,
                        content_id: message.messageUId,
                        url: '',
                        content: JSON.stringify({
                            title: item.title,
                            imageUri: item.picurl,
                            content: item.digest,
                            url: item.url,
                            messageName: 'RichContentMessage'
                        })
                    }
                };
                this.$emit('collect', params);
                this.closeContextmenu();
            },
            handleResize: function () {
                this.closeContextmenu();
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function getContextMenu() {
    var enableCollect = RongIM.config.modules.collect;
    var options = {
        template: 'templates/conversation/message-contextmenu.html',
        computed: {
            showSave: function () {
                return false;
            },
            showDownload: function () {
                return false;
            },
            showRecall: function () {
                return false;
            },
            showCopy: function () {
                return false;
            },
            showForward: function () {
                return true;
            },
            showCollect: function () {
                return enableCollect;
            },
            showQuote: function () {
                return false;
            }
        },
        methods: {
            forward: function () {
                this.$emit('forward', this.context.message);
            },
            remove: function () {
                this.$emit('remove', this.context.message);
            },
            collect: function () {
                this.$emit('collect', this.context.message);
            }
        }
    };
    return components.getContextMenu(options);
}
}(RongIM, RongIM.components));
