(function (RongIM, components) {
'use strict';

var utils = RongIM.utils;
var common = RongIM.common;
var browserWindow = RongIM.browserWindow;

components.getPSMultiImageTextMessage = function (resolve, reject) {
    var options = {
        name: 'ps-multi-image-text-message',
        props: ['message'],
        template: '#rong-template-ps-multi-image-text',
        mixins: [getContextMenu()],
        computed: {
            main: function () {
                var articles = [];
                var content = this.message.content;
                // Web SDK 与 C++ SDK 定义消息结构不一致导致
                if (content.richContentMessages) {
                    articles = content.richContentMessages.articles;
                } else {
                    articles = content.articles;
                }
                return articles[0];
            },
            subList: function () {
                var articles = [];
                var content = this.message.content;
                // Web SDK 与 C++ SDK 定义消息结构不一致导致
                if (content.richContentMessages) {
                    articles = content.richContentMessages.articles;
                } else {
                    articles = content.articles;
                }
                return articles.slice(1);
            }
        },
        created: function () {
            window.addEventListener('resize', this.handleResize);
        },
        beforeDestroy: function () {
            window.removeEventListener('resize', this.handleResize);
        },
        methods: {
            preview: function (item) {
                var url = item.url;
                var loginInfo = utils.cache.get('loginInfo');
                var zkxToken = decodeURIComponent(loginInfo.zkxToken);
                if (url.match(/\/taskcenter\//i) != null && loginInfo.RCESESSIONID) {
                    let urlParts = url.split('#');
                    url = urlParts[0] + (
                        urlParts[0].indexOf('?') > 0 ? '&' : '?'
                    ) + "sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
                    "&uid=RY" + loginInfo.zkxEmpId + (
                        urlParts[1] ? ('#' + urlParts[1]) : ''
                    );
                }
                browserWindow.openPSArticle(
                    RongIM.config.loginServer + '/sign-bridge.html' +
                    '?target=' + encodeURIComponent(url) +
                    '&empId=' + (loginInfo.zkxEmpId || '') +
                    '&token=' + encodeURIComponent(zkxToken + ';path=/')
                );
            },
            forward: function (item) {
                var msgContent = common.buildMessage.RichContentMessage({
                    title: item.title,
                    imageUri: item.picurl,
                    content: item.digest,
                    url: item.url
                });
                this.$emit('forward', { content: msgContent });
            },
            remove: function () {
                this.$emit('remove', this.message);
            },
            handleResize: function () {
                this.closeContextmenu();
            },
            collect: function (item) {
                var array = this.message.content.articles;
                var index;
                for (var i = 0; i < array.length; i += 1) {
                    if (item === array[i]) {
                        index = i; break;
                    }
                }
                var message = this.message;
                var sourceType;
                if (+message.conversationType === 7) {
                    sourceType = 3;
                }
                var params = {
                    scope: 'message',
                    type: 'RC:ImgTextMsg',
                    search_content: item.title,
                    fav_content: {
                        sender_id: message.senderUserId,
                        source_type: sourceType,
                        target_id: message.targetId,
                        content_id: message.messageUId + index,
                        url: '',
                        content: JSON.stringify({
                            title: item.title,
                            imageUri: item.picurl,
                            content: item.digest,
                            url: item.url,
                            messageName: 'RichContentMessage'
                        })
                    }
                };
                this.$emit('collect', params);
                this.closeContextmenu();
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function getContextMenu() {
    var enableCollect = RongIM.config.modules.collect;
    var options = {
        template: 'templates/conversation/message-contextmenu.html',
        computed: {
            showSave: function () {
                return false;
            },
            showDownload: function () {
                return false;
            },
            showRecall: function () {
                return false;
            },
            showCopy: function () {
                return false;
            },
            showForward: function () {
                return true;
            },
            showCollect: function () {
                return enableCollect;
            },
            showQuote: function () {
                return false;
            }
        },
        methods: {
            forward: function () {
                this.$emit('forward', this.context.message);
            },
            remove: function () {
                this.$emit('remove', this.context.message);
            },
            collect: function () {
                this.$emit('collect', this.context.message, this.context.index);
            }
        }
    };
    return components.getContextMenu(options);
}
}(RongIM, RongIM.components));
