(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;

components.getQuoteImagetext = function (resolve, reject) {
    var options = {
        name: 'quote-imagetext-message',
        props: ['message'],
        template: '#rong-template-quote-imagetext',
        computed: {
            content: function () {
                var content = this.message.content.content;
                content = utils.htmlLang.check(content);
                content = common.textMessageFormat(content);
                return common.highlight(content, this.keyword);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
