(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var userApi = RongIM.dataModel.User;

components.getQuoteMessage = function (resolve, reject) {
    var options = {
        name: 'quote-message',
        props: ['message'],
        data: function () {
            return {
                user: null
            };
        },
        template: '#rong-template-quote',
        components: {
            TextMessage: components.getQuoteText,
            ImageMessage: components.getQuoteImage,
            FileMessage: components.getQuoteFile,
            RichContentMessage: components.getQuoteImagetext
        },
        mounted: function () {
            var context = this;
            var userId = this.message.content.userId;
            userApi.get(userId, function (error, userInfo) {
                context.user = userInfo;
            });
        },
        computed: {
            type: function () {
                var typeMaping = {
                    'RC:TxtMsg': 'TextMessage',
                    'RC:ImgMsg': 'ImageMessage',
                    'RC:ImgTextMsg': 'RichContentMessage',
                    'RC:FileMsg': 'FileMessage'
                };
                return typeMaping[this.message.content.objName];
            },
            text: function () {
                var content = this.message.content.text;
                content = utils.htmlLang.check(content);
                content = common.textMessageFormat(content);
                return common.highlight(content, this.keyword);
            },
            isGroup: function () {
                return this.message.conversationType === utils.conversationType.GROUP;
            }
        },
        methods: {
            getGroupUsername: function (user) {
                var groupId = this.message.targetId;
                return common.getGroupUsername(user, groupId);
            },
            getUsername: function (user) {
                return common.getUsername(user);
            },
            showImage: function () {
                this.$emit('showImage', this.message);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
