/*
说明：好友验证请求消息
功能：
    发送消息时验证有一方为外部联系人并且不是互为好友则插入一条消息提示需要加为好友
*/
(function (RongIM, components) {
'use strict';

var utils = RongIM.utils;
var dialog = RongIM.dialog;

components.getRequestFriendVerificationMessage = function (resolve, reject) {
    var userApi = RongIM.dataModel.User;
    var options = {
        name: 'request-friend-verification-message',
        props: ['message'],
        template: 'templates/message/request-friend-verification.html',
        methods: {
            sendRequest: function () {
                var userId = this.message.targetId;
                userApi.get(userId, function (errorCode, user) {
                    if (errorCode) {
                        return;
                    }
                    dialog.verifyFriend(user);
                });
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
