/*
说明：设置 - 内容页(系统)
功能：
    邮箱绑定、解绑、验证
*/
(function (RongIM, components) {
    'use strict';
    
    var utils = RongIM.utils;
    var common = RongIM.common;
    components.getSettingEmail = function (resolve, reject) {
        var im = RongIM.instance;
        var orgApi = im.dataModel.Organization;
        var userApi = im.dataModel.User;
        var bindApi = im.dataModel.Bind;
        var supportLocales = [];
        $.each(RongIM.locale, function (key, locale) {
            supportLocales.push({
                value: key,
                name: locale.name
            });
        });
        var options = {
            name: 'setting-email',
            template: '#rong-template-email',
            data: function () {
                return {
                    // 绑定过的邮箱地址
                    emailValue: im.loginUser.email || '',
                    // 0 已绑定未验证 1已绑定验证 2解除绑定 3未绑定未验证 4邮箱格式错误 5邮箱已经绑定，联系客服 6重发验证码 7修改邮箱
                    emailStatus: im.loginUser.email_state == 2 ? 3 : im.loginUser.email_state,
                    timecountNum: 60,
                    timer: null,
                    title: '绑定邮箱',
                    content: ''
                };
            },
            computed: {
                isIptDisabled: function() {
                    if( this.emailStatus == 1 || !this.emailStatus ){
                        return true
                    }
                    return false
                },

                isDisabled: function() {
                    if(!this.emailValue) this.errorMessage = '';
                    if( this.timer && this.emailStatus ==7) {
                        return false
                    }
                    return Boolean(!this.emailValue && !this.timer);
                },

                showFix: function() {
                    return Boolean(!this.emailStatus || this.emailStatus == 8 || this.emailStatus == 6);
                },

                tipsMessage: function() {
                    if((this.emailStatus == 3 || !this.emailValue) && typeof(this.emailValue) == 'string') {
                        this.emailStatus = 3;
                        return '你填写的邮箱地址,需要验证。请放心填写,我们已对你的邮箱加密处理';
                    }
                    if(this.emailStatus == 1) {
                        return '已完成验证,如果您绑定的是科协企业邮箱,现在就可使用工作台的邮件系统了。';
                    }
                    if(this.emailStatus == 7) {
                        return '如果你更改了邮箱地址,将需要重新验证邮箱。';
                    }
                    return '';
                },

                errorMessage: function() {
                    if((!this.emailStatus || this.emailStatus == 6) && typeof(this.emailStatus) == 'number') {
                        return '该邮箱还未验证,请登录你的邮箱查收邮件并验证。';
                    }
                    if(this.emailStatus == 4) {
                        return "邮箱格式错误";
                    }
                    if(this.emailStatus == 5) {
                        return '邮箱' + this.emailValue + '已绑定科协一家账号，请解绑原账号或更换邮箱。';
                    }
                    return '';
                },

                buttonValue: function () {
                    if(this.emailStatus == 1) {
                        return '解绑邮箱';
                    }

                    if(!this.emailStatus && this.timer) {
                        let count = this.timecountNum >= 10 ? this.timecountNum + 's' : '0' + this.timecountNum + 's';
                        return '重发验证码(' + count + ')';
                    }

                    if((this.emailStatus == 6 || !this.emailStatus) && typeof(this.emailStatus) == 'number') {
                        return '重发验证码'
                    }

                    return '绑定邮箱';
                },
            },
            components: {
                createToast: components.createToast
            },
            watch: {},
            created() {this.upDateUserInfo();},
            mounted: function () {
                watchBindEmail(this, bindApi)
            },
            methods: {

                iptValidation() {
                    // let regEmail = /^[hicast.]+[a-zA-Z_-0-9]+@[cast\.org\.cn]$/;/^[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\\w\\.-]*[a-zA-Z0-9]\\.[a-zA-Z][a-zA-Z\\.]*[a-zA-Z]$/
                    let regEmail = /^[A-Za-z0-9]+([_\.][A-Za-z0-9]+)*@([A-Za-z0-9\-]+\.)+[A-Za-z]{2,6}$/;
                    if(!regEmail.test(this.emailValue)) {
                        return false;
                    }
                    return true;
                },

                // 修改邮箱进行绑定  ==> 新旧邮箱校验对比
                emailDataVil() {
                    orgApi.getOrgPath(im.loginUser.id, {}, (errorCode, result) => {
                        if(result && result.id) {
                            if( this.emailValue == result.email ) {
                                this.content = '与原有邮箱一致，请登录邮箱完成验证';
                                this.$refs.upDataEmailErr.show();
                            }else {
                                let params = {
                                    email: this.emailValue,
                                    uid: im.loginUser.id
                                };
                                if( this.timer) this.clearTime()
                                this.bindEmail(params);
                            }
                        }
                    })
                },
                
                // 绑定 解绑 验证 buttonClick
                sendEmail() {

                    // 当前有定时器并且该状态不是重新绑定
                    if( (this.timer && this.emailStatus != 7 ) || !im.loginUser.id) return;

                    // 设置邮箱格式错误  本地测试暂时去掉
                    if(!this.iptValidation()) {
                        this.emailStatus = 4;
                        return;
                    }

                    // 解绑邮箱
                    if(this.emailStatus == 1) {

                        this.title = '解绑邮箱';
                        this.content = '确定要解除当前邮箱的绑定吗?';

                        this.$refs.unBind.show();
                        return;
                    }
                    
                    let params = {
                        email: this.emailValue,
                        uid: im.loginUser.id
                    };

                    // 重新发送验证码
                    if((this.emailStatus == 6 || !this.emailStatus) && typeof(this.emailStatus) == 'number') {
                        this.resetSendEmailCode(params);
                        return;
                    }

                    // 修改邮箱重新绑定
                    if(this.emailStatus == 7) {
                        this.emailDataVil();
                        return
                    }

                    //绑定邮箱
                    this.bindEmail(params)
                },

                refresh(){
                    this.emailStatus = 0;
                    this.hide()
                    // this.upDateUserInfo();
                },

                // 绑定邮箱
                bindEmail(params) {
                    userApi.bindEmail(params, (errCode, result) => {
                        if(errCode == 10527 || errCode == 10129) {
                            this.emailStatus = 5;
                            return;
                        }

                        if(result.id) {
                            this.content = '一封验证邮件已发送至' + this.emailValue + ',请登录你的邮箱查收,并通过邮件验证。';
                            // this.resetSendEmailCode(params);
                            this.$refs.bind.show();
                            this.createTime();
                        }
                    });
                },

                // 发送邮箱验证码
                resetSendEmailCode(params) {
                    
                    userApi.resetSendEmailCode(params,(errorCode, result) => {
                        if(!errorCode) {
                            this.content = '一封验证邮件已发送至' + this.emailValue + ',请登录你的邮箱查收,并通过邮件验证。';
                            this.$refs.bind.show();
                            this.createTime();
                        }
                    });
                },

                //解绑邮箱
                unBindEmail() {
                    let params = {
                        email: this.emailValue,
                        uid: im.loginUser.id
                    };
                    userApi.unBindEmail(params, (errorCode,result) => {
                        if(errorCode) this.hide();
                        if(!errorCode) {
                            this.upDateUserInfo();
                        }
                    })
                },

                // 修改邮箱
                fixBindEmail() {
                    this.emailStatus = 7;
                    // this.clearTime();
                },

                cleanFixEmail() {
                    this.emailValue = im.loginUser.email;
                    this.emailStatus = 0;
                    // this.clearTime();
                },

                // 更新用户信息
                upDateUserInfo() {
                    orgApi.getOrgPath(im.loginUser.id, {}, (errorCode, result) => {
                        this.hide();
                        this.clearTime();
                        if(result && result.id) {
                            this.emailValue = result.email;
                            im.loginUser.email = result.email;
                            im.loginUser.email_state = result.email_state;
                            if( typeof(result.email_state) == 'string' && ( result.email_state == 2 )) {
                                this.emailStatus = 3;
                            }else {
                                this.emailStatus = result.email_state;
                            }
                        }
                    })
                },
                
                // 启动定时器
                createTime() {
                    this.emailStatus = 0;
                    this.timer = setInterval(() => {
                        if(this.timecountNum > 1 && this.timecountNum <= 60) {
                            this.timecountNum--;
                        }else {
                            this.emailStatus = 6;
                            this.clearTime();
                            this.upDateUserInfo();
                        }
                    }, 1000)
                },

                // 清除定时器
                clearTime() {
                    clearInterval(this.timer);
                    this.timer = null;
                    this.timecountNum = 60;
                },

                hide() {
                    if(this.$refs.bind) this.$refs.bind.hide();
                    if(this.$refs.unBind) this.$refs.unBind.hide();
                    if(this.$refs.upDataEmailErr) this.$refs.upDataEmailErr.hide();
                },

                resetEmail() {
                    
                }
            },
            beforeDestroy() {
                this.clearTime();
            },
            destroyed: function () {
                unwatch(this, bindApi);
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function watchBindEmail(context, bindApi) {
        context.upDataBindStatus = function() {
            common.messageToast({
                message: '邮箱绑定成功',
                type: 'success'
            });
            context.upDateUserInfo();
        }
        bindApi.watch(context.upDataBindStatus);
    }

    function unwatch(context, pinApi) {
        pinApi.unwatch(context.watchBindEmail);
    }
    
    }(RongIM, RongIM.components));
    