(function (RongIM, dependencies, components) {
    'use strict';
    console.log("tree-form");
    var utils = RongIM.utils;
    var common = RongIM.common;
    var $tree = $('div#menuTree');

    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }

    function imgLoaded(src, callback, onerror) {
        if (!src) {
            return;
        }
        var img = new Image();
        img.onload = callback;
        img.onerror = function () {
            if (typeof onerror === 'function') {
                onerror();
            }
        };
        img.src = transUrl(src);
    }

    /*
    说明：头像组件，用于显示头像，包括用户头像、群组头像、文件助手头像等
    */

    components.treeForm = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var options = {
            name: 'tree-form',
            template: '#tree-form',
            props: {
                dataList: {
                    type: Array,
                    default: () => []
                },
                showListType: {
                    type: Boolean,
                    default: false
                }
            },
            data: function () {
                return {
                    //当前点击的item
                    items: null,
                    top: 0,
                    isClick: true
                };
            },
            computed: {},
            filters: {},
            watch: {
                dataList: {
                    handler(newVal, oldVal) {
                        this.exampleTreeView(newVal)
                    },
                    immediate: true,
                    deep: true
                },
            },
            created() {
                console.log(this.$route,"*********************************")
            },
            mounted: function () {
                if (this.dataList.length > 0) this.exampleTreeView(this.dataList);
            },

            methods: {
                getAllParentNode(parentNode) {
                    var arry = [];
                    arry.push(parentNode);
                    //boolean i = true;
                    while (true) {
                        parentNode = $("#fixTree").treeview("getNode", parentNode.parentId);
                        if (parentNode.nodes) {
                            arry.push(parentNode);
                        } else {
                            break;
                        }
                    }
                    return arry;
                },
                addNextNode(event, node) {},
                /**
                 * 展开某个节点
                 * @param {Object} event 事件源
                 */
                openNodes(node) {
                    let tree = $('#fixTree');
                    //获取当前节点对象
                    tree.treeview('expandNode', node.nodeId);
                    tree.SelectedNodeIndex = node.nodeId;
                },
                /**
                 * 收起某个节点
                 * @param {Object} event 事件源
                 */
                retractNodes(node) {
                    let tree = $('#fixTree');
                    tree.treeview('collapseNode', node.nodeId);
                },
                //清除selected-node class
                removeSeleClass() {
                    let allClassList = $('.node-selected');
                    for (let i of allClassList) {
                        $(i).removeClass('node-selected')
                    }
                },
                //设置当前背景色
                setItemBgc(node) {
                    $('.' + node.onlyId).addClass('node-selected')
                    //选中当前点击
                    // node.state.selected = true;
                },
                //修改右边三角形状态
                itemRightIconType(itemTarget, itemNode) {
                    let itemDom = $(itemTarget.target).children('.fa');
                    if (itemNode.state.expanded) {
                        itemDom.removeClass('fa-angle-right');
                        itemDom.addClass('fa-angle-down');
                        return;
                    };

                    itemDom.removeClass('fa-angle-down');
                    itemDom.addClass('fa-angle-right');
                },
                searchSelect(){
                    let num = $('.BM8965_z').data('nodeid')
                    $('#fixTree').treeview('expandNode', [num, {
                        levels: 0,
                        silent: true
                    }]);
                    $("#fixTree").treeview('selectNode', [num, {
                        silent: true
                    }]); //默认选中
                },
                //设置根节点背景色
                setRootNode(node) {
                    let tree = $('#fixTree');
                    let parentNode = tree.treeview('getParent', node.nodeId);

                    if (node.root) {
                        $('.' + node.onlyId).addClass('node-selected')
                        return true
                    };

                    if (parentNode.root) {
                        parentNode.state.selected = true;
                        $('.' + parentNode.onlyId).addClass('node-selected');
                        return true
                    }
                    this.setRootNode(parentNode);
                },
                //收起全部节点
                retractAllNodes() {
                    let tree = $('#fixTree');
                    tree.treeview('collapseAll')
                },
                //实例化treeView
                exampleTreeView(treeViewParams,defaultSelect) {
                    // console.log(treeViewParams)
                    // debugger
                    let that = this;
                    $('#fixTree').treeview({
                        showCheckbox: true,
                        onNodeExpanded: that.addNextNode,
                        data: treeViewParams, // 树形菜单数据
                        emptyIcon: "icon-circle",
                        //enableLinks: false,
                        levels: 10, // 展开层级
                        tree: 'left',
                        //backColor: "transparent",// 背景
                        color: "black", // 文本颜色
                        // selectable: false,
                        selectedBackColor: "", // 选中时的背景色
                        selectedColor: '', //选中时的文本颜色
                        onhoverColor: "#e0e8f2", // hover时的颜色
                        // showBorder: false,
                        expandIcon: 'fa fa-angle-right', // 展开图标
                        collapseIcon: 'fa fa-angle-down', // 收缩图标
                        onNodeSelected: function (target, data) { // 选中事件
                        },
                        onItemClick: function (target, item) { //当前点击事件
                            let tree = $('#fixTree');
                            let nodeid = $(target.target).attr('data-nodeid');
                            let node = tree.treeview('getNode', nodeid);
                            //节点添加或删除成功后在执行
                            if (that.isClick) {
                                //科协组织云和联系人(通讯组之外)下的子节点不需要控制展开收起状态
                                if (item.rootType != "KXY" && (item.rootType != "myMailList" || (item.rootType == "myMailList" && item.root) || (item.rootType == "distributionGroup" && item.root))) {
                                    that.isClick = false;
                                    node.state.expanded = !node.state.expanded;
                                }
                                if (item.rootType == "distributionGroup" && item.id == 'pinGroup' && item.nodes.length == 0) {
                                    that.isClick = true;
                                }
                                // if (item.id == 'followDept' || item.id == 'followOrganization' || item.id == 'followWorkingGroup') {
                                //     that.isClick = false;
                                //     node.state.expanded = !node.state.expanded;
                                // }
                                //将当前点击节点通知上层
                                that.$emit('itemActive', item, target, function (res) {
                                    if (res != undefined) {
                                        tree.treeview("deleteChildrenNode", [item.nodeId, {
                                            node: res,
                                            silent: true
                                        }, false]);
                                        tree.treeview("addNode", [item.nodeId, {
                                            node: res,
                                            silent: true
                                        }, target.target, node]);
                                        if (item.rootType == 'distributionGroup') {
                                            res.forEach(obj => {
                                                let flag = $("li[class*='" + obj.id + "']")
                                                // 置顶
                                                if (obj.mainly && flag) {
                                                    flag[0].style.background = '#F4F3F3'
                                                    var child = document.createElement('div');
                                                    child.className = 'mainly-dot'
                                                    console.log(flag[0])
                                                    flag[0].appendChild(child);
                                                }
                                            })
                                            
                                            if(that.$route.params && that.$route.params.source == "search"){
                                                let selectObj = that.$route.params.item
                                                   $('.' + selectObj.id).addClass('node-selected')
                                                   $('.' + selectObj.id).click()
                                                
                                              }
                                              if(defaultSelect){
                                                $('.' + defaultSelect.id).addClass('node-selected')
                                                $('.' + defaultSelect.id).click()
                                              }
                                        }
                                       

                                    } else {
                                        that.isClick = true;
                                    }
                                })
                            }
                            that.removeSeleClass()
                            that.setItemBgc(node)
                            that.itemRightIconType(target, node)
                            that.setRootNode(node);
                        },
                        //节点添加完成或者删除完成后通知
                        addNodeSuccessCallBack: function () {
                            that.isClick = true
                        }
                    });
                    
                    if((this.$route.params && this.$route.params.source == "search") ||defaultSelect){
                        
                        that.retractAllNodes()
                        let num = $('.BM8965_z').data('nodeid')
                        //如果是在搜索页面进来的，获取通讯组dom并调用点击
                        $('#fixTree').treeview('expandNode', [num, {
                            levels: 1,
                            silent: true
                        }]);
                        $("#fixTree").treeview('selectNode', [num, {
                            silent: true
                        }]); //默认选中
                        
                       let nodes = $('#fixTree').treeview('getSelected')
                       if(nodes && nodes.length > 0 && nodes[0].id == 'BM8965_z'){
                         $('.pinGroup').click()
                       }
                       
                    }else{
                        $('#fixTree').treeview('expandNode', [0, {
                            levels: 0,
                            silent: true
                        }]);
                        $("#fixTree").treeview('selectNode', [0, {
                            silent: true
                        }]); //默认选中
                    }
                   
                  
                }
            },
            destroyed: function () {}
        };
        utils.asyncComponent(options, resolve, reject);
    };
}(RongIM, null, RongIM.components));