(function (RongAppversion) {
'use strict';

var utils = RongAppversion.utils;
var cache = utils.cache;
var serverApi = RongAppversion.serverApi;

function init(config) {
    cache.setKeyNS(config.appkey);
    var pcWin = RongAppversion.browserWindow;
    var appversion = new Vue({
        el: config.el,
        data: {
            config: config,
            isMaxWindow: false,
            versionList: [],
            selected: null
        },
        computed: {
            os: function () {
                return pcWin.platform;
            },
            locale: function () {
                var locale = this.config.locale;
                RongAppversion.locale[locale].product = this.config.product;
                return RongAppversion.locale[locale];
            },
            selectedNote: function () {
                var note = this.selected.release_note;
                // note = '当前版本的描述\n当前版本的描述\n当前版本的描述\n当前版本的描述\n当前版本的描述\n';
                return note.split('\n').filter(function (item) {
                    return item;
                });
            }
        },
        methods: {
            min: function () {
                pcWin.min();
            },
            max: function () {
                pcWin.max();
                this.isMaxWindow = true;
            },
            restore: function () {
                pcWin.restore();
                this.isMaxWindow = false;
            },
            close: function () {
                pcWin.close();
            },
            getTime: function (version) {
                var timestamp = version.create_dt;
                return utils.dateFormat(timestamp, {
                    // alwaysShowTime: true
                });
            },
            selectVersion: function (version) {
                this.selected = version;
            }
        },
        mounted: function () {
            setupVersionList(this);
        }
    });
    RongAppversion.instance = appversion;
}

function setupVersionList(context) {
    serverApi.getAppVersions(function (errorCode, result) {
        if (errorCode) {
            console.warn(errorCode);
            return;
        }
        context.versionList = result;
        context.selected = context.versionList[0];
    });
}

RongAppversion.init = init;
}(window.RongAppversion));
