/**
 * 说明： 寻呼闹钟图标 定时器 
 * @param {pin} 每一条寻呼的详情
 */
(function (RongIM, dependencies, components) {
    'use strict';

    var utils = RongIM.utils;
    
    components.getAlarmClock = function (resolve, reject) {

        var options = {
            name: 'alarm-clock',
            template: 'modules/pin/templates/alarm-clock.html',
            data: function () {
                return {
                    isShowDelayedIcon: false,
                    isSendeddIcon:false,
                    timer: null
                };
            },
            props: {
                pin:{
                    type: Object,
                    default: () => {}
                },
                kay:{
                    type: Number,
                    default: 0
                }
            },
            watch: {},
            created() {
                this.init();
            },
            computed: {},
            methods: {
                init() {
                    let that = this,sendTime = that.pin.delayed_send_dt,thisTime = new Date().getTime();
                    this.isShowDelayedIcon = sendTime > thisTime;
                    this.isSendeddIcon = that.pin.delayed&&!this.isShowDelayedIcon;
                    if (JSON.stringify(this.pin) == "{}" || !this.pin.delayed) this.isShowDelayedIcon = false;
                    if(this.isShowDelayedIcon) {
                        that.timer = setInterval(() => {
                            thisTime = new Date().getTime();
                            that.isShowDelayedIcon = sendTime > thisTime;
                            this.isSendeddIcon = sendTime < thisTime
                            if(!that.isShowDelayedIcon){
                                clearInterval(that.timer);
                                that.$emit('pinPushed')
                            } 
                        },1000)
                    }
                    
                },
                dateFormat: function (pin) {
                    var timestamp = pin.delayed ? pin.delayed_send_dt : pin.create_dt;
                    var dateFormat = utils.dateFormat;
                    var options = {
                        alwaysShowTime: true
                    };
                    return dateFormat(timestamp, options);
                }
            },
            beforeDestroy() {
                //清除定时器
                clearInterval(this.timer);
            },
        };
        utils.asyncComponent(options, resolve, reject);
    };
    }(RongIM, null, RongIM.components));
    