(function (RongIM, dependencies, components) {
    'use strict';
    var common = RongIM.common;
    components.getPinSearch = function (resolve, reject) {
        var utils = RongIM.utils;
        var im = RongIM.instance;
        var options = {
            name: 'pinSearch',
            template: '../../modules/pin/templates/search.html',
            props: {
                owner: im,
                searchHint: {
                    type: String,
                    default: im ? im.locale.btns.search : ''
                },
                searchText: {
                    type: String,
                    default: ''
                },
                readonly: false,
                iswork:{
                    type: Boolean,
                    default: false
                }
            },
            data: function () {
                return {
                    keyword: localStorage.getItem('searchText') || '',
                    oldkeyword: '',
                    timer: null,
                    ifHigtSearch: false,
                    showSearch:true,
                };
            },
            watch: {
                // searchText: function (val) {
                //     this.keyword = val;
                //     this.search();
                //     this.launch();
                // },
                keyword: function (v) {
                    // this.search()
                    // if(this.iswork){
                    //     if(v && v!=''){
                    //         this.showSearch = false
                    //     }else{
                    //         this.showSearch = true
                    //     }
                       
                    // }else{
                        this.showSearch = true
                    // }
                    this.launch();
                }
            },
            methods: {
                clear: function () {
                    this.keyword = '';
                    this.launch();
                },
                search: function () {
                    if (this.keyword == '') {
                        return false;
                    }
                    var context = this;
                    if (this.timer) {
                        clearTimeout(this.timer);
                    }
                    this.timer = setTimeout(function () {
                        context.launch();
                        context.timer = null;
                    }, 500);
                },
                searchPin: function () {
                    if (!this.readonly) {
                        if (this.keyword == '') {
                            common.messageToast({
                                type: 'error',
                                message: '请输入关键字'
                            });
                            return;
                        }
                        this.$refs.searchPin.focus()
                        this.$emit('search', {
                            keyword: this.keyword,
                            hint: this.searchHint
                        })
                    } else {
                        this.$emit('searchHigtPin')
                    }

                },
                launch: function () {
                    this.oldkeyword = this.keyword;
                    this.$emit('search', {
                        keyword: this.keyword,
                        hint: this.searchHint
                    });
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };
}(RongIM, null, RongIM.components));