/*
说明： 音视频 (VoIP) 桌面版为独立窗口通过 ipcRenderer 和主窗口相互通信
       接收主窗口发来的命令或 IM 消息执行对应操作并反馈。
步骤：  1. 发起音视频
            1.1 接收到主窗口发起的 "Call" 命令根据传入参数发起音视频会话。
            1.2 等待对方同意(会接收到 IM 消息 AcceptMessage)或拒绝(接收 IM 消息 HungupMessage)
            1.3 对方无操作 1 分钟自动超时触发 SummaryMessage
            1.4 结束会话(调用 hungup 方法) 对方结束会话 (会接收到 IM 消息 HungupMessage)
        2. 接收音视频
            2.1 接收到主窗口发送的 IM 消息"InviteMessage"。
            2.2 可以接受(调用 accept 方法)或拒绝(调用 reject 方法)
                3、4 同发起音视频

*/
(function (Voip, dependencies) {
'use strict';

var Vue = dependencies.Vue;
var RongCallLib = dependencies.RongCallLib;
var location = dependencies.location;
var $ = dependencies.jQuery;
// 强制退出，用于关闭窗口前提示确认。
var confirmeQuit = false;
var layer = window.layer;
// Voip 类型 1：语音 2 视频
var CallType = {
    MEDIA_AUDIO: 1,
    MEDIA_VEDIO: 2
};

// 通话状态
var RCCallStatus = {
    RCCallDialing: 1,
    RCCallIncoming: 2,
    RCCallRinging: 3,
    RCCallActive: 4,
    RCCallHangup: 5
};

/*
说明： 会话类型
        1. 单聊
        2. 讨论组
        3. 群组
*/
var ConversationType = {
    Private: 1,
    Discussion: 2,
    Group: 3
};

var utils = {
    /*说明： 获取当前 url 的 query 参数*/
    getQuery: function () {
        var result = {};
        var query = location.search.substring(1);
        var list = query.split('&');
        for (var i = list.length - 1; i >= 0; i--) {
            var item = list[i].split('=');
            result[item[0]] = item[1];
        }
        return result;
    },
    /*说明： 数字前使用 "0" 补位 默认两位*/
    prefixZero: function (str, length) {
        length = length || 2;
        return (Array(length).join(0) + str).slice(-length);
    },
    /*说明： 将以秒为单位的时间转换成 hh:mm:ss 这种格式的时间 */
    secondToMinute: function (value) {
        value = Math.round(value);
        var hour = Math.floor(value / 3600);
        value = value % 3600;
        var minute = utils.prefixZero(Math.floor(value / 60));
        var second = utils.prefixZero(value % 60);
        return (hour > 0 ? hour + ':' : '') + minute + ':' + second;
    },
    /*说明： 字符串格式化，将字符 source 中 "{{数字}}" 替换成 params 中对应的值， 双括号中"数字"为 params 下标*/
    templateFormat: function (source, params) {
        var undef;
        if (arguments.length === 1) {
            return function () {
                var args = $.makeArray(arguments);
                args.unshift(source);
                return $.validator.format.apply(this, args);
            };
        }
        if (params === undef) {
            return source;
        }
        if (arguments.length > 2 && params.constructor !== Array) {
            params = $.makeArray(arguments).slice(1);
        }
        if (params.constructor !== Array) {
            params = [params];
        }
        $.each(params, function (i, n) {
            source = source.replace(new RegExp('\\{{' + i + '\\}}', 'g'), function () {
                return n;
            });
        });
        return source;
    }
};

// var ring = {
//     audio: null,
//     play: function () {
//         if (!ring.audio) {
//             ring.audio = document.createElement('audio');
//             ring.audio.loop = true;
//             ring.audio.src = 'data:audio/mp3;base64,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';
//         }
//         ring.audio.play();
//     },
//     stop: function () {
//         ring.audio.pause();
//         ring.audio.currentTime = 0;
//     }
// };
/*说明： 使用 audio 标签播放声音 来电铃声和等待铃声*/
var sound = {
    ringAudio: null,
    waitAudio: null,
    playRing: function () {
        if (!sound.ringAudio) {
            sound.ringAudio = document.createElement('audio');
            sound.ringAudio.loop = true;
            sound.ringAudio.src = 'data:audio/mp3;base64,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';
        }
        sound.ringAudio.play();
    },
    stopRing: function () {
        sound.ringAudio.pause();
        sound.ringAudio.currentTime = 0;
    },
    playWait: function () {
        if (!sound.waitAudio) {
            sound.waitAudio = document.createElement('audio');
            sound.waitAudio.loop = true;
            sound.waitAudio.src = 'data:audio/mp3;base64,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';
            // sound.waitAudio = document.querySelector('#soundwaiting');
        }
        sound.waitAudio.play();
    },
    stopWait: function () {
        sound.waitAudio.pause();
        sound.waitAudio.currentTime = 0;
    }
};

var videoEleCache = {};

function init(config) {
    $.extend(Voip.config, config);

    var voip = new Vue({
        el: config.el,
        data: {
            config: Voip.config,
            closeBefore: false,
            tip: '',
            isMaxWin: false,
            isShareScreen: false,
            waiting: true,
            time: 0,
            type: CallType.MEDIA_VEDIO,
            status: '',
            conversation: {},
            self: {
                name: ''
            },
            senderUser: {},
            memberList: [],
            main: {},
            other: [],
            isMac: isMac(),
            /*会议控制*/
            normalMeetUsers: [],
            obersers: [],
            remove: false,
            reqSparkUser: {},
            currentDialogUser: {},
            showWhiteBoard: false,
            openMember: false,
            whiteBoard: false,
            networkErrorVisible: false,
        },
        created: function () {
            var query = utils.getQuery();
            created(this, query);
        },
        computed: {
            locale: function () {
                return Voip.locale[this.config.locale];
            },
            isPrivate: function () {
                return this.conversation.conversationType === 1;
            },
            isVideo: function () {
                return this.type === CallType.MEDIA_VEDIO;
            },
            isAudio: function () {
                return this.type === CallType.MEDIA_AUDIO;
            },
            // // 过滤空值，用于排查问题
            // validNormalMeetUsers: function() {
            //     return this.normalMeetUsers.filter(function (item, i) {
            //         if (!item) {
            //             console.warn('normalMeetUsers item is null', i);
            //             return false;
            //         }
            //         return true;
            //     });
            // },
            // // 过滤空值，用于排查问题
            // validObersers: function() {
            //     return this.obersers.filter(function (item, i) {
            //         if (!item) {
            //             console.warn('obersers item is null', i);
            //             return false;
            //         }
            //         return true;
            //     });
            // }
        },
        directives: {
            video: function (el, binding) {
                var item = binding.value;
                var videoEle = videoEleCache[item.id];
                if (!$.contains(el, videoEle)) {
                    $(el).find('video').remove();
                    $(el).append(videoEle);
                }
                if (videoEle && videoEle.paused) {
                    setTimeout(function () {
                        videoEle.play();
                    });
                }
            },
            scrollbarX: function (el, binding) {
                var nochanged = binding.value === binding.oldValue;
                if (nochanged) {
                    return;
                }

                var $el = $(el);
                if (!$el.data('init')) {
                    $el.data('init', true);
                    $el.append($('<b><i></i></b>'));
                    var scrollOuter = true;
                    var timeoutOuter;
                    var scrollInner = true;
                    var timeoutInner;
                    var $scrollbar = $el.children('b');
                    $scrollbar.on('scroll', function () {
                        if (scrollInner) {
                            var left = $scrollbar.scrollLeft();
                            $el.scrollLeft(left);
                            $scrollbar.css('left', left);

                            scrollOuter = false;
                            clearTimeout(timeoutOuter);
                            timeoutOuter = setTimeout(function () {
                                scrollOuter = true;
                            }, 500);
                        }
                    });
                    $el.on('scroll', function () {
                        if (scrollOuter) {
                            var left = $el.scrollLeft();
                            $scrollbar.scrollLeft(left);
                            $scrollbar.css('left', left);

                            scrollInner = false;
                            clearTimeout(timeoutInner);
                            timeoutInner = setTimeout(function () {
                                scrollInner = true;
                            }, 500);
                        }
                    });
                }
                var scrollbar = $el.children('b');
                scrollbar.hide();
                Vue.nextTick(function () {
                    $el.find('>b>i').css('width', el.scrollWidth);
                    scrollbar.show();
                });
            }
        },
        filters: {
            slice: function (name) {
                if (!name) {
                    return;
                }
                var isChinese = /^[^\x00-\xff]+$/.test(name);
                return isChinese ? name.slice(-1) : name[0].toUpperCase();
            }
        },
        methods: {
            templateFormat: utils.templateFormat,
            // 用于排查问题
            updateSelf: function (value) {
                // if (!value.name) {
                //     console.warn('updateSelf => name is', name);
                //     value.name = '';
                // }
                this.self = value;
            },
            getOtherName: function () {
                var context = this;
                var arr = this.memberList.filter(function (item) {
                    return [context.senderUser.id].indexOf(item.id) === -1;
                }).map(function (item) {
                    return item.name;
                });
                return arr.join('、');
            },
            /*说明： 显示头像图片*/
            showAvatarImg: function (item) {
                var showAvatar = item.waiting || !item.video || item.busy;
                return showAvatar && item.avatar;
            },
            /*说明： 显示头像第一个字符*/
            showAvatarSign: function (item) {
                var showAvatar = item.waiting || !item.video || item.busy;
                return showAvatar && !item.avatar;
            },
            /*说明： 头像显示字符时根据 id 获取背景色*/
            getThemeIndex: function (id) {
                var LENGTH = 6;
                return id ? (id.slice(-1).charCodeAt(0) % LENGTH) : 0;
            },
            /*说明： 隐藏 video 标签未连接时显示用户头像*/
            hiddenVideo: function (item) {
                return item.waiting || !item.video;
            },
            secondToMinute: utils.secondToMinute,
            max: function () {
                Voip.win.max();
                this.isMaxWin = true;
            },
            unmax: function () {
                Voip.win.unmax();
                this.isMaxWin = false;
            },
            min: function () {
                Voip.win.min();
            },
            close: function () {
                this.closeBefore = true;
            },
            enterClose: function () {
                confirmeQuit = true;
                if (this.status === 'ringing') {
                    this.reject();
                } else {
                    this.hungup();
                }
            },
            accept: function () {
                accept(this);
            },
            reject: function () {
                RongCallLib.reject(this.conversation);
            },
            hungup: function () {
                RongCallLib.hungup(this.conversation);
            },
            openVideo: function () {
                this.self.video = true;
                RongCallLib.audioToVideo();
            },
            closeVideo: function () {
                this.self.video = false;
                RongCallLib.videoToAudio();
            },
            openAudio: function () {
                this.self.audio = true;
                RongCallLib.unmute();
            },
            closeAudio: function () {
                this.self.audio = false;
                RongCallLib.mute();
            },
            switchAudio: function () {
                var context = this;
                context.type = CallType.MEDIA_AUDIO;
                context.memberList.forEach(function (item) {
                    item.video = false;
                });
                context.other = [].concat(context.memberList);
                context.closeVideo();
                Voip.win.setBounds(getWinSize(context));
            },
            addMember: function () {
                addMember(this);
            },
            switchMain: function (item) {
                var context = this;
                if (context.isVideo) {
                    var index = context.other.indexOf(item);
                    context.other.splice(index, 1);
                    context.other.push(context.main);
                    context.main = item;
                }
            },
            doRemoveUser: function (item) {
                var context = this;
                var user = getUser(this.memberList, item.id);
                var userId = user.id;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostRemoveUser(user.id);
                if (context.main.id === userId) {
                    context.main = context.other[0];
                    context.other.splice(0, 1);
                } else {
                    removeUser(context.other, userId);
                }
                removeUser(context.memberList, userId);
                removeUser(context.other, userId);
                removeUser(context.normalMeetUsers, userId);
                removeUser(context.obersers, userId);
                delete user['remove'];
                context.currentDialogUser = {};

            },
            removeUser: function (item) {
                var context = this;
                var user = getUser(this.memberList, item.id);
                context.currentDialogUser = user;
                context.currentDialogUser.remove = true;
            },
            upUser: function (item) {
                var userId = item.id;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostUpUser(userId);
            },
            becomeHost: function () {
                RongCallLib.Voip.getRtcPeer().blinkMeeting.getHostPower();
                layer.msg('你已经成为主持人');
                this.self.host = true;
                // this.$set(this.self,'host',true)
            },
            downUser: function (item) {
                var context = this;
                var user = getUser(this.memberList, item.id);
                context.currentDialogUser = jQuery.extend(true, {}, user);
                context.currentDialogUser.down = true;
            },
            doDownUser: function (item) {
                var user = getUser(this.memberList, item.id);
                var userId = user.id;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostRequestNormalUserToObserver(userId);
                delete user['down'];
                this.currentDialogUser = {};
            },
            requestBecomeUser: function () {
                RongCallLib.Voip.getRtcPeer().blinkMeeting.observerRequestBecomeNormalUser();
            },
            closeCamera: function (item) {
                var userId = item.id;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostRequestControlUserDevice(userId, 0x01, 0x02);
                var context = this;
                var user = getUser(context.memberList, userId);
                user.video = false;
            },
            openCamera: function (item) {
                var userId = item.id;
                /* var context = this;
                    var user = getUser(context.memberList,userId);
                    user.video = true;*/
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostRequestControlUserDevice(userId, 0x01, 0x01);

            },
            closeMic: function (item) {
                var userId = item.id;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostRequestControlUserDevice(userId, 0x02, 0x02);
                var context = this;
                var user = getUser(context.memberList, userId);
                user.audio = false;
            },
            openMic: function (item) {
                var userId = item.id;
                /* var context = this;
                    var user = getUser(context.memberList,userId);
                    user.audio = true;*/
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostRequestControlUserDevice(userId, 0x02, 0x01);

            },
            refuse: function () {
                this.reqSparkUser = {};
            },
            agree: function (item) {
                var context = this;
                var userId = item.id;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.hostDoObserverRequestBecomeNormalUser(userId, 0x01);
                var user = getUser(context.obersers, userId);
                context.normalMeetUsers.push(user);
                context.other.push(user);
                removeUser(context.obersers, userId);
                this.reqSparkUser = {};

            },
            shareScreen: function () {
                // In the renderer process.
                var context = this;
                RongDesktop.desktopCapturer.getSources({ types: ['screen'] }, function (error, sources) {
                    if (error) {
                        throw error;
                    }
                    var chromeMediaSourceId = sources[1].id;
                    navigator.getUserMedia({
                        audio: false,
                        video: {
                            mandatory: {
                                chromeMediaSource: 'desktop',
                                chromeMediaSourceId: chromeMediaSourceId,
                                minWidth: 1280,
                                maxWidth: 1920,
                                minHeight: 720,
                                maxHeight: 1080
                            }
                        }
                    }, getScreenMediaSuccess, getScreenMediaError);

                });
                function getScreenMediaSuccess(stream) {
                    context.self.share = true;
                    context.isShareScreen = true;
                    RongCallLib.rongRTCStream.publish({
                        id: context.self.id,
                        stream: {
                            tag: 'screen',
                            type: 2,
                            mediaStream: stream
                        }
                    });
                }
                function getScreenMediaError() {
                    console.log('getUserMediaError');
                }
            },
            endShareScreen: function () {
                var context = this;
                context.self.share = false;
                context.isShareScreen = false;
                RongCallLib.rongRTCStream.unpublish({
                    id: context.self.id,
                    stream: {
                        tag: 'screen',
                        type: 2,
                    }
                });
            },
            requestWhiteBoard: function () {
                RongCallLib.requestWhiteBoardURL();
            },
            closeWhiteBoard: function () {
                this.showWhiteBoard = false;
            },
            closeMember: function () {
                this.openMember = !this.openMember;
            },
            acceptBeRequestToUser: function () {
                var context = this;
                RongCallLib.Voip.getRtcPeer().blinkMeeting.doHostRequestToUser(this.currentDialogUser.hostId, 1);
                context.self.obeserver = false;
                context.currentDialogUser = {};

            },
            doControleUserDev: function (item) {

                RongCallLib.Voip.getRtcPeer().blinkMeeting.userDoHostRequestControlUserDevice(item.result.content.from, item.isOpen, item.result.content.type, 0x01);
                item.result.content.type == 1 ? item.user.video = true : item.user.audio = true;
                this.currentDialogUser = {};

            },
            audioHideSelf: function (item) {
                return item.id == this.self.id && this.isAudio;
            },
            networkErrorClose: function () {
                this.hungup();
            }
        }
    });
    Voip.instance = voip;
}
/**
 * 根据本地丢包率变化信号
 *
 */
// 根据本地丢包率变化信号

/*说明: 判读当前操作系统是否为 Mac*/
function isMac() {
    return navigator.userAgent.indexOf('Mac OS X') > 0;
}

/*说明： 显示文字提示框 => 关闭窗口前提示*/
/*function showTip(context, tip) {
    context.tip = tip;
    clearTimeout(showTip.timeout);
    showTip.timeout = setTimeout(function(){
        context.tip = '';
    }, 1000 * Voip.config.tipShowTime);
}*/

/*说明： 根据当前状态 （音视频类型，多人单人） 获取窗口配置大小*/
function getWinSize(context) {
    var key;
    if (context.type === CallType.MEDIA_AUDIO) {
        key = 'audio';
    } else {
        key = 'video';
    }
    if (context.conversation.conversationType === ConversationType.Group) {
        key += 'multi';
    }
    return Voip.config.winSize[key];
}

/*
说明： 音视频通话时间
*/
var startTime = null;
function startTiming(context) {
    startTime = new Date().getTime();
    context.time = 0;
    context.waiting = false;
    setInterval(function () {
        context.time = Math.round((new Date().getTime() - startTime) / 1000);
    }, 500);
}

/*说明：补全用户其他信息 是否等待连接中。视频是否打开，音频是否打开。是否忙碌中*/
function extraUserInfo(list, isVideo) {
    list.forEach(function (item) {
        Vue.set(item, 'waiting', true);
        Vue.set(item, 'video', isVideo);
        Vue.set(item, 'audio', true);
        Vue.set(item, 'busy', false);
        Vue.set(item, 'host', false);
    });
    return list;
}

var handlerCommand = {
    /*说明： 发起音视频会话*/
    Call: function (command, context) {
        context.conversation = {
            conversationType: command.conversationType,
            targetId: command.targetId
        };
        context.status = 'call';
        context.type = command.mediaType;
        context.isShareScreen = command.isShareScreen;
        var memberList = [command.self].concat(command.inviteUserList);
        extraUserInfo(memberList, context.isVideo);
        context.memberList = memberList;
        context.updateSelf(command.self);
        var inviteUserIds = command.inviteUserList.map(function (item) {
            return item.id;
        });
        var observerUserIds = command.inviteUserList.filter(function (t) {
            return t.obeserver;
        }).map(function (item) {
            return item.id;
        });
        if (context.isVideo) {
            context.main = context.self;
            /*     context.other = command.inviteUserList;
                    context.normalMeetUsers = command.inviteUserList;*/
            if (observerUserIds) {
                context.obersers = command.inviteUserList.filter(function (user) {
                    return observerUserIds.indexOf(user.id) > -1;
                });
                context.other = command.inviteUserList.filter(function (user) {
                    return observerUserIds.indexOf(user.id) < 0;
                });
                context.normalMeetUsers = command.inviteUserList.filter(function (user) {
                    return observerUserIds.indexOf(user.id) < 0;
                });
                context.normalMeetUsers.push(command.self);
            }

        } else {
            context.other = $.extend([], context.memberList);
            context.normalMeetUsers = $.extend([], context.memberList);
        }
        Voip.win.setBounds(getWinSize(context));
        var params = {
            conversationType: Number(command.conversationType),
            targetId: command.targetId,
            inviteUserIds: inviteUserIds,
            observerUserIds: observerUserIds,
            isSharing: command.isShareScreen,
            mediaType: command.mediaType
        };
        RongCallLib.call(params, function (errorCode) {
            if (errorCode) {
                console.error('[CallLib][call]', errorCode);
                confirmeQuit = true;
                Voip.win.close();
            }
        });
        sound.playWait();
    },
    /*说明： 接收到音视频会话邀请*/
    InviteMessage: function (command, context) {
        context.conversation = {
            conversationType: command.conversationType,
            targetId: command.targetId
        };
        context.status = 'ringing';
        context.type = command.content.mediaType;
        context.isShareScreen = command.content.sharing;
        var memberList = [command.senderUser].concat(command.inviteUserList);
        extraUserInfo(memberList, context.isVideo);
        context.memberList = memberList;
        var observerUserIds = command.content.observerUserIds;
        if (observerUserIds) {
            context.obersers = command.inviteUserList.filter(function (user) {
                return observerUserIds.indexOf(user.id) > -1;
            });
            // context.normalMeetUsers = command.inviteUserList.filter(function (user) { return user.id != command.self.id })
            context.normalMeetUsers = command.inviteUserList.filter(function (user) {
                return observerUserIds.indexOf(user.id) < 0;
            });

            context.normalMeetUsers.push(command.senderUser);
        }

        context.senderUser = command.senderUser;
        context.updateSelf(getUser(memberList, command.self.id));
        // ring.play();
        sound.playRing();
        Voip.win.setRingPos();
    },
    // RingingMessage: function (command, context) {
    //     sound.playWait();
    // },
    /*说明： 对方同意自己的音视频会话邀请*/
    AcceptMessage: function (command, context) {
        if (context.waiting) {
            sound.stopWait();
            startTiming(context);
        }
        var user;
        var userId = command.senderUserId;
        if (context.main.id === userId) {
            user = context.main;
        } else {
            user = getUser(context.memberList, userId);
        }
        user.waiting = false;
        if (context.isPrivate && context.type == CallType.MEDIA_VEDIO) {
            var main = context.main;
            context.main = context.other[0];
            context.other = [main];
        }
    },
    /*
    说明： 多人音视频，参与会话人视频打开状态改变 mediaType 1 关闭摄像头 2 打开摄像头
            如果是单聊 mediaType 为 1 时转为语音聊天
    */
    MediaModifyMessage: function (command, context) {
        var userId = command.senderUserId;
        var user;
        if (context.main.id === userId) {
            user = context.main;
        } else {
            user = getUser(context.other, userId);
        }
        var openVideo = command.content.mediaType === CallType.MEDIA_VEDIO;
        user.video = openVideo;
        if (context.isPrivate && !user.video) {
            context.switchAudio();
        }
    },
    /*说明： 多人音视频，参与会话人状态改变时触发，有人加入时*/
    MemberModifyMessage: function (command, context) {
        /*
        content.existedMemberStatusList {existedUserPofiles[]}
        existedUserPofiles {object}
        userId
        mediaId
        mediaType
        callStatus
        */
        console.debug('[voip] [MemberModifyMessage]', command);
        var inviteUserIds = command.content.inviteUserIds;
        var beInvited = inviteUserIds.indexOf(command.self.id) !== -1;

        var existedUserList = command.existedUserList;
        var existedMemberStatusList = command.content.existedMemberStatusList;
        existedMemberStatusList.forEach(function (item) {
            if (item.callStatus === RCCallStatus.RCCallHangup) {
                removeUser(existedUserList, item.userId);
                removeMember(context, item.userId);
            }
        });
        var observerUserIds = command.content.observerUserIds;
        if (beInvited) {
            context.conversation = {
                conversationType: command.conversationType,
                targetId: command.targetId
            };
            context.status = 'ringing';
            context.type = command.content.mediaType;

            if (observerUserIds) {
                context.obersers = command.inviteUserList.filter(function (user) {
                    return observerUserIds.indexOf(user.id) > -1;
                });
                // context.normalMeetUsers.push(command.senderUser);
                // context.normalMeetUsers.push(getUser(memberList, command.senderUser));
                var normalMeetUsers = command.inviteUserList.filter(function (user) {
                    return user.id != command.self.id;
                });
                normalMeetUsers = command.inviteUserList.filter(function (user) {
                    return observerUserIds.indexOf(user.id) < 0;
                });
                command.existedUserList.forEach(function (user) {
                    context.normalMeetUsers.push(user);
                });
                normalMeetUsers.forEach(function (user) {
                    context.normalMeetUsers.push(user);
                });
            }
            setExistUserStatus(existedUserList, command.content.existedMemberStatusList);
            var memberList = existedUserList.concat(command.inviteUserList);
            extraUserInfo(memberList, context.isVideo);
            context.memberList = memberList;
            context.updateSelf(getUser(memberList, command.self.id));
            context.senderUser = getUser(memberList, command.senderUserId);
            // ring.play();
            sound.playRing();
            Voip.win.setRingPos();
        } else {
            context.obersers = context.obersers.concat(command.inviteUserList.filter(function (user) { return observerUserIds.indexOf(user.id) > -1; }));
            // normalMeetUsers = command.inviteUserList.filter(function (user) {
            //     return user.id != command.self.id;
            // });
            // normalMeetUsers = command.inviteUserList.filter(function (user) {
            //     return observerUserIds.indexOf(user.id) < 0;
            // });
            // 过滤重复邀请成员
            var alreadyExistMember = context.memberList.map(function (item) {
                return item.id;
            });
            var normalMeetUsers = command.inviteUserList.filter(function (item) {
                return alreadyExistMember.indexOf(item.id) === -1;
            });
            var inviteUserList = command.inviteUserList;
            extraUserInfo(inviteUserList, context.isVideo);
            context.other.push.apply(context.other, normalMeetUsers);
            context.normalMeetUsers.push.apply(context.normalMeetUsers, normalMeetUsers);
            context.memberList.push.apply(context.memberList, normalMeetUsers);
        }
    },
    /*说明： 音视频通话，有人挂断时触发*/
    HungupMessage: function (command, context) {
        var isSend = command.messageDirection === 1;
        if (isSend) {
            return;
        }
        var userId = command.senderUserId;
        // 对方忙碌等待 3 秒移除
        var isBusy = command.content.reason === 14;
        var user = getUser(context.memberList, userId);
        if (isBusy && user) {
            user.busy = true;
            user.waiting = false;
            setTimeout(function () {
                removeMember(context, userId);
            }, 1000 * Voip.config.busyShowTime);
        } else {
            removeMember(context, userId);
        }
        //移除会控栏目
        // removeUser(context.normalMeetUsers, userId);
        // removeUser(context.obersers, userId);
        // removeUser(context.other, userId);
    },
    /*说明： 音视频 汇总结果 通话时长、对方拒绝、对方取消等*/
    SummaryMessage: function (command) {
        var params = {
            command: 'summary',
            message: command
        };
        Voip.request(params);
        confirmeQuit = true;
        Voip.win.close();
    },
    Close: function () {
        // IM 退出登录关闭音视频窗口
        confirmeQuit = true;
        Voip.win.close();
    }
};

/*
说明： 基础方法，从一个数组中获取对应 id 的成员
*/
function getUser(list, userId) {
    for (var i = list.length - 1; i >= 0; i--) {
        var item = list[i];
        if (item.id === userId) {
            return item;
        }
    }
}

/*
说明： 基础方法，从一个数组中移除对应 id 的成员
*/
function removeUser(list, userId) {
    if (Object.prototype.toString.call(list) != '[object Array]' || !userId) {
        console.error('error !list userid', list, userId);
        return;
    }
    list.forEach(function (item, index) {
        if (item.id === userId) {
            list.splice(index, 1);
            return false;
        }
    });
}

/*
说明： 多人音视频会话时更新其他成员的状态
*/
function setExistUserStatus(existedUserList, existedMemberStatusList) {
    var tempUserCache = {};
    existedMemberStatusList.forEach(function (item) {
        tempUserCache[item.userId] = item;
    });

    existedUserList.forEach(function (user) {
        var existedStatus = tempUserCache[user.id];
        var isVideo = existedStatus.mediaType === CallType.MEDIA_VEDIO;
        user.video = isVideo;
        user.waiting = existedStatus.callStatus !== RCCallStatus.RCCallActive;
    });
}

/*
说明： 同意对方发起的音视频会话
*/
function accept(context) {
    if (context.isVideo) {
        context.main = context.senderUser;
        console.log('accept main', context.senderUser.id);
        if (context.isPrivate) {
            context.other = context.memberList.filter(function (item) {
                return item.id !== context.senderUser.id;
            });
        } else {
            context.other = context.normalMeetUsers.filter(function (item) {
                return item.id !== context.senderUser.id;
            });
        }
    } else {
        context.other = $.extend([], context.memberList);
    }
    context.status = 'call';
    startTiming(context);
    // ring.stop();
    sound.stopRing();
    Voip.win.setBounds(getWinSize(context));

    var conv = context.conversation;
    var userType;
    if (getUser(context.obersers, context.self.id)) {
        userType = 2;
    }
    var params = {
        conversationType: conv.conversationType,
        targetId: conv.targetId,
        mediaType: context.type,
        userType: userType || 1
    };
    RongCallLib.accept(params);
}

/*
说明： 多人聊天时添加聊天成员
*/
function addMember(context) {
    var members = [];
    if (context.isVideo) {
        members = context.other.concat(context.main);
        members = members.concat(context.obersers);
    } else {
        members = context.other;
    }
    var memberIdList = members.map(function (item) {
        return item.id;
    });
    var params = {
        command: 'addMember',
        type: context.type,
        targetId: context.conversation.targetId,
        memberIdList: memberIdList
    };
    Voip.request(params, function (errorCode, list) {
        Voip.win.focus();
        if (errorCode) {
            return;
        }

        var maxlimit = Voip.config.maxMemberCount;
        var memberCount = context.memberList.length;
        memberCount += list.length;
        if (memberCount > maxlimit) {
            // var message = utils.templateFormat(context.locale.tips.maxlimit, maxlimit);
            // showTip(context, message);
            // return;
        }

        var observers = list.filter(function (t) {
            return t.obeserver;
        });
        var normoluser = list.filter(function (t) {
            return !t.obeserver;
        });
        extraUserInfo(list, context.isVideo);
        context.other.push.apply(context.other, normoluser);
        context.normalMeetUsers.push.apply(context.normalMeetUsers, normoluser);

        context.memberList.push.apply(context.memberList, list);
        context.obersers.push.apply(context.obersers, observers);
        var inviteUserIds = list.map(function (item) {
            return item.id;
        });
        var observerUserIds = observers.map(function (item) {
            return item.id;
        });
        var conversation = context.conversation;
        /*群聊邀请过来userid注意是否观察者*/
        var arg = {
            conversationType: conversation.conversationType,
            targetId: conversation.targetId,
            inviteUserIds: inviteUserIds,
            observerUserIds: observerUserIds,
            mediaType: context.type
        };
        RongCallLib.invite(arg, function () {
            // console.log(error);
        });
    });
}

/*
说明： 有人退出多人聊天移除对应数据
*/
function removeMember(context, userId) {
    if (!userId) {
        return;
    }
    if (context.main.id === userId) {
        context.main = context.other[0];
        context.other.splice(0, 1);
    } else {
        removeUser(context.other, userId);
    }
    removeUser(context.memberList, userId);
    removeUser(context.normalMeetUsers, userId);
    removeUser(context.obersers, userId);
    if (context.senderUser.id === userId) {
        var other = context.memberList.filter(function (item) {
            return item.id !== context.self.id && item.waiting === false;
        });
        if (other.length > 0) {
            context.senderUser = other[0];
        } else {
            context.conversation.passive = true;
            RongCallLib.hungup(context.conversation);
            return;
        }
    }

    if (context.memberList.length < 2) {
        context.conversation.passive = true;
        RongCallLib.hungup(context.conversation);
    }
}
function upUserVideoAudiostatus(user, talktype) {
    // talktype[0:无视频有音频, 1:有视频有音频, 2:有视频无音频, 3:无视频无音频]
    if (talktype == 0) {
        user.video = false;
        user.audio = true;
    } else if (talktype == 1) {
        user.video = true;
        user.audio = true;
    } else if (talktype == 2) {
        user.video = true;
        user.audio = false;
    } else {
        user.video = false;
        user.audio = false;
    }
}
/*
说明：  音视频节点事件，底层触发音视频接入(added)音视频断开(removed)网络等原因无法重连断开(disconnect)
*/
var videoItem = {
    added: function (result, context) {
        var talktype = result.talkType;
        var id = result.userId;
        var ele = result.data;
        // var id = $(ele).attr('userid');
        var user;
        if (context.main.id === id) {
            user = context.main;
        } else {
            user = getUser(context.other, id);
        }
        if (user) {
            user.waiting = false;
            context.isVideo && upUserVideoAudiostatus(user, talktype);
        }
        console.debug('[video] [added]', id, user && user.name);
        videoEleCache[id] = ele;
        var tag = result.tag;
        if (tag === 'screen') {
            // 替换屏幕共享视频流
        }
    },
    removed: function (result, context) {
        var id = result.userId;
        var data = result.data;
        // var id = $('#' + data).attr('userid');
        removeMember(context, id);
        removeMember(context, data);
    },
    disconnect: function (result, context) {
        context.hungup();
    }
};
/*  会控的一些通知 主持人降级 主持人升级 主持人邀请 有人被降级 有人被升级..........*/
var meetItem = {
    hostRemoved: function (result, context) {
        layer.msg('你已经被主持人移除');
        confirmeQuit = true;
        setTimeout(function () {
            RongCallLib.hungup(context.conversation);
            Voip.win.close();
        }, 1000);
    },
    userDown: function (result, context) {
        var userId = result.userId;
        delete videoEleCache[userId];
        if (userId == context.self.id) {
            Vue.set(context.self, 'obeserver', true);
        }
        var user = getUser(context.normalMeetUsers, userId);

        if (context.main.id === userId) {
            context.main = context.other[0];
            context.other.splice(0, 1);
            removeUser(context.normalMeetUsers, userId);
        } else {
            removeUser(context.normalMeetUsers, userId);
            removeUser(context.other, userId);
        }
        context.obersers.push(user);

    },
    becomeUser: function (result, context) {
        var id = result.userId;
        var user = getUser(context.obersers, id);
        if (id == context.self.id) {
            Vue.set(context.self, 'obeserver', false);
        }
        if (user) {
            user.video = true;
            user.audio = true;
        }
        console.error('becomeuser', result, user);
        context.normalMeetUsers.push(user);
        context.other.push(user);
        removeUser(context.obersers, id);
    },
    beRequestToUser: function (result, context) {
        context.currentDialogUser = result;
        context.currentDialogUser.method = 'acceptBeRequestToUser';
        context.currentDialogUser.beInviteSpark = true;
    },
    reciveRequestToUser: function (result, context) {
        var user = getUser(context.obersers, result.userId);
        context.reqSparkUser = user;
        user.userReqSpark = true;

    },
    hostRequestControlDevice: function (result, context) {
        var str1 = result.content.index == 1 ? '打开' : '关闭';
        var isOpen = result.content.index == 1;
        if (isOpen) {
            isOpen = true;
        } else {
            isOpen = false;
        }
        var srr2 = result.content.type == 1 ? '摄像头' + str1 : '麦克风';
        var user = getUser(context.memberList, result.userId);

        if (isOpen) {
            context.currentDialogUser.bd = str1 + srr2;
            context.currentDialogUser.result = result;
            context.currentDialogUser.user = user;
            context.currentDialogUser.isOpen = isOpen;
        } else {
            result.content.type == 1 ? user.video = false : user.audio = false;
            RongCallLib.Voip.getRtcPeer().blinkMeeting.userDoHostRequestControlUserDevice(result.content.from, isOpen, result.content.type, 0x01);
        }
    },
    whiteBoardURL: function (result, context) {
        var url = result.url;
        if (!url) {
            console.error('当前没有白板供查看，请等待其他人创建白板!');
        } else {
            url += '&type=web';
            context.showWhiteBoard = true;
            $('#wb').html('<iframe height=\'100%\' width=\'100%\' frameborder=\'0\' scrolling=\'no\' marginheight=\'0\' marginwidth=\'0\' src=\'' + url + '\' />');
        }
    },
    turnTalkType: function (result, context) {
        var userId = result.userId;
        var open = result.open;
        var mediaType = result.mediaType;
        var user = getUser(context.memberList, userId);
        mediaType == 1 ? user.video = open : user.audio = open;
    },
    otherUserBecomeHost: function (result, context) {
        context.self.host = false;
        var user = getUser(context.memberList, result.hostId);
        user.host = true;
    },
    userAgreeOpen: function (result, context) {
        var userId = result.userId;
        var isAgree = result.status == 1;
        var mediaType = result.mediaType;
        var user = getUser(context.memberList, userId);
        if (isAgree) {
            mediaType == 1 ? user.video = open : user.audio = open;
        }
    }
};

function created(context, query) {
    var userId = query.userid;
    var locale = query.locale;
    var appkey = query.appkey;
    var navi = decodeURIComponent(query.navi);
    var token = decodeURIComponent(query.token);
    watchClose(context);
    context.config.locale = locale;
    var config = context.config.voip;
    config.currentUserId = userId;
    config.RongIMLib = RongIMLib;
    config.RongRTC = RongRTC;
    config.sendCommand = function (params, callback) {
        console.debug('[voip] [send]', params);
        RongDesktop.voip.voipRequest(params);
        // 模拟发送命令回调
        var requestCallback = function (event, req) {
            var isCommandCallback = req.type === 'commandCallback';
            if (isCommandCallback) {
                var data = req.data;
                console.debug('[voip] [sendcallback]', req);
                if (data.command === params.command) {
                    callback && callback(data.error, data.result);
                    RongDesktop.ipcRenderer.removeListener('onIMRequest', requestCallback);
                }
            }
        };
        RongDesktop.ipcRenderer.on('onIMRequest', requestCallback);
    };
    config.watch = function (callback) {
        RongDesktop.ipcRenderer.on('onIMRequest', function (event, req) {
            if (req.type === 'message') {
                var message = req.data;
                callback(message);
            }
        });
    };

    IMSDK.init({
        appkey,
        navi,
        onstatuschanged: function (status) {
            /**
             * 201: 请求导航中 
             * 202: 请求导航成功
             * 1: 连接 im 中
             * 0: 连接 im 成功
             */
            console.debug('[im] [statuschanged]',status);
            var disconnect = [0, 1, 201, 202].indexOf(status) === -1;
            if (disconnect) {
                // 弹框提示
                context.networkErrorVisible = true;
            }
        }
    });
    IMSDK.connect(token, function () {
        RongCallLib = RongCallLib.init(config);
        // 日志使用方法
        // RongCallLib.logger(function(message, desc){
        //     Voip.win.voipLogger('info', message);
        // });
        // 注册视频节点监听
        RongCallLib.videoWatch(function (result) {
            console.debug('[CallLib] [videoWatch]', result.type, result);
            videoItem[result.type](result, context);
        });
        // 会控命令监听
        // RongCallLib.meetCommandWatche(function (result) {
        //     meetItem[result.type](result, context);
        // });
        // 注册命令监听
        RongCallLib.commandWatch(function (command) {
            console.debug('[CallLib] [commandWatch]', command.messageType, command);
            var handle = handlerCommand[command.messageType];
            if (handle) {
                handle(command, context);
            }
        });

        Voip.ready();
    });
}

function watchClose(context) {
    window.onbeforeunload = function () {
        if (!confirmeQuit) {
            context.closeBefore = true;
            return true;
        }
    };
}

Voip.init = init;

})(Voip, {
    jQuery: jQuery,
    Vue: Vue,
    RongCallLib: RongCallLib,
    location: window.location
});
