(function (RongWork) {
    'use strict';

    var utils = RongWork.utils;
    var components = RongWork.components;
    var serverApi = RongWork.serverApi;
    var dialog = RongWork.dialog;

    RongWork.dialog.editOtherApps = function (msg, callback) {
        var work = RongWork.instance;
        var options = {
            name: 'edit-otherapp',
            template: 'edit-otherapp.html',
            components: {
                customSelect: components.customSelect,
                pinSearch: components.getPinSearch
            },
            data: function () {
                return {
                    allApps: [],
                    selectedApps: [],
                    selectedApps_old: [],
                    delIdList: [],
                    selectedAppType: '',
                    appTypes: [{
                            type: '',
                            text: work.appGroupTitle('allApps')
                        }
                    ],
                    keyword: '',
                    isEdit: true,
                    show: true,
                    addList:[],
                    isSearch: false, //是否处于搜索状态
                };
            },
            mounted: function () {
                var context = this;
                var userId = work.query.userId;
                if (msg) {
                    let addType = msg.map(obj => {
                        return {
                            type: obj.id,
                            text: obj.name
                        }
                    })
                    context.appTypes = context.appTypes.concat(addType)
                }
                console.log(context.appTypes)
                // 获取全部应用列表
                getAppList(context, userId);
            },
            computed: {
                workInstance: function () {
                    return work;
                },
                searchBarStyle: function () {
                    return {
                        width: '40%',
                        left: '40%'
                    };
                },
                searchAppList: function () {
                    var context = this;
                    var regex = this.keyword ? new RegExp(this.keyword, 'i') : null;
                    return this.allApps.filter(function (app) {
                        if (!app.favorite && (
                                app.pc_home_page_url || app.home_page_url
                            ) && (!context.selectedAppType ||
                                context.selectedAppType == app.description
                            )) {
                            return !regex || regex.test(app.name);
                        }
                    });
                }
            },
            methods: {
                isSelected: function (app) {
                    var context = this;
                    var selected = false;
                    context.selectedApps.forEach(function (item) {
                        if (app.id === item.id) {
                            selected = true;
                        }
                    });
                    return selected;
                },
                add: function (app) {
                    var context = this;
                    let param = {
                        "app_uid": app.id,
                        "state": 1
                    }
                    let list = context.selectedApps.concat(app)
                    context.selectedApps = unique(list)
                    context.addList.push(app)
                    // serverApi.updateMyApplication(param, (res) => {
                    //     let list = context.selectedApps.concat(app)
                    //     context.selectedApps = unique(list)
                    //     // context.selectedApps.push(app)
                    //     callback({
                    //         flag: 1, //新增
                    //         app: app
                    //     })
                    // })
                    // if (!context.isSelected(app)) {
                    //     context.selectedApps.push(app);
                    // }
                },
                del: function (app) {
                    let favorite_pc = getQueryString('favorite', app.pc_home_page_url) == 'pc'; 
                    if (favorite_pc) {
                        utils.messagebox({
                            message: '该应用为默认应用，不支持移除'
                        });
                        return;
                    }
                    var context = this;
                    let param = {
                        "app_uid": app.id,
                        "state": 0
                    }
                    context.selectedApps.splice(context.selectedApps.findIndex(item => app.id === item.id), 1)
                    context.addList.splice(context.addList.findIndex(item => app.id === item.id), 1)
                    // serverApi.updateMyApplication(param, (res) => {
                    //     context.selectedApps.splice(context.selectedApps.findIndex(item => app.id === item.id), 1)
                    //     callback({
                    //         flag: 0, //移除
                    //         app: app
                    //     })
                    // })
                },
                remove: function (app) {
                    let favorite_pc = getQueryString('favorite', app.pc_home_page_url) == 'pc'; 
                    if (favorite_pc) {
                        utils.messagebox({
                            message: '该应用为默认应用，不支持移除'
                        });
                        return;
                    }
                    var context = this;
                    var index = context.selectedApps.indexOf(app);
                    context.selectedApps.splice(index, 1);
                    context.addList.splice(context.addList.findIndex(item => app.id === item.id), 1)
                    // context.delIdList.push(app)
                },
                save: function () {
                    var context = this;
                    // 获取移除的我的应用
                    let delIds = context.selectedApps_old.filter(itemF => !context.selectedApps.some(ele => ele.id === itemF.id)) || []
                    // var removeList = context.delIdList.map(obj => obj.id)
                    $.when.apply(
                        serverApi.batchRemoveMyApplication(delIds.map(obj => obj.id)),
                        serverApi.batchAddMyApplication(unique(context.addList).map(obj => obj.id))).done(function () {
                        callback(context.selectedApps);
                    }).fail(function (error) {
                        callback(error);
                    });
                    context.show = false
                },
                filterApps: function (opt) {
                    if(opt){
                        this.isSearch = true
                    }else{
                        this.isSearch = false
                    }
                    this.keyword = opt.keyword;
                },
                close: function () {
                    this.show = false
                },
                getEmpty() {
                    return "没有搜索到" + '<em>&quot;' + this.keyword + '&quot;</em>' + '相关的结果'
                }
            }
        };
        utils.mountDialog(options);
    };
    // 数组去重
    function unique(arr) {
        const res = new Map();
        return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
    }

    function getAppList(context, userId) {
        serverApi.getAllApps(function (errorCode, result) {
            if (errorCode) {
                return;
            }
            context.allApps = result.apps;
            // 获取我常用的应用列表
            context.selectedApps = context.allApps.filter(obj => {
                let favorite_pc = getQueryString('favorite', obj.pc_home_page_url) == 'pc'; 
                if (favorite_pc) obj.my_application = 1;
                return obj.my_application == 1;
            })
            context.selectedApps_old = context.allApps.filter(obj => {
                let favorite_pc = getQueryString('favorite', obj.pc_home_page_url) == 'pc'; 
                if (favorite_pc) obj.my_application = 1;
                return obj.my_application == 1;
            })

        });
    }

    function getQueryString(name, url) {
        url = url || window.location.href;
        var index = url.lastIndexOf('?');
        if (index === -1) return;
        var query = url.slice(index + 1);
        var vars = query.split("&");
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split("=");
            if (pair[0] == name) {return pair[1];}
        }
        return;
    }
}(window.RongWork));