export { Breadcrumb, Request, SdkInfo, SentryEvent, SentryException, SentryResponse, Severity, StackFrame, Stacktrace, Status, Thread, User, } from '@sentry/types/esm';
export { addGlobalEventProcessor, addBreadcrumb, captureException, captureEvent, captureMessage, configureScope, withScope, getHubFromCarrier, getCurrentHub, Hub, Scope, } from '@sentry/core/esm';
export { BrowserBackend, BrowserOptions } from './backend';
export { BrowserClient, ReportDialogOptions } from './client';
export { defaultIntegrations, forceLoad, init, lastEventId, onLoad, showReportDialog, flush, close } from './sdk';
export { SDK_NAME, SDK_VERSION } from './version';
import { Integrations as CoreIntegrations } from '@sentry/core/esm';
import * as BrowserIntegrations from './integrations';
import * as Transports from './transports';
declare const INTEGRATIONS: {
    GlobalHandlers: typeof BrowserIntegrations.GlobalHandlers;
    TryCatch: typeof BrowserIntegrations.TryCatch;
    Breadcrumbs: typeof BrowserIntegrations.Breadcrumbs;
    LinkedErrors: typeof BrowserIntegrations.LinkedErrors;
    UserAgent: typeof BrowserIntegrations.UserAgent;
    Ember: typeof BrowserIntegrations.Ember;
    Vue: typeof BrowserIntegrations.Vue;
    ReportingObserver: typeof BrowserIntegrations.ReportingObserver;
    Dedupe: typeof CoreIntegrations.Dedupe;
    FunctionToString: typeof CoreIntegrations.FunctionToString;
    SDKInformation: typeof CoreIntegrations.SDKInformation;
    InboundFilters: typeof CoreIntegrations.InboundFilters;
    ExtraErrorData: typeof CoreIntegrations.ExtraErrorData;
    Debug: typeof CoreIntegrations.Debug;
    RewriteFrames: typeof CoreIntegrations.RewriteFrames;
};
export { INTEGRATIONS as Integrations, Transports };
