"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var hub_1 = require("@sentry/hub");
var is_1 = require("@sentry/utils/is");
var logger_1 = require("@sentry/utils/logger");
var object_1 = require("@sentry/utils/object");
/** Patch toString calls to return proper name for wrapped functions */
var ExtraErrorData = /** @class */ (function () {
    /**
     * @inheritDoc
     */
    function ExtraErrorData(options) {
        if (options === void 0) { options = { depth: 3 }; }
        this.options = options;
        /**
         * @inheritDoc
         */
        this.name = ExtraErrorData.id;
    }
    /**
     * @inheritDoc
     */
    ExtraErrorData.prototype.setupOnce = function () {
        var _this = this;
        hub_1.addGlobalEventProcessor(function (event, hint) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
            var self;
            return tslib_1.__generator(this, function (_a) {
                self = hub_1.getCurrentHub().getIntegration(ExtraErrorData);
                if (!self) {
                    return [2 /*return*/, event];
                }
                return [2 /*return*/, self.enhanceEventWithErrorData(event, hint)];
            });
        }); });
    };
    /**
     * Attaches extracted information from the Error object to extra field in the SentryEvent
     */
    ExtraErrorData.prototype.enhanceEventWithErrorData = function (event, hint) {
        if (!hint || !hint.originalException || !is_1.isError(hint.originalException)) {
            return event;
        }
        var errorData = this.extractErrorData(hint.originalException);
        if (errorData) {
            var extra = tslib_1.__assign({}, event.extra);
            var normalizedErrorData = object_1.safeNormalize(errorData, this.options.depth);
            if (!is_1.isString(normalizedErrorData)) {
                extra = tslib_1.__assign({}, event.extra, normalizedErrorData);
            }
            return tslib_1.__assign({}, event, { extra: extra });
        }
        return event;
    };
    /**
     * Extract extra information from the Error object
     */
    ExtraErrorData.prototype.extractErrorData = function (error) {
        var e_1, _a, _b;
        var result = null;
        // We are trying to enhance already existing event, so no harm done if it won't succeed
        try {
            var nativeKeys_1 = ['name', 'message', 'stack', 'line', 'column', 'fileName', 'lineNumber', 'columnNumber'];
            var name_1 = error.name || error.constructor.name;
            var errorKeys = Object.getOwnPropertyNames(error).filter(function (key) { return nativeKeys_1.indexOf(key) === -1; });
            if (errorKeys.length) {
                var extraErrorInfo = {};
                try {
                    for (var errorKeys_1 = tslib_1.__values(errorKeys), errorKeys_1_1 = errorKeys_1.next(); !errorKeys_1_1.done; errorKeys_1_1 = errorKeys_1.next()) {
                        var key = errorKeys_1_1.value;
                        var value = error[key];
                        if (is_1.isError(value)) {
                            value = value.toString();
                        }
                        extraErrorInfo[key] = value;
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (errorKeys_1_1 && !errorKeys_1_1.done && (_a = errorKeys_1.return)) _a.call(errorKeys_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                result = (_b = {},
                    _b[name_1] = extraErrorInfo,
                    _b);
            }
        }
        catch (oO) {
            logger_1.logger.error('Unable to extract extra data from the Error object:', oO);
        }
        return result;
    };
    /**
     * @inheritDoc
     */
    ExtraErrorData.id = 'ExtraErrorData';
    return ExtraErrorData;
}());
exports.ExtraErrorData = ExtraErrorData;
//# sourceMappingURL=extraerrordata.js.map