import { Dsn, Scope } from '@sentry/core';
import { Breadcrumb, Integration, IntegrationClass, SentryBreadcrumbHint, SentryEvent, SentryEventHint, SentryResponse, Severity } from '@sentry/types';
import { CommonClient, ElectronOptions } from './common';
/**
 * The Sentry Electron SDK Frontend.
 *
 * @see ElectronOptions for documentation on configuration options.
 * @see SentryClient for usage documentation.
 */
export declare class ElectronClient implements CommonClient {
    /** Actual frontend implementation for the main or renderer process. */
    private readonly inner;
    /**
     * Creates a new Electron SDK instance.
     *
     * This constructor automatically chooses the right implementation for the
     * process type (`browser` or `renderer`).
     *
     * @param options Configuration options for this SDK.
     */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    captureMinidump(path: string, event: SentryEvent, scope: Scope): Promise<void>;
    /**
     * @inheritDoc
     */
    install(): boolean;
    /**
     * @inheritDoc
     */
    captureException(exception: any, hint?: SentryEventHint, scope?: Scope): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    captureMessage(message: string, level?: Severity, hint?: SentryEventHint, scope?: Scope): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    captureEvent(event: SentryEvent, hint?: SentryEventHint, scope?: Scope): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb: Breadcrumb, hint?: SentryBreadcrumbHint, scope?: Scope | undefined): void;
    /**
     * @inheritDoc
     */
    getDsn(): Dsn | undefined;
    /**
     * @inheritDoc
     */
    getOptions(): ElectronOptions;
    /**
     * @inheritDoc
     */
    close(timeout?: number): Promise<boolean>;
    /**
     * @inheritDoc
     */
    flush(timeout?: number): Promise<boolean>;
    /**
     * @inheritDoc
     */
    showReportDialog(options: any): void;
    /**
     * @inheritDoc
     */
    getIntegration<T extends Integration>(integration: IntegrationClass<T>): T | null;
}
/**
 * This either calls init on main with node interations or renderer
 * with browser integrations.
 *
 * @param options Options
 */
export declare function specificInit(options: ElectronOptions): void;
/** Convenience interface used to expose Integrations */
export interface Integrations {
    [key: string]: Integration;
}
/** Return all integrations depending if running in browser or renderer. */
export declare function getIntegrations(): {
    node: Integrations;
    electron: Integrations;
} | {
    browser: Integrations;
};
