"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const misc_1 = require("@sentry/utils/misc");
/**
 * The Sentry Electron SDK Frontend.
 *
 * @see ElectronOptions for documentation on configuration options.
 * @see SentryClient for usage documentation.
 */
class ElectronClient {
    /**
     * Creates a new Electron SDK instance.
     *
     * This constructor automatically chooses the right implementation for the
     * process type (`browser` or `renderer`).
     *
     * @param options Configuration options for this SDK.
     */
    constructor(options) {
        // We dynamically load the frontend implementation for the current process
        // type. In frontend bundlers such as webpack or rollup, those requires are
        // resolved statically. For this reason, we use `dynamicRequire` for the
        // main implementation here, which is only defined in the main process. The
        // renderer implementation must use the default `require`.
        // In case `process.type` is not defined, dispatch defaults to the renderer
        // implementation, which should be fine for most cases. False positives of
        // this would be running `@sentry/electron` in a bare node process, which is
        // acceptable.
        // tslint:disable:no-unsafe-any
        const clientClass = process.type === 'browser' ? misc_1.dynamicRequire(module, './main').MainClient : require('./renderer').RendererClient;
        // tslint:enable:no-unsafe-any
        this.inner = new clientClass(options);
    }
    /**
     * @inheritDoc
     */
    captureMinidump(path, event, scope) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.captureMinidump(path, event, scope);
        });
    }
    /**
     * @inheritDoc
     */
    install() {
        return this.inner.install();
    }
    /**
     * @inheritDoc
     */
    captureException(exception, hint, scope) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.captureException(exception, hint, scope);
        });
    }
    /**
     * @inheritDoc
     */
    captureMessage(message, level, hint, scope) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.captureMessage(message, level, hint, scope);
        });
    }
    /**
     * @inheritDoc
     */
    captureEvent(event, hint, scope) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.captureEvent(event, hint, scope);
        });
    }
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb, hint, scope) {
        this.inner.addBreadcrumb(breadcrumb, hint, scope);
    }
    /**
     * @inheritDoc
     */
    getDsn() {
        return this.inner.getDsn();
    }
    /**
     * @inheritDoc
     */
    getOptions() {
        return this.inner.getOptions();
    }
    /**
     * @inheritDoc
     */
    close(timeout) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.close(timeout);
        });
    }
    /**
     * @inheritDoc
     */
    flush(timeout) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.flush(timeout);
        });
    }
    /**
     * @inheritDoc
     */
    showReportDialog(options) {
        // tslint:disable-next-line
        this.inner.showReportDialog(options);
    }
    /**
     * @inheritDoc
     */
    getIntegration(integration) {
        return this.inner.getIntegration(integration);
    }
}
exports.ElectronClient = ElectronClient;
/**
 * This either calls init on main with node interations or renderer
 * with browser integrations.
 *
 * @param options Options
 */
function specificInit(options) {
    // tslint:disable-next-line
    process.type === 'browser' ? misc_1.dynamicRequire(module, './main').init(options) : require('./renderer').init(options);
}
exports.specificInit = specificInit;
/** Return all integrations depending if running in browser or renderer. */
function getIntegrations() {
    // tslint:disable:no-unsafe-any
    return process.type === 'browser'
        ? {
            electron: misc_1.dynamicRequire(module, './main').ElectronIntegrations,
            node: misc_1.dynamicRequire(module, './main').NodeIntegrations,
        }
        : { browser: require('./renderer').BrowserIntegrations };
    // tslint:enable:no-unsafe-any
}
exports.getIntegrations = getIntegrations;
//# sourceMappingURL=dispatch.js.map