"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_1 = require("@sentry/node");
const types_1 = require("@sentry/types");
const electron_1 = require("electron");
/** Capture unhandled erros. */
class OnUncaughtException {
    /**
     * @inheritDoc
     */
    constructor(options = {}) {
        this.options = options;
        /**
         * @inheritDoc
         */
        this.name = OnUncaughtException.id;
    }
    /**
     * @inheritDoc
     */
    setupOnce() {
        global.process.on('uncaughtException', (error) => {
            const self = node_1.getCurrentHub().getIntegration(OnUncaughtException);
            if (self) {
                node_1.getCurrentHub().withScope((scope) => __awaiter(this, void 0, void 0, function* () {
                    scope.addEventProcessor((event) => __awaiter(this, void 0, void 0, function* () {
                        return (Object.assign({}, event, { level: types_1.Severity.Fatal }));
                    }));
                    const nodeClient = node_1.getCurrentHub().getClient();
                    yield nodeClient.captureException(error, { originalException: error }, node_1.getCurrentHub().getScope());
                    if (this.options.onFatalError) {
                        this.options.onFatalError(error);
                    }
                    else if (global.process.listenerCount('uncaughtException') <= 2) {
                        // In addition to this handler there is always one in Electron
                        // The dialog is only show if there are no other handlers
                        console.error('Uncaught Exception:');
                        console.error(error);
                        const ref = error.stack;
                        const stack = ref !== undefined ? ref : `${error.name}: ${error.message}`;
                        const message = `Uncaught Exception:\n${stack}`;
                        electron_1.dialog.showErrorBox('A JavaScript error occurred in the main process', message);
                    }
                }));
            }
        });
    }
}
/**
 * @inheritDoc
 */
OnUncaughtException.id = 'OnUncaughtException';
exports.OnUncaughtException = OnUncaughtException;
//# sourceMappingURL=onuncaughtexception.js.map