import { SentryEvent } from '@sentry/types';
/**
 * Normalizes URLs in exceptions and stacktraces so Sentry can fingerprint
 * across platforms.
 *
 * @param url The URL to be normalized.
 * @param base (optional) The application base path.
 * @returns The normalized URL.
 */
export declare function normalizeUrl(url: string, base?: string): string;
/**
 * Normalizes all URLs in an event. See {@link normalizeUrl} for more
 * information. Mutates the passed in event.
 *
 * @param event The event to normalize.
 */
export declare function normalizeEvent(event: SentryEvent): SentryEvent;
