"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const browser_1 = require("@sentry/browser");
const core_1 = require("@sentry/core");
const types_1 = require("@sentry/types");
const common_1 = require("../common");
/** Timeout used for registering with the main process. */
const PING_TIMEOUT = 500;
/** Backend implementation for Electron renderer backends. */
class RendererBackend extends core_1.BaseBackend {
    /** Creates a new Electron backend instance. */
    constructor(options) {
        super(options);
        this.inner = new browser_1.BrowserBackend(options);
    }
    /**
     * @inheritDoc
     */
    install() {
        let success = true;
        if (this.isNativeEnabled()) {
            success = this.installNativeHandler() && success;
        }
        if (this.isJavaScriptEnabled()) {
            success = this.inner.install() && success;
        }
        this.pingMainProcess();
        return success;
    }
    /**
     * @inheritDoc
     */
    eventFromException(exception, hint) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.eventFromException(exception, hint);
        });
    }
    /**
     * @inheritDoc
     */
    eventFromMessage(message, level, hint) {
        return __awaiter(this, void 0, void 0, function* () {
            return this.inner.eventFromMessage(message, level, hint);
        });
    }
    /**
     * @inheritDoc
     */
    sendEvent(event) {
        return __awaiter(this, void 0, void 0, function* () {
            electron_1.ipcRenderer.send(common_1.IPC_EVENT, event);
            // This is a fire and forget thing
            return { status: types_1.Status.Success };
        });
    }
    /**
     * @inheritDoc
     */
    storeBreadcrumb(_) {
        throw new core_1.SentryError('Invariant violation: Only supported in main process');
    }
    /**
     * @inheritDoc
     */
    storeScope(scope) {
        electron_1.ipcRenderer.send(common_1.IPC_SCOPE, scope);
    }
    /** Returns whether JS is enabled. */
    isJavaScriptEnabled() {
        return this.options.enableJavaScript !== false;
    }
    /** Returns whether native reports are enabled. */
    isNativeEnabled() {
        // On macOS, we should start the Electron CrashReporter only in the main
        // process. It uses Crashpad internally, which will catch errors from all
        // sub processes thanks to out-of-processes crash handling. On other
        // platforms we need to start the CrashReporter in every sub process. For
        // more information see: https://goo.gl/nhqqwD
        if (process.platform === 'darwin') {
            return false;
        }
        // Mac AppStore builds cannot run the crash reporter due to the sandboxing
        // requirements. In this case, we prevent enabling native crashes entirely.
        // https://electronjs.org/docs/tutorial/mac-app-store-submission-guide#limitations-of-mas-build
        if (process.mas) {
            return false;
        }
        return this.options.enableNative !== false;
    }
    /** Activates the Electron CrashReporter. */
    installNativeHandler() {
        // We will manually submit errors, but CrashReporter requires a submitURL in
        // some versions. Also, provide a productName and companyName, which we will
        // add manually to the event's context during submission.
        electron_1.crashReporter.start({
            companyName: '',
            ignoreSystemCrashHandler: true,
            productName: electron_1.remote.app.getName(),
            submitURL: '',
            uploadToServer: false,
        });
        return true;
    }
    /** Checks if the main processes is available and logs a warning if not. */
    pingMainProcess() {
        // For whatever reason we have to wait PING_TIMEOUT until we send the ping
        // to main.
        setTimeout(() => {
            electron_1.ipcRenderer.send(common_1.IPC_PING);
            const timeout = setTimeout(() => {
                console.warn('Could not connect to Sentry main process. Did you call init?');
            }, PING_TIMEOUT);
            electron_1.ipcRenderer.on(common_1.IPC_PING, () => {
                clearTimeout(timeout);
            });
        }, PING_TIMEOUT);
    }
}
exports.RendererBackend = RendererBackend;
//# sourceMappingURL=backend.js.map